/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.infonode.util.ReleaseInfo;

public class ReleaseInfoDialog {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");

    public static void showDialog(ReleaseInfo releaseInfo, String string) {
        String[] stringArray;
        ReleaseInfo[] releaseInfoArray = new ReleaseInfo[]{releaseInfo};
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        ReleaseInfoDialog.showDialog(releaseInfoArray, stringArray);
    }

    public static void showDialog(ReleaseInfo[] releaseInfoArray, String[] stringArray) {
        final JComponent jComponent = ReleaseInfoDialog.constructMessage(releaseInfoArray, stringArray);
        JScrollPane jScrollPane = new JScrollPane(jComponent, 20, 31){

            public Dimension getPreferredSize() {
                Dimension dimension = jComponent.getPreferredSize();
                int n = (int)dimension.getHeight();
                return new Dimension((int)dimension.getWidth() + 50, n < 300 ? (int)super.getPreferredSize().getHeight() : 400);
            }
        };
        jComponent.setBorder(new EmptyBorder(10, 20, 10, 20));
        jScrollPane.getViewport().setBackground(Color.white);
        JOptionPane.showMessageDialog(null, jScrollPane, "Product Release Information", 1);
    }

    private static JComponent constructMessage(ReleaseInfo[] releaseInfoArray, String[] stringArray) {
        Box box = new Box(1);
        for (int i = 0; i < releaseInfoArray.length; ++i) {
            JLabel jLabel = new JLabel("<html><body>" + (stringArray == null || stringArray[i] == null ? "" : stringArray[i] + "<br>") + "<table>" + "<tr><td style='font-weight: bold;'>Product Name:</td><td>" + releaseInfoArray[i].getProductName() + "</td></tr>" + "<tr><td style='font-weight: bold;'>Version:</td><td>" + releaseInfoArray[i].getProductVersion().toString() + "</td></tr>" + "<tr><td style='font-weight: bold;'>Build Time:</td><td>" + DATE_FORMAT.format(new Date(releaseInfoArray[i].getBuildTime())) + "</td></tr>" + "<tr><td style='font-weight: bold;'>License:</td><td>" + releaseInfoArray[i].getLicense() + "</td></tr>" + "<tr><td style='font-weight: bold;'>Vendor:</td><td>" + releaseInfoArray[i].getProductVendor() + "</td></tr>" + "<tr><td style='font-weight: bold;'>Homepage:</td><td>" + releaseInfoArray[i].getHomepage() + "</td></tr>" + "</table></body></html>");
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            jLabel.setBorder(new CompoundBorder(new EmptyBorder(0, 0, i == releaseInfoArray.length - 1 ? 0 : 10, 0), new TitledBorder(" " + releaseInfoArray[i].getProductName() + " ")));
            box.add(jLabel);
        }
        return box;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

