/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Details;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import hu.belicza.andras.sc2gears.replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.Downloader;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.ReplayOperationsPopupMenu;
import hu.belicza.andras.sc2gears.ui.charts.ChartUtils;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartPainter;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartParams;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ReplayAnalyzer
extends ModuleFrame {
    private static final int MAX_MAP_PREVIEW_ZOOM = 6;
    private static final Dictionary<Integer, JComponent> LABEL_DICTIONARY = new Hashtable<Integer, JComponent>();
    private File replayFile;
    private final Replay replay;

    static {
        int n = 0;
        while (n <= 6) {
            LABEL_DICTIONARY.put(n, new JLabel(n == 0 ? "1/2x" : String.valueOf(n) + "x"));
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public ReplayAnalyzer(Object ... objectArray) {
        super(objectArray == null || objectArray.length < 1 ? Language.getText("module.replayAnalyzer.opening") : null);
        if (objectArray == null || objectArray.length < 1) {
            String string = Settings.getString("settings.folders.defaultReplay");
            JFileChooser jFileChooser = new JFileChooser(string == null ? Settings.getString("settings.folders.sc2AutoReplay") : string);
            jFileChooser.setDialogTitle(Language.getText("module.repAnalyzer.openTitle"));
            jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
            jFileChooser.setAccessory(GuiUtils.createReplayFilePreviewAccessory(jFileChooser));
            jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
            if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) != 0) {
                this.dispose();
                this.replayFile = null;
                this.replay = null;
                return;
            }
            this.replayFile = jFileChooser.getSelectedFile();
        } else {
            this.replayFile = (File)objectArray[0];
        }
        this.replay = ReplayParser.parseReplay(this.replayFile.getAbsolutePath(), ReplayParser.ALL_CONTENT);
        if (this.replay == null) {
            GuiUtils.showErrorDialog(Language.getText("module.repAnalyzer.openError"));
            this.dispose();
            return;
        }
        MainFrame.INSTANCE.updateRecentReplays(this.replayFile);
        this.setTitle(GeneralUtils.getFileNameWithoutExt(this.replayFile));
        this.setFrameIcon(Icons.SC2);
        this.buildGui();
    }

    private void buildGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.charts.title"), Icons.CHART, false, jTabbedPane, this.createChartsTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.gameInfo.title"), Icons.INFORMATION_BALLOON, false, jTabbedPane, this.createGameInfoTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.inGameChat.title"), Icons.BALLOONS, false, jTabbedPane, this.createInGameChatTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.mapPreview.title"), Icons.MAP, false, jTabbedPane, this.createMapPreviewTab(), null);
        this.getContentPane().add(jTabbedPane);
    }

    private JComponent createChartsTab() {
        JComponent jComponent;
        Object object;
        JComponent jComponent2;
        JComponent jComponent3;
        Object object2;
        JPanel jPanel = new JPanel(new BorderLayout());
        final JList jList = new JList();
        final EnumMap<ReplayConsts.ActionType, JCheckBox> enumMap = new EnumMap<ReplayConsts.ActionType, JCheckBox>(ReplayConsts.ActionType.class);
        final JCheckBox jCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.actions.useListedActionsAsInput", "module.repAnalyzer.charts.actions.useListedAsInput");
        final JComponent[] jComponentArray = new JComponent[1];
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jComponentArray[0].repaint();
            }
        };
        final GameEvents.Action[][] actionArray = new GameEvents.Action[1][];
        final JCheckBox[] jCheckBoxArray = new JCheckBox[this.replay.details.players.length];
        final int[] nArray = this.replay.details.getTeamOrderPlayerIndeces();
        final String[][][] stringArray = new String[1][][];
        final String[][][] stringArray2 = new String[1][][];
        final JLabel jLabel = new JLabel();
        final ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[][] stringArray6;
                EnumSet<ReplayConsts.ActionType> enumSet = EnumSet.noneOf(ReplayConsts.ActionType.class);
                ReplayConsts.ActionType[] actionTypeArray = ReplayConsts.ActionType.values();
                int n = actionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    stringArray6 = actionTypeArray[n2];
                    if (((JCheckBox)enumMap.get(stringArray6)).isSelected()) {
                        enumSet.add((ReplayConsts.ActionType)stringArray6);
                    }
                    ++n2;
                }
                stringArray6 = stringArray[0];
                String[][] stringArray22 = stringArray2[0];
                boolean[] blArray = new boolean[jCheckBoxArray.length];
                int n3 = 0;
                while (n3 < blArray.length) {
                    blArray[nArray[n3]] = jCheckBoxArray[n3].isSelected();
                    ++n3;
                }
                ArrayList<GameEvents.Action> arrayList = new ArrayList<GameEvents.Action>();
                GameEvents.Action[] actionArray2 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions;
                int n4 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions.length;
                int n5 = 0;
                while (n5 < n4) {
                    block15: {
                        GameEvents.Action action;
                        block17: {
                            String string;
                            int n6;
                            int n7;
                            String[] stringArray3;
                            String[] stringArray4;
                            int n8;
                            int n9;
                            String[][] stringArray5;
                            boolean bl;
                            String string2;
                            block16: {
                                action = actionArray2[n5];
                                if (!blArray[action.player] || !enumSet.contains((Object)action.type)) break block15;
                                string2 = null;
                                if (stringArray22 == null) break block16;
                                bl = true;
                                string2 = action.toString().toLowerCase();
                                stringArray5 = stringArray22;
                                n9 = stringArray22.length;
                                n8 = 0;
                                while (n8 < n9) {
                                    stringArray4 = stringArray5[n8];
                                    bl = true;
                                    stringArray3 = stringArray4;
                                    n7 = stringArray4.length;
                                    n6 = 0;
                                    while (n6 < n7) {
                                        string = stringArray3[n6];
                                        if (!string2.contains(string)) {
                                            bl = false;
                                            break;
                                        }
                                        ++n6;
                                    }
                                    if (bl) break;
                                    ++n8;
                                }
                                if (bl) break block15;
                            }
                            if (stringArray6 == null) break block17;
                            bl = true;
                            if (string2 == null) {
                                string2 = action.toString().toLowerCase();
                            }
                            stringArray5 = stringArray6;
                            n9 = stringArray6.length;
                            n8 = 0;
                            while (n8 < n9) {
                                stringArray4 = stringArray5[n8];
                                bl = true;
                                stringArray3 = stringArray4;
                                n7 = stringArray4.length;
                                n6 = 0;
                                while (n6 < n7) {
                                    string = stringArray3[n6];
                                    if (!string2.contains(string)) {
                                        bl = false;
                                        break;
                                    }
                                    ++n6;
                                }
                                if (bl) break;
                                ++n8;
                            }
                            if (!bl) break block15;
                        }
                        arrayList.add(action);
                    }
                    ++n5;
                }
                actionArray[0] = arrayList.toArray(new GameEvents.Action[arrayList.size()]);
                jList.setListData(actionArray[0]);
                jLabel.setText(Language.getText("module.repAnalyzer.tab.charts.actions.listedActionsCount", actionArray[0].length));
                if (jCheckBox.isSelected()) {
                    jComponentArray[0].repaint();
                }
            }
        };
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(new JPanel(new BorderLayout()));
        box2.add(new JLabel(Language.getText("charts.chartType")));
        final JComboBox jComboBox = GuiUtils.createComboBox((Object[])ChartType.values(), "module.repAnalyzer.charts.chartType");
        jComboBox.setToolTipText(Language.getText("charts.chartTypeToolTip"));
        jComboBox.addActionListener(actionListener);
        box2.add(jComboBox);
        box2.add(Box.createHorizontalStrut(5));
        final JCheckBox jCheckBox2 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.groupByTeams", "module.repAnalyzer.charts.groupByTeams");
        jCheckBox2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.groupByTeamToolTip"));
        jCheckBox2.addActionListener(actionListener);
        box2.add(jCheckBox2);
        box2.add(Box.createHorizontalStrut(5));
        final JCheckBox jCheckBox3 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.allPlayersOn1Chart", "module.repAnalyzer.charts.allPlayersOn1Chart");
        jCheckBox3.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.allPlayersOn1ChartToolTip"));
        jCheckBox3.addActionListener(actionListener);
        box2.add(jCheckBox3);
        box2.add(Box.createHorizontalStrut(8));
        final JCheckBox jCheckBox4 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.usePlayersColors", "module.repAnalyzer.charts.usePlayersColors");
        jCheckBox4.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.usePlayersColorsToolTip"));
        jCheckBox4.addActionListener(actionListener);
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jList.invalidate();
                jList.getParent().repaint();
                if (jCheckBox.isSelected()) {
                    jComponentArray[0].repaint();
                }
            }
        };
        jCheckBox4.addActionListener(actionListener3);
        box2.add(jCheckBox4);
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox4.setEnabled(!jCheckBox3.isSelected());
            }
        };
        jCheckBox3.addActionListener(actionListener4);
        actionListener4.actionPerformed(null);
        box2.add(Box.createHorizontalStrut(8));
        final JCheckBox jCheckBox5 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.displayInSeconds", "module.repAnalyzer.charts.displayInSeconds");
        jCheckBox5.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.displayInSecondsToolTip"));
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.displayInSeconds = jCheckBox5.isSelected();
            }
        };
        actionListener5.actionPerformed(null);
        jCheckBox5.addActionListener(actionListener5);
        jCheckBox5.addActionListener(actionListener2);
        jCheckBox5.addActionListener(actionListener);
        box2.add(jCheckBox5);
        box2.add(Box.createHorizontalStrut(9));
        final JLabel jLabel2 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.zoom"));
        jLabel2.setOpaque(true);
        box2.add(jLabel2);
        final JComboBox jComboBox2 = GuiUtils.createComboBox(new Object[]{"x1", "x2", "x4", "x8", "x16", "x32"}, "module.repAnalyzer.charts.zoom");
        jComboBox2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.zoomToolTip"));
        box2.add(jComboBox2);
        box2.add(new JPanel(new BorderLayout()));
        box.add(box2);
        final Box box3 = Box.createHorizontalBox();
        box.add(box3);
        box.add(Box.createVerticalStrut(2));
        Box box4 = Box.createHorizontalBox();
        box4.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.players")));
        box4.add(Box.createHorizontalStrut(5));
        int n = this.replay.details.players[nArray[0]].team;
        int n2 = 0;
        while (n2 < this.replay.details.players.length) {
            object2 = this.replay.details.players[nArray[n2]];
            jCheckBoxArray[n2] = new JCheckBox(((Details.Player)object2).name, ((Details.Player)object2).lastActionFrame > 0);
            jComponent3 = jCheckBoxArray[n2];
            ((AbstractButton)jComponent3).addActionListener(actionListener2);
            ((AbstractButton)jComponent3).addActionListener(actionListener);
            int n3 = this.replay.details.players[nArray[n2]].team;
            if (n3 != n) {
                box4.add(Box.createHorizontalStrut(7));
                box4.add(new JLabel("VS."));
                box4.add(Box.createHorizontalStrut(10));
                n = n3;
            }
            if (((Details.Player)object2).isWinner != null && ((Details.Player)object2).isWinner.booleanValue()) {
                jComponent2 = new JLabel(Icons.TROPHY);
                jComponent2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.players.winnerToolTip"));
                box4.add(jComponent2);
            }
            box4.add(jComponent3);
            box4.add(Box.createHorizontalStrut(3));
            ++n2;
        }
        box.add(box4);
        jPanel.add((Component)box, "North");
        final JSplitPane jSplitPane = new JSplitPane(0, true);
        jSplitPane.setDividerSize(6);
        object2 = GuiUtils.createComboBox(new Integer[]{1, 2, 3, 4, 5, 10, 15, 20, 30, 50, 100}, "module.repAnalyzer.charts.apm.granularity");
        ((JComboBox)object2).addActionListener(actionListener);
        jComponent3 = GuiUtils.createComboBox((Object[])ChartUtils.GraphApproximation.values(), "module.repAnalyzer.charts.apm.graphApproximation");
        ((JComboBox)jComponent3).addActionListener(actionListener);
        JCheckBox jCheckBox6 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.hotkeys.showSelectHotkeys", "module.repAnalyzer.charts.hotkeys.showSelectHotkeys");
        jCheckBox6.addActionListener(actionListener);
        jComponent2 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showBuilds", "module.repAnalyzer.charts.buildsTech.showBuilds");
        ((AbstractButton)jComponent2).addActionListener(actionListener);
        final JCheckBox jCheckBox7 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showTrains", "module.repAnalyzer.charts.buildsTech.showTrains");
        jCheckBox7.addActionListener(actionListener);
        final JCheckBox jCheckBox8 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showWorkers", "module.repAnalyzer.charts.buildsTech.showWorkers");
        ActionListener actionListener6 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox8.setEnabled(jCheckBox7.isSelected());
            }
        };
        actionListener6.actionPerformed(null);
        jCheckBox7.addActionListener(actionListener6);
        jCheckBox8.addActionListener(actionListener);
        JCheckBox jCheckBox9 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showResearches", "module.repAnalyzer.charts.buildsTech.showResearches");
        jCheckBox9.addActionListener(actionListener);
        JCheckBox jCheckBox10 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showUpgrades", "module.repAnalyzer.charts.buildsTech.showUpgrades");
        jCheckBox10.addActionListener(actionListener);
        JCheckBox jCheckBox11 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.useIcons", "module.repAnalyzer.charts.buildsTech.useIcons");
        jCheckBox11.addActionListener(actionListener);
        JCheckBox jCheckBox12 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showUnits", "module.repAnalyzer.charts.buildsTechStat.showUnits");
        jCheckBox12.addActionListener(actionListener);
        JCheckBox jCheckBox13 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showBuildings", "module.repAnalyzer.charts.buildsTechStat.showBuildings");
        jCheckBox13.addActionListener(actionListener);
        JCheckBox jCheckBox14 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showResearches", "module.repAnalyzer.charts.buildsTechStat.showResearches");
        jCheckBox14.addActionListener(actionListener);
        JCheckBox jCheckBox15 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showUpgrades", "module.repAnalyzer.charts.buildsTech.showUpgrades");
        jCheckBox15.addActionListener(actionListener);
        JCheckBox jCheckBox16 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showAbilityGroups", "module.repAnalyzer.charts.buildsTechStat.showAbilityGroups");
        jCheckBox16.addActionListener(actionListener);
        JComboBox jComboBox3 = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(IconHandler.Size.values(), EnumSet.of(IconHandler.Size.HIDDEN)), "module.repAnalyzer.charts.buildsTechStat.barSize");
        jComboBox3.addActionListener(actionListener);
        JCheckBox jCheckBox17 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.mapView.hideOverlappedBuildings", "module.repAnalyzer.charts.mapView.hideOverlappedBuildings");
        jCheckBox17.addActionListener(actionListener);
        JCheckBox jCheckBox18 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.mapView.fillBuildingIcons", "module.repAnalyzer.charts.mapView.fillBuildingIcons");
        jCheckBox18.addActionListener(actionListener);
        ActionListener actionListener7 = new ActionListener((JComboBox)object2, (JComboBox)jComponent3, jCheckBox6, (JCheckBox)jComponent2, jCheckBox7, jCheckBox8, jCheckBox9, jCheckBox10, jCheckBox11, jCheckBox12, jCheckBox13, jCheckBox14, jCheckBox15, jCheckBox16, jComboBox3, jCheckBox17, jCheckBox18, jPanel){
            private final /* synthetic */ JComboBox val$apmGranularityComboBox;
            private final /* synthetic */ JComboBox val$apmApproximationComboBox;
            private final /* synthetic */ JCheckBox val$showSelectHotkeysCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildsCheckBox;
            private final /* synthetic */ JCheckBox val$showTrainsCheckBox;
            private final /* synthetic */ JCheckBox val$showWorkersCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesCheckBox;
            private final /* synthetic */ JCheckBox val$useIconsCheckBox;
            private final /* synthetic */ JCheckBox val$showUnitsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildingsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsStatCheckBox;
            private final /* synthetic */ JComboBox val$barSizeComboBox;
            private final /* synthetic */ JCheckBox val$hideOverlappedBuildingsCheckBox;
            private final /* synthetic */ JCheckBox val$fillBuildingIconsCheckBox;
            private final /* synthetic */ JPanel val$chartsPanel;
            {
                this.val$apmGranularityComboBox = jComboBox2;
                this.val$apmApproximationComboBox = jComboBox3;
                this.val$showSelectHotkeysCheckBox = jCheckBox;
                this.val$showBuildsCheckBox = jCheckBox2;
                this.val$showTrainsCheckBox = jCheckBox3;
                this.val$showWorkersCheckBox = jCheckBox4;
                this.val$showResearchesCheckBox = jCheckBox5;
                this.val$showUpgradesCheckBox = jCheckBox6;
                this.val$useIconsCheckBox = jCheckBox7;
                this.val$showUnitsStatCheckBox = jCheckBox8;
                this.val$showBuildingsStatCheckBox = jCheckBox9;
                this.val$showResearchesStatCheckBox = jCheckBox10;
                this.val$showUpgradesStatCheckBox = jCheckBox11;
                this.val$showAbilityGroupsStatCheckBox = jCheckBox12;
                this.val$barSizeComboBox = jComboBox4;
                this.val$hideOverlappedBuildingsCheckBox = jCheckBox13;
                this.val$fillBuildingIconsCheckBox = jCheckBox14;
                this.val$chartsPanel = jPanel;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                box3.removeAll();
                switch ((ChartType)((Object)jComboBox.getSelectedItem())) {
                    case APM: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(new JLabel(Language.getText("charts.granularity")));
                        box3.add(this.val$apmGranularityComboBox);
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.apm.pixels")));
                        box3.add(Box.createHorizontalStrut(6));
                        box3.add(new JLabel(Language.getText("charts.graphApproximation")));
                        box3.add(this.val$apmApproximationComboBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case HOTKEYS: {
                        box3.add(this.val$showSelectHotkeysCheckBox);
                        break;
                    }
                    case BUILDS_TECH: {
                        box3.add(this.val$showBuildsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showTrainsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showWorkersCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showResearchesCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showUpgradesCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$useIconsCheckBox);
                        break;
                    }
                    case BUILDS_TECH_STAT: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(this.val$showUnitsStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showBuildingsStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showResearchesStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showUpgradesStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showAbilityGroupsStatCheckBox);
                        box3.add(Box.createHorizontalStrut(4));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.buildsTechStat.barSize")));
                        box3.add(this.val$barSizeComboBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case MAP_VIEW: {
                        box3.add(this.val$hideOverlappedBuildingsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$fillBuildingIconsCheckBox);
                    }
                }
                this.val$chartsPanel.validate();
                this.val$chartsPanel.repaint();
            }
        };
        jComboBox.addActionListener(actionListener7);
        actionListener7.actionPerformed(null);
        final Integer[] integerArray = new Integer[1];
        final Integer[] integerArray2 = new Integer[1];
        final GameEvents.Action[] actionArray2 = new GameEvents.Action[1];
        final ChartParams[] chartParamsArray = new ChartParams[1];
        final JScrollPane jScrollPane = new JScrollPane(21, 31);
        final JComponent jComponent4 = jComponentArray[0] = new JComponent((JComboBox)object2, (JComboBox)jComponent3, jCheckBox6, (JCheckBox)jComponent2, jCheckBox7, jCheckBox8, jCheckBox9, jCheckBox10, jCheckBox11, jCheckBox12, jCheckBox13, jCheckBox14, jCheckBox15, jCheckBox16, jComboBox3, jCheckBox17, jCheckBox18, jScrollPane){
            private final /* synthetic */ JComboBox val$apmGranularityComboBox;
            private final /* synthetic */ JComboBox val$apmApproximationComboBox;
            private final /* synthetic */ JCheckBox val$showSelectHotkeysCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildsCheckBox;
            private final /* synthetic */ JCheckBox val$showTrainsCheckBox;
            private final /* synthetic */ JCheckBox val$showWorkersCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesCheckBox;
            private final /* synthetic */ JCheckBox val$useIconsCheckBox;
            private final /* synthetic */ JCheckBox val$showUnitsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildingsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsStatCheckBox;
            private final /* synthetic */ JComboBox val$barSizeComboBox;
            private final /* synthetic */ JCheckBox val$hideOverlappedBuildingsCheckBox;
            private final /* synthetic */ JCheckBox val$fillBuildingIconsCheckBox;
            private final /* synthetic */ JScrollPane val$chartCanvasScrollPane;
            {
                this.val$apmGranularityComboBox = jComboBox3;
                this.val$apmApproximationComboBox = jComboBox4;
                this.val$showSelectHotkeysCheckBox = jCheckBox6;
                this.val$showBuildsCheckBox = jCheckBox7;
                this.val$showTrainsCheckBox = jCheckBox8;
                this.val$showWorkersCheckBox = jCheckBox9;
                this.val$showResearchesCheckBox = jCheckBox10;
                this.val$showUpgradesCheckBox = jCheckBox11;
                this.val$useIconsCheckBox = jCheckBox12;
                this.val$showUnitsStatCheckBox = jCheckBox13;
                this.val$showBuildingsStatCheckBox = jCheckBox14;
                this.val$showResearchesStatCheckBox = jCheckBox15;
                this.val$showUpgradesStatCheckBox = jCheckBox16;
                this.val$showAbilityGroupsStatCheckBox = jCheckBox17;
                this.val$barSizeComboBox = jComboBox5;
                this.val$hideOverlappedBuildingsCheckBox = jCheckBox18;
                this.val$fillBuildingIconsCheckBox = jCheckBox19;
                this.val$chartCanvasScrollPane = jScrollPane;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                ChartParams chartParams = chartParamsArray[0] = new ChartParams();
                chartParams.chartCanvas = jComponentArray[0];
                chartParams.markerFrame = integerArray[0];
                chartParams.markerX = integerArray2[0];
                chartParams.selectedAction = actionArray2[0];
                chartParams.visibleRectangle = this.getVisibleRect();
                chartParams.g2 = (Graphics2D)graphics;
                chartParams.replay = ReplayAnalyzer.this.replay;
                chartParams.actions = jCheckBox.isSelected() ? actionArray[0] : ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions;
                chartParams.chartType = (ChartType)((Object)jComboBox.getSelectedItem());
                chartParams.groupByTeam = jCheckBox2.isSelected();
                chartParams.allPlayersOnOneChart = jCheckBox3.isSelected();
                chartParams.usePlayersInGameColors = jCheckBox4.isSelected();
                chartParams.displayInSeconds = jCheckBox5.isSelected();
                chartParams.zoom = Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                chartParams.setVisiblePlayers(jCheckBoxArray, nArray);
                chartParams.width = this.getWidth();
                chartParams.height = this.getHeight();
                switch (chartParams.chartType) {
                    case APM: {
                        chartParams.apmGranularity = (Integer)this.val$apmGranularityComboBox.getSelectedItem();
                        chartParams.apmApproximation = (ChartUtils.GraphApproximation)((Object)this.val$apmApproximationComboBox.getSelectedItem());
                        break;
                    }
                    case HOTKEYS: {
                        chartParams.showSelectHotkeys = this.val$showSelectHotkeysCheckBox.isSelected();
                        break;
                    }
                    case BUILDS_TECH: {
                        chartParams.showBuilds = this.val$showBuildsCheckBox.isSelected();
                        chartParams.showTrains = this.val$showTrainsCheckBox.isSelected();
                        chartParams.showWorkers = this.val$showWorkersCheckBox.isSelected();
                        chartParams.showResearches = this.val$showResearchesCheckBox.isSelected();
                        chartParams.showUpgrades = this.val$showUpgradesCheckBox.isSelected();
                        chartParams.useIcons = this.val$useIconsCheckBox.isSelected();
                        break;
                    }
                    case BUILDS_TECH_STAT: {
                        chartParams.showUnitsStat = this.val$showUnitsStatCheckBox.isSelected();
                        chartParams.showBuildingsStat = this.val$showBuildingsStatCheckBox.isSelected();
                        chartParams.showResearchesStat = this.val$showResearchesStatCheckBox.isSelected();
                        chartParams.showUpgradesStat = this.val$showUpgradesStatCheckBox.isSelected();
                        chartParams.showAbilityGroupsStat = this.val$showAbilityGroupsStatCheckBox.isSelected();
                        chartParams.barSize = (IconHandler.Size)((Object)this.val$barSizeComboBox.getSelectedItem());
                        break;
                    }
                    case MAP_VIEW: {
                        chartParams.hideOverlappedBuildings = this.val$hideOverlappedBuildingsCheckBox.isSelected();
                        chartParams.fillBuildingIcons = this.val$fillBuildingIconsCheckBox.isSelected();
                    }
                }
                new ChartPainter(chartParams).paintChart();
            }

            @Override
            public Dimension getPreferredSize() {
                if (jComboBox.getSelectedItem() == ChartType.MAP_VIEW && ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo != null) {
                    int n = Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                    return new Dimension(((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.width * n << 1, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.height * n << 1);
                }
                Dimension dimension = this.val$chartCanvasScrollPane.getViewport().getExtentSize();
                dimension.width *= Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                return dimension;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                ChartParams chartParams = chartParamsArray[0];
                if (chartParams == null) {
                    return null;
                }
                if (chartParams.toolTipProvider == null) {
                    int n = chartParams.xToFrame(mouseEvent.getX());
                    return n < 0 ? null : Language.getText("module.repAnalyzer.tab.charts.chartTooltip.frameTime", n, ReplayUtils.formatFrames(n));
                }
                return chartParams.toolTipProvider.getToolTip(mouseEvent.getPoint());
            }
        };
        jComponent4.setToolTipText("");
        GuiUtils.makeComponentDragScrollable(jComponent4);
        final boolean[] blArray = new boolean[1];
        jComponent4.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    new ReplayOperationsPopupMenu(new File[]{ReplayAnalyzer.this.replayFile}, new ReplayOperationsPopupMenu.ReplayOpCallback(){

                        @Override
                        public void replayRenamed(File file, File file2, int n) {
                            ReplayAnalyzer.this.replayFile = file2;
                        }

                        @Override
                        public void replayMoved(File file, File file2, int n) {
                            ReplayAnalyzer.this.replayFile = new File(file2, file.getName());
                        }

                        @Override
                        public void replayDeleted(File file, int n) {
                        }

                        @Override
                        public void moveRenameDeleteEnded() {
                            ReplayAnalyzer.this.setTitle(GeneralUtils.getFileNameWithoutExt(ReplayAnalyzer.this.replayFile));
                            MainFrame.INSTANCE.refreshRepAnalNavigationNode();
                        }
                    }).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (jComboBox.getSelectedItem() != ChartType.MAP_VIEW) {
                    integerArray2[0] = Math.max(25, mouseEvent.getX());
                    integerArray[0] = null;
                    jComponent4.repaint();
                    if (chartParamsArray[0] != null && actionArray[0].length > 0) {
                        GameEvents.Action action = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.new GameEvents.Action();
                        action.frame = chartParamsArray[0].xToFrame(integerArray2[0]);
                        int n = Arrays.binarySearch(actionArray[0], action, ReplayUtils.ACTION_FRAME_COMPARATOR);
                        int n2 = n >= 0 ? n : (-n <= actionArray[0].length ? -n - 1 : -n - 2);
                        blArray[0] = true;
                        jList.setSelectedIndex(n2);
                        jList.ensureIndexIsVisible(n2);
                        blArray[0] = false;
                    }
                }
            }
        });
        jScrollPane.setViewportView(jComponent4);
        jSplitPane.setTopComponent(jScrollPane);
        final ActionListener actionListener8 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                jLabel2.setBackground(n == 1 ? null : Color.GREEN);
                if (jComboBox.getSelectedItem() == ChartType.MAP_VIEW) {
                    jScrollPane.setHorizontalScrollBarPolicy(32);
                    jScrollPane.setVerticalScrollBarPolicy(22);
                } else {
                    jScrollPane.setHorizontalScrollBarPolicy(n > 1 ? 32 : 31);
                    jScrollPane.setVerticalScrollBarPolicy(21);
                }
                jComponent4.invalidate();
                jScrollPane.validate();
            }
        };
        actionListener8.actionPerformed(null);
        jComboBox2.addActionListener(actionListener8);
        jComboBox.addActionListener(new ActionListener(){
            private boolean lastWasMapView;
            {
                this.lastWasMapView = jComboBox2.getSelectedItem() == ChartType.MAP_VIEW;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = jComboBox.getSelectedItem() == ChartType.MAP_VIEW;
                if (bl ^ this.lastWasMapView) {
                    actionListener8.actionPerformed(null);
                }
                this.lastWasMapView = bl;
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        Box box5 = Box.createHorizontalBox();
        box5.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.displayActionTypes")));
        box5.add(Box.createHorizontalStrut(5));
        Object object3 = ReplayConsts.ActionType.values();
        int n4 = ((ReplayConsts.ActionType[])object3).length;
        int n5 = 0;
        while (n5 < n4) {
            object = object3[n5];
            jComponent = GuiUtils.createCheckBox(((ReplayConsts.ActionType)((Object)object)).textKey, "module.repAnalyzer.charts.actions.actionType." + ((Enum)object).ordinal());
            ((AbstractButton)jComponent).addActionListener(actionListener2);
            enumMap.put((ReplayConsts.ActionType)((Object)object), (JCheckBox)jComponent);
            box5.add(jComponent);
            box5.add(Box.createHorizontalStrut(5));
            ++n5;
        }
        jPanel2.add((Component)box5, "North");
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && jList.getSelectedIndex() >= 0 && !blArray[0]) {
                    integerArray2[0] = null;
                    actionArray2[0] = actionArray[0][jList.getSelectedIndex()];
                    integerArray[0] = actionArray2[0].frame;
                    int n = integerArray[0];
                    if (chartParamsArray[0] != null) {
                        Rectangle rectangle = chartParamsArray[0].visibleRectangle;
                        if (chartParamsArray[0].chartType == ChartType.MAP_VIEW) {
                            int n2;
                            int n3;
                            GameEvents.BaseUseAbilityAction baseUseAbilityAction;
                            GameEvents.Action action = (GameEvents.Action)jList.getSelectedValue();
                            if (action instanceof GameEvents.BaseUseAbilityAction && (baseUseAbilityAction = (GameEvents.BaseUseAbilityAction)action).hasTargetPoint() && !rectangle.contains(n3 = chartParamsArray[0].scaleMapCoord(baseUseAbilityAction.targetP1), n2 = (((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.height * chartParamsArray[0].zoom << 1) - chartParamsArray[0].scaleMapCoord(baseUseAbilityAction.targetP2))) {
                                int n4 = Math.min(Math.min(10 * chartParamsArray[0].zoom, rectangle.width), rectangle.height);
                                jComponent4.scrollRectToVisible(new Rectangle(n3 - n4, n2 - n4, n4 << 1, n4 << 1));
                                jScrollPane.repaint();
                            }
                        } else if (n < rectangle.x || n >= rectangle.x + rectangle.width) {
                            jComponent4.scrollRectToVisible(new Rectangle(chartParamsArray[0].frameToX(n) - (rectangle.width >> 2), 0, rectangle.width >> 1, 1));
                        }
                    }
                    jComponent4.repaint();
                }
            }
        });
        jList.setFont(new Font("Monospaced", 0, 12));
        object = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.actions.invertColors", "module.repAnalyzer.charts.actions.invertColors");
        final JComboBox jComboBox4 = GuiUtils.createComboBox((Object[])IconHandler.Size.values(), "module.repAnalyzer.charts.actions.iconSize");
        jList.setCellRenderer(new ListCellRenderer((JCheckBox)object, jCheckBox4){
            private final JLabel label = new JLabel();
            private final /* synthetic */ JCheckBox val$invertListColorsCheckBox;
            private final /* synthetic */ JCheckBox val$usePlayersColorsCheckBox;
            {
                this.val$invertListColorsCheckBox = jCheckBox;
                this.val$usePlayersColorsCheckBox = jCheckBox2;
                this.label.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                GameEvents.Action action = (GameEvents.Action)object;
                IconHandler.Size size = (IconHandler.Size)((Object)jComboBox4.getSelectedItem());
                if (size == IconHandler.Size.HIDDEN) {
                    this.label.setIcon(null);
                } else if (action instanceof GameEvents.UseUnitAbilityAction) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.UseUnitAbilityAction)action).unitAbility.abilityGroup, size));
                } else if (action instanceof GameEvents.TrainAction) {
                    this.label.setIcon(Icons.getUnitIcon(((GameEvents.TrainAction)action).unit, size));
                } else if (action instanceof GameEvents.UseBuildingAbilityAction) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.UseBuildingAbilityAction)action).buildingAbility.abilityGroup, size));
                } else if (action instanceof GameEvents.BuildAction) {
                    this.label.setIcon(Icons.getBuildingIcon(((GameEvents.BuildAction)action).building, size));
                } else if (action instanceof GameEvents.UpgradeAction) {
                    this.label.setIcon(Icons.getUpgradeIcon(((GameEvents.UpgradeAction)action).upgrade, size));
                } else if (action instanceof GameEvents.ResearchAction) {
                    this.label.setIcon(Icons.getResearchIcon(((GameEvents.ResearchAction)action).research, size));
                } else if (action instanceof GameEvents.BaseUseAbilityAction && ((GameEvents.BaseUseAbilityAction)action).abilityGroup != null) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.BaseUseAbilityAction)action).abilityGroup, size));
                } else {
                    this.label.setIcon(IconHandler.NULL.get((Object)size));
                }
                this.label.setText(action.toString());
                if (bl ^ this.val$invertListColorsCheckBox.isSelected()) {
                    this.label.setBackground(this.val$usePlayersColorsCheckBox.isSelected() ? ((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players[action.player].getDarkerColor() : jList.getSelectionBackground());
                    this.label.setForeground(this.val$usePlayersColorsCheckBox.isSelected() ? Color.WHITE : jList.getSelectionForeground());
                } else {
                    this.label.setBackground(jList.getBackground());
                    this.label.setForeground(this.val$usePlayersColorsCheckBox.isSelected() ? ((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players[action.player].getDarkerColor() : jList.getForeground());
                }
                this.label.setEnabled(jList.isEnabled());
                this.label.setFont(jList.getFont());
                return this.label;
            }
        });
        jPanel2.add((Component)new JScrollPane(jList), "Center");
        Box box6 = Box.createVerticalBox();
        object3 = new JPanel(new GridLayout(4, 2, 0, 0));
        ((Container)object3).add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.jumpToFrame")));
        jComponent = new JTextField(1);
        jComponent.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.jumpToFrameToolTip"));
        ((JTextField)jComponent).addActionListener(new ActionListener((JTextField)jComponent, jList, jComponent4){
            private final /* synthetic */ JTextField val$jumpToFrameTextField;
            private final /* synthetic */ JList val$actionsList;
            private final /* synthetic */ JComponent val$chartCanvas;
            {
                this.val$jumpToFrameTextField = jTextField;
                this.val$actionsList = jList;
                this.val$chartCanvas = jComponent;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionArray[0].length > 0) {
                    try {
                        int n = Integer.parseInt(this.val$jumpToFrameTextField.getText());
                        GameEvents.Action action = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.new GameEvents.Action();
                        action.frame = n;
                        int n2 = Arrays.binarySearch(actionArray[0], action, ReplayUtils.ACTION_FRAME_COMPARATOR);
                        int n3 = n2 >= 0 ? n2 : (-n2 <= actionArray[0].length ? -n2 - 1 : -n2 - 2);
                        this.val$actionsList.setSelectedIndex(n3);
                        this.val$actionsList.ensureIndexIsVisible(n3);
                        this.val$chartCanvas.repaint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        ((Container)object3).add(jComponent);
        ((Container)object3).add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.searchText")));
        final JTextField jTextField = new JTextField(1);
        jTextField.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.searchTextToolTip"));
        jTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText().trim().toLowerCase();
                if (actionArray[0].length > 0 && string.length() > 0) {
                    int n;
                    GameEvents.Action[] actionArray2 = actionArray[0];
                    int n2 = n = jList.getSelectedIndex() < 0 ? actionArray2.length - 1 : jList.getSelectedIndex();
                    do {
                        if (++n2 == actionArray2.length) {
                            n2 = 0;
                        }
                        if (!actionArray2[n2].toString().toLowerCase().contains(string)) continue;
                        jList.setSelectedIndex(n2);
                        jList.ensureIndexIsVisible(n2);
                        jComponent4.repaint();
                        break;
                    } while (n2 != n);
                }
            }
        });
        ((Container)object3).add(jTextField);
        final JLabel jLabel3 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterActions"));
        jLabel3.setOpaque(true);
        ((Container)object3).add(jLabel3);
        final JTextField jTextField2 = new JTextField(1);
        jTextField2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterActionsToolTip"));
        final ActionListener actionListener9 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stringArray[0] = ReplayAnalyzer.createFilterGroups(jTextField2.getText());
                jLabel3.setBackground(stringArray[0] == null ? null : Color.GREEN);
                if (actionEvent != null) {
                    actionListener2.actionPerformed(null);
                }
            }
        };
        jTextField2.addActionListener(actionListener9);
        ((Container)object3).add(jTextField2);
        final JLabel jLabel4 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterOutActions"));
        jLabel4.setOpaque(true);
        ((Container)object3).add(jLabel4);
        final JTextField jTextField3 = new JTextField(1);
        jTextField3.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterOutActionsToolTip"));
        final ActionListener actionListener10 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stringArray2[0] = ReplayAnalyzer.createFilterGroups(jTextField3.getText());
                jLabel4.setBackground(stringArray2[0] == null ? null : Color.GREEN);
                if (actionEvent != null) {
                    actionListener2.actionPerformed(null);
                }
            }
        };
        jTextField3.addActionListener(actionListener10);
        ((Container)object3).add(jTextField3);
        box6.add((Component)object3);
        object3 = new JPanel(new GridLayout(1, 2, 0, 0));
        ((Container)object3).add(new JLabel());
        JButton jButton = new JButton();
        GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.charts.actionOps.clearFiltersButton", new Object[0]);
        jButton.putClientProperty("JComponent.sizeVariant", "small");
        jButton.updateUI();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField2.setText("");
                jTextField3.setText("");
                actionListener9.actionPerformed(null);
                actionListener10.actionPerformed(null);
                actionListener2.actionPerformed(null);
            }
        });
        ((Container)object3).add(jButton);
        box6.add((Component)object3);
        box6.add(new JPanel(new BorderLayout()));
        box6.setMinimumSize(new Dimension(10, 10));
        jPanel2.add((Component)box6, "East");
        Box box7 = Box.createHorizontalBox();
        box7.add(jLabel);
        box7.add(Box.createHorizontalStrut(12));
        ((AbstractButton)object).addActionListener(actionListener3);
        box7.add((Component)object);
        box7.add(Box.createHorizontalStrut(12));
        box7.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actions.iconSizes")));
        jComboBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jList.updateUI();
            }
        });
        box7.add(jComboBox4);
        box7.add(Box.createHorizontalStrut(12));
        jCheckBox.setOpaque(true);
        ActionListener actionListener11 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox.setBackground(jCheckBox.isSelected() ? Color.GREEN : null);
            }
        };
        actionListener11.actionPerformed(null);
        jCheckBox.addActionListener(actionListener11);
        jCheckBox.addActionListener(actionListener);
        box7.add(jCheckBox);
        box7.add(new JPanel(new BorderLayout()));
        jPanel2.add((Component)box7, "South");
        jSplitPane.setBottomComponent(jPanel2);
        jPanel.add(jSplitPane);
        jSplitPane.setResizeWeight(0.7);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jSplitPane.setDividerLocation(0.7);
            }
        });
        actionListener2.actionPerformed(null);
        Object object4 = new Object();
        ChartType[] chartTypeArray = ChartType.values();
        int n6 = chartTypeArray.length;
        int n7 = 0;
        while (n7 < n6) {
            final ChartType chartType = chartTypeArray[n7];
            object4 = new Object();
            jPanel.getInputMap(1).put(chartType.keyStroke, object4);
            jPanel.getActionMap().put(object4, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jComboBox.setSelectedItem((Object)chartType);
                }
            });
            ++n7;
        }
        object4 = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(73, 2), object4);
        jPanel.getActionMap().put(object4, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox2.getSelectedIndex() < jComboBox2.getItemCount() - 1) {
                    jComboBox2.setSelectedIndex(jComboBox2.getSelectedIndex() + 1);
                }
            }
        });
        object4 = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(85, 2), object4);
        jPanel.getActionMap().put(object4, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox2.getSelectedIndex() > 0) {
                    jComboBox2.setSelectedIndex(jComboBox2.getSelectedIndex() - 1);
                }
            }
        });
        object4 = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(74, 2), object4);
        jPanel.getActionMap().put(object4, new AbstractAction((JTextField)jComponent){
            private final /* synthetic */ JTextField val$jumpToFrameTextField;
            {
                this.val$jumpToFrameTextField = jTextField;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$jumpToFrameTextField.requestFocusInWindow();
            }
        });
        object4 = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(83, 2), object4);
        jPanel.getActionMap().put(object4, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField.requestFocusInWindow();
            }
        });
        object4 = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(70, 2), object4);
        jPanel.getActionMap().put(object4, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField2.requestFocusInWindow();
            }
        });
        object4 = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(84, 2), object4);
        jPanel.getActionMap().put(object4, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField3.requestFocusInWindow();
            }
        });
        return jPanel;
    }

    private static String[][] createFilterGroups(String string) {
        String[][] stringArray;
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase());
        ArrayList<String[][]> arrayList2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (stringArray.equals("or")) {
                arrayList2 = null;
                continue;
            }
            if (stringArray.equals("and")) continue;
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<String[][]>(2);
                arrayList.add(arrayList2);
            }
            arrayList2.add(stringArray);
        }
        stringArray = new String[arrayList.size()][];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((List)arrayList.get(n)).toArray(new String[0]);
            ++n;
        }
        return stringArray;
    }

    private JComponent createGameInfoTab() {
        Details.Player[] playerArray;
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setTabSize(4);
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.fileName", this.replayFile.getAbsolutePath()));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.version", this.replay.version));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.date", Language.formatDateTime(new Date(this.replayFile.lastModified()))));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gameLength", ReplayUtils.formatMs(this.replay.gameLength * 500)));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gameSpeed", new Object[]{this.replay.initData.gameSpeed}));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gameType", new Object[]{this.replay.initData.gameType}));
        if (this.replay.initData.format != null) {
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.format", new Object[]{this.replay.initData.format}));
        }
        if (this.replay.initData.gateway != null) {
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gateway", new Object[]{this.replay.initData.gateway}));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.replay.initData.clientNames;
        Object object2 = this.replay.initData.clientNames.length;
        int n = 0;
        while (n < object2) {
            object = stringArray[n];
            if (((String)object).length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)object);
            }
            ++n;
        }
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.clients", stringBuilder));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapName", this.replay.details.mapName));
        if (this.replay.initData.mapFileName != null) {
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapFile", this.replay.initData.mapFileName));
        }
        if (this.replay.mapInfo != null) {
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapSize", this.replay.mapInfo.getSizeString()));
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapPlayableSize", this.replay.mapInfo.getPlayableSizeString()));
        }
        jTextArea.append("\n");
        jTextArea.append(Language.getText("module.repAnalyzer.tab.gameInfo.players"));
        object = this.replay.details.getTeamOrderPlayerIndeces();
        n = -1;
        Object object3 = object;
        int n2 = ((Object)object3).length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = object3[n3];
            playerArray = this.replay.details.players[object2];
            if (playerArray.team != n) {
                jTextArea.append("\n\t" + Language.getText("module.repAnalyzer.tab.gameInfo.team", playerArray.team == Integer.MAX_VALUE ? Language.getText("general.unknown") : Integer.valueOf(playerArray.team)));
                n = playerArray.team;
            }
            jTextArea.append("\n\t\t");
            jTextArea.append(playerArray.fullName);
            jTextArea.append(", ");
            jTextArea.append(playerArray.raceString());
            if (playerArray.type != null) {
                jTextArea.append(", ");
                jTextArea.append(playerArray.type.stringValue);
                if (playerArray.type == ReplayConsts.PlayerType.COMPUTER) {
                    jTextArea.append(" (");
                    jTextArea.append(playerArray.difficulty.stringValue);
                    jTextArea.append(")");
                }
            }
            jTextArea.append(", ");
            jTextArea.append(playerArray.getColorName());
            ++n3;
        }
        jTextArea.append("\n");
        jTextArea.append("\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        playerArray = this.replay.details.players;
        int n4 = this.replay.details.players.length;
        n2 = 0;
        while (n2 < n4) {
            Details.Player player = playerArray[n2];
            if (player.isWinner != null && player.isWinner.booleanValue()) {
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(player.name);
            }
            ++n2;
        }
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.winners", stringBuilder2.toString()));
        jPanel.add(new JScrollPane(jTextArea));
        return jPanel;
    }

    private JComponent createInGameChatTab() {
        Object object;
        Object object2;
        StyleContext styleContext = new StyleContext();
        Style style = styleContext.addStyle("default", StyleContext.getDefaultStyleContext().getStyle("default"));
        int n = 0;
        Object object3 = this.replay.details.players;
        int n2 = this.replay.details.players.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = object3[n3];
            object = styleContext.addStyle("p" + n, style);
            StyleConstants.setForeground((MutableAttributeSet)object, ((Details.Player)object2).getDarkerColor());
            ++n;
            ++n3;
        }
        object2 = new JPanel(new BorderLayout());
        Box box = Box.createHorizontalBox();
        JTextPane jTextPane = new JTextPane(){

            @Override
            public void paint(Graphics graphics) {
                Container container = this;
                while (!(container instanceof JViewport)) {
                    container = container.getParent();
                }
                Rectangle rectangle = ((JViewport)container).getViewRect();
                graphics.setColor(new Color(240, 240, 240));
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                super.paint(graphics);
            }
        };
        jTextPane.setOpaque(false);
        jTextPane.setBackground(new Color(0, 0, 0, 0));
        object3 = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.hideMessageTarget", "module.repAnalyzer.inGameChat.hideMessageTargets");
        object = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.showBlinks", "module.repAnalyzer.inGameChat.showBlinks");
        JCheckBox jCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.formatIntoParagraphs", "module.repAnalyzer.inGameChat.formatIntoParagraphs");
        ActionListener actionListener = new ActionListener((JCheckBox)object3, (JCheckBox)object, jCheckBox, jTextPane, styleContext){
            private final /* synthetic */ JCheckBox val$hideMessageTargetsCheckBox;
            private final /* synthetic */ JCheckBox val$showBlinksCheckBox;
            private final /* synthetic */ JCheckBox val$formatIntoParagraphsCheckBox;
            private final /* synthetic */ JTextPane val$chatTextPane;
            private final /* synthetic */ StyleContext val$STYLE_CONTEX;
            {
                this.val$hideMessageTargetsCheckBox = jCheckBox;
                this.val$showBlinksCheckBox = jCheckBox2;
                this.val$formatIntoParagraphsCheckBox = jCheckBox3;
                this.val$chatTextPane = jTextPane;
                this.val$STYLE_CONTEX = styleContext;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = this.val$hideMessageTargetsCheckBox.isSelected();
                boolean bl2 = this.val$showBlinksCheckBox.isSelected();
                boolean bl3 = this.val$formatIntoParagraphsCheckBox.isSelected();
                String string = bl ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAll");
                String string2 = bl ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAllies");
                this.val$chatTextPane.setText("");
                int n = 0;
                int n2 = 0;
                Document document = this.val$chatTextPane.getDocument();
                MessageEvents.Message[] messageArray = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.messageEvents.messages;
                int n3 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.messageEvents.messages.length;
                int n4 = 0;
                while (n4 < n3) {
                    MessageEvents.Message message;
                    MessageEvents.Message message2 = messageArray[n4];
                    n2 = n;
                    String string3 = null;
                    String string4 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.initData.clientNames[message2.client];
                    n += message2.time;
                    if (message2 instanceof MessageEvents.Text) {
                        message = (MessageEvents.Text)message2;
                        string3 = bl ? Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageNoTarget", ReplayUtils.formatMs(n), string4, message.text) : Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageFull", ReplayUtils.formatMs(n), string4, message.opCode == 0 ? string : string2, message.text);
                    } else if (message2 instanceof MessageEvents.Blink && bl2) {
                        message = (MessageEvents.Blink)message2;
                        string3 = Language.getText("module.repAnalyzer.tab.inGameChat.blinkMessage", ReplayUtils.formatMs(n), string4, ReplayUtils.formatCoordinate(((MessageEvents.Blink)message).x), ReplayUtils.formatCoordinate(((MessageEvents.Blink)message).y));
                    }
                    if (string3 != null) {
                        try {
                            document.insertString(document.getLength(), bl3 && n - n2 > 6000 && n2 > 0 ? "\n" + string3 + "\n" : String.valueOf(string3) + "\n", this.val$STYLE_CONTEX.getStyle("p" + message2.client));
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                    ++n4;
                }
                this.val$chatTextPane.setCaretPosition(0);
            }
        };
        ((AbstractButton)object3).addActionListener(actionListener);
        ((AbstractButton)object).addActionListener(actionListener);
        jCheckBox.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        box.add((Component)object3);
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)object);
        box.add(Box.createHorizontalStrut(10));
        box.add(jCheckBox);
        ((Container)object2).add((Component)GuiUtils.wrapInPanel(box), "North");
        jTextPane.setEditable(false);
        ((Container)object2).add((Component)new JScrollPane(jTextPane), "Center");
        return object2;
    }

    private JComponent createMapPreviewTab() {
        Object object;
        Object object2;
        Serializable serializable;
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        Box box = Box.createVerticalBox();
        JLabel jLabel2 = new JLabel(Language.getText("module.repAnalyzer.tab.gameInfo.mapName", this.replay.mapInfo == null ? this.replay.details.mapName : String.valueOf(this.replay.details.mapName) + " " + this.replay.mapInfo.getPlayableSizeString() + " (" + this.replay.mapInfo.getSizeString() + ")"), 0);
        GuiUtils.changeFontToBold(jLabel2);
        box.add(GuiUtils.wrapInPanel(jLabel2));
        if (this.replay.mapInfo == null && (serializable = ReplayParser.getMapFile(this.replay)) != null && !((File)serializable).exists() && ((String)(object2 = ((File)serializable).getName())).length() == 69) {
            object = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            JLabel jLabel3 = new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.mapFileNotExists"), 0);
            box2.add(jLabel3);
            box2.add(Box.createHorizontalStrut(5));
            Box box3 = Box.createHorizontalBox();
            JComboBox jComboBox = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(ReplayConsts.Gateway.values(), EnumSet.of(ReplayConsts.Gateway.UNKNOWN)), "module.repAnalyzer.mapPreview.downloadFromGateway");
            JButton jButton = new JButton(Icons.DRIVE_DOWNLOAD);
            GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.mapPreview.downloadMapButton", new Object[0]);
            jButton.addActionListener(new ActionListener((Box)object, box3, jButton, jLabel3, jComboBox, (String)object2, (File)serializable, jPanel, box2){
                private final /* synthetic */ Box val$downloadBox;
                private final /* synthetic */ Box val$downloadSourceBox;
                private final /* synthetic */ JButton val$downloadButton;
                private final /* synthetic */ JLabel val$downloadInfoLabel;
                private final /* synthetic */ JComboBox val$downloadFromGatewayComboBox;
                private final /* synthetic */ String val$mapFileName;
                private final /* synthetic */ File val$mapFile;
                private final /* synthetic */ JPanel val$mapPreviewPanel;
                private final /* synthetic */ Box val$controlBox;
                {
                    this.val$downloadBox = box;
                    this.val$downloadSourceBox = box2;
                    this.val$downloadButton = jButton;
                    this.val$downloadInfoLabel = jLabel;
                    this.val$downloadFromGatewayComboBox = jComboBox;
                    this.val$mapFileName = string;
                    this.val$mapFile = file;
                    this.val$mapPreviewPanel = jPanel;
                    this.val$controlBox = box3;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$downloadBox.remove(this.val$downloadSourceBox);
                    this.val$downloadButton.setEnabled(false);
                    this.val$downloadInfoLabel.setText(Language.getText("module.repAnalyzer.tab.mapPreview.downloadingMap"));
                    String string = String.valueOf(((ReplayConsts.Gateway)((Object)this.val$downloadFromGatewayComboBox.getSelectedItem())).depotServerUrl) + this.val$mapFileName;
                    Downloader[] downloaderArray = new Downloader[1];
                    Downloader downloader = downloaderArray[0] = new Downloader(string, this.val$mapFile, new Downloader.Callback(downloaderArray){
                        private final InternalFrameListener downloadStopperListener;
                        {
                            this.downloadStopperListener = new InternalFrameAdapter(){

                                @Override
                                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                    downloaderArray[0].requestToCancel();
                                }
                            };
                            ReplayAnalyzer.this.addInternalFrameListener(this.downloadStopperListener);
                        }

                        @Override
                        public void downloadFinished(boolean bl) {
                            ReplayAnalyzer.this.removeInternalFrameListener(this.downloadStopperListener);
                            if (!ReplayAnalyzer.this.isClosed()) {
                                val$downloadInfoLabel.setText(Language.getText(bl ? "module.repAnalyzer.tab.mapPreview.mapDownloaded" : "module.repAnalyzer.tab.mapPreview.mapDownloadFailed"));
                                val$controlBox.remove(val$downloadButton);
                                JButton jButton = new JButton(Icons.ARROW_CIRCLE_DOUBLE);
                                GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.mapPreview.reopenReplayButton", new Object[0]);
                                jButton.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        try {
                                            ReplayAnalyzer.this.setClosed(true);
                                        }
                                        catch (PropertyVetoException propertyVetoException) {
                                            // empty catch block
                                        }
                                        MainFrame.INSTANCE.openReplayFile(ReplayAnalyzer.this.replayFile);
                                    }
                                });
                                val$controlBox.add(jButton);
                                val$mapPreviewPanel.validate();
                            }
                        }
                    });
                    this.val$downloadBox.add(downloader.progressBar);
                    this.val$mapPreviewPanel.validate();
                    downloader.start();
                }
            });
            box2.add(jButton);
            ((Container)object).add(box2);
            box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.downloadFromGateway")));
            box3.add(jComboBox);
            ((Container)object).add(box3);
            box.add((Component)object);
        }
        serializable = Box.createHorizontalBox();
        ((Container)serializable).add(new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.zoom")));
        object2 = new JSlider(0, 6, Settings.getInt("module.repAnalyzer.mapPreview.zoom"));
        ((JSlider)object2).setPaintLabels(true);
        ((JSlider)object2).setPaintTicks(true);
        ((JSlider)object2).setSnapToTicks(true);
        ((JSlider)object2).setMajorTickSpacing(1);
        ((JSlider)object2).setLabelTable(LABEL_DICTIONARY);
        object = new ChangeListener((JSlider)object2, jLabel){
            private final /* synthetic */ JSlider val$zoomSlider;
            private final /* synthetic */ JLabel val$mapPreviewLabel;
            {
                this.val$zoomSlider = jSlider;
                this.val$mapPreviewLabel = jLabel;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (this.val$zoomSlider.getValueIsAdjusting()) {
                    return;
                }
                int n = this.val$zoomSlider.getValue();
                if (((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo == null) {
                    this.val$mapPreviewLabel.setText(Language.getText("module.repAnalyzer.tab.mapPreview.previewNotAvailable"));
                } else {
                    int n2 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getIconWidth();
                    int n3 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getIconHeight();
                    this.val$mapPreviewLabel.setIcon(new ImageIcon(((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getImage().getScaledInstance(n == 0 ? n2 / 2 : n2 * n, n == 0 ? n3 / 2 : n3 * n, 4)));
                }
                if (changeEvent != null) {
                    Settings.set("module.repAnalyzer.mapPreview.zoom", n);
                }
            }
        };
        object.stateChanged(null);
        ((JSlider)object2).addChangeListener((ChangeListener)object);
        ((Container)serializable).add((Component)object2);
        box.add((Component)serializable);
        jPanel.add((Component)GuiUtils.wrapInPanel(box), "North");
        jLabel.setHorizontalAlignment(0);
        GuiUtils.makeComponentDragScrollable(jLabel);
        jPanel.add((Component)new JScrollPane(jLabel), "Center");
        return jPanel;
    }

    public static enum ChartType {
        APM("module.repAnalyzer.tab.charts.chartType.apm"),
        HOTKEYS("module.repAnalyzer.tab.charts.chartType.hotkeys"),
        BUILDS_TECH("module.repAnalyzer.tab.charts.chartType.buildsTech"),
        BUILDS_TECH_STAT("module.repAnalyzer.tab.charts.chartType.buildsTechStat"),
        MAP_VIEW("module.repAnalyzer.tab.charts.chartType.mapView");

        public final String stringValue;
        public final KeyStroke keyStroke;

        private ChartType(String string2) {
            this.stringValue = Language.getText(string2);
            this.keyStroke = KeyStroke.getKeyStroke(49 + this.ordinal(), 2);
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

