/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay.model;

import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Details;
import java.util.Map;

public class GameEvents {
    public static final int EVENT_TYPE_INITIALIZATION = 0;
    public static final int EVENT_TYPE_ACTION = 1;
    public static final int EVENT_TYPE_UNNAMED = 2;
    public static final int EVENT_TYPE_REPLAY = 3;
    public static final int EVENT_TYPE_INACTION = 4;
    public static final int EVENT_TYPE_SYSTEM = 5;
    public static final byte OP_CODE_AUTO_SYNC = 0;
    public static final byte OP_CODE_GAME_START = 5;
    public static final byte OP_CODE_ALLIANCE = 6;
    public static final byte OP_CODE_PLAYER_LEAVE = 9;
    public static final byte OP_CODE_USE_ABILITY = 11;
    public static final byte OP_CODE_PLAYER_INIT_JOIN = 11;
    public static final byte OP_CODE_SELECT_FOLLOW_UP = -119;
    public static final byte OP_CODE_SELECT_DESELECT = -84;
    public String[] playerNames;
    public boolean displayInSeconds;
    public Action[] actions;
    public final Map<Short, String> unitTypeNameMap;
    private static String[] SPACES = new String[30];

    static {
        GameEvents.SPACES[0] = "";
        int n = 1;
        while (n < SPACES.length) {
            GameEvents.SPACES[n] = String.valueOf(SPACES[n - 1]) + ' ';
            ++n;
        }
    }

    public GameEvents(Details.Player[] playerArray, Map<Short, String> map) {
        int n = 0;
        Details.Player[] playerArray2 = playerArray;
        int n2 = playerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Details.Player player = playerArray2[n3];
            if (n < player.name.length()) {
                n = player.name.length();
            }
            ++n3;
        }
        this.playerNames = new String[playerArray.length];
        int n4 = 0;
        while (n4 < this.playerNames.length) {
            this.playerNames[n4] = "  " + playerArray[n4].name + SPACES[n - playerArray[n4].name.length() + 2];
            ++n4;
        }
        this.unitTypeNameMap = map;
    }

    public class Action {
        public int frame;
        public byte player;
        public byte opCode;
        public ReplayConsts.ActionType type = ReplayConsts.ActionType.OTHER;

        protected String toStringTemplate() {
            return String.valueOf(GameEvents.this.displayInSeconds ? ReplayUtils.formatFramesShort(this.frame) : String.format("%6d", this.frame)) + GameEvents.this.playerNames[this.player];
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(GameEvents.this.displayInSeconds ? ReplayUtils.formatFramesShort(this.frame) : String.format("%6d", this.frame));
            stringBuilder.append(GameEvents.this.playerNames[this.player]);
            this.customToString(stringBuilder);
            return stringBuilder.toString();
        }

        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("0x").append(Integer.toHexString(this.opCode & 0xFF));
        }
    }

    public class AllianceAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Set Alliance");
        }
    }

    public class BaseUseAbilityAction
    extends Action {
        public int abilityCode;
        public String abilityName;
        public ReplayConsts.AbilityGroup abilityGroup;
        public boolean targetIsUnit;
        public int targetP1;
        public int targetP2;

        public BaseUseAbilityAction() {
        }

        public BaseUseAbilityAction(String string, ReplayConsts.AbilityGroup abilityGroup) {
            this.abilityName = string;
            this.abilityGroup = abilityGroup;
        }

        @Override
        protected final void customToString(StringBuilder stringBuilder) {
            this.customAbilToString(stringBuilder);
            if (this.targetIsUnit) {
                stringBuilder.append("; target: ");
                String string = GameEvents.this.unitTypeNameMap.get((short)this.targetP2);
                if (string == null) {
                    stringBuilder.append("Unknown[").append(Integer.toHexString(this.targetP2)).append(']');
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(" (").append(Integer.toHexString(this.targetP1)).append(')');
            } else if (this.targetP1 != 256 || this.targetP2 != 256) {
                stringBuilder.append("; target: ");
                stringBuilder.append("x=").append(ReplayUtils.formatCoordinate(this.targetP1)).append(",y=").append(ReplayUtils.formatCoordinate(this.targetP2));
            }
        }

        protected void customAbilToString(StringBuilder stringBuilder) {
            if (this.abilityName == null) {
                stringBuilder.append("Use ability ").append(String.format("%6x", this.abilityCode));
            } else {
                stringBuilder.append(this.abilityName);
            }
        }

        public boolean hasTargetPoint() {
            return !this.targetIsUnit && (this.targetP1 != 256 || this.targetP2 != 256);
        }
    }

    public class BuildAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Building building;

        public BuildAction(ReplayConsts.Building building) {
            this.type = ReplayConsts.ActionType.BUILD;
            this.building = building;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Build ").append(this.building.stringValue);
        }
    }

    public class CancelResRequestAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Cancel trade");
        }
    }

    public class HotkeyAction
    extends Action {
        public boolean isSelect;

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Hotkey ").append(this.isSelect ? "Select " : "Assign ").append((this.opCode & 0xFF) >> 4);
        }
    }

    public class LeaveGameAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Leave game");
        }
    }

    public class MoveScreenAction
    extends Action {
        public int x;
        public int y;
        public int hor;
        public int vert;

        public MoveScreenAction() {
            this.type = ReplayConsts.ActionType.INACTION;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Move screen x=").append(this.x >> 8).append('.').append(ReplayUtils.DECIMAL_TABLE[this.x & 0xFF]).append(",y=").append(this.y >> 8).append('.').append(ReplayUtils.DECIMAL_TABLE[this.y & 0xFF]);
        }
    }

    public class RequestResoucesAction
    extends Action {
        public int minRequested;
        public int gasRequested;

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Request resources ").append(this.minRequested).append(',').append(this.gasRequested);
        }
    }

    public class ResearchAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Research research;

        public ResearchAction(ReplayConsts.Research research) {
            this.type = ReplayConsts.ActionType.RESEARCH;
            this.research = research;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Research ").append(this.research.stringValue);
        }
    }

    public class SelectAction
    extends Action {
        public boolean automatic;
        public int deselectionBitsCount;
        public byte[] deselectionUnitBitmap;
        public short[] unitTypes;
        public byte[] unitsOfTypeCounts;
        public int[] unitIds;

        public SelectAction() {
            this.type = ReplayConsts.ActionType.SELECT;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            if (this.automatic) {
                stringBuilder.append("Selection auto-update ");
            }
            int n = 0;
            if (this.unitTypes != null) {
                int n2 = 0;
                while (n2 < this.unitTypes.length) {
                    stringBuilder.append(n2 == 0 ? "Select " : ", ");
                    String string = GameEvents.this.unitTypeNameMap.get(this.unitTypes[n2]);
                    if (string == null) {
                        stringBuilder.append("Unknown[").append(Integer.toHexString(this.unitTypes[n2])).append(']');
                    } else {
                        stringBuilder.append(string);
                    }
                    int n3 = this.unitsOfTypeCounts[n2];
                    if (n3 > 1) {
                        stringBuilder.append(" x").append(this.unitsOfTypeCounts[n2]);
                    }
                    stringBuilder.append(" (");
                    int n4 = n3;
                    while (n4 > 0) {
                        stringBuilder.append(Integer.toHexString(this.unitIds[n])).append(',');
                        --n4;
                        ++n;
                    }
                    stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
                    ++n2;
                }
            }
            if (this.deselectionBitsCount > 0) {
                if (this.unitTypes.length > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("Deselect ").append(this.deselectionBitsCount).append(this.deselectionBitsCount == 1 ? " unit" : " units");
            }
        }
    }

    public class SendResourcesAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Send resources");
        }
    }

    public class TrainAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Unit unit;

        public TrainAction(ReplayConsts.Unit unit) {
            this.type = ReplayConsts.ActionType.TRAIN;
            this.unit = unit;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Train ").append(this.unit.stringValue);
        }
    }

    public class TrainHallucinatedAction
    extends TrainAction {
        public TrainHallucinatedAction(ReplayConsts.Unit unit) {
            super(unit);
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Train ").append(this.unit.stringValue).append(" Hallucination (Sentry)");
        }
    }

    public class UpgradeAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Upgrade upgrade;

        public UpgradeAction(ReplayConsts.Upgrade upgrade) {
            this.type = ReplayConsts.ActionType.UPGRADE;
            this.upgrade = upgrade;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Upgrade ").append(this.upgrade.stringValue);
        }
    }

    public class UseBuildingAbilityAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.BuildingAbility buildingAbility;
        public final ReplayConsts.Building building;

        public UseBuildingAbilityAction(ReplayConsts.BuildingAbility buildingAbility, ReplayConsts.Building building) {
            this.buildingAbility = buildingAbility;
            this.building = building;
            this.abilityGroup = buildingAbility.abilityGroup;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append(this.buildingAbility.stringValue).append(" (").append(this.building.stringValue).append(')');
        }
    }

    public class UseUnitAbilityAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.UnitAbility unitAbility;
        public final ReplayConsts.Unit unit;

        public UseUnitAbilityAction(ReplayConsts.UnitAbility unitAbility, ReplayConsts.Unit unit) {
            this.unitAbility = unitAbility;
            this.unit = unit;
            this.abilityGroup = unitAbility.abilityGroup;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append((Object)this.unitAbility).append(" (").append(this.unit.stringValue).append(')');
        }
    }

    public class WarpAction
    extends TrainAction {
        public WarpAction(ReplayConsts.Unit unit) {
            super(unit);
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Train ").append(this.unit.stringValue).append(" (Warp gate)");
        }
    }
}

