/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay;

import hu.belicza.andras.sc2gears.mpq.MpqParser;
import hu.belicza.andras.sc2gears.mpq.model.UserData;
import hu.belicza.andras.sc2gears.replay.AbilityCodes;
import hu.belicza.andras.sc2gears.replay.BitBufferView;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Details;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import hu.belicza.andras.sc2gears.replay.model.InitData;
import hu.belicza.andras.sc2gears.replay.model.MapInfo;
import hu.belicza.andras.sc2gears.replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.CommonUtils;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.Pair;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReplayParser {
    private static final byte[] STAR_S2MA = new byte[]{42, 115, 50, 109, 97};
    private static final byte[] S2MA = new byte[]{115, 50, 109, 97};
    public static final Set<ReplayContent> ALL_CONTENT = EnumSet.allOf(ReplayContent.class);
    public static final Set<ReplayContent> GENERAL_INFO_CONTENT = EnumSet.of(ReplayContent.INIT_DATA, ReplayContent.DETAILS, ReplayContent.ATTRIBUTES_EVENTS);

    private ReplayParser() {
    }

    public static Replay parseReplay(String string, Set<ReplayContent> set) {
        MpqParser mpqParser = null;
        try {
            mpqParser = new MpqParser(string);
            Replay replay = new Replay();
            UserData userData = mpqParser.getUserData();
            ByteBuffer byteBuffer = ByteBuffer.wrap(userData.userData).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.getInt();
            byteBuffer.getInt();
            ReplayParser.readStringWithLength(ReplayParser.readValueStrut(byteBuffer), byteBuffer);
            byteBuffer.getShort();
            byteBuffer.get();
            byteBuffer.getShort();
            ReplayParser.readValueStrut(byteBuffer);
            replay.buildNumbers = new int[4];
            int n = 0;
            while (n < 4) {
                byteBuffer.getShort();
                replay.buildNumbers[n] = ReplayParser.readValueStrut(byteBuffer);
                ++n;
            }
            replay.version = String.valueOf(replay.buildNumbers[0]) + "." + replay.buildNumbers[1] + "." + replay.buildNumbers[2] + "." + replay.buildNumbers[3];
            if (ReplayUtils.getAbilityCodesForVersion(replay.buildNumbers) == null) {
                System.out.println("Unsupported replay version: " + replay.version + " (" + string + ")!");
                return null;
            }
            byteBuffer.getShort();
            ReplayParser.readValueStrut(byteBuffer);
            byteBuffer.getShort();
            ReplayParser.readValueStrut(byteBuffer);
            byteBuffer.getShort();
            replay.frames = ReplayParser.readValueStrut(byteBuffer) << 2;
            replay.gameLength = replay.frames >> 5;
            replay.gameLengthSec = replay.gameLength >> 1;
            if (set.contains((Object)ReplayContent.INIT_DATA)) {
                ReplayParser.parseInitData(replay, mpqParser.getFile(ReplayContent.INIT_DATA.hash1, ReplayContent.INIT_DATA.hash2, ReplayContent.INIT_DATA.hash3));
            }
            if (set.contains((Object)ReplayContent.DETAILS)) {
                ReplayParser.parseDetails(replay, mpqParser.getFile(ReplayContent.DETAILS.hash1, ReplayContent.DETAILS.hash2, ReplayContent.DETAILS.hash3));
            }
            if (set.contains((Object)ReplayContent.ATTRIBUTES_EVENTS)) {
                ReplayParser.parseAttributesEvents(replay, mpqParser.getFile(ReplayContent.ATTRIBUTES_EVENTS.hash1, ReplayContent.ATTRIBUTES_EVENTS.hash2, ReplayContent.ATTRIBUTES_EVENTS.hash3));
            }
            for (ReplayContent replayContent : set) {
                byte[] byArray = mpqParser.getFile(replayContent.hash1, replayContent.hash2, replayContent.hash3);
                switch (replayContent) {
                    case GAME_EVENTS: {
                        ReplayParser.parseGameEvents(byArray, replay);
                        break;
                    }
                    case MESSAGE_EVENTS: {
                        ReplayParser.parseMessageEvents(byArray, replay);
                        break;
                    }
                    case MAP_INFO: {
                        ReplayParser.parseMapInfo(replay);
                        break;
                    }
                    case SMARTCAM_EVENTS: {
                        break;
                    }
                }
            }
            Replay replay2 = replay;
            return replay2;
        }
        catch (Exception exception) {
            System.out.println("Error parsing replay: " + string);
            exception.printStackTrace();
            return null;
        }
        finally {
            if (mpqParser != null) {
                mpqParser.close();
            }
        }
    }

    private static void parseInitData(Replay replay, byte[] byArray) {
        InitData initData = replay.initData = new InitData();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.get() & 0xFF;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < n) {
            String string = ReplayParser.readString(byteBuffer);
            arrayList.add(string);
            byteBuffer.position(byteBuffer.position() + 5);
            ++n2;
        }
        initData.clientNames = arrayList.toArray(new String[arrayList.size()]);
        if (ReplayParser.positionAfter(STAR_S2MA, byteBuffer)) {
            byteBuffer.getShort();
            initData.gateway = ReplayConsts.Gateway.fromBinaryValue(ReplayParser.readStringWithLength(2, byteBuffer));
            n2 = 1;
            int n3 = 0;
            while (n3 < 4 && n2 != 0) {
                n2 &= ReplayParser.positionAfter(S2MA, byteBuffer);
                ++n3;
            }
            if (n2 != 0) {
                byteBuffer.position(byteBuffer.position() + 4);
                byte[] byArray2 = new byte[32];
                byteBuffer.get(byArray2);
                String string = CommonUtils.convertToHexString(byArray2);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.charAt(0)).append(string.charAt(1)).append('/').append(string.charAt(2)).append(string.charAt(3)).append('/').append(string).append(".s2ma");
                initData.mapFileName = stringBuilder.toString();
            }
        } else {
            initData.gameType = ReplayConsts.GameType.SINGLE_PLAYER;
        }
    }

    private static void parseDetails(Replay replay, byte[] byArray) {
        Details details = replay.details = new Details();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.getInt();
        byteBuffer.getShort();
        int n = (byteBuffer.get() & 0xFF) >> 1;
        byteBuffer.position(7);
        ArrayList<Details.Player> arrayList = new ArrayList<Details.Player>(n);
        int n2 = 0;
        while (n2 < n) {
            Details.Player player = new Details.Player();
            byteBuffer.getInt();
            player.name = ReplayParser.readStringWithLength(ReplayParser.readValueStrut(byteBuffer), byteBuffer);
            if (player.name.length() == 0) {
                byteBuffer.position(byteBuffer.position() + 51 + (n - n2 - 2) * 56);
                break;
            }
            byteBuffer.get();
            byteBuffer.getInt();
            ReplayParser.readValueStrut(byteBuffer);
            byteBuffer.getShort();
            byteBuffer.getInt();
            byteBuffer.getShort();
            ReplayParser.readValueStrut(byteBuffer);
            byteBuffer.getShort();
            ReplayParser.readValueStrut(byteBuffer);
            player.fullName = player.name;
            byteBuffer.get();
            if (byteBuffer.get() != 2) {
                byteBuffer.get();
            }
            player.raceString = ReplayParser.readStringWithLength(ReplayParser.readValueStrut(byteBuffer), byteBuffer);
            byteBuffer.getShort();
            int n3 = byteBuffer.get() & 0xFF;
            int n4 = 0;
            while (n4 < 4) {
                byteBuffer.getShort();
                player.argbColor[n4] = ReplayParser.readValueStrut(byteBuffer);
                ++n4;
            }
            n4 = 4;
            while (n4 <= n3) {
                byteBuffer.getShort();
                ReplayParser.readValueStrut(byteBuffer);
                ++n4;
            }
            arrayList.add(player);
            ++n2;
        }
        details.players = arrayList.toArray(new Details.Player[arrayList.size()]);
        byteBuffer.getShort();
        details.mapName = ReplayParser.readStringWithLength(ReplayParser.readValueStrut(byteBuffer), byteBuffer);
        byteBuffer.getShort();
        ReplayParser.readStringWithLength(ReplayParser.readValueStrut(byteBuffer), byteBuffer);
        byteBuffer.getShort();
        byteBuffer.get();
        byteBuffer.getShort();
        details.mapPreviewFileName = ReplayParser.readStringWithLength(ReplayParser.readValueStrut(byteBuffer), byteBuffer);
    }

    private static void parseAttributesEvents(Replay replay, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.getInt();
        ArrayList<Pair<Integer, String>> arrayList = new ArrayList<Pair<Integer, String>>(4);
        ArrayList<Pair<Integer, String>> arrayList2 = new ArrayList<Pair<Integer, String>>(4);
        ArrayList<Pair<Integer, String>> arrayList3 = new ArrayList<Pair<Integer, String>>(6);
        ArrayList<Pair<Integer, String>> arrayList4 = new ArrayList<Pair<Integer, String>>(8);
        ArrayList<Pair<Integer, String>> arrayList5 = new ArrayList<Pair<Integer, String>>(8);
        int n = byteBuffer.getInt();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byteBuffer.getInt();
            short s = byteBuffer.getShort();
            byteBuffer.getShort();
            int n4 = (byteBuffer.get() & 0xFF) - 1;
            String string = ReplayParser.readStringWithLength(4, byteBuffer);
            switch (s) {
                case 500: {
                    replay.details.players[n4].type = ReplayConsts.PlayerType.fromBinaryValue(string);
                    break;
                }
                case 3001: {
                    replay.details.players[n4].race = ReplayConsts.Race.fromBinaryValue(string);
                    break;
                }
                case 2001: {
                    replay.initData.format = ReplayConsts.Format.fromBinaryValue(string.indexOf(0) < 0 ? string : string.substring(0, string.indexOf(0)));
                    break;
                }
                case 2002: {
                    arrayList.add(new Pair<Integer, String>(n4, string));
                    break;
                }
                case 2003: {
                    arrayList2.add(new Pair<Integer, String>(n4, string));
                    break;
                }
                case 2004: {
                    arrayList3.add(new Pair<Integer, String>(n4, string));
                    break;
                }
                case 2005: {
                    arrayList4.add(new Pair<Integer, String>(n4, string));
                    break;
                }
                case 2006: {
                    arrayList5.add(new Pair<Integer, String>(n4, string));
                    break;
                }
                case 3000: {
                    replay.initData.gameSpeed = ReplayConsts.GameSpeed.fromBinaryValue(string);
                    break;
                }
                case 3009: {
                    replay.initData.gameType = ReplayConsts.GameType.fromBinaryValue(string.indexOf(0) < 0 ? string : string.substring(0, string.indexOf(0)));
                    break;
                }
                case 3007: {
                    if (n2 >= n4) break;
                    n2 = n4;
                    break;
                }
                case 3004: {
                    replay.details.players[n4].difficulty = ReplayConsts.Difficulty.fromBinaryValue(string);
                    break;
                }
                case 3002: {
                    replay.details.players[n4].playerColor = ReplayConsts.PlayerColor.fromBinaryValue(string);
                    break;
                }
            }
            ++n3;
        }
        ArrayList<Pair<Integer, String>> arrayList6 = null;
        switch (replay.initData.format) {
            case ONE_VS_ONE: {
                arrayList6 = arrayList;
                break;
            }
            case TWO_VS_TWO: {
                arrayList6 = arrayList2;
                break;
            }
            case THREE_VS_THREE: {
                arrayList6 = arrayList3;
                break;
            }
            case FOUR_VS_FOUR: {
                arrayList6 = arrayList4;
                break;
            }
            case FREE_FOR_ALL: {
                arrayList6 = arrayList5;
            }
        }
        if (arrayList6 != null) {
            for (Pair pair : arrayList6) {
                replay.details.players[((Integer)pair.value1).intValue()].team = ((String)pair.value2).charAt(0) - 48;
            }
        }
        if (replay.details.players.length - 1 > n2) {
            replay.details.players = Arrays.copyOfRange(replay.details.players, 0, n2 + 1);
        }
    }

    private static void parseMessageEvents(byte[] byArray, Replay replay) {
        MessageEvents messageEvents = replay.messageEvents = new MessageEvents();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n + 2 < byArray.length && byArray[n] == 0 && byArray[n + 2] == -128) {
            n += 7;
        }
        byteBuffer.position(n);
        ArrayList<MessageEvents.Blink> arrayList = new ArrayList<MessageEvents.Blink>();
        while (byteBuffer.hasRemaining()) {
            int n2 = byteBuffer.get() & 0xFF;
            int n3 = n2 >> 2;
            if ((n2 & 1) != 0) {
                n3 = (n3 << 8) + (byteBuffer.get() & 0xFF);
            } else if ((n2 & 2) != 0) {
                n3 = (n3 << 16) + ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
            }
            n3 = n3 * 125 / 2;
            int n4 = (byteBuffer.get() & 0xF) - 1;
            byte by = byteBuffer.get();
            MessageEvents.Message message = by == -125 ? new MessageEvents.Blink() : new MessageEvents.Text((byte)(by & 7));
            message.time = n3;
            message.client = n4;
            if (by == -125) {
                message.x = Integer.reverseBytes(byteBuffer.getInt()) >> 1;
                message.y = Integer.reverseBytes(byteBuffer.getInt()) >> 1;
            } else {
                ((MessageEvents.Text)message).text = ReplayParser.readStringWithLength((byteBuffer.get() & 0xFF) + ((by & 8) != 0 ? 64 : 0), byteBuffer);
            }
            arrayList.add((MessageEvents.Blink)message);
        }
        messageEvents.messages = arrayList.toArray(new MessageEvents.Message[arrayList.size()]);
    }

    private static void parseGameEvents(byte[] byArray, Replay replay) {
        ArrayList<Integer> arrayList;
        AbilityCodes abilityCodes = ReplayUtils.getAbilityCodesForVersion(replay.buildNumbers);
        Details.Player[] playerArray = replay.details.players;
        byte by = (byte)playerArray.length;
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < playerArray.length) {
            int n2 = playerArray[n].team;
            arrayList = (ArrayList<Integer>)hashMap.get(n2);
            if (arrayList == null) {
                arrayList = new ArrayList(4);
                hashMap.put(n2, arrayList);
            }
            arrayList.add(n);
            ++n;
        }
        GameEvents gameEvents = replay.gameEvents = new GameEvents(playerArray, abilityCodes.UNIT_TYPE_NAME);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        arrayList = new ArrayList<Integer>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte by2 = 0;
        while (byteBuffer.hasRemaining()) {
            n4 = n5;
            byte by3 = by2;
            n5 = byteBuffer.position();
            int n6 = byteBuffer.get() & 0xFF;
            int n7 = n6 >> 2;
            if ((n6 & 1) != 0) {
                n7 = (n7 << 8) + (byteBuffer.get() & 0xFF);
            } else if ((n6 & 2) != 0) {
                n7 = (byteBuffer.get() & 0xFF) >> 2;
            }
            n3 += n7 << 2;
            byte by4 = byteBuffer.get();
            byte by5 = (byte)((by4 & 0xF) - 1);
            by2 = byteBuffer.get();
            GameEvents.Action action = null;
            block0 : switch ((by4 & 0xE0) >> 5) {
                case 0: {
                    switch (by2) {
                        case 11: 
                        case 27: 
                        case 43: {
                            break block0;
                        }
                        case 5: {
                            break block0;
                        }
                    }
                    System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", by2) + ", event desc=0x" + String.format("%02x", by4) + ": INITIALIZATION), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by3) + ", total parsed: " + arrayList.size() + ", stream pos: 0x" + String.format("%04x", byteBuffer.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    byteBuffer.position(byteBuffer.limit());
                    break;
                }
                case 1: {
                    switch (by2) {
                        case -116: 
                        case -100: 
                        case -84: 
                        case 12: 
                        case 28: 
                        case 44: 
                        case 60: 
                        case 76: 
                        case 92: 
                        case 108: 
                        case 124: {
                            GameEvents.SelectAction selectAction = gameEvents.new GameEvents.SelectAction();
                            action = selectAction;
                            boolean bl = selectAction.automatic = by2 != -84;
                            if (selectAction.automatic) {
                                selectAction.type = ReplayConsts.ActionType.INACTION;
                            }
                            byteBuffer.get();
                            selectAction.deselectionBitsCount = byteBuffer.get() & 0xFF;
                            if ((selectAction.deselectionBitsCount & 7) == 0) {
                                int n8;
                                if (selectAction.deselectionBitsCount > 0) {
                                    selectAction.deselectionUnitBitmap = new byte[selectAction.deselectionBitsCount >> 3];
                                    n8 = 0;
                                    while (n8 < selectAction.deselectionUnitBitmap.length) {
                                        selectAction.deselectionUnitBitmap[n8] = byteBuffer.get();
                                        ++n8;
                                    }
                                }
                                n8 = byteBuffer.get() & 0xFF;
                                selectAction.unitTypes = new short[n8];
                                selectAction.unitsOfTypeCounts = new byte[n8];
                                int n9 = 0;
                                while (n9 < n8) {
                                    selectAction.unitTypes[n9] = (short)(((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF));
                                    byteBuffer.get();
                                    selectAction.unitsOfTypeCounts[n9] = byteBuffer.get();
                                    ++n9;
                                }
                                n9 = byteBuffer.get() & 0xFF;
                                selectAction.unitIds = new int[n9];
                                int n10 = 0;
                                while (n10 < n9) {
                                    selectAction.unitIds[n10] = (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 24 | (byteBuffer.get() & 0xFF) << 16;
                                    ++n10;
                                }
                                break block0;
                            }
                            selectAction.deselectionUnitBitmap = new byte[selectAction.deselectionBitsCount + 7 >> 3];
                            int n11 = 0;
                            while (n11 < selectAction.deselectionUnitBitmap.length - 1) {
                                selectAction.deselectionUnitBitmap[n11] = byteBuffer.get();
                                ++n11;
                            }
                            BitBufferView bitBufferView = new BitBufferView(byteBuffer, selectAction.deselectionBitsCount & 7);
                            selectAction.deselectionUnitBitmap[selectAction.deselectionUnitBitmap.length - 1] = bitBufferView.initialBits;
                            int n12 = bitBufferView.get();
                            selectAction.unitTypes = new short[n12];
                            selectAction.unitsOfTypeCounts = new byte[n12];
                            int n13 = 0;
                            while (n13 < n12) {
                                selectAction.unitTypes[n13] = bitBufferView.get2Bytes();
                                bitBufferView.get();
                                selectAction.unitsOfTypeCounts[n13] = (byte)bitBufferView.get();
                                ++n13;
                            }
                            n13 = bitBufferView.get();
                            selectAction.unitIds = new int[n13];
                            int n14 = 0;
                            while (n14 < n13) {
                                selectAction.unitIds[n14] = bitBufferView.getInt();
                                selectAction.unitIds[n14] = (selectAction.unitIds[n14] & 0xFF00) >> 8 | (selectAction.unitIds[n14] & 0xFF) << 8 | (selectAction.unitIds[n14] & 0xFF000000) >>> 8 | (selectAction.unitIds[n14] & 0xFF0000) << 8;
                                ++n14;
                            }
                            n14 = bitBufferView.getRemainder();
                            if (n14 <= 0) break block0;
                            byteBuffer.position(byteBuffer.position() + n14);
                            break;
                        }
                        case -115: 
                        case -99: 
                        case 13: 
                        case 29: 
                        case 45: 
                        case 61: 
                        case 77: 
                        case 93: 
                        case 109: 
                        case 125: {
                            GameEvents.HotkeyAction hotkeyAction = gameEvents.new GameEvents.HotkeyAction();
                            action = hotkeyAction;
                            int n15 = byteBuffer.get() & 0xFF;
                            boolean bl = hotkeyAction.isSelect = (n15 & 2) == 2;
                            if (hotkeyAction.isSelect) {
                                action.type = ReplayConsts.ActionType.SELECT;
                            }
                            if (n15 <= 3) break block0;
                            byteBuffer.position(byteBuffer.position() + (n15 >> 3) + ((n15 & 4) == 4 ? ((byteBuffer.get(byteBuffer.position()) & 6) == 6 ? 2 : 1) : 0));
                            break;
                        }
                        case 11: {
                            byteBuffer.get();
                            byteBuffer.get();
                            byteBuffer.get();
                            byteBuffer.get();
                            int n16 = ((byteBuffer.get() & 0xFF) << 16) + ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
                            ReplayConsts.Unit unit = null;
                            ReplayConsts.Building building = null;
                            ReplayConsts.Upgrade upgrade = null;
                            ReplayConsts.Research research = null;
                            Object[] objectArray = abilityCodes.COMMON_BASE_ABILITY_CODES.get(n16);
                            if (objectArray != null) {
                                GameEvents gameEvents2 = gameEvents;
                                gameEvents2.getClass();
                                action = gameEvents2.new GameEvents.BaseUseAbilityAction((String)objectArray[0], (ReplayConsts.AbilityGroup)((Object)objectArray[1]));
                            } else {
                                unit = abilityCodes.TRAIN_ABILITY_CODES.get(n16);
                                if (unit != null) {
                                    GameEvents gameEvents3 = gameEvents;
                                    gameEvents3.getClass();
                                    action = gameEvents3.new GameEvents.TrainAction(unit);
                                } else {
                                    building = abilityCodes.BUILD_ABILITY_CODES.get(n16);
                                    if (building != null) {
                                        GameEvents gameEvents4 = gameEvents;
                                        gameEvents4.getClass();
                                        action = gameEvents4.new GameEvents.BuildAction(building);
                                    } else {
                                        objectArray = abilityCodes.USE_UNIT_ABILITY.get(n16);
                                        if (objectArray != null) {
                                            GameEvents gameEvents5 = gameEvents;
                                            gameEvents5.getClass();
                                            action = gameEvents5.new GameEvents.UseUnitAbilityAction((ReplayConsts.UnitAbility)((Object)objectArray[0]), (ReplayConsts.Unit)((Object)objectArray[1]));
                                        } else {
                                            objectArray = abilityCodes.USE_BUILDING_ABILITY.get(n16);
                                            if (objectArray != null) {
                                                GameEvents gameEvents6 = gameEvents;
                                                gameEvents6.getClass();
                                                action = gameEvents6.new GameEvents.UseBuildingAbilityAction((ReplayConsts.BuildingAbility)((Object)objectArray[0]), (ReplayConsts.Building)((Object)objectArray[1]));
                                            } else {
                                                unit = abilityCodes.WARP_ABILITY_CODES.get(n16);
                                                if (unit != null) {
                                                    GameEvents gameEvents7 = gameEvents;
                                                    gameEvents7.getClass();
                                                    action = gameEvents7.new GameEvents.WarpAction(unit);
                                                } else {
                                                    unit = abilityCodes.TRAIN_HALLU_ABILITY_CODES.get(n16);
                                                    if (unit != null) {
                                                        GameEvents gameEvents8 = gameEvents;
                                                        gameEvents8.getClass();
                                                        action = gameEvents8.new GameEvents.TrainHallucinatedAction(unit);
                                                    } else {
                                                        upgrade = abilityCodes.UPGRADE_ABILITY_CODES.get(n16);
                                                        if (upgrade != null) {
                                                            GameEvents gameEvents9 = gameEvents;
                                                            gameEvents9.getClass();
                                                            action = gameEvents9.new GameEvents.UpgradeAction(upgrade);
                                                        } else {
                                                            research = abilityCodes.RESEARCH_ABILITY_CODES.get(n16);
                                                            if (research != null) {
                                                                GameEvents gameEvents10 = gameEvents;
                                                                gameEvents10.getClass();
                                                                action = gameEvents10.new GameEvents.ResearchAction(research);
                                                            } else {
                                                                action = gameEvents.new GameEvents.BaseUseAbilityAction();
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            ((GameEvents.BaseUseAbilityAction)action).abilityCode = n16;
                            GameEvents.BaseUseAbilityAction baseUseAbilityAction = (GameEvents.BaseUseAbilityAction)action;
                            boolean bl = baseUseAbilityAction.targetIsUnit = (byteBuffer.get() & 0x10) != 0;
                            if (baseUseAbilityAction.targetIsUnit) {
                                byteBuffer.position(byteBuffer.position() + 6);
                                baseUseAbilityAction.targetP1 = byteBuffer.getInt();
                                baseUseAbilityAction.targetP1 = (baseUseAbilityAction.targetP1 & 0xFFF) << 4 | (baseUseAbilityAction.targetP1 & 0xF000) >> 12 | (baseUseAbilityAction.targetP1 & 0xFF000000) >>> 8 | (baseUseAbilityAction.targetP1 & 0xFF0000) << 8;
                                baseUseAbilityAction.targetP2 = (byteBuffer.get() & 0xFF) << 4 | byteBuffer.get() & 0xF;
                                byteBuffer.position(byteBuffer.position() + 13);
                                break;
                            }
                            byteBuffer.position(byteBuffer.position() + 12);
                            baseUseAbilityAction.targetP1 = Integer.reverseBytes(byteBuffer.getInt()) << 1;
                            baseUseAbilityAction.targetP2 = Integer.reverseBytes(byteBuffer.getInt()) << 1;
                            byteBuffer.position(byteBuffer.position() + 4);
                            break;
                        }
                        case -113: 
                        case 31: 
                        case 47: 
                        case 63: 
                        case 79: 
                        case 95: 
                        case 111: 
                        case 127: {
                            action = gameEvents.new GameEvents.SendResourcesAction();
                            byteBuffer.position(byteBuffer.position() + 17);
                            break;
                        }
                        case 9: {
                            String string = replay.initData.clientNames[by5];
                            boolean bl = false;
                            int n17 = playerArray.length - 1;
                            while (n17 >= 0) {
                                if (playerArray[n17].name.equals(string)) {
                                    by5 = (byte)n17;
                                    bl = true;
                                    break;
                                }
                                --n17;
                            }
                            if (!bl) break block0;
                            action = gameEvents.new GameEvents.LeaveGameAction();
                            if (hashMap.size() <= 1) break block0;
                            n17 = playerArray[by5].team;
                            List list = (List)hashMap.get(n17);
                            list.remove(new Integer(by5));
                            if (!list.isEmpty()) break block0;
                            hashMap.remove(n17);
                            Details.Player[] playerArray2 = playerArray;
                            int n18 = playerArray.length;
                            int n19 = 0;
                            while (n19 < n18) {
                                Details.Player player = playerArray2[n19];
                                if (player.team == n17) {
                                    player.isWinner = Boolean.FALSE;
                                }
                                ++n19;
                            }
                            if (hashMap.size() != 1) break block0;
                            int n20 = (Integer)hashMap.keySet().iterator().next();
                            Details.Player[] playerArray3 = playerArray;
                            int n21 = playerArray.length;
                            n18 = 0;
                            while (n18 < n21) {
                                Details.Player player = playerArray3[n18];
                                if (player.team == n20) {
                                    player.isWinner = Boolean.TRUE;
                                }
                                ++n18;
                            }
                            break block0;
                        }
                        default: {
                            System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", by2) + ", event desc=0x" + String.format("%02x", by4) + ": ACTION), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by3) + ", total parsed: " + arrayList.size() + ", stream pos: 0x" + String.format("%04x", byteBuffer.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                            byteBuffer.position(byteBuffer.limit());
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (by2) {
                        case 6: {
                            action = gameEvents.new GameEvents.AllianceAction();
                            byteBuffer.position(byteBuffer.position() + 8);
                            break block0;
                        }
                        case 7: {
                            byteBuffer.getInt();
                            break block0;
                        }
                    }
                    System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", by2) + ", event desc=0x" + String.format("%02x", by4) + ": UNNAMED), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by3) + ", total parsed: " + arrayList.size() + ", stream pos: 0x" + String.format("%04x", byteBuffer.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    byteBuffer.position(byteBuffer.limit());
                    break;
                }
                case 3: {
                    switch (by2) {
                        case -127: 
                        case -111: 
                        case -95: 
                        case -79: 
                        case -63: 
                        case -47: 
                        case -31: 
                        case -15: 
                        case 1: 
                        case 17: 
                        case 33: 
                        case 49: 
                        case 65: 
                        case 81: 
                        case 97: 
                        case 113: {
                            int n22;
                            int n23 = Integer.reverseBytes(byteBuffer.getInt());
                            GameEvents.MoveScreenAction moveScreenAction = gameEvents.new GameEvents.MoveScreenAction();
                            action = moveScreenAction;
                            moveScreenAction.x = (by2 & 0xF0) << 8 | (n23 & 0xFF000000) >>> 20 | (n23 & 0xF0000) >> 16;
                            moveScreenAction.y = (n23 & 0xF00000) >> 8 | (n23 & 0xFF00) >> 4 | n23 & 0xF;
                            if ((n23 & 0xF0) <= 0 || ((n22 = byteBuffer.getShort() & 0xFFFF) & 0xF000) <= 4096 || ((n22 = byteBuffer.getShort() & 0xFFFF) & 0xF000) <= 12288) break block0;
                            byteBuffer.getShort();
                            break;
                        }
                        case -121: {
                            byteBuffer.position(byteBuffer.position() + 8);
                            break;
                        }
                        default: {
                            System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", by2) + ", event desc=0x" + String.format("%02x", by4) + ": REPLAY), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by3) + ", total parsed: " + arrayList.size() + ", stream pos: 0x" + String.format("%04x", byteBuffer.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                            byteBuffer.position(byteBuffer.limit());
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (by2) {
                        case -58: {
                            byteBuffer.position(byteBuffer.position() + 16);
                            break block0;
                        }
                        case 0: {
                            byteBuffer.getInt();
                            break block0;
                        }
                        case -116: 
                        case -100: 
                        case 12: 
                        case 28: 
                        case 44: 
                        case 60: 
                        case 76: 
                        case 92: 
                        case 108: 
                        case 124: {
                            break block0;
                        }
                        case -122: 
                        case 22: 
                        case 38: 
                        case 54: 
                        case 70: 
                        case 86: 
                        case 102: 
                        case 118: {
                            GameEvents.RequestResoucesAction requestResoucesAction = gameEvents.new GameEvents.RequestResoucesAction();
                            action = requestResoucesAction;
                            byteBuffer.getInt();
                            byteBuffer.getInt();
                            byteBuffer.getInt();
                            requestResoucesAction.minRequested = byteBuffer.getInt();
                            requestResoucesAction.gasRequested = byteBuffer.getInt();
                            byteBuffer.getInt();
                            break block0;
                        }
                        case -120: 
                        case 24: 
                        case 40: 
                        case 56: 
                        case 72: 
                        case 88: 
                        case 104: 
                        case 120: {
                            action = gameEvents.new GameEvents.CancelResRequestAction();
                            byteBuffer.getInt();
                            break block0;
                        }
                    }
                    System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", by2) + ", event desc=0x" + String.format("%02x", by4) + ": INACTION), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by3) + ", total parsed: " + arrayList.size() + ", stream pos: 0x" + String.format("%04x", byteBuffer.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    byteBuffer.position(byteBuffer.limit());
                    break;
                }
                case 5: {
                    switch (by2) {
                        case -119: {
                            byteBuffer.getInt();
                            break block0;
                        }
                    }
                    System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", by2) + ", event desc=0x" + String.format("%02x", by4) + ": SYSTEM), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by3) + ", total parsed: " + arrayList.size() + ", stream pos: 0x" + String.format("%04x", byteBuffer.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    byteBuffer.position(byteBuffer.limit());
                    break;
                }
                default: {
                    System.out.println("Unrecognized event desc: 0x" + String.format("%02x", by4) + "), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by3) + ", total parsed: " + arrayList.size() + ", stream pos: 0x" + String.format("%04x", byteBuffer.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    byteBuffer.position(byteBuffer.limit());
                }
            }
            if (action == null || by5 < 0 || by5 >= by) continue;
            action.player = by5;
            action.opCode = by2;
            action.frame = n3;
            if (action.type != ReplayConsts.ActionType.INACTION) {
                playerArray[by5].lastActionFrame = n3;
                ++playerArray[by5].actionsCount;
            }
            arrayList.add((Integer)((Object)action));
        }
        gameEvents.actions = arrayList.toArray(new GameEvents.Action[arrayList.size()]);
    }

    private static void parseMapInfo(Replay replay) {
        File file = ReplayParser.getMapFile(replay);
        if (file == null || !file.exists()) {
            return;
        }
        MpqParser mpqParser = null;
        try {
            mpqParser = new MpqParser(file.getAbsolutePath());
            MapInfo mapInfo = new MapInfo();
            byte[] byArray = mpqParser.getFile(ReplayContent.MAP_INFO.hash1, ReplayContent.MAP_INFO.hash2, ReplayContent.MAP_INFO.hash3);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
            if (byteBuffer.getInt() != 1298231369) {
                return;
            }
            try {
                byteBuffer.position(byteBuffer.position() + 12);
                mapInfo.width = byteBuffer.getInt();
                mapInfo.height = byteBuffer.getInt();
                byteBuffer.position(byteBuffer.position() + 12);
                while (byteBuffer.get() != 0) {
                }
                while (byteBuffer.get() != 0) {
                }
                mapInfo.boundaryLeft = byteBuffer.getInt();
                mapInfo.boundaryBottom = byteBuffer.getInt();
                mapInfo.boundaryRight = byteBuffer.getInt();
                mapInfo.boundaryTop = byteBuffer.getInt();
                mapInfo.previewIcon = ReplayUtils.parseTgaImage(mpqParser.getFile(replay.details.mapPreviewFileName));
                replay.mapInfo = mapInfo;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (mpqParser != null) {
                mpqParser.close();
            }
        }
    }

    public static void parseExtendedMapInfo(Replay replay) {
        File file = ReplayParser.getMapFile(replay);
        if (file == null || !file.exists()) {
            return;
        }
        MpqParser mpqParser = null;
        try {
            try {
                GameEvents.Action[] actionArray;
                Object object;
                mpqParser = new MpqParser(file.getAbsolutePath());
                byte[] byArray = mpqParser.getFile(ReplayContent.MAP_OBJECTS.hash1, ReplayContent.MAP_OBJECTS.hash2, ReplayContent.MAP_OBJECTS.hash3);
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
                Element element = document.getDocumentElement();
                ArrayList<Pair<MapInfo.MapObject, Point>> arrayList = new ArrayList<Pair<MapInfo.MapObject, Point>>(128);
                NodeList nodeList = element.getElementsByTagName("ObjectUnit");
                int n = nodeList.getLength() - 1;
                while (n >= 0) {
                    object = (Element)nodeList.item(n);
                    MapInfo.MapObject mapObject = MapInfo.MapObject.fromBinaryValue(object.getAttribute("UnitType"));
                    if (mapObject != null) {
                        arrayList.add(new Pair<MapInfo.MapObject, Point>(mapObject, ReplayParser.parsePoint(object.getAttribute("Position"))));
                    }
                    --n;
                }
                replay.mapInfo.mapObjectList = arrayList;
                ArrayList<Point> arrayList2 = new ArrayList<Point>();
                object = element.getElementsByTagName("ObjectPoint");
                int n2 = object.getLength() - 1;
                while (n2 >= 0) {
                    actionArray = (GameEvents.Action[])object.item(n2);
                    if ("StartLoc".equals(actionArray.getAttribute("Type"))) {
                        arrayList2.add(ReplayParser.parsePoint(actionArray.getAttribute("Position")));
                    }
                    --n2;
                }
                replay.mapInfo.startLocationList = arrayList2;
                if (arrayList2.size() > 0) {
                    GameEvents.MoveScreenAction[] moveScreenActionArray = new GameEvents.MoveScreenAction[replay.details.players.length];
                    actionArray = replay.gameEvents.actions;
                    int n3 = actionArray.length;
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n3) {
                        GameEvents.Action action = actionArray[n5];
                        if (action instanceof GameEvents.MoveScreenAction && moveScreenActionArray[action.player] == null) {
                            moveScreenActionArray[action.player] = (GameEvents.MoveScreenAction)action;
                            if (++n4 == moveScreenActionArray.length) break;
                        }
                        ++n5;
                    }
                    int n6 = moveScreenActionArray.length - 1;
                    while (n6 >= 0) {
                        GameEvents.MoveScreenAction moveScreenAction = moveScreenActionArray[n6];
                        if (moveScreenAction != null) {
                            int n7 = Integer.MAX_VALUE;
                            Point point = null;
                            for (Point point2 : arrayList2) {
                                int n8 = GeneralUtils.distanceSquare(moveScreenAction.x << 8, moveScreenAction.y << 8, point2.x, point2.y);
                                if (n8 >= n7) continue;
                                n7 = n8;
                                point = point2;
                            }
                            replay.details.players[n6].startLocation = point;
                        }
                        --n6;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (mpqParser != null) {
                    mpqParser.close();
                }
            }
        }
        finally {
            if (mpqParser != null) {
                mpqParser.close();
            }
        }
    }

    private static Point parsePoint(String string) {
        int n = string.indexOf(44);
        return new Point((int)(Float.parseFloat(string.substring(0, n)) * 65536.0f), (int)(Float.parseFloat(string.substring(n + 1, string.indexOf(44, n + 1))) * 65536.0f));
    }

    public static File getMapFile(Replay replay) {
        if (replay.initData.mapFileName == null) {
            return null;
        }
        File file = new File(Settings.getString("settings.folders.sc2Maps"));
        File file2 = file.exists() ? file : new File(System.getProperty("user.home"), Settings.getString("settings.folders.sc2Maps"));
        return new File(file2, replay.initData.mapFileName);
    }

    private static int readValueStrut(ByteBuffer byteBuffer) {
        int n = (byteBuffer.get() & 0xFF) >> 1;
        if ((n & 0x40) == 0) {
            return n;
        }
        n &= 0x3F;
        int n2 = 6;
        int n3;
        while (((n3 = byteBuffer.get() & 0xFF) & 0x80) != 0) {
            n |= (n3 & 0x7F) << n2;
            n2 += 7;
        }
        return n3 << n2 | n;
    }

    private static String readString(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.get() & 0xFF];
        byteBuffer.get(byArray);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return new String(byArray);
        }
    }

    private static String readStringWithLength(int n, ByteBuffer byteBuffer) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return new String(byArray);
        }
    }

    private static boolean positionAfter(byte[] byArray, ByteBuffer byteBuffer) {
        byte[] byArray2 = byteBuffer.array();
        int n = byteBuffer.position();
        while (n <= byArray2.length - byArray.length) {
            int n2 = 0;
            while (n2 < byArray.length) {
                if (byArray2[n + n2] != byArray[n2]) break;
                ++n2;
            }
            if (n2 == byArray.length) break;
            ++n;
        }
        if (n <= byArray2.length - byArray.length) {
            byteBuffer.position(n + byArray.length);
            return true;
        }
        return false;
    }

    public static enum ReplayContent {
        INIT_DATA("replay.initData", -750801643, 1518242780, -14336164),
        DETAILS("replay.details", 620083690, -746339684, -281006446),
        ATTRIBUTES_EVENTS("replay.attributes.events", 1306016990, 497594575, -1563492568),
        GAME_EVENTS("replay.game.events", 496563520, -1430084277, -193582187),
        MESSAGE_EVENTS("replay.message.events", 1089231967, 831857289, 1784674979),
        SMARTCAM_EVENTS("replay.smartcam.events", 1029411303, 992681632, -1221660585),
        SYNC_EVENTS("replay.sync.events", 1206425669, -907692176, 991491766),
        MAP_INFO("MapInfo", 456326858, 2000504491, 1514959542),
        MAP_OBJECTS("Objects", 602486196, -842158972, 1775018687);

        public final String fileName;
        public final int hash1;
        public final int hash2;
        public final int hash3;

        private ReplayContent(String string2, int n2, int n3, int n4) {
            this.fileName = string2;
            this.hash1 = n2;
            this.hash2 = n3;
            this.hash3 = n4;
        }
    }
}

