/*
 * Decompiled with CFR 0.152.
 */
package org.fife.plaf.OfficeXP;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;
import org.fife.plaf.OfficeXP.OfficeXPUtilities;

public class OfficeXPButtonUI
extends WindowsButtonUI {
    private static MouseInputHandler mouseInputHandler;
    private boolean isMouseOver = false;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();
    private static final int PREFERRED_TOOLBAR_BUTTON_SIZE = 23;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OfficeXPButtonUI();
    }

    protected synchronized MouseInputHandler getMouseInputHandler() {
        if (mouseInputHandler == null) {
            mouseInputHandler = new MouseInputHandler();
        }
        return mouseInputHandler;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Container container = jComponent.getParent();
        if (container != null && container instanceof JToolBar) {
            Dimension dimension = super.getPreferredSize(jComponent);
            if (dimension.width < 23) {
                dimension.width = 23;
            }
            if (dimension.height < 23) {
                dimension.height = 23;
            }
            return dimension;
        }
        return super.getPreferredSize(jComponent);
    }

    public void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        mouseInputHandler = this.getMouseInputHandler();
        abstractButton.addMouseListener(mouseInputHandler);
    }

    protected boolean isMouseOver() {
        return this.isMouseOver;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton.getParent() instanceof JToolBar) {
            this.paintToolbarButton(graphics, abstractButton);
        } else {
            super.paint(graphics, jComponent);
        }
    }

    static void paintArmedToolbarButtonBackground(Graphics graphics, int n, int n2) {
        graphics.setColor(UIManager.getColor("OfficeLnF.HighlightBorderColor"));
        graphics.drawRect(0, 0, n, n2);
        graphics.setColor(UIManager.getColor("OfficeXPLnF.PressedHighlightColor"));
        graphics.fillRect(1, 1, n - 1, n2 - 1);
    }

    static void paintMouseOverToolbarButtonBackground(Graphics graphics, int n, int n2) {
        graphics.setColor(UIManager.getColor("OfficeLnF.HighlightBorderColor"));
        graphics.drawRect(0, 0, n, n2);
        graphics.setColor(UIManager.getColor("OfficeLnF.HighlightColor"));
        graphics.fillRect(1, 1, n - 1, n2 - 1);
    }

    public void paintToolbarButton(Graphics graphics, JComponent jComponent) {
        this.paintToolbarButtonBackground(graphics, jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        FontMetrics fontMetrics = jComponent.getFontMetrics(graphics.getFont());
        Insets insets = jComponent.getInsets();
        this.viewRect.x = insets.left;
        this.viewRect.y = insets.top;
        this.viewRect.width = abstractButton.getWidth() - (insets.right + this.viewRect.x);
        this.viewRect.height = abstractButton.getHeight() - (insets.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, string == null ? 0 : abstractButton.getIconTextGap());
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, this.textRect);
            } else {
                this.paintText(graphics, jComponent, this.textRect, string);
            }
        }
        this.paintToolbarButtonIcon(graphics, jComponent, this.iconRect);
    }

    protected void paintToolbarButtonBackground(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        int n = abstractButton.getWidth() - 1;
        int n2 = abstractButton.getHeight() - 1;
        if (buttonModel.isEnabled()) {
            if (buttonModel.isArmed()) {
                OfficeXPButtonUI.paintArmedToolbarButtonBackground(graphics, n, n2);
            } else if (this.isMouseOver() || buttonModel.isPressed()) {
                OfficeXPButtonUI.paintMouseOverToolbarButtonBackground(graphics, n, n2);
            }
        }
    }

    protected void paintToolbarButtonIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        if (!buttonModel.isEnabled()) {
            OfficeXPUtilities.paintDisabledButtonIcon(graphics, abstractButton, rectangle);
        } else if (buttonModel.isArmed()) {
            Icon icon = abstractButton.getIcon();
            if (icon != null) {
                icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
            }
        } else if (this.isMouseOver() || buttonModel.isPressed()) {
            Icon icon = abstractButton.getDisabledIcon();
            if (icon != null) {
                icon.paintIcon(jComponent, graphics, rectangle.x + 1, rectangle.y + 1);
                icon = abstractButton.getIcon();
                if (icon != null) {
                    icon.paintIcon(jComponent, graphics, rectangle.x - 1, rectangle.y - 1);
                }
            } else {
                icon = abstractButton.getIcon();
                if (icon != null) {
                    icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
                }
            }
        } else {
            Icon icon = abstractButton.getIcon();
            if (icon != null) {
                icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
            }
        }
    }

    protected void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
    }

    public void uninstallListeners(AbstractButton abstractButton) {
        abstractButton.removeMouseListener(mouseInputHandler);
        super.installListeners(abstractButton);
    }

    protected static class MouseInputHandler
    extends MouseInputAdapter {
        private boolean someButtonDepressed;

        public void mousePressed(MouseEvent mouseEvent) {
            this.someButtonDepressed = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.someButtonDepressed = false;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.someButtonDepressed) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                OfficeXPButtonUI officeXPButtonUI = (OfficeXPButtonUI)((Object)abstractButton.getUI());
                officeXPButtonUI.setMouseOver(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            OfficeXPButtonUI officeXPButtonUI = (OfficeXPButtonUI)((Object)abstractButton.getUI());
            officeXPButtonUI.setMouseOver(false);
        }
    }
}

