/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;

public class SearchFieldGroup {
    public final Container parentToNotify;
    private final Class<? extends SearchField> searchFieldType;
    public final Box uiComponent = Box.createHorizontalBox();
    public final Box searchFieldsBox = Box.createVerticalBox();
    public final List<SearchField> searchFieldList = new ArrayList<SearchField>();

    public SearchFieldGroup(Container container, Class<? extends SearchField> clazz) {
        this.parentToNotify = container;
        this.searchFieldType = clazz;
        this.uiComponent.setBorder(BorderFactory.createRaisedBevelBorder());
        this.uiComponent.add(this.searchFieldsBox);
        JLabel jLabel = new JLabel(Icons.PLUS);
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.setToolTipText(Language.getText("module.repSearch.tab.filters.addNewFieldToolTip"));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SearchFieldGroup.this.addNewSearchField();
            }
        });
        this.uiComponent.add(jLabel);
        this.addNewSearchField();
    }

    private void addNewSearchField() {
        try {
            final Box box = Box.createHorizontalBox();
            final SearchField searchField = this.searchFieldType.newInstance();
            if (!this.searchFieldList.isEmpty()) {
                searchField.displayLabel.setPreferredSize(new Dimension(this.searchFieldList.get((int)0).displayLabel.getPreferredSize().width, searchField.displayLabel.getPreferredSize().height));
            }
            this.searchFieldList.add(searchField);
            box.add(searchField.uiComponent);
            box.add(Box.createHorizontalStrut(6));
            JLabel jLabel = new JLabel(Icons.MINUS);
            jLabel.setCursor(Cursor.getPredefinedCursor(12));
            jLabel.setToolTipText(Language.getText("module.repSearch.tab.filters.removeFieldToolTip"));
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SearchFieldGroup.this.searchFieldsBox.getComponentCount() > 1) {
                        SearchFieldGroup.this.searchFieldList.remove(searchField);
                        SearchFieldGroup.this.searchFieldsBox.remove(box);
                        SearchFieldGroup.this.updateRemoveLabels();
                        SearchFieldGroup.this.parentToNotify.validate();
                    }
                }
            });
            box.add(jLabel);
            this.searchFieldsBox.add(box);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateRemoveLabels();
        this.parentToNotify.validate();
    }

    private void updateRemoveLabels() {
        boolean bl = this.searchFieldsBox.getComponentCount() != 1;
        int n = this.searchFieldsBox.getComponentCount() - 1;
        while (n >= 0) {
            Box box = (Box)this.searchFieldsBox.getComponent(n);
            box.getComponent(box.getComponentCount() - 1).setEnabled(bl);
            --n;
        }
    }

    public boolean validateAll() {
        boolean bl = true;
        for (SearchField searchField : this.searchFieldList) {
            bl &= searchField.validate();
        }
        return bl;
    }

    public ReplayFilter[] getReplayFilters() {
        ArrayList<ReplayFilter> arrayList = new ArrayList<ReplayFilter>(this.searchFieldList.size());
        for (SearchField searchField : this.searchFieldList) {
            ReplayFilter replayFilter = searchField.getFilter();
            if (replayFilter == null) continue;
            arrayList.add(replayFilter);
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new ReplayFilter[arrayList.size()]);
    }
}

