/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.icons;

import hu.belicza.andras.sc2gears.language.Language;
import java.awt.Component;
import java.awt.Graphics;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconHandler {
    public static final Map<Size, Icon> NULL = new EnumMap<Size, Icon>(Size.class);
    private final ImageIcon originalIcon;
    private final Map<Size, ImageIcon> sizeIconMap;

    static {
        Size[] sizeArray = Size.values();
        int n = sizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Size size = sizeArray[n2];
            final int n3 = 60 >> size.sizeShift;
            NULL.put(size, new Icon(){

                @Override
                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                }

                @Override
                public int getIconWidth() {
                    return n3;
                }

                @Override
                public int getIconHeight() {
                    return n3;
                }
            });
            ++n2;
        }
    }

    public IconHandler(ImageIcon imageIcon) {
        this.originalIcon = imageIcon;
        this.sizeIconMap = imageIcon == null ? null : new EnumMap(Size.class);
    }

    public Icon get(Size size) {
        if (this.originalIcon == null) {
            return NULL.get((Object)size);
        }
        if (size == Size.BIG) {
            return this.originalIcon;
        }
        ImageIcon imageIcon = this.sizeIconMap.get((Object)size);
        if (imageIcon == null) {
            imageIcon = new ImageIcon(this.originalIcon.getImage().getScaledInstance(this.originalIcon.getIconWidth() >> size.sizeShift, this.originalIcon.getIconHeight() >> size.sizeShift, 4));
            this.sizeIconMap.put(size, imageIcon);
        }
        return imageIcon;
    }

    public static enum Size {
        HIDDEN(8, "module.repAnalyzer.tab.charts.actions.iconSize.hidden"),
        SMALL(2, "module.repAnalyzer.tab.charts.actions.iconSize.small"),
        MEDIUM(1, "module.repAnalyzer.tab.charts.actions.iconSize.medium"),
        BIG(0, "module.repAnalyzer.tab.charts.actions.iconSize.big");

        public final int sizeShift;
        private final String stringValue;

        private Size(int n2, String string2) {
            this.sizeShift = n2;
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

