/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.CommonUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.TableColumnModel;

public class GuiUtils {
    public static final FileView SC2GEARS_FILE_VIEW = new FileView(){

        @Override
        public Icon getIcon(File file) {
            if (file.isDirectory()) {
                return null;
            }
            if (SC2_REPLAY_FILTER.accept(file)) {
                return Icons.SC2;
            }
            if (SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                return Icons.FOLDERS_STACK;
            }
            if (SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                return Icons.TABLE;
            }
            if (ZIP_FILE_FILTER.accept(file)) {
                return Icons.DOCUMENT_ZIPPER;
            }
            return null;
        }
    };
    public static FileFilter SC2_REPLAY_FILTER;
    public static FileFilter SC2_REPLAY_SOURCE_FILE_FILTER;
    public static FileFilter SC2_REPLAY_LIST_FILE_FILTER;
    public static FileFilter ZIP_FILE_FILTER;

    private GuiUtils() {
    }

    public static void initFileFilters() {
        SC2_REPLAY_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.sc2ReplayFiles"), "SC2Replay");
        SC2_REPLAY_SOURCE_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.sc2ReplaySources"), ".sc2repsrc".substring(1));
        SC2_REPLAY_LIST_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.sc2ReplayLists"), ".csv".substring(1));
        ZIP_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.zipFiles"), "zip");
    }

    public static void updateButtonText(AbstractButton abstractButton, String string, Object ... objectArray) {
        String string2 = objectArray == null ? Language.getText(string) : Language.getText(string, objectArray);
        int n = string2.indexOf(95);
        if (n < 0) {
            abstractButton.setText(string2);
        } else {
            abstractButton.setText(string2.replace("_", ""));
            abstractButton.setMnemonic(string2.charAt(n + 1));
        }
    }

    public static JPanel wrapInPanel(JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.add(jComponent);
        return jPanel;
    }

    public static void centerWindow(Window window) {
        window.setLocationRelativeTo(null);
    }

    public static void centerWindowToWindow(Window window, Window window2) {
        window.setLocation(window2.getX() + (window2.getWidth() - window.getWidth()) / 2, window2.getY() + (window2.getHeight() - window.getHeight()) / 2);
    }

    public static boolean setLAF(String string) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n2];
            if (lookAndFeelInfo.getName().equals(string)) {
                try {
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("Failed to set " + lookAndFeelInfo.getName() + " look and feel!");
                    exception.printStackTrace(System.err);
                    return false;
                }
            }
            ++n2;
        }
        System.err.println(String.valueOf(string) + " look and feel was not found!");
        return false;
    }

    public static void packTable(JTable jTable) {
        int n = jTable.getColumnCount() - 1;
        while (n >= 0) {
            int n2 = 70;
            int n3 = jTable.getRowCount() - 1;
            while (n3 >= 0) {
                n2 = Math.max(n2, jTable.getRowMargin() + jTable.getCellRenderer((int)n3, (int)n).getTableCellRendererComponent((JTable)jTable, (Object)jTable.getValueAt((int)n3, (int)n), (boolean)false, (boolean)false, (int)n3, (int)n).getPreferredSize().width);
                --n3;
            }
            jTable.getColumnModel().getColumn(n).setPreferredWidth(n2);
            --n;
        }
    }

    public static UIManager.LookAndFeelInfo[] getSortedInstalledLAFInfos() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        Arrays.sort(lookAndFeelInfoArray, new Comparator<UIManager.LookAndFeelInfo>(){

            @Override
            public int compare(UIManager.LookAndFeelInfo lookAndFeelInfo, UIManager.LookAndFeelInfo lookAndFeelInfo2) {
                if ("Nimbus".equals(lookAndFeelInfo.getName())) {
                    return -1;
                }
                if ("Nimbus".equals(lookAndFeelInfo2.getName())) {
                    return 1;
                }
                if ("Metal".equals(lookAndFeelInfo.getName())) {
                    return -1;
                }
                if ("Metal".equals(lookAndFeelInfo2.getName())) {
                    return 1;
                }
                if ("Office 2003".equals(lookAndFeelInfo.getName())) {
                    return -1;
                }
                if ("Office 2003".equals(lookAndFeelInfo2.getName())) {
                    return 1;
                }
                if ("Office XP".equals(lookAndFeelInfo.getName())) {
                    return -1;
                }
                if ("Office XP".equals(lookAndFeelInfo2.getName())) {
                    return 1;
                }
                if ("Visual Studio 2005".equals(lookAndFeelInfo.getName())) {
                    return -1;
                }
                if ("Visual Studio 2005".equals(lookAndFeelInfo2.getName())) {
                    return 1;
                }
                if ("InfoNode".equals(lookAndFeelInfo.getName())) {
                    return -1;
                }
                if ("InfoNode".equals(lookAndFeelInfo2.getName())) {
                    return 1;
                }
                if ("EaSynthLookAndFeel".equals(lookAndFeelInfo.getName())) {
                    return -1;
                }
                if ("EaSynthLookAndFeel".equals(lookAndFeelInfo2.getName())) {
                    return 1;
                }
                return 0;
            }
        });
        return lookAndFeelInfoArray;
    }

    public static void addNewTab(String string, Icon icon, boolean bl, JTabbedPane jTabbedPane, JComponent jComponent, Runnable runnable) {
        GuiUtils.addNewTab(string, icon, bl, jTabbedPane, jComponent, true, runnable);
    }

    public static void addNewTab(String string, Icon icon, boolean bl, final JTabbedPane jTabbedPane, final JComponent jComponent, boolean bl2, final Runnable runnable) {
        JLabel jLabel;
        jTabbedPane.addTab(null, jComponent);
        Character c = null;
        if (bl2) {
            int n = jTabbedPane.getTabCount();
            if (n == 1) {
                c = Character.valueOf('1');
            } else {
                int n2 = jTabbedPane.getMnemonicAt(n - 2);
                if (n2 >= 0 && n2 < 57) {
                    c = Character.valueOf((char)(n2 + 1));
                }
            }
        }
        if (c != null) {
            jLabel = new JLabel(c + " " + string, icon, 2);
            jLabel.setDisplayedMnemonicIndex(0);
            jTabbedPane.setMnemonicAt(jTabbedPane.getTabCount() - 1, c.charValue());
        } else {
            jLabel = new JLabel(string, icon, 2);
        }
        if (bl) {
            Box box = Box.createHorizontalBox();
            box.add(jLabel);
            final AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (runnable != null) {
                        runnable.run();
                    }
                    jTabbedPane.remove(jComponent);
                }
            };
            JLabel jLabel2 = new JLabel(Icons.CROSS_SMALL);
            jLabel2.setToolTipText(Language.getText("tab.close.tooltop"));
            jLabel2.setCursor(Cursor.getPredefinedCursor(12));
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    abstractAction.actionPerformed(null);
                }
            };
            jLabel2.addMouseListener(mouseAdapter);
            box.add(jLabel2);
            Object object = new Object();
            jComponent.getInputMap(1).put(KeyStroke.getKeyStroke(87, 2), object);
            jComponent.getActionMap().put(object, abstractAction);
            jTabbedPane.setTabComponentAt(jTabbedPane.getTabCount() - 1, box);
        } else {
            jTabbedPane.setTabComponentAt(jTabbedPane.getTabCount() - 1, jLabel);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.requestFocusInWindow();
            }
        });
    }

    public static void appendNewLine(JTextArea jTextArea, String string) {
        jTextArea.append(string);
        jTextArea.append("\n");
    }

    public static void showErrorDialog(Object object) {
        JLabel jLabel = CommonUtils.createLinkStyledLabel(Language.getText("general.errorDetails"));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MainFrame.INSTANCE.viewSystemMessagesMenuItem.doClick();
            }
        });
        String string = Language.getText("general.okButton");
        JOptionPane.showOptionDialog(MainFrame.INSTANCE, new Object[]{object, new JLabel(" "), jLabel}, Language.getText("general.errorTitle"), -1, 0, null, new Object[]{string}, string);
    }

    public static void showInfoDialog(Object object) {
        String string = Language.getText("general.okButton");
        JOptionPane.showOptionDialog(MainFrame.INSTANCE, object, Language.getText("general.infoTitle"), -1, 1, null, new Object[]{string}, string);
    }

    public static int showConfirmDialog(Object object, boolean bl) {
        String string = Language.getText("general.yesButton");
        return JOptionPane.showOptionDialog(MainFrame.INSTANCE, object, Language.getText("general.confirmationTitle"), -1, bl ? 2 : 3, null, new Object[]{string, Language.getText(bl ? "general.cancelButton" : "general.noButton")}, string);
    }

    public static JComponent createReplayFilePreviewAccessory(JFileChooser jFileChooser) {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder(Language.getText("module.repAnalyzer.tab.gameInfo.title")));
        final JLabel jLabel = new JLabel();
        box.add(jLabel);
        final JLabel jLabel2 = new JLabel();
        box.add(jLabel2);
        final JLabel jLabel3 = new JLabel();
        box.add(jLabel3);
        final JLabel jLabel4 = new JLabel();
        box.add(jLabel4);
        final JLabel jLabel5 = new JLabel();
        box.add(jLabel5);
        final JLabel jLabel6 = new JLabel();
        box.add(jLabel6);
        final JLabel jLabel7 = new JLabel();
        box.add(jLabel7);
        final JLabel jLabel8 = new JLabel();
        box.add(jLabel8);
        jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file == null || file.isDirectory()) {
                        return;
                    }
                    Replay replay = ReplayParser.parseReplay(file.getAbsolutePath(), EnumSet.of(ReplayParser.ReplayContent.INIT_DATA, ReplayParser.ReplayContent.DETAILS, ReplayParser.ReplayContent.ATTRIBUTES_EVENTS, ReplayParser.ReplayContent.MAP_INFO));
                    if (replay == null) {
                        jLabel.setText(Language.getText("fileChooser.failedToParseRepaly"));
                        jLabel2.setText("");
                        jLabel3.setText("");
                        jLabel4.setText("");
                        jLabel5.setText("");
                        jLabel7.setText("");
                        jLabel6.setText("");
                        jLabel8.setIcon(null);
                    } else {
                        jLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.version", replay.version));
                        jLabel2.setText(Language.getText("module.repAnalyzer.tab.gameInfo.gameLength", ReplayUtils.formatMs(replay.gameLength * 500)));
                        jLabel3.setText(Language.getText("module.repAnalyzer.tab.gameInfo.gameSpeed", new Object[]{replay.initData.gameSpeed}));
                        jLabel4.setText(Language.getText("module.repAnalyzer.tab.gameInfo.gameType", new Object[]{replay.initData.gameType}));
                        jLabel5.setText(replay.initData.gateway == null ? "" : Language.getText("module.repAnalyzer.tab.gameInfo.gateway", new Object[]{replay.initData.gateway}));
                        jLabel7.setText(String.valueOf(Language.getText("module.repAnalyzer.tab.gameInfo.players")) + " " + replay.details.getPlayerNames());
                        jLabel6.setText(Language.getText("module.repAnalyzer.tab.gameInfo.mapName", replay.details.mapName));
                        jLabel8.setIcon(replay.mapInfo == null ? null : replay.mapInfo.previewIcon);
                    }
                }
            }
        });
        box.setPreferredSize(new Dimension(300, 420));
        return new JScrollPane(box);
    }

    public static int getColumnViewIndex(JTable jTable, int n) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount() - 1;
        while (n2 >= 0) {
            if (tableColumnModel.getColumn(n2).getModelIndex() == n) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public static JCheckBox createCheckBox(String string, final String string2) {
        final JCheckBox jCheckBox = new JCheckBox(Language.getText(string), Settings.getBoolean(string2));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.set(string2, jCheckBox.isSelected());
            }
        });
        return jCheckBox;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(String string, final String string2, Icon icon) {
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        GuiUtils.updateButtonText(jCheckBoxMenuItem, string, new Object[0]);
        if (icon != null) {
            jCheckBoxMenuItem.setIcon(icon);
        }
        jCheckBoxMenuItem.setSelected(Settings.getBoolean(string2));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.set(string2, jCheckBoxMenuItem.isSelected());
            }
        });
        return jCheckBoxMenuItem;
    }

    public static JComboBox createComboBox(Object[] objectArray, final String string) {
        final JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setSelectedIndex(Settings.getInt(string));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.set(string, jComboBox.getSelectedIndex());
            }
        });
        jComboBox.putClientProperty("JComponent.sizeVariant", "small");
        jComboBox.updateUI();
        return jComboBox;
    }

    public static void makeComponentDragScrollable(final JComponent jComponent) {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            int dragStartX;
            int dragStartY;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    this.dragStartX = mouseEvent.getXOnScreen();
                    this.dragStartY = mouseEvent.getYOnScreen();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    Rectangle rectangle = jComponent.getVisibleRect();
                    rectangle.x += (this.dragStartX - mouseEvent.getXOnScreen()) * 2;
                    rectangle.y += (this.dragStartY - mouseEvent.getYOnScreen()) * 2;
                    jComponent.scrollRectToVisible(rectangle);
                    this.dragStartX = mouseEvent.getXOnScreen();
                    this.dragStartY = mouseEvent.getYOnScreen();
                }
            }
        };
        jComponent.addMouseListener(mouseAdapter);
        jComponent.addMouseMotionListener(mouseAdapter);
    }

    public static void changeFontToBold(JComponent jComponent) {
        Font font = jComponent.getFont();
        jComponent.setFont(new Font(font.getName(), 1, font.getSize()));
    }

    public static JTable createNonEditableTable() {
        return new JTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
    }
}

