/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.logger.Log;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.Consts;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.NormalThread;
import hu.belicza.andras.sc2gears.ui.WelcomeFrame;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.UIManager;

public class Sc2gears {
    private Sc2gears() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Sc2gears.checkFolders();
        Settings.loadProperties();
        Sc2gears.checkRunningInstance(stringArray);
        Log.init();
        Sc2gears.checkAndPerformPostUpdate();
        Sc2gears.installExtraLAFs();
        GuiUtils.setLAF(Settings.getString("settings.laf"));
        if (Settings.doesSettingsFileExist()) {
            Language.loadLanguage(Settings.getString("settings.language"));
        } else {
            WelcomeFrame welcomeFrame;
            WelcomeFrame welcomeFrame2 = welcomeFrame = new WelcomeFrame();
            synchronized (welcomeFrame2) {
                try {
                    welcomeFrame.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        GuiUtils.initFileFilters();
        new MainFrame(stringArray);
    }

    private static void checkFolders() {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"User Content", "User Content/Logs", "User Content/Replay sources", "User Content/Replay lists"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            ++n2;
        }
    }

    public static boolean checkAndPerformPostUpdate() {
        File file = new File(Consts.LIB_UPDATER_FOLDER, "Sc2gearsUpdater2.jar").getAbsoluteFile();
        if (file.exists()) {
            System.out.println("Performing post-update...");
            Settings.remove("settings.folders.sc2Installation");
            Settings.remove("settings.folders.sc2AutoReplay");
            Settings.remove("settings.folders.sc2Maps");
            File file2 = new File(Consts.LIB_UPDATER_FOLDER, "Sc2gearsUpdater.jar").getAbsoluteFile();
            int n = 0;
            while (n < 20) {
                if (!file2.exists() || file2.delete()) {
                    if (file.renameTo(file2)) {
                        System.out.println("Post-update completed.");
                        return true;
                    }
                    System.err.println("Could not rename file: " + file.getAbsolutePath());
                    System.err.println("\tto: " + file2.getAbsolutePath());
                    System.err.println("Post-update could not be performed!");
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                ++n;
            }
            System.err.println("Could not delete file: " + file2.getAbsolutePath());
            System.err.println("Post-update could not be performed!");
            return false;
        }
        return true;
    }

    private static void checkRunningInstance(String[] stringArray) {
        block21: {
            if (Settings.getBoolean("settings.allowOnlyOneInstance")) {
                boolean bl;
                block22: {
                    PrintWriter printWriter;
                    Socket socket;
                    int n = 37894;
                    try {
                        final ServerSocket serverSocket = new ServerSocket(37894, 0, InetAddress.getByName("localhost"));
                        new NormalThread("Instance listener"){

                            @Override
                            public void run() {
                                while (true) {
                                    Socket socket = null;
                                    BufferedReader bufferedReader = null;
                                    try {
                                        try {
                                            socket = serverSocket.accept();
                                            MainFrame.INSTANCE.restoreMainFrame();
                                            int n = MainFrame.INSTANCE.getExtendedState();
                                            MainFrame.INSTANCE.setExtendedState(1);
                                            MainFrame.INSTANCE.setExtendedState(n);
                                            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                            int n2 = Integer.parseInt(bufferedReader.readLine());
                                            if (n2 > 0) {
                                                String[] stringArray = new String[n2];
                                                int n3 = 0;
                                                while (n3 < n2) {
                                                    stringArray[n3] = bufferedReader.readLine();
                                                    ++n3;
                                                }
                                                MainFrame.INSTANCE.openArguments(stringArray);
                                            }
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                            if (bufferedReader != null) {
                                                try {
                                                    bufferedReader.close();
                                                }
                                                catch (Exception exception2) {
                                                    // empty catch block
                                                }
                                            }
                                            if (socket == null) continue;
                                            try {
                                                socket.close();
                                            }
                                            catch (Exception exception3) {}
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (bufferedReader != null) {
                                            try {
                                                bufferedReader.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        if (socket != null) {
                                            try {
                                                socket.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        throw throwable;
                                    }
                                    if (bufferedReader != null) {
                                        try {
                                            bufferedReader.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (socket == null) continue;
                                    try {
                                        socket.close();
                                    }
                                    catch (Exception exception) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }.start();
                        break block21;
                    }
                    catch (Exception exception) {
                        socket = null;
                        printWriter = null;
                        bl = false;
                        try {
                            try {
                                socket = new Socket("localhost", 37894);
                                printWriter = new PrintWriter(socket.getOutputStream(), true);
                                printWriter.println(stringArray.length);
                                String[] stringArray2 = stringArray;
                                int n2 = stringArray.length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    String string = stringArray2[n3];
                                    printWriter.println(new File(string).getAbsolutePath());
                                    ++n3;
                                }
                                bl = true;
                            }
                            catch (Exception exception2) {
                                exception2.printStackTrace();
                                if (printWriter != null) {
                                    printWriter.close();
                                }
                                if (socket != null) {
                                    try {
                                        socket.close();
                                    }
                                    catch (Exception exception3) {}
                                }
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            if (printWriter != null) {
                                printWriter.close();
                            }
                            if (socket != null) {
                                try {
                                    socket.close();
                                }
                                catch (Exception exception4) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (bl) {
                    System.exit(0);
                }
            }
        }
    }

    private static void installExtraLAFs() {
        UIManager.installLookAndFeel("EaSynthLookAndFeel", "com.easynth.lookandfeel.EaSynthLookAndFeel");
        UIManager.installLookAndFeel("InfoNode", "net.infonode.gui.laf.InfoNodeLookAndFeel");
        UIManager.installLookAndFeel("Office 2003", "org.fife.plaf.Office2003.Office2003LookAndFeel");
        UIManager.installLookAndFeel("Office XP", "org.fife.plaf.OfficeXP.OfficeXPLookAndFeel");
        UIManager.installLookAndFeel("Visual Studio 2005", "org.fife.plaf.VisualStudio2005.VisualStudio2005LookAndFeel");
    }
}

