/*
 * Decompiled with CFR 0.152.
 */
package org.fife.plaf.OfficeXP;

import java.awt.Color;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class OfficeXPColorManager
implements PropertyChangeListener {
    protected static final int COLOR_SCHEME_BLUE = 0;
    protected static final int COLOR_SCHEME_GREEN = 1;
    protected static final int COLOR_SCHEME_SILVER = 2;
    protected static final String DLL_DESKTOP_PROPERTY = "win.xpstyle.dllName";
    protected static final String STYLE_DESKTOP_PROPERTY = "win.xpstyle.colorName";
    protected static final String THEMEACTIVE_DESKTOP_PROPERTY = "win.xpstyle.themeActive";
    private static final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static final int DELTA = 2;

    protected OfficeXPColorManager() {
    }

    private static final boolean closeEnough(int n, int n2) {
        return n >= n2 - 2 && n <= n2 + 2;
    }

    protected static final int getColorScheme(UIDefaults uIDefaults) {
        Color color = uIDefaults.getColor("Menu.selectionBackground");
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (OfficeXPColorManager.closeEnough(n, 49) && OfficeXPColorManager.closeEnough(n2, 106) && OfficeXPColorManager.closeEnough(n3, 197)) {
            return 0;
        }
        if (OfficeXPColorManager.closeEnough(n, 147) && OfficeXPColorManager.closeEnough(n2, 160) && OfficeXPColorManager.closeEnough(n3, 112)) {
            return 1;
        }
        if (OfficeXPColorManager.closeEnough(n, 178) && OfficeXPColorManager.closeEnough(n2, 180) && OfficeXPColorManager.closeEnough(n3, 191)) {
            return 2;
        }
        return 0;
    }

    protected Object[] getColorSchemeBlueDefaults(UIDefaults uIDefaults) {
        ColorUIResource colorUIResource = new ColorUIResource(252, 252, 249);
        ColorUIResource colorUIResource2 = new ColorUIResource(197, 194, 184);
        ColorUIResource colorUIResource3 = new ColorUIResource(193, 210, 238);
        Object[] objectArray = new Object[]{"Button.disabledForeground", colorUIResource2, "CheckBoxMenuItem.background", colorUIResource, "CheckBoxMenuItem.disabledForeground", colorUIResource2, "Menu.background", colorUIResource, "MenuItem.background", colorUIResource, "MenuItem.disabledForeground", colorUIResource2, "PopupMenu.background", colorUIResource, "PopupMenu.disabledForeground", colorUIResource2, "RadioButtonMenuItem.background", colorUIResource, "RadioButtonMenuItem.disabledForeground", colorUIResource2, "Separator.foreground", colorUIResource2, "Separator.background", colorUIResource, "ToolBar.background", new ColorUIResource(239, 237, 222), "ToolBar.shadow", new ColorUIResource(191, 188, 177), "OfficeLnF.ComboBox.Arrow.Armed.Gradient1", colorUIResource3, "OfficeLnF.ComboBox.Arrow.Armed.Gradient2", null, "OfficeLnF.ComboBox.Arrow.Selected.Gradient1", new ColorUIResource(152, 181, 226), "OfficeLnF.ComboBox.Arrow.Selected.Gradient2", null, "OfficeLnF.ComboBox.Arrow.Normal.Gradient1", uIDefaults.getColor("Panel.background"), "OfficeLnF.ComboBox.Arrow.Normal.Gradient2", null, "OfficeLnF.HighlightBorderColor", new ColorUIResource(49, 106, 197), "OfficeLnF.HighlightColor", colorUIResource3, "OfficeXPLnF.PressedHighlightColor", new ColorUIResource(152, 181, 226), "OfficeXPLnF.CheckBoxHighlightColor", new ColorUIResource(225, 230, 232), "OfficeXPLnF.ChosenMenuColor", uIDefaults.getColor("ToolBar.background"), "OfficeLnF.MenuBorderColor", new ColorUIResource(138, 134, 122), "OfficeXPLnF.MenuItemBackground", uIDefaults.getColor("MenuItem.background")};
        return objectArray;
    }

    protected Object[] getColorSchemeGreenDefaults(UIDefaults uIDefaults) {
        ColorUIResource colorUIResource = new ColorUIResource(252, 252, 249);
        ColorUIResource colorUIResource2 = new ColorUIResource(197, 194, 184);
        ColorUIResource colorUIResource3 = new ColorUIResource(206, 209, 195);
        Object[] objectArray = new Object[]{"Button.disabledForeground", colorUIResource2, "CheckBoxMenuItem.background", colorUIResource, "CheckBoxMenuItem.disabledForeground", colorUIResource2, "Menu.background", colorUIResource, "MenuItem.background", colorUIResource, "MenuItem.disabledForeground", colorUIResource2, "PopupMenu.background", colorUIResource, "PopupMenu.disabledForeground", colorUIResource2, "RadioButtonMenuItem.background", colorUIResource, "RadioButtonMenuItem.disabledForeground", colorUIResource2, "Separator.foreground", colorUIResource2, "Separator.background", colorUIResource, "ToolBar.background", new ColorUIResource(239, 237, 222), "ToolBar.shadow", new ColorUIResource(191, 188, 177), "OfficeLnF.ComboBox.Arrow.Armed.Gradient1", colorUIResource3, "OfficeLnF.ComboBox.Arrow.Armed.Gradient2", null, "OfficeLnF.ComboBox.Arrow.Selected.Gradient1", new ColorUIResource(201, 208, 184), "OfficeLnF.ComboBox.Arrow.Selected.Gradient2", null, "OfficeLnF.ComboBox.Arrow.Normal.Gradient1", uIDefaults.getColor("Panel.background"), "OfficeLnF.ComboBox.Arrow.Normal.Gradient2", null, "OfficeLnF.HighlightBorderColor", new ColorUIResource(147, 160, 112), "OfficeLnF.HighlightColor", colorUIResource3, "OfficeXPLnF.PressedHighlightColor", new ColorUIResource(201, 208, 184), "OfficeXPLnF.CheckBoxHighlightColor", new ColorUIResource(234, 235, 223), "OfficeXPLnF.ChosenMenuColor", uIDefaults.getColor("ToolBar.background"), "OfficeLnF.MenuBorderColor", new ColorUIResource(138, 134, 122), "OfficeXPLnF.MenuItemBackground", uIDefaults.getColor("MenuItem.background")};
        return objectArray;
    }

    protected Object[] getColorSchemeSilverDefaults(UIDefaults uIDefaults) {
        ColorUIResource colorUIResource = new ColorUIResource(224, 223, 227);
        ColorUIResource colorUIResource2 = new ColorUIResource(251, 250, 251);
        ColorUIResource colorUIResource3 = new ColorUIResource(197, 194, 184);
        ColorUIResource colorUIResource4 = new ColorUIResource(199, 199, 202);
        Object[] objectArray = new Object[]{"Button.disabledForeground", colorUIResource3, "CheckBoxMenuItem.background", colorUIResource2, "CheckBoxMenuItem.disabledForeground", colorUIResource3, "Menu.background", colorUIResource2, "MenuItem.background", colorUIResource2, "MenuItem.disabledForeground", colorUIResource3, "MenuBar.background", colorUIResource, "Panel.background", colorUIResource, "PopupMenu.background", colorUIResource2, "PopupMenu.disabledForeground", colorUIResource3, "RadioButtonMenuItem.background", colorUIResource2, "RadioButtonMenuItem.disabledForeground", colorUIResource3, "Separator.foreground", colorUIResource3, "Separator.background", colorUIResource2, "ToolBar.background", new ColorUIResource(229, 228, 232), "ToolBar.shadow", new ColorUIResource(191, 188, 177), "OfficeLnF.ComboBox.Arrow.Armed.Gradient1", colorUIResource4, "OfficeLnF.ComboBox.Arrow.Armed.Gradient2", null, "OfficeLnF.ComboBox.Arrow.Selected.Gradient1", new ColorUIResource(210, 211, 216), "OfficeLnF.ComboBox.Arrow.Selected.Gradient2", null, "OfficeLnF.ComboBox.Arrow.Normal.Gradient1", uIDefaults.getColor("Panel.background"), "OfficeLnF.ComboBox.Arrow.Normal.Gradient2", null, "OfficeLnF.HighlightBorderColor", new ColorUIResource(169, 171, 181), "OfficeLnF.HighlightColor", colorUIResource4, "OfficeXPLnF.PressedHighlightColor", new ColorUIResource(210, 211, 216), "OfficeXPLnF.CheckBoxHighlightColor", new ColorUIResource(233, 234, 237), "OfficeXPLnF.ChosenMenuColor", uIDefaults.getColor("ToolBar.background"), "OfficeLnF.MenuBorderColor", new ColorUIResource(126, 126, 129), "OfficeXPLnF.MenuItemBackground", uIDefaults.getColor("MenuItem.background")};
        return objectArray;
    }

    protected Object[] getColorSchemeWindowsClassicDefaults(UIDefaults uIDefaults) {
        ColorUIResource colorUIResource = new ColorUIResource(249, 248, 247);
        ColorUIResource colorUIResource2 = new ColorUIResource(166, 166, 166);
        ColorUIResource colorUIResource3 = new ColorUIResource(182, 189, 210);
        Object[] objectArray = new Object[]{"Button.disabledForeground", colorUIResource2, "CheckBoxMenuItem.background", colorUIResource, "CheckBoxMenuItem.disabledForeground", colorUIResource2, "Menu.background", colorUIResource, "MenuItem.background", colorUIResource, "MenuItem.disabledForeground", colorUIResource2, "PopupMenu.background", colorUIResource, "PopupMenu.disabledForeground", colorUIResource2, "RadioButtonMenuItem.background", colorUIResource, "RadioButtonMenuItem.disabledForeground", colorUIResource2, "Separator.foreground", colorUIResource2, "Separator.background", colorUIResource, "ToolBar.background", new ColorUIResource(219, 216, 209), "ToolBar.shadow", new ColorUIResource(166, 166, 166), "OfficeLnF.ComboBox.Arrow.Armed.Gradient1", colorUIResource3, "OfficeLnF.ComboBox.Arrow.Armed.Gradient2", null, "OfficeLnF.ComboBox.Arrow.Selected.Gradient1", new ColorUIResource(133, 146, 181), "OfficeLnF.ComboBox.Arrow.Selected.Gradient2", null, "OfficeLnF.ComboBox.Arrow.Normal.Gradient1", uIDefaults.getColor("Panel.background"), "OfficeLnF.ComboBox.Arrow.Normal.Gradient2", null, "OfficeLnF.HighlightBorderColor", new ColorUIResource(10, 36, 106), "OfficeLnF.HighlightColor", colorUIResource3, "OfficeXPLnF.PressedHighlightColor", new ColorUIResource(133, 146, 181), "OfficeXPLnF.CheckBoxHighlightColor", new ColorUIResource(212, 213, 216), "OfficeXPLnF.ChosenMenuColor", uIDefaults.getColor("ToolBar.background"), "OfficeLnF.MenuBorderColor", new ColorUIResource(102, 102, 102), "OfficeXPLnF.MenuItemBackground", uIDefaults.getColor("MenuItem.background")};
        return objectArray;
    }

    protected String getLookAndFeelClassName() {
        return "org.fife.plaf.OfficeXP.OfficeXPLookAndFeel";
    }

    public void install() {
        toolkit.addPropertyChangeListener(STYLE_DESKTOP_PROPERTY, this);
        toolkit.addPropertyChangeListener(THEMEACTIVE_DESKTOP_PROPERTY, this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (STYLE_DESKTOP_PROPERTY.equals(string) || THEMEACTIVE_DESKTOP_PROPERTY.equals(string)) {
            try {
                UIManager.setLookAndFeel(this.getLookAndFeelClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void updateDefaultColors(UIDefaults uIDefaults) {
        Object[] objectArray = null;
        String string = System.getProperty("OfficeLnFs.theme");
        if ("blue".equals(string)) {
            objectArray = this.getColorSchemeBlueDefaults(uIDefaults);
        } else if ("olive".equals(string)) {
            objectArray = this.getColorSchemeGreenDefaults(uIDefaults);
        } else if ("silver".equals(string)) {
            objectArray = this.getColorSchemeSilverDefaults(uIDefaults);
        } else if ("classic".equals(string)) {
            objectArray = this.getColorSchemeWindowsClassicDefaults(uIDefaults);
        } else {
            boolean bl;
            Boolean bl2 = (Boolean)toolkit.getDesktopProperty(THEMEACTIVE_DESKTOP_PROPERTY);
            boolean bl3 = bl = bl2 != null ? bl2 : false;
            if (bl) {
                switch (OfficeXPColorManager.getColorScheme(uIDefaults)) {
                    case 0: {
                        objectArray = this.getColorSchemeBlueDefaults(uIDefaults);
                        break;
                    }
                    case 1: {
                        objectArray = this.getColorSchemeGreenDefaults(uIDefaults);
                        break;
                    }
                    case 2: {
                        objectArray = this.getColorSchemeSilverDefaults(uIDefaults);
                    }
                }
            } else {
                objectArray = this.getColorSchemeWindowsClassicDefaults(uIDefaults);
            }
        }
        uIDefaults.putDefaults(objectArray);
    }

    public void uninstall() {
        toolkit.removePropertyChangeListener(THEMEACTIVE_DESKTOP_PROPERTY, this);
        toolkit.removePropertyChangeListener(STYLE_DESKTOP_PROPERTY, this);
    }
}

