/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalSearchField;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class GameLengthSearchField
extends IntervalSearchField {
    private static final DateFormat MIN_SEC_PARSER = new SimpleDateFormat("m:s");
    private static final DateFormat HOUR_MIN_SEC_PARSER = new SimpleDateFormat("H:m:s");

    public GameLengthSearchField() {
        super("module.repSearch.tab.filters.name.gameLength");
        this.minTextField.setToolTipText(Language.getText("module.repSearch.tab.filters.timeFormatToolTip"));
        this.maxTextField.setToolTipText(Language.getText("module.repSearch.tab.filters.timeFormatToolTip"));
    }

    @Override
    public boolean customValidateMin() {
        String string = this.minTextField.getText();
        if (string.length() == 0) {
            return true;
        }
        Integer n = this.parseSeconds(string);
        return n != null && n >= 0;
    }

    @Override
    public boolean customValidateMax() {
        String string = this.maxTextField.getText();
        if (string.length() == 0) {
            return true;
        }
        Integer n = this.parseSeconds(string);
        return n != null && n >= 0;
    }

    @Override
    public ReplayFilter getFilter() {
        return this.minTextField.getText().length() == 0 && this.maxTextField.getText().length() == 0 ? null : new IntervalReplayFilter(this){
            private final Integer minSeconds;
            private final Integer maxSeconds;
            {
                this.minSeconds = this.minText.length() > 0 ? GameLengthSearchField.this.parseSeconds(this.minText) : null;
                this.maxSeconds = this.maxText.length() > 0 ? GameLengthSearchField.this.parseSeconds(this.maxText) : null;
            }

            @Override
            public boolean accept(File file, Replay replay) {
                if (this.minSeconds != null && replay.gameLengthSec < this.minSeconds) {
                    return false;
                }
                return this.maxSeconds == null || replay.gameLengthSec <= this.maxSeconds;
            }
        };
    }

    private Integer parseSeconds(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            Date date = null;
            try {
                date = HOUR_MIN_SEC_PARSER.parse(string);
            }
            catch (Exception exception2) {
                try {
                    date = MIN_SEC_PARSER.parse(string);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            if (date == null) {
                return null;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return gregorianCalendar.get(11) * 3600 + gregorianCalendar.get(12) * 60 + gregorianCalendar.get(13);
        }
    }
}

