/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Details;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import hu.belicza.andras.sc2gears.replay.model.MapInfo;
import hu.belicza.andras.sc2gears.ui.charts.BaseChartPainter;
import hu.belicza.andras.sc2gears.ui.charts.ChartUtils;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartParams;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ReplayAnalyzer;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.IntHolder;
import hu.belicza.andras.sc2gears.util.Pair;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class ChartPainter
extends BaseChartPainter {
    private static final String[] NUMBER_STRINGS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final Color COLOR_CHART_MARKER = new Color(150, 150, 255);
    private static final Map<MapInfo.MapObject, Color> MAP_OBJECT_COLOR_MAP = new EnumMap<MapInfo.MapObject, Color>(MapInfo.MapObject.class);
    private final StringBuilder[] descriptionBuilders;
    protected final ChartParams params;
    private static /* synthetic */ int[] $SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$ActionType;
    private static /* synthetic */ int[] $SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$Race;

    static {
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.MINERAL_FIELD, new Color(130, 130, 255));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.HIGH_YIELD_MINERAL_FIELD, new Color(180, 180, 100));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.VESPENE_GEYSER, new Color(100, 220, 100));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.SPACE_PLATFORM_GEYSER, new Color(100, 220, 100));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.OBSERVATORY, new Color(255, 255, 255));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_ROCK_4X4, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_ROCK_6X6, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_ROCK_2X6_VERTICAL, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_ROCK_2X6_HORIZONTAL, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_DERBIS_4X4, new Color(92, 51, 23));
        MAP_OBJECT_COLOR_MAP.put(MapInfo.MapObject.DESTRUCTIBLE_DERBIS_6X6, new Color(92, 51, 23));
    }

    public ChartPainter(ChartParams chartParams) {
        super(chartParams);
        this.params = chartParams;
        this.params.calcualteDerivedData(COLOR_PLAYER_DEFAULT);
        this.descriptionBuilders = new StringBuilder[this.params.chartPlayerIndices.length];
    }

    @Override
    public void paintChart() {
        super.paintChart();
        if (this.params.chartPlayerIndices.length == 0 || this.params.chartDX <= 0 || this.params.replay.frames == 0) {
            return;
        }
        if (this.params.chartType != ReplayAnalyzer.ChartType.MAP_VIEW) {
            Details.Player[] playerArray = this.params.replay.details.players;
            int n = 0;
            while (n < this.descriptionBuilders.length) {
                this.descriptionBuilders[n] = new StringBuilder();
                if (this.params.groupByTeam) {
                    this.descriptionBuilders[n].append(Language.getText("module.repAnalyzer.tab.charts.chartText.team", this.params.teamList.get(n))).append(" [");
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < this.params.playerChartIndices.length) {
                        if (this.params.playerChartIndices[n3] == n) {
                            Details.Player player = playerArray[n3];
                            if (n2++ > 0) {
                                this.descriptionBuilders[n].append(", ");
                            }
                            this.descriptionBuilders[n].append(player.name).append(" (").append((player.race == ReplayConsts.Race.RANDOM ? player.raceString : player.raceString()).charAt(0)).append(')');
                        }
                        ++n3;
                    }
                    this.descriptionBuilders[n].append("]");
                } else {
                    Details.Player player = playerArray[this.params.chartPlayerIndices[n]];
                    this.descriptionBuilders[n].append(player.name).append(" (").append((player.race == ReplayConsts.Race.RANDOM ? player.raceString : player.raceString()).charAt(0)).append(')');
                }
                ++n;
            }
            this.paintAxis();
        }
        switch (this.params.chartType) {
            case APM: {
                this.paintApmChart();
                break;
            }
            case HOTKEYS: {
                this.paintHotkeysChart();
                break;
            }
            case BUILDS_TECH: {
                this.paintBuildsTechChart();
                break;
            }
            case BUILDS_TECH_STAT: {
                this.paintBuildsTechStatChart();
                break;
            }
            case MAP_VIEW: {
                this.paintMapViewChart();
            }
        }
        if (this.params.chartType != ReplayAnalyzer.ChartType.MAP_VIEW) {
            this.paintPlayerDescriptions();
            if (this.params.markerX == null && this.params.markerFrame != null) {
                this.params.markerX = this.params.frameToX(this.params.markerFrame);
            }
            if (this.params.markerX != null) {
                this.g2.setColor(COLOR_CHART_MARKER);
                this.g2.setStroke(STROKE_DASHED);
                this.g2.drawLine(this.params.markerX, 0, this.params.markerX, this.params.height - 1);
                this.g2.setStroke(STROKE_DEFAULT);
            }
        }
    }

    private void paintAxis() {
        this.g2.setColor(COLOR_AXIS);
        int n = this.params.chartsCount - 1;
        while (n >= 0) {
            this.g2.drawLine(25 + this.params.visibleRectangle.x, this.params.chartY1s[n], 25 + this.params.visibleRectangle.x, this.params.chartY2s[n]);
            this.g2.drawLine(25, this.params.chartY2s[n] + 1, this.params.chartX2, this.params.chartY2s[n] + 1);
            --n;
        }
        n = this.g2.getFontMetrics().getAscent();
        int n2 = this.params.chartWidth < 100 ? 1 : this.params.chartWidth / 100;
        int n3 = this.params.chartsCount - 1;
        while (n3 >= 0) {
            int n4 = n2;
            while (n4 >= 0) {
                int n5 = this.params.chartX1 + n4 * this.params.chartDX / n2;
                int n6 = n4 == 0 ? 0 : (n4 == n2 ? this.params.replay.frames : this.params.xToFrame(n5));
                String string = this.params.displayInSeconds ? ReplayUtils.formatFramesShort(n6) : Integer.toString(n6);
                this.g2.setColor(COLOR_AXIS);
                this.g2.drawLine(n5, this.params.chartY2s[n3] + 1, n5, this.params.chartY2s[n3] + 3);
                this.g2.setColor(COLOR_AXIS_LABELS);
                this.g2.drawString(string, n5 - (this.g2.getFontMetrics().stringWidth(string) >> (n4 == n2 ? 0 : 1)), this.params.chartY2s[n3] + n);
                --n4;
            }
            --n3;
        }
    }

    private void paintApmChart() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        GameEvents.Action[] actionArray = this.params.actions;
        int n9 = this.params.width / this.params.apmGranularity + (this.params.width % this.params.apmGranularity != 0 ? 1 : 0);
        int[][] nArray = new int[this.params.chartPlayerIndices.length][n9];
        int[] nArray2 = new int[this.params.chartPlayerIndices.length];
        int n10 = actionArray.length - 1;
        while (n10 >= 0) {
            int n11;
            GameEvents.Action action = actionArray[n10];
            if (action.type != ReplayConsts.ActionType.INACTION && (n11 = this.params.playerChartIndices[action.player]) >= 0) {
                int[] nArray3 = nArray[n11];
                int n12 = (this.params.frameToX(action.frame) - 25) / this.params.apmGranularity;
                nArray3[n12] = nArray3[n12] + 1;
                int n13 = n11;
                nArray2[n13] = nArray2[n13] + 1;
            }
            --n10;
        }
        n10 = 0;
        while (n10 < nArray2.length) {
            if (this.params.groupByTeam) {
                n8 = 0;
                n7 = 0;
                while (n7 < this.params.playerChartIndices.length) {
                    if (this.params.playerChartIndices[n7] == n10) {
                        n8 = Math.max(n8, this.params.replay.details.players[n7].lastActionFrame);
                    }
                    ++n7;
                }
            } else {
                n8 = this.params.replay.details.players[this.params.chartPlayerIndices[n10]].lastActionFrame;
            }
            this.descriptionBuilders[n10].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.actions", nArray2[n10])).append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.apm", n8 == 0 ? 0L : (long)nArray2[n10] * 3840L / (long)n8));
            ++n10;
        }
        int[] nArray4 = new int[this.params.chartPlayerIndices.length];
        n8 = 0;
        while (n8 < nArray.length) {
            if (nArray[n8] != null) {
                nArray4[n8] = GeneralUtils.maxValue(nArray[n8]);
            }
            ++n8;
        }
        if (this.params.allPlayersOnOneChart) {
            Arrays.fill(nArray4, GeneralUtils.maxValue(nArray4));
        }
        n7 = 0;
        while (n7 < nArray.length) {
            n6 = this.params.chartY2s[n7];
            n5 = nArray4[n7];
            int[] nArray5 = nArray[n7];
            if (n5 > 0) {
                n4 = nArray5.length - 1;
                while (n4 >= 0) {
                    nArray5[n4] = n6 - this.params.chartHeight * nArray5[n4] / n5;
                    --n4;
                }
            } else {
                Arrays.fill(nArray5, n6);
            }
            ++n7;
        }
        n7 = this.g2.getFontMetrics().getAscent();
        n6 = this.params.xToFrame(25 + this.params.apmGranularity - 1);
        n5 = this.params.chartHeight < 20 ? 1 : this.params.chartHeight / 20;
        this.g2.setStroke(STROKE_DASHED);
        n4 = this.params.chartsCount - 1;
        while (n4 >= 0) {
            n3 = n5 - 1;
            while (n3 >= 0) {
                n2 = this.params.chartY1s[n4] + n3 * this.params.chartDY / n5;
                this.g2.setColor(COLOR_ASSIST_LINES);
                this.g2.drawLine(this.params.chartX1 + 1 + this.params.visibleRectangle.x, n2, this.params.chartX2, n2);
                this.g2.setColor(COLOR_AXIS_LABELS);
                n = (int)(n6 < 1 ? 1L : (long)(n5 - n3) * (long)nArray4[n4] * 3840L / (long)(n5 * n6));
                this.g2.drawString(Integer.toString(n), this.params.visibleRectangle.x, n2 + (n7 >> 1) - 1);
                --n3;
            }
            --n4;
        }
        this.g2.setStroke(STROKE_DEFAULT);
        this.g2.setStroke(this.params.apmApproximation == ChartUtils.GraphApproximation.LINEAR ? STROKE_DOUBLE_WIDTH_ROUNDED : STROKE_DOUBLE_WIDTH);
        int[] nArray6 = new int[n9];
        n3 = 25 - this.params.apmGranularity;
        n2 = 0;
        while (n2 < nArray6.length) {
            nArray6[n2] = n3 += this.params.apmGranularity;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            int[] nArray7 = nArray[n2];
            this.g2.setColor(this.params.playerColors[this.params.chartPlayerIndices[n2]]);
            n = Math.max(0, (this.params.visibleRectangle.x - 25) / this.params.apmGranularity);
            int n14 = Math.min(nArray6.length - 1, (this.params.visibleRectangle.x + this.params.visibleRectangle.width - 1) / this.params.apmGranularity + 1);
            switch (this.params.apmApproximation) {
                case LINEAR: {
                    int n15 = n;
                    while (n15 < n14) {
                        this.g2.drawLine(nArray6[n15], nArray7[n15], nArray6[n15 + 1], nArray7[n15 + 1]);
                        ++n15;
                    }
                    break;
                }
                case CUBIC: {
                    Rectangle rectangle = this.g2.getClipBounds();
                    if (rectangle == null) {
                        this.g2.setClip(this.params.chartX1, this.params.chartY1s[n2], this.params.chartWidth, this.params.chartHeight);
                    } else {
                        this.g2.setClip(rectangle.intersection(new Rectangle(this.params.chartX1, this.params.chartY1s[n2], this.params.chartWidth, this.params.chartHeight)));
                    }
                    this.drawCubicCurve2D(nArray6, nArray7, n, n14);
                    this.g2.setClip(rectangle);
                }
            }
            ++n2;
        }
        this.g2.setStroke(STROKE_DEFAULT);
    }

    private void paintHotkeysChart() {
        int n;
        Object[] objectArray;
        Color color;
        int n2 = this.g2.getFontMetrics().getAscent();
        int n3 = this.g2.getFontMetrics().charWidth('8');
        boolean bl = this.params.chartHeight >= 10 * n2;
        Color[] colorArray = new Color[this.params.playerColors.length];
        int n4 = 0;
        while (n4 < colorArray.length) {
            color = this.params.playerColors[n4];
            if (color != null) {
                objectArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                colorArray[n4] = new Color(Color.HSBtoRGB(1.0f - objectArray[0], (float)objectArray[1], 1.0f - objectArray[2]));
            }
            ++n4;
        }
        int[] nArray = new int[this.params.chartPlayerIndices.length];
        color = this.params.showSelectHotkeys ? new int[this.params.chartPlayerIndices.length] : null;
        objectArray = this.params.actions;
        ArrayList<Pair<Rectangle, String>> arrayList = new ArrayList<Pair<Rectangle, String>>(64);
        Map<Short, String> map = this.params.replay.gameEvents.unitTypeNameMap;
        List[] listArray = new List[this.params.playerColors.length];
        List[][] listArrayArray = new List[this.params.playerColors.length][];
        int n5 = 0;
        while (n5 < listArray.length) {
            List list = listArray[n5] = this.params.playerChartIndices[n5] < 0 ? null : new ArrayList();
            if (this.params.playerChartIndices[n5] < 0) {
                listArrayArray[n5] = null;
            } else {
                listArrayArray[n5] = new List[10];
                n = 0;
                while (n < 10) {
                    listArrayArray[n5][n] = new ArrayList();
                    ++n;
                }
            }
            ++n5;
        }
        n5 = n2 + (bl ? this.params.chartHeight / 10 - n2 >> 1 : 0) - 2;
        n = objectArray.length;
        int n6 = 0;
        while (n6 < n) {
            GameEvents.Action action = objectArray[n6];
            int n7 = this.params.playerChartIndices[action.player];
            if (n7 >= 0) {
                int n8;
                short s;
                int n9;
                int n10;
                List list;
                if (action instanceof GameEvents.SelectAction) {
                    list = listArray[action.player];
                    GameEvents.SelectAction selectAction = (GameEvents.SelectAction)action;
                    n10 = 0;
                    int n11 = 0;
                    n9 = 0;
                    while (n9 < selectAction.deselectionBitsCount) {
                        if ((n9 & 7) == 0) {
                            n11 = selectAction.deselectionUnitBitmap[n9 >> 3] & 0xFF;
                        }
                        if ((n11 & 0x80) != 0) {
                            if (n9 - n10 >= list.size()) break;
                            list.remove(n9 - n10++);
                        }
                        n11 <<= 1;
                        ++n9;
                    }
                    n9 = 0;
                    while (n9 < selectAction.unitTypes.length) {
                        s = selectAction.unitTypes[n9];
                        n8 = selectAction.unitsOfTypeCounts[n9];
                        while (n8 > 0) {
                            list.add(s);
                            --n8;
                        }
                        ++n9;
                    }
                } else if (action instanceof GameEvents.HotkeyAction) {
                    list = listArray[action.player];
                    boolean bl2 = ((GameEvents.HotkeyAction)action).isSelect;
                    int n12 = (action.opCode & 0xFF) >> 4;
                    if (bl2) {
                        list.clear();
                        list.addAll(listArrayArray[action.player][n12]);
                    } else {
                        listArrayArray[action.player][n12].clear();
                        listArrayArray[action.player][n12].addAll(list);
                    }
                    if (this.params.showSelectHotkeys || !bl2) {
                        this.g2.setColor(this.params.playerColors[action.player]);
                        int n13 = this.params.frameToX(action.frame);
                        n10 = this.params.chartY1s[n7] + (bl ? n12 * this.params.chartHeight / 10 : n12 * (this.params.chartHeight - n2) / 9) + n5;
                        if (!bl2) {
                            this.g2.fillRect(n13, n10 - n2 + 2, n3, n2);
                            this.g2.setColor(colorArray[action.player]);
                            StringBuilder stringBuilder = new StringBuilder();
                            n9 = 0;
                            while (n9 < list.size()) {
                                if (stringBuilder.length() > 0) {
                                    stringBuilder.append(", ");
                                }
                                s = (Short)list.get(n9++);
                                n8 = 1;
                                while (n9 < list.size() && (Short)list.get(n9) == s) {
                                    ++n8;
                                    ++n9;
                                }
                                String string = map.get(s);
                                if (string == null) {
                                    stringBuilder.append("Unknown[").append(Integer.toHexString(s)).append(']');
                                } else {
                                    stringBuilder.append(string);
                                }
                                if (n8 <= 1) continue;
                                stringBuilder.append(" x").append(n8);
                            }
                            arrayList.add(new Pair<Rectangle, String>(new Rectangle(n13, n10 - n2 + 2, n3, n2), stringBuilder.toString()));
                        }
                        this.g2.drawString(NUMBER_STRINGS[n12], n13, n10);
                        Object object = bl2 ? color : (Object)nArray;
                        int n14 = n7;
                        object[n14] = object[n14] + true;
                    }
                }
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.descriptionBuilders.length) {
            if (this.params.showSelectHotkeys) {
                this.descriptionBuilders[n6].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.hotkeys", nArray[n6] + color[n6])).append(" (").append(Language.getText("module.repAnalyzer.tab.charts.chartText.assign", nArray[n6])).append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.select", (int)color[n6])).append(')');
            } else {
                this.descriptionBuilders[n6].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.hotkeysAssign", nArray[n6]));
            }
            ++n6;
        }
        this.params.toolTipProvider = new ChartParams.ToolTipProvider(arrayList);
    }

    private void paintBuildsTechChart() {
        GameEvents.Action[] actionArray = this.params.actions;
        EnumSet<ReplayConsts.ActionType> enumSet = EnumSet.noneOf(ReplayConsts.ActionType.class);
        if (this.params.showBuilds) {
            enumSet.add(ReplayConsts.ActionType.BUILD);
        }
        if (this.params.showTrains) {
            enumSet.add(ReplayConsts.ActionType.TRAIN);
        }
        if (this.params.showResearches) {
            enumSet.add(ReplayConsts.ActionType.RESEARCH);
        }
        if (this.params.showUpgrades) {
            enumSet.add(ReplayConsts.ActionType.UPGRADE);
        }
        int n = this.params.useIcons ? Icons.getBuildingIcon(ReplayConsts.Building.NEXUS, IconHandler.Size.MEDIUM).getIconHeight() : this.g2.getFontMetrics().getAscent();
        int n2 = Math.max(1, (this.params.chartDY - 7) / n);
        int[] nArray = this.params.showBuilds ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray2 = this.params.showTrains ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray3 = this.params.showWorkers ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray4 = this.params.showResearches ? new int[this.params.chartPlayerIndices.length] : null;
        int[] nArray5 = this.params.showUpgrades ? new int[this.params.chartPlayerIndices.length] : null;
        ArrayList<Pair<Rectangle, String>> arrayList = this.params.useIcons ? new ArrayList<Pair<Rectangle, String>>(64) : null;
        int[] nArray6 = new int[this.params.allPlayersOnOneChart ? 1 : this.params.chartsCount];
        if (n2 > 2) {
            Arrays.fill(nArray6, 1);
        }
        int n3 = actionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            block21: {
                ReplayConsts.Unit unit;
                int n5;
                GameEvents.Action action;
                block22: {
                    action = actionArray[n4];
                    n5 = this.params.playerChartIndices[action.player];
                    if (n5 < 0 || !enumSet.contains((Object)action.type)) break block21;
                    if (action.type != ReplayConsts.ActionType.TRAIN || (unit = ((GameEvents.TrainAction)action).unit) != ReplayConsts.Unit.SCV && unit != ReplayConsts.Unit.DRONE && unit != ReplayConsts.Unit.PROBE) break block22;
                    if (!this.params.showWorkers) break block21;
                    int n6 = n5;
                    nArray3[n6] = nArray3[n6] + 1;
                }
                unit = action.type == ReplayConsts.ActionType.TRAIN ? ((GameEvents.TrainAction)action).unit : (action.type == ReplayConsts.ActionType.BUILD ? ((GameEvents.BuildAction)action).building : (action.type == ReplayConsts.ActionType.RESEARCH ? ((GameEvents.ResearchAction)action).research : ((GameEvents.UpgradeAction)action).upgrade));
                String string = ((Object)((Object)unit)).toString();
                int[] nArray7 = action.type == ReplayConsts.ActionType.TRAIN ? nArray2 : (action.type == ReplayConsts.ActionType.BUILD ? nArray : (action.type == ReplayConsts.ActionType.RESEARCH ? nArray4 : nArray5));
                int n7 = n5;
                nArray7[n7] = nArray7[n7] + 1;
                this.g2.setColor(action.type == ReplayConsts.ActionType.RESEARCH || action.type == ReplayConsts.ActionType.UPGRADE ? this.params.replay.details.players[action.player].getBrighterColor() : this.params.playerColors[action.player]);
                this.g2.setStroke(action.type == ReplayConsts.ActionType.TRAIN ? STROKE_DASHED : STROKE_DEFAULT);
                if (this.params.allPlayersOnOneChart) {
                    n5 = 0;
                }
                int n8 = this.params.frameToX(action.frame);
                int n9 = this.params.chartY2s[n5] - 7 - nArray6[n5] * n;
                int n10 = n5;
                nArray6[n10] = nArray6[n10] + 1;
                if (nArray6[n10] == n2) {
                    nArray6[n5] = 0;
                }
                this.g2.drawLine(n8, n9 + 1, n8, this.params.chartY2s[n5]);
                if (this.params.useIcons) {
                    Icon icon = Icons.getEntityIcon((Object)unit, IconHandler.Size.MEDIUM);
                    Icons.getEntityIcon((Object)unit, IconHandler.Size.MEDIUM).paintIcon(this.params.chartCanvas, this.g2, n8 - (icon.getIconWidth() >> 1), n9 - icon.getIconHeight());
                    arrayList.add(new Pair<Rectangle, String>(new Rectangle(n8 - (icon.getIconWidth() >> 1), n9 - icon.getIconHeight(), icon.getIconWidth(), icon.getIconHeight()), string));
                } else {
                    this.g2.drawString(string, n8 - (this.g2.getFontMetrics().stringWidth(string) >> 1), n9);
                }
            }
            ++n4;
        }
        if (this.params.useIcons) {
            this.params.toolTipProvider = new ChartParams.ToolTipProvider(arrayList);
        }
        if (!enumSet.isEmpty()) {
            n4 = 0;
            while (n4 < this.descriptionBuilders.length) {
                if (this.params.showBuilds) {
                    this.descriptionBuilders[n4].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.builds", nArray[n4]));
                }
                if (this.params.showTrains) {
                    this.descriptionBuilders[n4].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.trains", nArray2[n4]));
                    if (this.params.showWorkers) {
                        this.descriptionBuilders[n4].append(" (").append(Language.getText("module.repAnalyzer.tab.charts.chartText.workers", nArray3[n4])).append(')');
                    }
                }
                if (this.params.showResearches) {
                    this.descriptionBuilders[n4].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.researches", nArray4[n4]));
                }
                if (this.params.showUpgrades) {
                    this.descriptionBuilders[n4].append(", ").append(Language.getText("module.repAnalyzer.tab.charts.chartText.upgrades", nArray5[n4]));
                }
                ++n4;
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void paintBuildsTechStatChart() {
        var1_1 = this.params.markerFrame == null ? (this.params.markerX == null ? this.params.replay.frames : this.params.xToFrame(this.params.markerX)) : this.params.markerFrame;
        var2_2 = this.params.actions;
        var3_3 = new ChartStat[this.params.chartPlayerIndices.length];
        var4_4 = 0;
        while (var4_4 < var3_3.length) {
            var3_3[var4_4] = new ChartStat();
            ++var4_4;
        }
        var6_6 = var2_2.length;
        var8_7 = 0;
        if (true) ** GOTO lbl59
        do {
            if ((var7_10 = this.params.playerChartIndices[var4_5.player]) >= 0) {
                var5_9 = var3_3[var7_10];
                var9_11 = null;
                switch (ChartPainter.$SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$ActionType()[var4_5.type.ordinal()]) {
                    case 3: {
                        if (!this.params.showUnitsStat || (var9_11 = var5_9.unitCountMap.get(var10_13 = ((GameEvents.TrainAction)var4_5).unit)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.unitCountMap.put((ReplayConsts.Unit)var10_13, var9_11);
                        var5_9.unitList.add((ReplayConsts.Unit)var10_13);
                        break;
                    }
                    case 2: {
                        if (!this.params.showBuildingsStat || (var9_11 = var5_9.buildingCountMap.get(var10_13 = ((GameEvents.BuildAction)var4_5).building)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.buildingCountMap.put((ReplayConsts.Building)var10_13, var9_11);
                        var5_9.buildingList.add((ReplayConsts.Building)var10_13);
                        break;
                    }
                    case 4: {
                        if (!this.params.showResearchesStat || (var9_11 = var5_9.researchCountMap.get(var10_13 = ((GameEvents.ResearchAction)var4_5).research)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.researchCountMap.put((ReplayConsts.Research)var10_13, var9_11);
                        var5_9.researchList.add((ReplayConsts.Research)var10_13);
                        break;
                    }
                    case 5: {
                        if (!this.params.showUpgradesStat || (var9_11 = var5_9.upgradeCountMap.get(var10_13 = ((GameEvents.UpgradeAction)var4_5).upgrade)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.upgradeCountMap.put((ReplayConsts.Upgrade)var10_13, var9_11);
                        var5_9.upgradeList.add((ReplayConsts.Upgrade)var10_13);
                        break;
                    }
                    default: {
                        if (!(var4_5 instanceof GameEvents.BaseUseAbilityAction) || !this.params.showAbilityGroupsStat || (var10_13 = ((GameEvents.BaseUseAbilityAction)var4_5).abilityGroup) == null || (var9_11 = var5_9.abilityGroupCountMap.get(var10_13)) != null) break;
                        var9_11 = new IntHolder();
                        var5_9.abilityGroupCountMap.put((ReplayConsts.AbilityGroup)var10_13, var9_11);
                        var5_9.abilityGroupList.add((ReplayConsts.AbilityGroup)var10_13);
                    }
                }
                if (var9_11 != null) {
                    ++var9_11.value;
                }
            }
            ++var8_7;
lbl59:
            // 2 sources

            if (var8_7 >= var6_6) break;
            var4_5 = var2_2[var8_7];
        } while (var4_5.frame <= var1_1);
        var8_8 = new int[5][var3_3.length];
        var9_12 = 0;
        while (var9_12 < var3_3.length) {
            var5_9 = var3_3[var9_12];
            var8_8[0][var9_12] = ChartPainter.maxOfMap(var5_9.unitCountMap);
            var8_8[1][var9_12] = ChartPainter.maxOfMap(var5_9.buildingCountMap);
            var8_8[2][var9_12] = ChartPainter.maxOfMap(var5_9.researchCountMap);
            var8_8[3][var9_12] = ChartPainter.maxOfMap(var5_9.upgradeCountMap);
            var8_8[4][var9_12] = ChartPainter.maxOfMap(var5_9.abilityGroupCountMap);
            ++var9_12;
        }
        if (this.params.allPlayersOnOneChart) {
            var9_12 = 0;
            while (var9_12 < 5) {
                var8_8[var9_12][0] = GeneralUtils.maxValue(var8_8[var9_12]);
                var10_15 = 1;
                while (var10_15 < var8_8[var9_12].length) {
                    var8_8[var9_12][var10_15] = var8_8[var9_12][0];
                    ++var10_15;
                }
                ++var9_12;
            }
        }
        var9_12 = this.g2.getFontMetrics().getAscent();
        var10_16 = Math.max(0, this.params.chartHeight - Icons.getBuildingIcon(ReplayConsts.Building.NEXUS, this.params.barSize).getIconHeight() - var9_12);
        var11_17 = new IntHolder[this.params.allPlayersOnOneChart != false ? 1 : var3_3.length];
        var12_18 = 0;
        while (var12_18 < var11_17.length) {
            var11_17[var12_18] = new IntHolder(26);
            ++var12_18;
        }
        var12_19 = new ArrayList<Pair<Rectangle, String>>(32);
        var13_20 = new boolean[this.params.allPlayersOnOneChart != false ? 1 : var3_3.length][5];
        var14_21 = 0;
        while (var14_21 < 5) {
            var15_22 = 0;
            while (var15_22 < var3_3.length) {
                var5_9 = var3_3[var15_22];
                var16_23 = this.params.chartY2s[var15_22];
                var17_24 = var11_17[this.params.allPlayersOnOneChart != false ? 0 : var15_22];
                var18_25 = var13_20[this.params.allPlayersOnOneChart != false ? 0 : var15_22];
                if (var14_21 > 0) {
                    v0 = var14_21;
                    var18_25[v0] = var18_25[v0] | var18_25[var14_21 - 1];
                }
                this.g2.setColor(var14_21 == 2 || var14_21 == 3 ? this.params.replay.details.players[this.params.chartPlayerIndices[var15_22]].getBrighterColor() : this.params.playerColors[this.params.chartPlayerIndices[var15_22]]);
                var19_26 = false;
                if (var14_21 == 0 && var5_9.unitList.size() > 0) {
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.unitList) {
                        this.drawStatBar(var12_19, Icons.getUnitIcon((ReplayConsts.Unit)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.unitCountMap.get((Object)var20_27).value, var8_8[0][var15_22], var16_23);
                    }
                }
                if (var14_21 == 1 && var5_9.buildingList.size() > 0) {
                    if (var18_25[var14_21 - 1]) {
                        var17_24.value += 10;
                        var18_25[var14_21 - 1] = false;
                    }
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.buildingList) {
                        this.drawStatBar(var12_19, Icons.getBuildingIcon((ReplayConsts.Building)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.buildingCountMap.get((Object)var20_27).value, var8_8[1][var15_22], var16_23);
                    }
                }
                if (var14_21 == 2 && var5_9.researchList.size() > 0) {
                    if (var18_25[var14_21 - 1]) {
                        var17_24.value += 10;
                        var18_25[var14_21 - 1] = false;
                    }
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.researchList) {
                        this.drawStatBar(var12_19, Icons.getResearchIcon((ReplayConsts.Research)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.researchCountMap.get((Object)var20_27).value, var8_8[2][var15_22], var16_23);
                    }
                }
                if (var14_21 == 3 && var5_9.upgradeList.size() > 0) {
                    if (var18_25[var14_21 - 1]) {
                        var17_24.value += 10;
                        var18_25[var14_21 - 1] = false;
                    }
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.upgradeList) {
                        this.drawStatBar(var12_19, Icons.getUpgradeIcon((ReplayConsts.Upgrade)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.upgradeCountMap.get((Object)var20_27).value, var8_8[3][var15_22], var16_23);
                    }
                }
                if (var14_21 == 4 && var5_9.abilityGroupList.size() > 0) {
                    if (var18_25[var14_21 - 1]) {
                        var17_24.value += 10;
                        var18_25[var14_21 - 1] = false;
                    }
                    var19_26 = true;
                    for (Enum var20_27 : var5_9.abilityGroupList) {
                        this.drawStatBar(var12_19, Icons.getAbilityGroupIcon((ReplayConsts.AbilityGroup)var20_27, this.params.barSize), var20_27, var17_24, var10_16, var5_9.abilityGroupCountMap.get((Object)var20_27).value, var8_8[4][var15_22], var16_23);
                    }
                }
                v1 = var14_21;
                var18_25[v1] = var18_25[v1] | var19_26;
                ++var15_22;
            }
            ++var14_21;
        }
        this.params.toolTipProvider = new ChartParams.ToolTipProvider(var12_19);
    }

    private void drawStatBar(List<Pair<Rectangle, String>> list, Icon icon, Object object, IntHolder intHolder, int n, int n2, int n3, int n4) {
        int n5 = icon.getIconWidth();
        icon.paintIcon(this.params.chartCanvas, this.g2, intHolder.value, n4 - icon.getIconHeight() + 1);
        int n6 = n4 - icon.getIconHeight();
        int n7 = n * n2 / n3;
        this.g2.fill3DRect(intHolder.value, n6 - n7, n5, n7, true);
        Color color = this.g2.getColor();
        this.g2.setColor(COLOR_PLAYER_DEFAULT);
        String string = Integer.toString(n2);
        this.g2.drawString(string, intHolder.value + (n5 - this.g2.getFontMetrics().stringWidth(string) >> 1), n6 - n7 - 1);
        this.g2.setColor(color);
        list.add(new Pair<Rectangle, String>(new Rectangle(intHolder.value, n6 - n7, n5, n4 - n6 + n7), object.toString()));
        intHolder.value += n5;
    }

    private static int maxOfMap(Map<?, IntHolder> map) {
        int n = 0;
        if (map != null) {
            for (IntHolder intHolder : map.values()) {
                if (n >= intHolder.value) continue;
                n = intHolder.value;
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void paintMapViewChart() {
        var1_1 = this.params.replay.mapInfo;
        if (this.params.replay.mapInfo == null) {
            this.g2.setColor(Color.WHITE);
            this.g2.drawString(Language.getText("module.repAnalyzer.tab.charts.chartText.mapViewChartNotAvailable1"), 10, 20);
            this.g2.drawString(Language.getText("module.repAnalyzer.tab.charts.chartText.mapViewChartNotAvailable2"), 10, 20 + this.g2.getFontMetrics().getHeight());
            this.params.toolTipProvider = new ChartParams.ToolTipProvider(new ArrayList<Pair<Rectangle, String>>(0));
            return;
        }
        if (var1_1.mapObjectList == null) {
            ReplayParser.parseExtendedMapInfo(this.params.replay);
        }
        var2_2 = this.params.markerFrame == null ? (this.params.markerX == null ? this.params.replay.frames : this.params.xToFrame(this.params.markerX)) : this.params.markerFrame;
        var3_3 = this.params.actions;
        var4_4 = new ArrayList<Pair<Rectangle, String>>(128);
        var5_5 = this.params.zoom << 1;
        var6_6 = var1_1.width * var5_5;
        var7_7 = var1_1.height * var5_5;
        this.g2.setColor(Color.LIGHT_GRAY);
        this.g2.drawLine(var6_6, 0, var6_6, var7_7);
        this.g2.drawLine(0, var7_7, var6_6, var7_7);
        if (var5_5 <= 2) {
            this.g2.drawString(Language.getText("module.repAnalyzer.tab.charts.chartText.mapViewZoomTip"), var6_6 + 5, 20);
        }
        this.g2.drawImage(var1_1.previewIcon.getImage(), var1_1.boundaryLeft * var5_5, (var1_1.height - var1_1.boundaryTop) * var5_5, var1_1.previewIcon.getIconWidth() * var5_5, var1_1.previewIcon.getIconHeight() * var5_5, null);
        var9_8 = var1_1.mapObjectList.iterator();
        while (var9_8.hasNext()) {
            var8_9 = var9_8.next();
            this.g2.setColor(ChartPainter.MAP_OBJECT_COLOR_MAP.get(var8_9.value1));
            var10_10 = new Rectangle(((MapInfo.MapObject)var8_9.value1).width * var5_5, ((MapInfo.MapObject)var8_9.value1).height * var5_5);
            var10_10.x = this.params.scaleMapCoord(((Point)var8_9.value2).x) - (var10_10.width >> 1);
            var10_10.y = var7_7 - this.params.scaleMapCoord(((Point)var8_9.value2).y) - (var10_10.height >> 1);
            this.g2.fillRect(var10_10.x, var10_10.y, var10_10.width, var10_10.height);
            if (((MapInfo.MapObject)var8_9.value1).toolTip == null) continue;
            var4_4.add(new Pair<Rectangle, String>(var10_10, ((MapInfo.MapObject)var8_9.value1).toolTip));
        }
        var8_9 = new ArrayList<E>(128);
        var10_11 = var3_3.length;
        var12_12 = this.params.replay.details.players.length - 1;
        while (var12_12 >= 0) {
            block30: {
                if (this.params.playerChartIndices[var12_12] >= 0) {
                    var11_14 = this.params.replay.details.players[var12_12];
                    if (var11_14.startLocation != null) {
                        var13_15 = null;
                        var14_17 = var11_14.race;
                        if (var14_17 != ReplayConsts.Race.PROTOSS || var14_17 != ReplayConsts.Race.TERRAN || var14_17 != ReplayConsts.Race.ZERG) {
                            var15_22 = 0;
                            while (var15_22 < var10_11) {
                                var9_8 = var3_3[var15_22];
                                if (var9_8.player == var12_12 && var9_8 instanceof GameEvents.TrainAction) {
                                    var14_17 = ((GameEvents.TrainAction)var9_8).unit.raceOfUnit();
                                    break;
                                }
                                ++var15_22;
                            }
                        }
                        switch (ChartPainter.$SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$Race()[var14_17.ordinal()]) {
                            case 1: {
                                var13_15 = ReplayConsts.Building.NEXUS;
                                break;
                            }
                            case 2: {
                                var13_15 = ReplayConsts.Building.COMMAND_CENTER;
                                break;
                            }
                            case 3: {
                                var13_15 = ReplayConsts.Building.HATCHERY;
                                break;
                            }
                            default: {
                                break block30;
                            }
                        }
                        v0 = this.params.replay.gameEvents;
                        v0.getClass();
                        var15_23 = v0.new GameEvents.BuildAction(var13_15);
                        var15_23.player = (byte)var12_12;
                        var16_27 = new Rectangle(var15_23.building.width * var5_5, var15_23.building.height * var5_5);
                        var16_27.x = this.params.scaleMapCoord(var11_14.startLocation.x) - (var16_27.width >> 1);
                        var16_27.y = var7_7 - this.params.scaleMapCoord(var11_14.startLocation.y) - (var16_27.height >> 1);
                        var8_9.add(new Pair<GameEvents.BuildAction, Object>(var15_23, var16_27));
                    }
                }
            }
            --var12_12;
        }
        var12_13 = new GameEvents.Action[this.params.playerChartIndices.length];
        var13_16 = this.params.hideOverlappedBuildings;
        var14_18 = 0;
        if (true) ** GOTO lbl102
        do {
            if (this.params.playerChartIndices[var9_8.player] >= 0) {
                if (var9_8 instanceof GameEvents.MoveScreenAction) {
                    var12_13[var9_8.player] = var9_8;
                } else if (var9_8 instanceof GameEvents.BuildAction && (var15_24 = (GameEvents.BuildAction)var9_8).hasTargetPoint()) {
                    var16_27 = new Rectangle(var15_24.building.width * var5_5, var15_24.building.height * var5_5);
                    var16_27.x = this.params.scaleMapCoord(var15_24.targetP1) - (var16_27.width >> 1);
                    var16_27.y = var7_7 - this.params.scaleMapCoord(var15_24.targetP2) - (var16_27.height >> 1);
                    if (var13_16) {
                        var17_28 = var8_9.size() - 1;
                        while (var17_28 >= 0) {
                            if (var16_27.intersects((Rectangle)((Pair)var8_9.get((int)var17_28)).value2)) {
                                var8_9.remove(var17_28);
                            }
                            --var17_28;
                        }
                    }
                    var8_9.add(new Pair<GameEvents.BuildAction, Object>(var15_24, var16_27));
                }
            }
            ++var14_18;
lbl102:
            // 2 sources

            if (var14_18 >= var10_11) break;
            var9_8 = var3_3[var14_18];
        } while (var9_8.frame <= var2_2);
        var15_25 = var8_9.iterator();
        while (var15_25.hasNext()) {
            var14_20 = (Pair)var15_25.next();
            var16_27 = (GameEvents.BuildAction)var14_20.value1;
            this.g2.setColor(this.params.playerColors[var16_27.player]);
            this.g2.setColor(this.params.playerColors[this.params.chartPlayerIndices[this.params.playerChartIndices[var16_27.player]]]);
            var17_30 = (Rectangle)var14_20.value2;
            if (this.params.fillBuildingIcons) {
                this.g2.fillRect(var17_30.x, var17_30.y, var17_30.width, var17_30.height);
            } else {
                var18_32 = Icons.getBuildingIcon(var16_27.building, IconHandler.Size.BIG);
                if (var18_32 instanceof ImageIcon) {
                    var19_34 /* !! */  = ((ImageIcon)var18_32).getImage();
                    this.g2.drawImage((Image)var19_34 /* !! */ , var17_30.x, var17_30.y, var17_30.width, var17_30.height, null);
                    this.g2.drawRect(var17_30.x, var17_30.y, var17_30.width, var17_30.height);
                }
            }
            var4_4.add(new Pair<Rectangle, String>(var17_30, String.valueOf(var16_27.building.toString()) + " (" + this.params.replay.details.players[var16_27.player].name + ')'));
        }
        var14_21 = 25 * var5_5;
        var15_26 = 15 * var5_5;
        this.g2.setStroke(ChartPainter.STROKE_DOUBLE_WIDTH);
        var19_34 /* !! */  = var12_13;
        var18_33 = var12_13.length;
        var17_31 = 0;
        while (var17_31 < var18_33) {
            var16_27 = var19_34 /* !! */ [var17_31];
            if (var16_27 != null) {
                this.g2.setColor(this.params.playerColors[var16_27.player]);
                var20_35 = (GameEvents.MoveScreenAction)var16_27;
                this.g2.drawRect(this.params.scaleMapCoord(var20_35.x) - (var14_21 >> 1), var7_7 - this.params.scaleMapCoord(var20_35.y) - (var15_26 >> 1), var14_21, var15_26);
            }
            ++var17_31;
        }
        this.g2.setStroke(ChartPainter.STROKE_DEFAULT);
        if (this.params.selectedAction instanceof GameEvents.BaseUseAbilityAction && (var16_27 = (GameEvents.BaseUseAbilityAction)this.params.selectedAction).hasTargetPoint()) {
            var17_31 = this.params.scaleMapCoord(var16_27.targetP1);
            var18_33 = var7_7 - this.params.scaleMapCoord(var16_27.targetP2);
            this.g2.setColor(Color.RED);
            this.g2.drawLine(var17_31, var18_33 - var5_5, var17_31, var18_33 + var5_5);
            this.g2.drawLine(var17_31 - var5_5, var18_33, var17_31 + var5_5, var18_33);
            this.g2.setColor(Color.WHITE);
            this.g2.drawRect(var17_31 - var5_5, var18_33 - var5_5, var5_5 * 2, var5_5 * 2);
        }
        this.params.toolTipProvider = new ChartParams.ToolTipProvider(var4_4){

            @Override
            public String getToolTip(Point point) {
                String string = super.getToolTip(point);
                if (string != null) {
                    return string;
                }
                if (point.x < var6_6 && point.y < var7_7) {
                    return "x=" + ReplayUtils.formatCoordinate((int)((float)point.x * 65536.0f * (float)var1_1.width / (float)var6_6)) + ", y=" + ReplayUtils.formatCoordinate((int)((float)(var7_7 - point.y) * 65536.0f * (float)var1_1.height / (float)var7_7));
                }
                return null;
            }
        };
    }

    private void paintPlayerDescriptions() {
        Font font = this.g2.getFont();
        this.g2.setFont(new Font(font.getName(), 1, font.getSize()));
        int n = this.g2.getFontMetrics().getAscent();
        int n2 = 0;
        while (n2 < this.descriptionBuilders.length) {
            int n3 = this.params.chartPlayerIndices[n2];
            this.g2.setColor(this.params.playerColors[n3]);
            this.g2.drawString(this.descriptionBuilders[n2].toString(), 26 + this.params.visibleRectangle.x, this.params.chartY1s[n2] - 1 + (this.params.allPlayersOnOneChart ? n2 * n + n2 : 0));
            ++n2;
        }
        this.g2.setFont(font);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$ActionType() {
        if ($SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$ActionType != null) {
            return $SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$ActionType;
        }
        int[] nArray = new int[ReplayConsts.ActionType.values().length];
        try {
            nArray[ReplayConsts.ActionType.BUILD.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.INACTION.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.OTHER.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.RESEARCH.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.SELECT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.TRAIN.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.ActionType.UPGRADE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$ActionType = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$Race() {
        if ($SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$Race != null) {
            return $SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$Race;
        }
        int[] nArray = new int[ReplayConsts.Race.values().length];
        try {
            nArray[ReplayConsts.Race.ANY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.PROTOSS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.RANDOM.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.TERRAN.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.UNKNOWN.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReplayConsts.Race.ZERG.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$hu$belicza$andras$sc2gears$replay$ReplayConsts$Race = nArray;
        return nArray;
    }

    private class ChartStat {
        final Map<ReplayConsts.Unit, IntHolder> unitCountMap;
        final Map<ReplayConsts.Building, IntHolder> buildingCountMap;
        final Map<ReplayConsts.Research, IntHolder> researchCountMap;
        final Map<ReplayConsts.Upgrade, IntHolder> upgradeCountMap;
        final Map<ReplayConsts.AbilityGroup, IntHolder> abilityGroupCountMap;
        final List<ReplayConsts.Unit> unitList;
        final List<ReplayConsts.Building> buildingList;
        final List<ReplayConsts.Research> researchList;
        final List<ReplayConsts.Upgrade> upgradeList;
        final List<ReplayConsts.AbilityGroup> abilityGroupList;

        private ChartStat() {
            this.unitCountMap = ChartPainter.this.params.showUnitsStat ? new EnumMap(ReplayConsts.Unit.class) : null;
            this.buildingCountMap = ChartPainter.this.params.showBuildingsStat ? new EnumMap(ReplayConsts.Building.class) : null;
            this.researchCountMap = ChartPainter.this.params.showResearchesStat ? new EnumMap(ReplayConsts.Research.class) : null;
            this.upgradeCountMap = ChartPainter.this.params.showUpgradesStat ? new EnumMap(ReplayConsts.Upgrade.class) : null;
            this.abilityGroupCountMap = ChartPainter.this.params.showAbilityGroupsStat ? new EnumMap(ReplayConsts.AbilityGroup.class) : null;
            this.unitList = new ArrayList<ReplayConsts.Unit>();
            this.buildingList = new ArrayList<ReplayConsts.Building>();
            this.researchList = new ArrayList<ReplayConsts.Research>();
            this.upgradeList = new ArrayList<ReplayConsts.Upgrade>();
            this.abilityGroupList = new ArrayList<ReplayConsts.AbilityGroup>();
        }
    }
}

