/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.multirepanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Details;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.NormalThread;
import hu.belicza.andras.sc2gears.ui.charts.ChartUtils;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.BuildOrderStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartData;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartPainter;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartParams;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.DateRangeStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.MapStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlayerGameParticipationStats;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlayerStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.Record;
import hu.belicza.andras.sc2gears.util.NullAwareComparable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class MultiRepAnalysis
extends ModuleFrame {
    private static final Set<ReplayParser.ReplayContent> CONTENT_FOR_ANALYSIS = EnumSet.of(ReplayParser.ReplayContent.INIT_DATA, ReplayParser.ReplayContent.DETAILS, ReplayParser.ReplayContent.ATTRIBUTES_EVENTS, ReplayParser.ReplayContent.GAME_EVENTS);
    private static final int SECONDS_LIMIT_FOR_ANALYSIS = 120;
    private static final String[] PLAYERS_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.players.header.playerName", "module.multiRepAnal.tab.players.header.replays", "module.multiRepAnal.tab.players.header.avgApm", "module.multiRepAnal.tab.players.header.record", "module.multiRepAnal.tab.players.header.winRatio", "module.multiRepAnal.tab.players.header.raceDistribution", "module.multiRepAnal.tab.players.header.totalTimeInGames", "module.multiRepAnal.tab.players.header.avgGameLength", "module.multiRepAnal.tab.players.header.presence", "module.multiRepAnal.tab.players.header.avgGamesPerDay", "module.multiRepAnal.tab.players.header.firstGame", "module.multiRepAnal.tab.players.header.lastGame"};
    private static final String[] MAPS_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.maps.header.mapName", "module.multiRepAnal.tab.maps.header.replays", "module.multiRepAnal.tab.maps.header.replaysRatio", "module.multiRepAnal.tab.maps.header.1v1PWinRatio", "module.multiRepAnal.tab.maps.header.1v1TWinRatio", "module.multiRepAnal.tab.maps.header.1v1ZWinRatio", "module.multiRepAnal.tab.maps.header.1v1RWinRatio", "module.multiRepAnal.tab.maps.header.firstPlayed", "module.multiRepAnal.tab.maps.header.lastPlayed"};
    private static final String[] BUILD_ORDERS_1V1_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.1v1BuildOrders.header.race", "module.multiRepAnal.tab.1v1BuildOrders.header.buildOrder", "module.multiRepAnal.tab.1v1BuildOrders.header.occurrences", "module.multiRepAnal.tab.1v1BuildOrders.header.record", "module.multiRepAnal.tab.1v1BuildOrders.header.winRatio", "module.multiRepAnal.tab.1v1BuildOrders.header.firstUsed", "module.multiRepAnal.tab.1v1BuildOrders.header.lastUsed"};
    private static final String[] PLAYERS_HEADER_NAMES = new String[PLAYERS_HEADER_KEYS.length];
    private static final String[] MAPS_HEADER_NAMES = new String[MAPS_HEADER_KEYS.length];
    private static final String[] BUILD_ORDERS_1V1_HEADER_NAMES = new String[BUILD_ORDERS_1V1_HEADER_KEYS.length];
    private static final String[] FORMAT_RECORDS_HEADER_NAMES;
    private static final String[] RECORDS_1V1_HEADER_NAMES;
    private static final AtomicInteger counter;
    private final File[] files;
    private final JCheckBox stretchToWindowCheckBox = GuiUtils.createCheckBox("module.multiRepAnal.stretchToWindow", "module.multiRepAnal.stretchToWindow");
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private int replaysIncludedInAnalysis;
    private final Map<String, PlayerStatistics> playerStatisticsMap = new HashMap<String, PlayerStatistics>();
    private final Map<String, MapStatistics> mapStatisticsMap = new HashMap<String, MapStatistics>();
    private final Map<String, BuildOrderStatistics> buildOrder1v1StatisticsMap = new HashMap<String, BuildOrderStatistics>();

    static {
        int n = 0;
        while (n < PLAYERS_HEADER_KEYS.length) {
            MultiRepAnalysis.PLAYERS_HEADER_NAMES[n] = Language.getText(PLAYERS_HEADER_KEYS[n]);
            ++n;
        }
        n = 0;
        while (n < MAPS_HEADER_KEYS.length) {
            MultiRepAnalysis.MAPS_HEADER_NAMES[n] = Language.getText(MAPS_HEADER_KEYS[n]);
            ++n;
        }
        n = 0;
        while (n < BUILD_ORDERS_1V1_HEADER_KEYS.length) {
            MultiRepAnalysis.BUILD_ORDERS_1V1_HEADER_NAMES[n] = Language.getText(BUILD_ORDERS_1V1_HEADER_KEYS[n]);
            ++n;
        }
        FORMAT_RECORDS_HEADER_NAMES = (String[])PLAYERS_HEADER_NAMES.clone();
        MultiRepAnalysis.FORMAT_RECORDS_HEADER_NAMES[0] = Language.getText("module.multiRepAnal.tab.player.tab.formatRecords.header.format");
        RECORDS_1V1_HEADER_NAMES = (String[])PLAYERS_HEADER_NAMES.clone();
        MultiRepAnalysis.RECORDS_1V1_HEADER_NAMES[0] = Language.getText("module.multiRepAnal.tab.player.tab.1v1MatchupRecords.header.matchup");
        counter = new AtomicInteger();
    }

    /*
     * Enabled aggressive block sorting
     */
    public MultiRepAnalysis(Object ... objectArray) {
        super(objectArray == null || objectArray.length < 1 ? Language.getText("module.multiRepAnal.opening") : null);
        this.setFrameIcon(Icons.CHART_UP_COLOR);
        if (objectArray == null || objectArray.length < 1) {
            String string = Settings.getString("settings.folders.defaultReplay");
            JFileChooser jFileChooser = new JFileChooser(string == null ? Settings.getString("settings.folders.sc2AutoReplay") : string);
            jFileChooser.setDialogTitle(Language.getText("module.multiRepAnal.openTitle"));
            jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
            jFileChooser.setAccessory(GuiUtils.createReplayFilePreviewAccessory(jFileChooser));
            jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setMultiSelectionEnabled(true);
            if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) != 0) {
                this.dispose();
                this.files = null;
                return;
            }
            this.files = jFileChooser.getSelectedFiles();
        } else {
            this.files = (File[])objectArray[0];
        }
        this.setTitle(Language.getText("module.multiRepAnal.title", counter.incrementAndGet()));
        this.buildGUI();
    }

    private void buildGUI() {
        Box box = Box.createVerticalBox();
        final Box box2 = Box.createHorizontalBox();
        final JButton jButton = new JButton(Icons.CROSS_OCTAGON);
        GuiUtils.updateButtonText(jButton, "module.multiRepAnal.abortAnalysisButton", new Object[0]);
        box2.add(jButton);
        box2.add(this.stretchToWindowCheckBox);
        box.add(box2);
        final JProgressBar jProgressBar = new JProgressBar();
        box.add(jProgressBar);
        this.getContentPane().add((Component)box, "North");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        final NormalThread normalThread = new NormalThread("Replay search"){
            private volatile boolean aborted;
            private int replaysCount;
            private int analyzedCount;
            private int skippedCount;

            @Override
            public void run() {
                File file;
                InternalFrameAdapter internalFrameAdapter = new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                        jButton.doClick();
                    }
                };
                MultiRepAnalysis.this.addInternalFrameListener(internalFrameAdapter);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        box2.remove(jButton);
                        MultiRepAnalysis.this.getContentPane().validate();
                        aborted = true;
                    }
                });
                jProgressBar.setStringPainted(true);
                jProgressBar.setString(Language.getText("module.multiRepAnal.countingReplays"));
                File[] fileArray = MultiRepAnalysis.this.files;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    file = fileArray[n2];
                    if (this.aborted) break;
                    this.replaysCount += this.countReplays(file);
                    ++n2;
                }
                if (this.aborted) {
                    jProgressBar.setString(String.valueOf(Language.getText("module.multiRepAnal.analysisAborted")) + " [" + jProgressBar.getString() + "]");
                } else {
                    jProgressBar.setMaximum(this.replaysCount);
                    this.updateProgressBar();
                    fileArray = MultiRepAnalysis.this.files;
                    n = fileArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        file = fileArray[n2];
                        if (this.aborted) break;
                        this.analyzeReplays(file);
                        ++n2;
                    }
                    if (this.aborted) {
                        jProgressBar.setString(String.valueOf(Language.getText("module.multiRepAnal.analysisAborted")) + " [" + jProgressBar.getString() + "]");
                    } else {
                        box2.remove(jButton);
                        MultiRepAnalysis.this.getContentPane().validate();
                    }
                    MultiRepAnalysis.this.replaysIncludedInAnalysis = this.analyzedCount - this.skippedCount;
                    GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.players.title"), Icons.USERS, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.createPlayersTab(), null);
                    GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.maps.title"), Icons.MAPS_STACK, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.createMapsTab(), null);
                    GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.1v1BuildOrders.title"), Icons.BLOCK, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.create1v1BuildOrdersTab(), null);
                }
                MultiRepAnalysis.this.removeInternalFrameListener(internalFrameAdapter);
            }

            private int countReplays(File file) {
                if (file.isFile()) {
                    return GuiUtils.SC2_REPLAY_FILTER.accept(file) ? 1 : 0;
                }
                File[] fileArray = file.listFiles();
                int n = 0;
                if (fileArray != null) {
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File file2 = fileArray2[n3];
                        if (this.aborted) {
                            return 0;
                        }
                        n += this.countReplays(file2);
                        ++n3;
                    }
                }
                return n;
            }

            private void analyzeReplays(File file) {
                if (file.isFile()) {
                    if (GuiUtils.SC2_REPLAY_FILTER.accept(file)) {
                        ++this.analyzedCount;
                        Replay replay = ReplayParser.parseReplay(file.getAbsolutePath(), CONTENT_FOR_ANALYSIS);
                        if (replay != null && replay.gameLength >= 240) {
                            int n;
                            Object object;
                            Date date = new Date(file.lastModified());
                            Details.Player[] playerArray = replay.details.players;
                            ReplayConsts.Format format = replay.initData.format;
                            ReplayConsts.Race race = null;
                            ReplayConsts.Race race2 = null;
                            PlayerGameParticipationStats[] playerGameParticipationStatsArray = new PlayerGameParticipationStats[playerArray.length];
                            int n2 = -1;
                            Object[] objectArray = playerArray;
                            int n3 = playerArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                object = objectArray[n4];
                                ++n2;
                                n = ((Details.Player)object).lastActionFrame >> 6;
                                if (n >= 120) {
                                    PlayerStatistics playerStatistics = (PlayerStatistics)MultiRepAnalysis.this.playerStatisticsMap.get(((Details.Player)object).fullName);
                                    if (playerStatistics == null) {
                                        playerStatistics = new PlayerStatistics(((Details.Player)object).fullName);
                                        MultiRepAnalysis.this.playerStatisticsMap.put(((Details.Player)object).fullName, playerStatistics);
                                    }
                                    playerGameParticipationStatsArray[n2] = new PlayerGameParticipationStats(date, format, n, ((Details.Player)object).actionsCount, ((Details.Player)object).isWinner, ((Details.Player)object).race, playerArray.length > 1 ? playerArray[playerArray[0] == object ? 1 : 0].race : null, replay.details.mapName);
                                    playerStatistics.buildInPlayerGameParticipation(playerGameParticipationStatsArray[n2]);
                                    if (format == ReplayConsts.Format.ONE_VS_ONE && ((Details.Player)object).isWinner != null) {
                                        if (((Details.Player)object).isWinner.booleanValue()) {
                                            race = ((Details.Player)object).race;
                                        } else {
                                            race2 = ((Details.Player)object).race;
                                        }
                                    }
                                    playerStatistics.playerGameParticipationStatsList.add(playerGameParticipationStatsArray[n2]);
                                }
                                ++n4;
                            }
                            object = (MapStatistics)MultiRepAnalysis.this.mapStatisticsMap.get(replay.details.mapName);
                            if (object == null) {
                                object = new MapStatistics(replay.details.mapName);
                                MultiRepAnalysis.this.mapStatisticsMap.put(replay.details.mapName, object);
                            }
                            ++((MapStatistics)object).gamesCount;
                            ((DateRangeStatistics)object).registerDate(date);
                            if (race != null) {
                                Record record = ((MapStatistics)object).getRaceRecord(race);
                                ++record.totalGames;
                                ++record.wins;
                            }
                            if (race2 != null) {
                                Record record = ((MapStatistics)object).getRaceRecord(race2);
                                ++record.totalGames;
                                ++record.losses;
                            }
                            if (replay.initData.format == ReplayConsts.Format.ONE_VS_ONE) {
                                int n5 = 6;
                                ReplayConsts.Building[][] buildingArray = new ReplayConsts.Building[playerArray.length][6];
                                objectArray = new int[playerArray.length];
                                n = 0;
                                int n6 = 0;
                                while (n6 < playerGameParticipationStatsArray.length) {
                                    if (playerGameParticipationStatsArray[n6] == null) {
                                        objectArray[n6] = (Details.Player)6;
                                        ++n;
                                    }
                                    ++n6;
                                }
                                GameEvents.Action[] actionArray = replay.gameEvents.actions;
                                int n7 = actionArray.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    GameEvents.Action action = actionArray[n8];
                                    if (action instanceof GameEvents.BuildAction && objectArray[action.player] < 6) {
                                        buildingArray[action.player][objectArray[action.player]] = ((GameEvents.BuildAction)action).building;
                                        byte by = action.player;
                                        objectArray[by] = objectArray[by] + true;
                                        if (objectArray[by] == 6 && ++n == objectArray.length) break;
                                    }
                                    ++n8;
                                }
                                n8 = buildingArray.length - 1;
                                while (n8 >= 0) {
                                    if (playerGameParticipationStatsArray[n8] != null) {
                                        ReplayConsts.Building[] buildingArray2 = buildingArray[n8];
                                        Details.Player player = objectArray[n8];
                                        if (player != false) {
                                            String string;
                                            StringBuilder stringBuilder = new StringBuilder();
                                            int n9 = 0;
                                            while (n9 < player) {
                                                if (stringBuilder.length() > 0) {
                                                    stringBuilder.append(", ");
                                                }
                                                stringBuilder.append(buildingArray2[n9].toString());
                                                ++n9;
                                            }
                                            playerGameParticipationStatsArray[n8].buildOrder = string = stringBuilder.toString();
                                            playerGameParticipationStatsArray[n8].raceFromBuildOrder = buildingArray2[0].raceOfBuilding();
                                            BuildOrderStatistics buildOrderStatistics = (BuildOrderStatistics)MultiRepAnalysis.this.buildOrder1v1StatisticsMap.get(string);
                                            if (buildOrderStatistics == null) {
                                                buildOrderStatistics = new BuildOrderStatistics(string, playerGameParticipationStatsArray[n8].raceFromBuildOrder);
                                                MultiRepAnalysis.this.buildOrder1v1StatisticsMap.put(string, buildOrderStatistics);
                                            }
                                            buildOrderStatistics.buildInPlayerGameParticipation(playerGameParticipationStatsArray[n8]);
                                        }
                                    }
                                    --n8;
                                }
                            }
                        } else {
                            ++this.skippedCount;
                        }
                        this.updateProgressBar();
                    }
                } else {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        File[] fileArray2 = fileArray;
                        int n = fileArray.length;
                        int n10 = 0;
                        while (n10 < n) {
                            File file2 = fileArray2[n10];
                            if (this.aborted) {
                                return;
                            }
                            this.analyzeReplays(file2);
                            ++n10;
                        }
                    }
                }
            }

            private void updateProgressBar() {
                jProgressBar.setValue(this.analyzedCount);
                jProgressBar.setString(Language.getText("module.multiRepAnal.analysisStatus", this.analyzedCount, this.skippedCount, this.replaysCount, this.replaysCount == 0 ? 100 : 100 * this.analyzedCount / this.replaysCount));
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                normalThread.start();
            }
        });
    }

    private JComponent createPlayersTab() {
        Object[][] objectArray = new Object[this.playerStatisticsMap.size()][];
        int n = 0;
        for (PlayerStatistics object2 : this.playerStatisticsMap.values()) {
            objectArray[n++] = new Object[]{object2.fullName, object2.record.totalGames, object2.getAvgApm(), object2.record, object2.record.getWinRatio(), object2.getRaceDistributionString(), object2.getFormattedTotalTimeInGames(), ReplayUtils.formatMs(object2.getAvgGameLength() * 1000), object2.getPresence(), Float.valueOf(object2.getAvgGamesPerDay()), Language.formatDate(object2.firstDate), Language.formatDate(object2.lastDate)};
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                if (mouseEvent.getButton() == 1 && jTable.getSelectedRow() >= 0 && mouseEvent.getClickCount() == 2) {
                    String string = (String)jTable.getValueAt(jTable.rowAtPoint(mouseEvent.getPoint()), GuiUtils.getColumnViewIndex(jTable, 0));
                    final JComponent[] jComponentArray = new JComponent[1];
                    GuiUtils.addNewTab(string, Icons.USER, true, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.createPlayerTab((PlayerStatistics)MultiRepAnalysis.this.playerStatisticsMap.get(string), jComponentArray), new Runnable(){

                        @Override
                        public void run() {
                            MultiRepAnalysis.this.tabbedPane.setSelectedIndex(0);
                        }
                    });
                    MultiRepAnalysis.this.tabbedPane.setSelectedIndex(MultiRepAnalysis.this.tabbedPane.getTabCount() - 1);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jComponentArray[0].requestFocusInWindow();
                        }
                    });
                }
            }
        };
        int[] nArray = new int[2];
        nArray[0] = 1;
        return this.createStatisticsTableTab("module.multiRepAnal.tab.players.info", new Object[]{this.playerStatisticsMap.size()}, 0, nArray, objectArray, PLAYERS_HEADER_NAMES, mouseAdapter);
    }

    private JComponent createMapsTab() {
        Object[][] objectArray = new Object[this.mapStatisticsMap.size()][];
        NullAwareComparable<Integer> nullAwareComparable = NullAwareComparable.getPercent(null);
        int n = 0;
        for (MapStatistics mapStatistics : this.mapStatisticsMap.values()) {
            Record record = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.PROTOSS);
            Record record2 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.TERRAN);
            Record record3 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.ZERG);
            Record record4 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.RANDOM);
            objectArray[n++] = new Object[]{mapStatistics.name, mapStatistics.gamesCount, NullAwareComparable.getPercent(mapStatistics.gamesCount * 100 / this.replaysIncludedInAnalysis), record == null ? nullAwareComparable : record.getWinRatio(), record2 == null ? nullAwareComparable : record2.getWinRatio(), record3 == null ? nullAwareComparable : record3.getWinRatio(), record4 == null ? nullAwareComparable : record4.getWinRatio(), Language.formatDate(mapStatistics.firstDate), Language.formatDate(mapStatistics.lastDate)};
        }
        int[] nArray = new int[2];
        nArray[0] = 1;
        return this.createStatisticsTableTab("module.multiRepAnal.tab.maps.info", new Object[]{this.mapStatisticsMap.size()}, 0, nArray, objectArray, MAPS_HEADER_NAMES, null);
    }

    private JComponent create1v1BuildOrdersTab() {
        Object[][] objectArray = new Object[this.buildOrder1v1StatisticsMap.size()][];
        int n = 0;
        for (BuildOrderStatistics buildOrderStatistics : this.buildOrder1v1StatisticsMap.values()) {
            objectArray[n++] = new Object[]{buildOrderStatistics.race, buildOrderStatistics.buildOrder, buildOrderStatistics.record.totalGames, buildOrderStatistics.record, buildOrderStatistics.record.getWinRatio(), Language.formatDate(buildOrderStatistics.firstDate), Language.formatDate(buildOrderStatistics.lastDate)};
        }
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[2] = 4;
        return this.createStatisticsTableTab("module.multiRepAnal.tab.1v1BuildOrders.info", new Object[]{this.buildOrder1v1StatisticsMap.size()}, 1, nArray, objectArray, BUILD_ORDERS_1V1_HEADER_NAMES, null);
    }

    private JComponent createPlayerTab(PlayerStatistics playerStatistics, JComponent[] jComponentArray) {
        Object n;
        Object n3;
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        EnumMap<ReplayConsts.Format, PlayerStatistics> enumMap = new EnumMap<ReplayConsts.Format, PlayerStatistics>(ReplayConsts.Format.class);
        HashMap<Integer, PlayerStatistics> hashMap = new HashMap<Integer, PlayerStatistics>();
        HashMap<String, MapStatistics> hashMap2 = new HashMap<String, MapStatistics>();
        HashMap<String, BuildOrderStatistics> hashMap3 = new HashMap<String, BuildOrderStatistics>();
        for (PlayerGameParticipationStats object42 : playerStatistics.playerGameParticipationStatsList) {
            int n2 = object42.format == ReplayConsts.Format.ONE_VS_ONE ? 2 : 0;
            while (n2 >= 0) {
                if (n2 == 0) {
                    object = (PlayerStatistics)enumMap.get((Object)object42.format);
                    if (object == null) {
                        object = new PlayerStatistics(null);
                        enumMap.put(object42.format, (PlayerStatistics)object);
                    }
                } else {
                    n3 = object42.race.ordinal() << 8 | (n2 == 1 ? object42.opponent1v1Race : ReplayConsts.Race.ANY).ordinal();
                    object = (PlayerStatistics)hashMap.get(n3);
                    if (object == null) {
                        object = new PlayerStatistics(null);
                        hashMap.put((Integer)n3, (PlayerStatistics)object);
                    }
                }
                object.buildInPlayerGameParticipation(object42);
                --n2;
            }
            n = (MapStatistics)hashMap2.get(object42.mapName);
            if (n == null) {
                n = new MapStatistics(object42.mapName);
                hashMap2.put(object42.mapName, (MapStatistics)n);
            }
            ++((MapStatistics)n).gamesCount;
            ((DateRangeStatistics)n).registerDate(object42.date);
            if (object42.format == ReplayConsts.Format.ONE_VS_ONE && object42.isWinner != null) {
                object = ((MapStatistics)n).getRaceRecord(object42.race);
                ++object.totalGames;
                if (object42.isWinner.booleanValue()) {
                    ++object.wins;
                } else {
                    ++object.losses;
                }
            }
            if (object42.format != ReplayConsts.Format.ONE_VS_ONE) continue;
            object = (BuildOrderStatistics)hashMap3.get(object42.buildOrder);
            if (object == null) {
                object = new BuildOrderStatistics(object42.buildOrder, object42.raceFromBuildOrder);
                hashMap3.put(object42.buildOrder, (BuildOrderStatistics)object);
            }
            object.buildInPlayerGameParticipation(object42);
        }
        JLabel jLabel = new JLabel(Language.getText("module.multiRepAnal.tab.player.info", playerStatistics.fullName, playerStatistics.record.totalGames));
        GuiUtils.changeFontToBold(jLabel);
        jPanel.add((Component)jLabel, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jComponentArray[0] = n = new JPanel(new BorderLayout());
        Collections.sort(playerStatistics.playerGameParticipationStatsList);
        object = new JComponent[1];
        n3 = new ActionListener((JComponent[])object){
            private final /* synthetic */ JComponent[] val$chartCanvasHolder;
            {
                this.val$chartCanvasHolder = jComponentArray;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$chartCanvasHolder[0].repaint();
            }
        };
        Box n4 = Box.createHorizontalBox();
        n4.add(new JPanel(new BorderLayout()));
        n4.add(new JLabel(Language.getText("charts.chartType")));
        final JComboBox jComboBox = GuiUtils.createComboBox((Object[])ChartType.values(), "module.multiRepAnal.charts.chartType");
        jComboBox.setToolTipText(Language.getText("charts.chartTypeToolTip"));
        jComboBox.addActionListener((ActionListener)n3);
        n4.add(jComboBox);
        n4.add(Box.createHorizontalStrut(5));
        n4.add(new JLabel(Language.getText("module.multiRepAnal.tab.player.tab.charts.granularity")));
        Iterator iterator = GuiUtils.createComboBox((Object[])ChartGranularity.values(), "module.multiRepAnal.charts.chartGranularity");
        Object object2 = new ChartData[1];
        Object object3 = new ActionListener((JComboBox)((Object)iterator), (ChartData[])object2, playerStatistics){
            private final /* synthetic */ JComboBox val$chartGranularityComboBox;
            private final /* synthetic */ ChartData[] val$chartDataHolder;
            private final /* synthetic */ PlayerStatistics val$ps;
            {
                this.val$chartGranularityComboBox = jComboBox;
                this.val$chartDataHolder = chartDataArray;
                this.val$ps = playerStatistics;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChartGranularity chartGranularity = (ChartGranularity)((Object)this.val$chartGranularityComboBox.getSelectedItem());
                if (this.val$chartDataHolder[0] == null || this.val$chartDataHolder[0].chartGranularity != chartGranularity) {
                    this.val$chartDataHolder[0] = new ChartData(this.val$ps, chartGranularity);
                }
            }
        };
        ((JComboBox)((Object)iterator)).addActionListener((ActionListener)object3);
        ((JComboBox)((Object)iterator)).addActionListener((ActionListener)n3);
        n4.add((Component)((Object)iterator));
        n4.add(Box.createHorizontalStrut(5));
        n4.add(new JLabel(Language.getText("charts.graphApproximation")));
        Object object4 = GuiUtils.createComboBox((Object[])ChartUtils.GraphApproximation.values(), "module.multiRepAnal.charts.graphApproximation");
        ((JComboBox)object4).addActionListener((ActionListener)n3);
        n4.add((Component)object4);
        object3.actionPerformed(null);
        n4.add(new JPanel(new BorderLayout()));
        ((Container)n).add((Component)n4, "North");
        object[0] = new JComponent((JComponent[])object, playerStatistics, (ChartData[])object2, jComboBox, (JComboBox)((Object)iterator), (JComboBox)object4){
            private final /* synthetic */ JComponent[] val$chartCanvasHolder;
            private final /* synthetic */ PlayerStatistics val$ps;
            private final /* synthetic */ ChartData[] val$chartDataHolder;
            private final /* synthetic */ JComboBox val$chartTypeComboBox;
            private final /* synthetic */ JComboBox val$chartGranularityComboBox;
            private final /* synthetic */ JComboBox val$graphApproximationComboBox;
            {
                this.val$chartCanvasHolder = jComponentArray;
                this.val$ps = playerStatistics;
                this.val$chartDataHolder = chartDataArray;
                this.val$chartTypeComboBox = jComboBox;
                this.val$chartGranularityComboBox = jComboBox2;
                this.val$graphApproximationComboBox = jComboBox3;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                ChartParams chartParams = new ChartParams();
                chartParams.chartCanvas = this.val$chartCanvasHolder[0];
                chartParams.g2 = (Graphics2D)graphics;
                chartParams.playerStatistics = this.val$ps;
                chartParams.segmentStats = this.val$chartDataHolder[0].segmentStats;
                chartParams.chartType = (ChartType)((Object)this.val$chartTypeComboBox.getSelectedItem());
                chartParams.chartGranularity = (ChartGranularity)((Object)this.val$chartGranularityComboBox.getSelectedItem());
                chartParams.graphApproximation = (ChartUtils.GraphApproximation)((Object)this.val$graphApproximationComboBox.getSelectedItem());
                chartParams.width = this.getWidth();
                chartParams.height = this.getHeight();
                new ChartPainter(chartParams).paintChart();
            }
        };
        Object object5 = object[0];
        ((Container)n).add((Component)object5);
        Object object6 = new Object();
        ChartType[] chartTypeArray = ChartType.values();
        int n5 = chartTypeArray.length;
        int n6 = 0;
        while (n6 < n5) {
            final ChartType chartType = chartTypeArray[n6];
            object6 = new Object();
            ((JComponent)n).getInputMap(1).put(chartType.keyStroke, object6);
            ((JComponent)n).getActionMap().put(object6, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jComboBox.setSelectedItem((Object)chartType);
                }
            });
            ++n6;
        }
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.charts.title"), Icons.CHART_UP_COLOR, false, jTabbedPane, (JComponent)n, false, null);
        n = new JPanel(new BorderLayout());
        object = new Object[enumMap.size()][];
        int nullAwareComparable = 0;
        for (Map.Entry entry : enumMap.entrySet()) {
            iterator = (PlayerStatistics)entry.getValue();
            object[nullAwareComparable++] = new Object[]{entry.getKey(), ((PlayerStatistics)((Object)iterator)).record.totalGames, ((PlayerStatistics)((Object)iterator)).getAvgApm(), ((PlayerStatistics)((Object)iterator)).record, ((PlayerStatistics)((Object)iterator)).record.getWinRatio(), ((PlayerStatistics)((Object)iterator)).getRaceDistributionString(), ((PlayerStatistics)((Object)iterator)).getFormattedTotalTimeInGames(), ReplayUtils.formatMs(((PlayerStatistics)((Object)iterator)).getAvgGameLength() * 1000), ((DateRangeStatistics)((Object)iterator)).getPresence(), Float.valueOf(((PlayerStatistics)((Object)iterator)).getAvgGamesPerDay()), Language.formatDate(((PlayerStatistics)((Object)iterator)).firstDate), Language.formatDate(((PlayerStatistics)((Object)iterator)).lastDate)};
        }
        int[] nArray = new int[2];
        nArray[0] = 1;
        ((Container)n).add(this.createStatisticsTableTab(null, null, 0, nArray, (Object[][])object, FORMAT_RECORDS_HEADER_NAMES, null));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.formatRecords.title"), null, false, jTabbedPane, (JComponent)n, false, null);
        n = new JPanel(new BorderLayout());
        object = new Object[hashMap.size()][];
        nullAwareComparable = 0;
        ReplayConsts.Race[] raceArray = ReplayConsts.Race.values();
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = String.valueOf(raceArray[((Integer)entry.getKey()).intValue() >> 8].letter) + "v" + raceArray[((Integer)entry.getKey()).intValue() & 0xFF].letter;
            object3 = (PlayerStatistics)entry.getValue();
            object[nullAwareComparable++] = new Object[]{object2, ((PlayerStatistics)object3).record.totalGames, ((PlayerStatistics)object3).getAvgApm(), ((PlayerStatistics)object3).record, ((PlayerStatistics)object3).record.getWinRatio(), ((PlayerStatistics)object3).getRaceDistributionString(), ((PlayerStatistics)object3).getFormattedTotalTimeInGames(), ReplayUtils.formatMs(((PlayerStatistics)object3).getAvgGameLength() * 1000), ((DateRangeStatistics)object3).getPresence(), Float.valueOf(((PlayerStatistics)object3).getAvgGamesPerDay()), Language.formatDate(((PlayerStatistics)object3).firstDate), Language.formatDate(((PlayerStatistics)object3).lastDate)};
        }
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        ((Container)n).add(this.createStatisticsTableTab(null, null, 0, nArray2, (Object[][])object, RECORDS_1V1_HEADER_NAMES, null));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.1v1MatchupRecords.title"), null, false, jTabbedPane, (JComponent)n, false, null);
        n = new JPanel(new BorderLayout());
        object = new Object[hashMap2.size()][];
        NullAwareComparable<Integer> n52 = NullAwareComparable.getPercent(null);
        boolean bl = false;
        for (MapStatistics mapStatistics : hashMap2.values()) {
            object2 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.PROTOSS);
            object3 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.TERRAN);
            object4 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.ZERG);
            object5 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.RANDOM);
            object[++var13_23] = new Object[]{mapStatistics.name, mapStatistics.gamesCount, NullAwareComparable.getPercent(mapStatistics.gamesCount * 100 / playerStatistics.playerGameParticipationStatsList.size()), object2 == null ? n52 : ((Record)object2).getWinRatio(), object3 == null ? n52 : ((Record)object3).getWinRatio(), object4 == null ? n52 : ((Record)object4).getWinRatio(), object5 == null ? n52 : ((Record)object5).getWinRatio(), Language.formatDate(mapStatistics.firstDate), Language.formatDate(mapStatistics.lastDate)};
        }
        int[] nArray3 = new int[2];
        nArray3[0] = 1;
        ((Container)n).add(this.createStatisticsTableTab(null, null, 0, nArray3, (Object[][])object, MAPS_HEADER_NAMES, null));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.maps.title"), Icons.MAPS_STACK, false, jTabbedPane, (JComponent)n, false, null);
        n = new JPanel(new BorderLayout());
        object = new Object[hashMap3.size()][];
        int n7 = 0;
        for (BuildOrderStatistics buildOrderStatistics : hashMap3.values()) {
            object[n7++] = new Object[]{buildOrderStatistics.race, buildOrderStatistics.buildOrder, buildOrderStatistics.record.totalGames, buildOrderStatistics.record, buildOrderStatistics.record.getWinRatio(), Language.formatDate(buildOrderStatistics.firstDate), Language.formatDate(buildOrderStatistics.lastDate)};
        }
        int[] nArray4 = new int[3];
        nArray4[0] = 2;
        nArray4[2] = 4;
        ((Container)n).add(this.createStatisticsTableTab(null, null, 1, nArray4, (Object[][])object, BUILD_ORDERS_1V1_HEADER_NAMES, null));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.1v1BuildOrders.title"), Icons.BLOCK, false, jTabbedPane, (JComponent)n, false, null);
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    private JComponent createStatisticsTableTab(String string, Object[] objectArray, final int n, int[] nArray, Object[][] objectArray2, String[] stringArray, MouseListener mouseListener) {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (string != null) {
            jPanel.add((Component)new JLabel(Language.getText(string, objectArray)), "North");
        }
        final JTable jTable = GuiUtils.createNonEditableTable();
        jPanel.add((Component)new JScrollPane(jTable), "Center");
        Box box = Box.createVerticalBox();
        box.add(jTable.getTableHeader());
        box.add(new JScrollPane(jTable));
        jPanel.add((Component)box, "Center");
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int n) {
                int n2 = this.getRowCount();
                if (n2 == 0) {
                    return super.getColumnClass(n);
                }
                if (n2 > 10) {
                    n2 = 10;
                }
                int n3 = 0;
                while (n3 < n2) {
                    Object object = this.getValueAt(n3, n);
                    if (object != null) {
                        return object.getClass();
                    }
                    ++n3;
                }
                return Object.class;
            }
        };
        defaultTableModel.setDataVector(objectArray2, stringArray);
        jTable.setModel(defaultTableModel);
        jTable.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>((TableModel)defaultTableModel, nArray){
            {
                super(tableModel);
                ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
                int[] nArray2 = nArray;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4;
                    arrayList.add(new RowSorter.SortKey(n4, (n4 = nArray2[n3]) == n5 ? SortOrder.ASCENDING : SortOrder.DESCENDING));
                    ++n3;
                }
                this.setSortKeys(arrayList);
                this.setMaxSortKeys(3);
            }

            @Override
            public void toggleSortOrder(int n2) {
                ArrayList<RowSorter.SortKey> arrayList;
                if (n2 != n && ((arrayList = new ArrayList<RowSorter.SortKey>(this.getSortKeys())).isEmpty() || ((RowSorter.SortKey)arrayList.get(0)).getColumn() != n2)) {
                    arrayList.add(0, new RowSorter.SortKey(n2, SortOrder.DESCENDING));
                    if (arrayList.size() > this.getMaxSortKeys()) {
                        arrayList.remove(this.getMaxSortKeys());
                    }
                    this.setSortKeys(arrayList);
                    return;
                }
                super.toggleSortOrder(n2);
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTable.setAutoResizeMode(MultiRepAnalysis.this.stretchToWindowCheckBox.isSelected() ? 4 : 0);
            }
        };
        actionListener.actionPerformed(null);
        this.stretchToWindowCheckBox.addActionListener(actionListener);
        if (mouseListener != null) {
            jTable.addMouseListener(mouseListener);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiUtils.packTable(jTable);
            }
        });
        return jPanel;
    }

    public static enum ChartGranularity {
        DAY("module.multiRepAnal.tab.player.tab.charts.granularity.day"),
        WEEK("module.multiRepAnal.tab.player.tab.charts.granularity.week"),
        MONTH("module.multiRepAnal.tab.player.tab.charts.granularity.month"),
        YEAR("module.multiRepAnal.tab.player.tab.charts.granularity.year");

        private final String stringValue;

        private ChartGranularity(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum ChartType {
        ACTIVITY("module.multiRepAnal.tab.player.tab.charts.chartType.activity", "module.multiRepAnal.tab.player.tab.charts.chartType.activity.yAxisLabel"),
        APM_DEVELOPMENT("module.multiRepAnal.tab.player.tab.charts.chartType.apmDevelopment", "module.multiRepAnal.tab.player.tab.charts.chartType.apmDevelopment.yAxisLabel"),
        RACE_DISTRIBUTION("module.multiRepAnal.tab.player.tab.charts.chartType.raceDistribution", "module.multiRepAnal.tab.player.tab.charts.chartType.raceDistribution.yAxisLabel"),
        WIN_RATIO_DEVELOPMENT("module.multiRepAnal.tab.player.tab.charts.chartType.winRatioDevelopment", "module.multiRepAnal.tab.player.tab.charts.chartType.winRatioDevelopment.yAxisLabel");

        private final String stringValue;
        public final String yAxisLabelKey;
        public final KeyStroke keyStroke;

        private ChartType(String string2, String string3) {
            this.stringValue = Language.getText(string2);
            this.yAxisLabelKey = string3;
            this.keyStroke = KeyStroke.getKeyStroke(49 + this.ordinal(), 2);
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

