/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.Sc2gears;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.logger.Log;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.CommonUtils;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.NormalThread;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.MultiRepAnalysis;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ReplayAnalyzer;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplaySearch;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MainFrame
extends JFrame {
    private static final int MAX_RECENT_REPLAYS = 15;
    public static MainFrame INSTANCE;
    private TrayIcon trayIcon;
    private final JSplitPane mainSplitPane = new JSplitPane(1, true);
    private final JMenu recentReplaysMenu = new JMenu();
    public final JMenuItem viewSystemMessagesMenuItem = new JMenuItem(Icons.REPORT_EXCLAMATION);
    private final JMenuItem checkUpdatesMenuItem = new JMenuItem(Icons.ARROW_CIRCLE_DOUBLE);
    private final JScrollPane navigationBar = new JScrollPane();
    private final JTree navigationTree = new JTree();
    private final DefaultMutableTreeNode repAnalNode = new DefaultMutableTreeNode(Language.getText("module.repAnalyzer.name"));
    private final DefaultMutableTreeNode newRepAnalNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode multiRepAnalNode = new DefaultMutableTreeNode(Language.getText("module.multiRepAnal.name"));
    private final DefaultMutableTreeNode newMultiRepAnalNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode repSearchNode = new DefaultMutableTreeNode(Language.getText("module.repSearch.name"));
    private final DefaultMutableTreeNode newRepSearchNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode repSourcesNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repSources.name"));
    public final DefaultMutableTreeNode emptyRepSourceNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.empty") + '>');
    private final DefaultMutableTreeNode repListsNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repLists.name"));
    public final DefaultMutableTreeNode emptyRepListNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.empty") + '>');
    private final JDesktopPane desktopPane = new JDesktopPane();
    private MenuItem hideTrayMenuItem;
    private MenuItem restoreTrayMenuItem;

    public MainFrame(String[] stringArray) {
        super("Sc2gears");
        if (INSTANCE != null) {
            throw new RuntimeException("Only one instance of MainFrame is allowed!");
        }
        INSTANCE = this;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.exit(false, new String[0]);
            }
        });
        this.setIconImage(Icons.SC2GEARS.getImage());
        this.installTrayIcon();
        this.buildGUI();
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        this.setBounds(rectangle.x + insets.left + 10, rectangle.y + insets.top + 10, rectangle.width - insets.left - insets.right - 20, rectangle.height - insets.top - insets.bottom - 20);
        this.setVisible(true);
        ToolTipManager.sharedInstance().setInitialDelay(200);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        double d = 0.24;
        if ((double)this.getWidth() * d > 250.0) {
            d = 250.0 / (double)this.getWidth();
        }
        this.mainSplitPane.setDividerLocation(Settings.getInt("navigation.position") == 0 ? d : 1.0 - d);
        if (Settings.getBoolean("settings.checkUpdatesOnStartup")) {
            this.checkUpdatesMenuItem.doClick();
        }
        if (stringArray.length > 0) {
            this.openArguments(stringArray);
        } else {
            Enum enum_;
            this.rebuildRecentReplaysMenu();
            Enum[] enumArray = ReplayConsts.Building.values();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                enum_ = enumArray[n2];
                Icons.getBuildingIcon((ReplayConsts.Building)enum_, IconHandler.Size.BIG);
                ++n2;
            }
            enumArray = ReplayConsts.Unit.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                enum_ = enumArray[n2];
                Icons.getUnitIcon((ReplayConsts.Unit)enum_, IconHandler.Size.BIG);
                ++n2;
            }
            enumArray = ReplayConsts.AbilityGroup.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                enum_ = enumArray[n2];
                Icons.getAbilityGroupIcon((ReplayConsts.AbilityGroup)enum_, IconHandler.Size.BIG);
                ++n2;
            }
        }
    }

    public void openArguments(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    File file = new File(string);
                    if (GuiUtils.SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file});
                    } else if (GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null});
                    } else {
                        MainFrame.this.openReplayFile(new File(string));
                    }
                    ++n2;
                }
            }
        });
    }

    private void installTrayIcon() {
        if (SystemTray.isSupported()) {
            TrayIcon trayIcon = new TrayIcon(Icons.SC2GEARS.getImage(), Language.getText("trayIcon.running", "Sc2gears"));
            trayIcon.setImageAutoSize(true);
            PopupMenu popupMenu = new PopupMenu();
            this.hideTrayMenuItem = new MenuItem(Language.getText("tray.hide"));
            this.hideTrayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.hideMainFrame();
                }
            });
            popupMenu.add(this.hideTrayMenuItem);
            this.restoreTrayMenuItem = new MenuItem(Language.getText("tray.restore"));
            this.restoreTrayMenuItem.setEnabled(false);
            this.restoreTrayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.restoreMainFrame();
                }
            });
            popupMenu.add(this.restoreTrayMenuItem);
            popupMenu.addSeparator();
            MenuItem menuItem = new MenuItem(Language.getText("tray.exit"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.exit(false, new String[0]);
                }
            });
            popupMenu.add(menuItem);
            trayIcon.setPopupMenu(popupMenu);
            trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.restoreMainFrame();
                }
            });
            try {
                SystemTray.getSystemTray().add(trayIcon);
                this.trayIcon = trayIcon;
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    private void buildGUI() {
        this.buildNavigationBar();
        this.mainSplitPane.setDividerSize(6);
        this.getContentPane().add(this.mainSplitPane);
        this.arrangeContent();
        this.buildMenuBar();
    }

    private void buildNavigationBar() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.repAnalNode.add(this.newRepAnalNode);
        defaultMutableTreeNode.add(this.repAnalNode);
        this.multiRepAnalNode.add(this.newMultiRepAnalNode);
        defaultMutableTreeNode.add(this.multiRepAnalNode);
        this.repSearchNode.add(this.newRepSearchNode);
        defaultMutableTreeNode.add(this.repSearchNode);
        defaultMutableTreeNode.add(this.repSourcesNode);
        defaultMutableTreeNode.add(this.repListsNode);
        this.refreshNavigationTree();
        ((DefaultTreeModel)this.navigationTree.getModel()).setRoot(defaultMutableTreeNode);
        this.navigationTree.setRootVisible(false);
        this.navigationTree.setShowsRootHandles(true);
        this.navigationTree.getSelectionModel().setSelectionMode(1);
        this.navigationTree.setCellRenderer(this.createTreeCellRenderer());
        if (Settings.getBoolean("navigation.useSmallFont")) {
            this.navigationTree.setFont(new Font(this.navigationTree.getFont().getName(), 0, 10));
        }
        this.expandAllNavigationRow();
        this.navigationTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 || mouseEvent.getClickCount() == 2) {
                    TreePath treePath = MainFrame.this.navigationTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode || defaultMutableTreeNode2 == MainFrame.this.repListsNode) {
                        if (defaultMutableTreeNode == MainFrame.this.emptyRepSourceNode) {
                            GuiUtils.showInfoDialog(Language.getText("navigationTree.info.newRepSource"));
                        } else if (defaultMutableTreeNode == MainFrame.this.emptyRepListNode) {
                            GuiUtils.showInfoDialog(Language.getText("navigationTree.info.newRepList"));
                        } else {
                            File file;
                            File file2 = file = defaultMutableTreeNode2 == MainFrame.this.repSourcesNode ? new File("User Content/Replay sources", String.valueOf(defaultMutableTreeNode.getUserObject().toString()) + ".sc2repsrc") : new File("User Content/Replay lists", String.valueOf(defaultMutableTreeNode.getUserObject().toString()) + ".csv");
                            if (mouseEvent.getButton() == 3) {
                                MainFrame.this.navigationTree.setSelectionPath(treePath);
                                JPopupMenu jPopupMenu = new JPopupMenu();
                                JMenuItem jMenuItem = new JMenuItem(Icons.CROSS);
                                GuiUtils.updateButtonText(jMenuItem, "navigationTree.popup.deleteItem", new Object[0]);
                                jMenuItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (file.delete()) {
                                            MainFrame.this.refreshNavigationTree();
                                        }
                                    }
                                });
                                jPopupMenu.add(jMenuItem);
                                jPopupMenu.show(MainFrame.this.navigationTree, mouseEvent.getX(), mouseEvent.getY());
                            } else if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null});
                            } else {
                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file});
                            }
                        }
                    } else if (mouseEvent.getClickCount() == 2) {
                        MainFrame.this.createNewInternalFrame(defaultMutableTreeNode, new Object[0]);
                    }
                }
            }
        });
        this.navigationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                if (defaultMutableTreeNode.getUserObject() instanceof JInternalFrame) {
                    JInternalFrame jInternalFrame = (JInternalFrame)defaultMutableTreeNode.getUserObject();
                    try {
                        if (jInternalFrame.isIcon()) {
                            jInternalFrame.setIcon(false);
                        }
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                }
            }
        });
        this.navigationBar.setViewportView(this.navigationTree);
        this.navigationBar.setVisible(Settings.getBoolean("navigation.showNavbar"));
    }

    private TreeCellRenderer createTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode != MainFrame.this.newRepAnalNode && defaultMutableTreeNode != MainFrame.this.newMultiRepAnalNode && defaultMutableTreeNode != MainFrame.this.newRepSearchNode && defaultMutableTreeNode != MainFrame.this.emptyRepSourceNode && defaultMutableTreeNode != MainFrame.this.emptyRepListNode) {
                    TreeNode treeNode = defaultMutableTreeNode.getParent();
                    if (treeNode == MainFrame.this.repAnalNode) {
                        this.setIcon(Icons.CHART);
                    } else if (treeNode == MainFrame.this.multiRepAnalNode) {
                        this.setIcon(Icons.CHART_UP_COLOR);
                    } else if (treeNode == MainFrame.this.repSearchNode) {
                        this.setIcon(Icons.BINOCULAR);
                    } else if (treeNode == MainFrame.this.repSourcesNode) {
                        this.setIcon(Icons.FOLDERS_STACK);
                    } else if (treeNode == MainFrame.this.repListsNode) {
                        this.setIcon(Icons.TABLE);
                    }
                }
                return this;
            }
        };
    }

    private void expandAllNavigationRow() {
        int n = 0;
        while (n < this.navigationTree.getRowCount()) {
            this.navigationTree.expandRow(n);
            ++n;
        }
    }

    public void refreshNavigationTree() {
        int n = 0;
        while (n < 2) {
            DefaultMutableTreeNode defaultMutableTreeNode = n == 0 ? this.repSourcesNode : this.repListsNode;
            String string = n == 0 ? "User Content/Replay sources" : "User Content/Replay lists";
            final String string2 = n == 0 ? ".sc2repsrc" : ".csv";
            defaultMutableTreeNode.removeAllChildren();
            String[] stringArray = new File(string).list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(string2);
                }
            });
            if (stringArray == null || stringArray.length == 0) {
                defaultMutableTreeNode.add(defaultMutableTreeNode == this.repSourcesNode ? this.emptyRepSourceNode : this.emptyRepListNode);
            } else {
                Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string3 = stringArray2[n3];
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(string3.substring(0, string3.lastIndexOf(46))));
                    ++n3;
                }
            }
            ((DefaultTreeModel)this.navigationTree.getModel()).reload(defaultMutableTreeNode);
            ++n;
        }
    }

    public void refreshRepAnalNavigationNode() {
        ((DefaultTreeModel)this.navigationTree.getModel()).reload(this.repAnalNode);
    }

    private void buildMenuBar() {
        Object object;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        GuiUtils.updateButtonText(jMenu, "menu.file", new Object[0]);
        JMenuItem jMenuItem = new JMenuItem(Icons.SC2);
        GuiUtils.updateButtonText(jMenuItem, "menu.file.openReplay", new Object[0]);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepAnalNode, new Object[0]);
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(Icons.SC2);
        GuiUtils.updateButtonText(jMenuItem2, "menu.file.openLastReplay", new Object[0]);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(Settings.getString("settings.folders.sc2AutoReplay"));
                File file2 = file.exists() ? file : new File(System.getProperty("user.home"), Settings.getString("settings.folders.sc2AutoReplay"));
                File[] fileArray = file2.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile() && GuiUtils.SC2_REPLAY_FILTER.accept(file);
                    }
                });
                if (fileArray == null || fileArray.length == 0) {
                    GuiUtils.showErrorDialog(new Object[]{Language.getText(fileArray == null ? "misc.autorepFolderNotExists" : "misc.autorepFolderEmpty"), file2.getAbsolutePath()});
                    return;
                }
                File file3 = fileArray[fileArray.length - 1];
                long l = file3.lastModified();
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file4 = fileArray2[n2];
                    if (file4.lastModified() > l) {
                        file3 = file4;
                        l = file4.lastModified();
                    }
                    ++n2;
                }
                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepAnalNode, new Object[]{file3});
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        GuiUtils.updateButtonText(this.recentReplaysMenu, "menu.file.recentReplays", new Object[0]);
        jMenu.add(this.recentReplaysMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem(Icons.DOOR_OPEN_IN);
        GuiUtils.updateButtonText(jMenuItem3, "menu.file.exit", new Object[0]);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(88, 512));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.exit(false, new String[0]);
            }
        });
        jMenu.add(jMenuItem3);
        jMenuBar.add(jMenu);
        jMenuItem = new JMenu();
        GuiUtils.updateButtonText(jMenuItem, "menu.navigation", new Object[0]);
        jMenuItem2 = new JMenuItem(Icons.TOGGLE_EXPAND);
        GuiUtils.updateButtonText(jMenuItem2, "menu.navigation.expandAll", new Object[0]);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.expandAllNavigationRow();
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenuItem3 = new JMenuItem(Icons.TOGGLE);
        GuiUtils.updateButtonText(jMenuItem3, "menu.navigation.collapseAll", new Object[0]);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < MainFrame.this.navigationTree.getRowCount()) {
                    MainFrame.this.navigationTree.collapseRow(n);
                    ++n;
                }
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem3);
        Serializable serializable = new JMenuItem(Icons.ARROW_CIRCLE_315);
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.navigation.refreshTree", new Object[0]);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.refreshNavigationTree();
            }
        });
        ((JMenu)jMenuItem).add((JMenuItem)serializable);
        ((JMenu)jMenuItem).addSeparator();
        Object object2 = GuiUtils.createCheckBoxMenuItem("menu.navigation.useSmallFont", "navigation.useSmallFont", Icons.APPLICATION_SIDEBAR_LIST);
        JMenu jMenu2 = new JMenu();
        final JCheckBoxMenuItem jCheckBoxMenuItem = GuiUtils.createCheckBoxMenuItem("menu.navigation.showNavbar", "navigation.showNavbar", Icons.APPLICATION_SIDEBAR);
        jCheckBoxMenuItem.addActionListener(new ActionListener((JCheckBoxMenuItem)object2, jMenu2){
            private int storedLeftComponentWidth = 170;
            private final /* synthetic */ JCheckBoxMenuItem val$useSmallFontMenuItem;
            private final /* synthetic */ JMenu val$navigationBarPositionMenu;
            {
                this.val$useSmallFontMenuItem = jCheckBoxMenuItem2;
                this.val$navigationBarPositionMenu = jMenu;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jCheckBoxMenuItem.isSelected()) {
                    this.storedLeftComponentWidth = MainFrame.this.mainSplitPane.getLeftComponent().getWidth();
                }
                MainFrame.this.navigationBar.setVisible(jCheckBoxMenuItem.isSelected());
                this.val$useSmallFontMenuItem.setEnabled(jCheckBoxMenuItem.isSelected());
                this.val$navigationBarPositionMenu.setEnabled(jCheckBoxMenuItem.isSelected());
                if (jCheckBoxMenuItem.isSelected()) {
                    MainFrame.this.mainSplitPane.setDividerLocation(this.storedLeftComponentWidth);
                }
                MainFrame.this.mainSplitPane.validate();
            }
        });
        ((JMenu)jMenuItem).add(jCheckBoxMenuItem);
        ((JMenuItem)object2).setEnabled(Settings.getBoolean("navigation.showNavbar"));
        ((AbstractButton)object2).addActionListener(new ActionListener((JCheckBoxMenuItem)object2){
            private final /* synthetic */ JCheckBoxMenuItem val$useSmallFontMenuItem;
            {
                this.val$useSmallFontMenuItem = jCheckBoxMenuItem;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.navigationTree.setFont(new Font(MainFrame.this.navigationTree.getFont().getName(), 0, this.val$useSmallFontMenuItem.isSelected() ? 10 : 12));
            }
        });
        ((JMenu)jMenuItem).add((JMenuItem)object2);
        jMenu2.setEnabled(Settings.getBoolean("navigation.showNavbar"));
        GuiUtils.updateButtonText(jMenu2, "menu.navigation.navbarPosition", new Object[0]);
        Object[] objectArray = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem(), new JRadioButtonMenuItem()};
        GuiUtils.updateButtonText(objectArray[0], "menu.navigation.navbarPosition.left", new Object[0]);
        GuiUtils.updateButtonText(objectArray[1], "menu.navigation.navbarPosition.right", new Object[0]);
        objectArray[0].setIcon(Icons.APPLICATION_DOCK_180);
        objectArray[1].setIcon(Icons.APPLICATION_DOCK);
        objectArray[Settings.getInt("navigation.position")].setSelected(true);
        Object object3 = new ButtonGroup();
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            ((ButtonGroup)object3).add((AbstractButton)object);
            final int n2 = n++;
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Settings.set("navigation.position", n2);
                    MainFrame.this.arrangeContent();
                }
            });
            jMenu2.add((JMenuItem)object);
        }
        ((JMenu)jMenuItem).add(jMenu2);
        jMenuBar.add((JMenu)jMenuItem);
        jMenuItem2 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem2, "menu.settings", new Object[0]);
        jMenuItem3 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem3, "menu.settings.laf", new Object[0]);
        jMenuItem3.setIcon(Icons.UI_FLOW);
        serializable = new ButtonGroup();
        objectArray = GuiUtils.getSortedInstalledLAFInfos();
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object2 = objectArray[n4];
            object3 = new JRadioButtonMenuItem(((UIManager.LookAndFeelInfo)object2).getName(), ((UIManager.LookAndFeelInfo)object2).getName().equals(UIManager.getLookAndFeel().getName()));
            ((ButtonGroup)serializable).add((AbstractButton)object3);
            ((AbstractButton)object3).addActionListener(new ActionListener((UIManager.LookAndFeelInfo)object2){
                private final /* synthetic */ UIManager.LookAndFeelInfo val$lookAndFeelInfo;
                {
                    this.val$lookAndFeelInfo = lookAndFeelInfo;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GuiUtils.setLAF(this.val$lookAndFeelInfo.getName())) {
                        SwingUtilities.updateComponentTreeUI(MainFrame.this);
                        MainFrame.this.navigationTree.setCellRenderer(MainFrame.this.createTreeCellRenderer());
                        Settings.set("settings.laf", this.val$lookAndFeelInfo.getName());
                    }
                }
            });
            jMenuItem3.add((Component)object3);
            ++n4;
        }
        ((JMenu)jMenuItem2).add(jMenuItem3);
        serializable = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.settings.language", new Object[0]);
        ((AbstractButton)serializable).setIcon(Icons.LOCALE);
        object2 = new ButtonGroup();
        object3 = Language.getAvailableLanguages();
        int n5 = ((String[])object3).length;
        n3 = 0;
        while (n3 < n5) {
            final String string = object3[n3];
            n = string.equals(Settings.getString("settings.language")) ? 1 : 0;
            object = new JRadioButtonMenuItem(n != 0 ? String.valueOf('*') + string + '*' : string, Icons.getLanguageIcon(string), n != 0);
            ((ButtonGroup)object2).add((AbstractButton)object);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Settings.set("settings.language", string);
                }
            });
            ((JMenu)serializable).add((JMenuItem)object);
            ++n3;
        }
        ((JMenu)jMenuItem2).add((JMenuItem)serializable);
        ((JMenu)jMenuItem2).addSeparator();
        object2 = new JMenuItem(Icons.FOLDERS);
        GuiUtils.updateButtonText((AbstractButton)object2, "menu.settings.folders", new Object[0]);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showFolderSettingsDialog();
            }
        });
        ((JMenu)jMenuItem2).add((JMenuItem)object2);
        ((JMenu)jMenuItem2).addSeparator();
        final JMenuItem jMenuItem4 = GuiUtils.createCheckBoxMenuItem("menu.settings.allowOnlyOneInstance", "settings.allowOnlyOneInstance", Icons.APPLICATION_SHARE);
        ((JMenu)jMenuItem2).add(jMenuItem4);
        final JMenuItem jMenuItem5 = GuiUtils.createCheckBoxMenuItem("menu.settings.checkUpdatesOnStartup", "settings.checkUpdatesOnStartup", Icons.ARROW_CIRCLE_DOUBLE);
        ((JMenu)jMenuItem2).add(jMenuItem5);
        ((JMenu)jMenuItem2).addSeparator();
        final JMenuItem jMenuItem6 = new JMenuItem(Icons.DISK);
        GuiUtils.updateButtonText(jMenuItem6, "menu.settings.saveNow", new Object[0]);
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.saveProperties();
            }
        });
        ((JMenu)jMenuItem2).add(jMenuItem6);
        object3 = GuiUtils.createCheckBoxMenuItem("menu.settings.saveOnExit", "settings.saveOnExit", null);
        ((JMenu)jMenuItem2).add((JMenuItem)object3);
        jMenuBar.add((JMenu)jMenuItem2);
        jMenuItem3 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem3, "menu.window", new Object[0]);
        serializable = new JCheckBoxMenuItem();
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.window.fullscreen", new Object[0]);
        ((AbstractButton)serializable).setIcon(Icons.APPLICATION_RESIZE_FULL);
        ((JMenuItem)serializable).setAccelerator(KeyStroke.getKeyStroke(122, 0));
        ((AbstractButton)serializable).addActionListener(new ActionListener((JCheckBoxMenuItem)serializable){
            private Rectangle storedBounds;
            private final /* synthetic */ JCheckBoxMenuItem val$fullscreenMenuItem;
            {
                this.val$fullscreenMenuItem = jCheckBoxMenuItem;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                    if (this.val$fullscreenMenuItem.isSelected()) {
                        this.storedBounds = MainFrame.this.getBounds();
                    }
                    MainFrame.this.dispose();
                    MainFrame.this.setUndecorated(this.val$fullscreenMenuItem.isSelected());
                    MainFrame.this.setExtendedState(this.val$fullscreenMenuItem.isSelected() ? 6 : 0);
                    if (!this.val$fullscreenMenuItem.isSelected()) {
                        MainFrame.this.setBounds(this.storedBounds);
                    }
                    MainFrame.this.setVisible(true);
                    this.val$fullscreenMenuItem.setIcon(this.val$fullscreenMenuItem.isSelected() ? Icons.APPLICATION_RESIZE_ACTUAL : Icons.APPLICATION_RESIZE_FULL);
                }
            }
        });
        ((JMenu)jMenuItem3).add((JMenuItem)serializable);
        object2 = new JMenuItem(Icons.APPLICATION_DOCK_TAB);
        GuiUtils.updateButtonText((AbstractButton)object2, "menu.window.mimimizeToTray", new Object[0]);
        ((JMenuItem)object2).setEnabled(this.trayIcon != null);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.hideMainFrame();
            }
        });
        ((JMenu)jMenuItem3).add((JMenuItem)object2);
        ((JMenu)jMenuItem3).addSeparator();
        jMenuItem4 = new JMenuItem(Icons.APPLICATION_SPLIT_TILE);
        jMenuItem5 = new JMenuItem(Icons.APPLICATIONS_STACK);
        jMenuItem6 = new JMenuItem(Icons.APPLICATION_SPLIT_TILE);
        object3 = new JMenuItem(Icons.APPLICATIONS_STACK);
        n = 25;
        object = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3;
                boolean bl = actionEvent.getSource() == jMenuItem4 || actionEvent.getSource() == jMenuItem6;
                boolean bl2 = actionEvent.getSource() == jMenuItem4 || actionEvent.getSource() == jMenuItem5;
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n4 = jInternalFrameArray.length;
                if (!bl2) {
                    JInternalFrame[] jInternalFrameArray2 = jInternalFrameArray;
                    n3 = jInternalFrameArray.length;
                    n2 = 0;
                    while (n2 < n3) {
                        JInternalFrame jInternalFrame = jInternalFrameArray2[n2];
                        if (jInternalFrame.isIcon()) {
                            --n4;
                        }
                        ++n2;
                    }
                }
                int n5 = 1;
                n2 = 1;
                if (bl) {
                    n3 = Settings.getBoolean("window.verticalTileStrategy") ? 1 : 0;
                    while (n5 * n2 < n4) {
                        if (n3 != 0) {
                            if (n5 == n2) {
                                ++n2;
                                continue;
                            }
                            ++n5;
                            continue;
                        }
                        if (n5 == n2) {
                            ++n5;
                            continue;
                        }
                        ++n2;
                    }
                }
                if (bl) {
                    n3 = MainFrame.this.desktopPane.getWidth() / n5;
                    n = (MainFrame.this.desktopPane.getHeight() - (bl2 ? 0 : 25)) / n2;
                } else {
                    n3 = MainFrame.this.desktopPane.getWidth() - n4 * 25;
                    n = MainFrame.this.desktopPane.getHeight() - n4 * 25;
                }
                int n6 = 0;
                while (n6 < jInternalFrameArray.length) {
                    try {
                        JInternalFrame jInternalFrame = jInternalFrameArray[n6];
                        if (bl2 && jInternalFrame.isIcon()) {
                            jInternalFrame.setIcon(false);
                        }
                        if (jInternalFrame.isMaximum()) {
                            jInternalFrame.setMaximum(false);
                        }
                        if (bl) {
                            jInternalFrame.setBounds(n6 % n5 * n3, n6 / n5 * n, n3, n);
                        } else {
                            jInternalFrame.setBounds(n6 * 25, n6 * 25, n3, n);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    ++n6;
                }
            }
        };
        GuiUtils.updateButtonText(jMenuItem4, "menu.window.tileAllWindows", new Object[0]);
        jMenuItem4.addActionListener((ActionListener)object);
        ((JMenu)jMenuItem3).add(jMenuItem4);
        GuiUtils.updateButtonText(jMenuItem5, "menu.window.cascadeAllWindows", new Object[0]);
        jMenuItem5.addActionListener((ActionListener)object);
        ((JMenu)jMenuItem3).add(jMenuItem5);
        GuiUtils.updateButtonText(jMenuItem6, "menu.window.tileVisibleWindows", new Object[0]);
        jMenuItem6.addActionListener((ActionListener)object);
        ((JMenu)jMenuItem3).add(jMenuItem6);
        GuiUtils.updateButtonText((AbstractButton)object3, "menu.window.cascadeVisibleWindows", new Object[0]);
        ((AbstractButton)object3).addActionListener((ActionListener)object);
        ((JMenu)jMenuItem3).add((JMenuItem)object3);
        JMenuItem jMenuItem7 = new JMenuItem(Icons.APPLICATION_DIALOG);
        GuiUtils.updateButtonText(jMenuItem7, "menu.window.minimizeAll", new Object[0]);
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n2];
                    try {
                        jInternalFrame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
        ((JMenu)jMenuItem3).add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem(Icons.CROSS_BUTTON);
        GuiUtils.updateButtonText(jMenuItem8, "menu.window.closeAll", new Object[0]);
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n2];
                    try {
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
        ((JMenu)jMenuItem3).add(jMenuItem8);
        ((JMenu)jMenuItem3).addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem2 = GuiUtils.createCheckBoxMenuItem("menu.window.useVerticalTileStrategy", "window.verticalTileStrategy", Icons.APPLICATION_TILE_VERTICAL);
        ((JMenu)jMenuItem3).add(jCheckBoxMenuItem2);
        jMenuBar.add((JMenu)jMenuItem3);
        serializable = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.help", new Object[0]);
        object2 = new JMenuItem(Icons.HOME_ARROW);
        GuiUtils.updateButtonText((AbstractButton)object2, "menu.help.visitHomePage", new Object[0]);
        ((JMenuItem)object2).setAccelerator(KeyStroke.getKeyStroke(112, 0));
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/");
            }
        });
        ((JMenu)serializable).add((JMenuItem)object2);
        jMenuItem4 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(jMenuItem4, "menu.help.viewVersionHistory", new Object[0]);
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/version-history");
            }
        });
        ((JMenu)serializable).add(jMenuItem4);
        jMenuItem5 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(jMenuItem5, "menu.help.viewFaq", new Object[0]);
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/faq");
            }
        });
        ((JMenu)serializable).add(jMenuItem5);
        jMenuItem6 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(jMenuItem6, "menu.help.visitForum", new Object[0]);
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonUtils.showURLInBrowser("http://groups.google.com/group/sc2gears");
            }
        });
        ((JMenu)serializable).add(jMenuItem6);
        ((JMenu)serializable).addSeparator();
        GuiUtils.updateButtonText(this.viewSystemMessagesMenuItem, "menu.help.viewSystemMessages", new Object[0]);
        this.viewSystemMessagesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final JDialog jDialog = new JDialog(MainFrame.this, Language.getText("dialog.systemMessages.title"), true);
                jDialog.setDefaultCloseOperation(2);
                JTextArea jTextArea = new JTextArea(Log.getLog(), 15, 40);
                jTextArea.setEditable(false);
                jDialog.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
                final JButton jButton = new JButton();
                GuiUtils.updateButtonText(jButton, "button.close", new Object[0]);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.dispose();
                    }
                });
                jDialog.getContentPane().add((Component)GuiUtils.wrapInPanel(jButton), "South");
                jDialog.setSize(700, 500);
                GuiUtils.centerWindowToWindow(jDialog, MainFrame.this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jButton.requestFocusInWindow();
                    }
                });
                jDialog.setVisible(true);
            }
        });
        ((JMenu)serializable).add(this.viewSystemMessagesMenuItem);
        ((JMenu)serializable).addSeparator();
        GuiUtils.updateButtonText(this.checkUpdatesMenuItem, "menu.help.checkUpdates", new Object[0]);
        this.checkUpdatesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.checkUpdates();
            }
        });
        ((JMenu)serializable).add(this.checkUpdatesMenuItem);
        ((JMenu)serializable).addSeparator();
        object3 = new JMenuItem(Icons.INFORMATION);
        GuiUtils.updateButtonText((AbstractButton)object3, "menu.help.about", "Sc2gears");
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showAboutDialog();
            }
        });
        ((JMenu)serializable).add((JMenuItem)object3);
        jMenuBar.add((JMenu)serializable);
        this.setJMenuBar(jMenuBar);
    }

    private void createNewInternalFrame(MutableTreeNode mutableTreeNode, Object ... objectArray) {
        ModuleFrame moduleFrame = null;
        if (mutableTreeNode == this.newRepAnalNode) {
            moduleFrame = new ReplayAnalyzer(objectArray);
        } else if (mutableTreeNode == this.newMultiRepAnalNode) {
            moduleFrame = new MultiRepAnalysis(objectArray);
        } else if (mutableTreeNode == this.newRepSearchNode) {
            moduleFrame = new ReplaySearch(objectArray);
        }
        if (moduleFrame != null && !moduleFrame.isClosed()) {
            moduleFrame.setDefaultCloseOperation(2);
            final DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(moduleFrame);
            ((DefaultTreeModel)this.navigationTree.getModel()).insertNodeInto(defaultMutableTreeNode, (DefaultMutableTreeNode)mutableTreeNode.getParent(), 1);
            final TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.navigationTree.setSelectionPath(treePath);
            moduleFrame.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    ((DefaultTreeModel)MainFrame.this.navigationTree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
                }

                @Override
                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                    if (!((JInternalFrame)internalFrameEvent.getSource()).isIcon()) {
                        MainFrame.this.navigationTree.setSelectionPath(treePath);
                        MainFrame.this.navigationTree.scrollPathToVisible(treePath);
                    }
                }
            });
            this.desktopPane.add(moduleFrame);
            moduleFrame.setVisible(true);
            try {
                moduleFrame.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }
    }

    public void openReplayFile(File file) {
        this.createNewInternalFrame(this.newRepAnalNode, file);
        int n = Settings.getInt("recentReplays.count");
        ArrayList<String> arrayList = new ArrayList<String>(n + 1);
        String string = file.getAbsolutePath();
        arrayList.add(string);
        int n2 = 0;
        while (n2 < n) {
            String string2 = Settings.getString("recentReplays.entry." + n2);
            if (!string.equals(string2)) {
                arrayList.add(string2);
            }
            ++n2;
        }
        while (arrayList.size() > 15) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (arrayList.size() != n) {
            n = arrayList.size();
            Settings.set("recentReplays.count", n);
        }
        n2 = 0;
        while (n2 < n) {
            Settings.set("recentReplays.entry." + n2, arrayList.get(n2));
            ++n2;
        }
        this.rebuildRecentReplaysMenu();
    }

    public void openReplaysInMultiRepAnalysis(File[] fileArray) {
        this.createNewInternalFrame(this.newMultiRepAnalNode, new Object[]{fileArray});
    }

    private void rebuildRecentReplaysMenu() {
        this.recentReplaysMenu.removeAll();
        int n = Settings.getInt("recentReplays.count");
        int n2 = 0;
        while (n2 < n) {
            final File file = new File(Settings.getString("recentReplays.entry." + n2));
            JMenuItem jMenuItem = new JMenuItem(String.valueOf(n2 + 1) + " " + file.getName(), Icons.SC2);
            if (n2 < 9) {
                jMenuItem.setMnemonic(49 + n2);
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.openReplayFile(file);
                }
            });
            this.recentReplaysMenu.add(jMenuItem);
            ++n2;
        }
    }

    private void arrangeContent() {
        this.mainSplitPane.setLeftComponent(null);
        this.mainSplitPane.setRightComponent(null);
        if (Settings.getInt("navigation.position") == 0) {
            if (this.navigationBar.getWidth() != 0) {
                this.mainSplitPane.setDividerLocation(this.navigationBar.getWidth());
            }
            this.mainSplitPane.setLeftComponent(this.navigationBar);
            this.mainSplitPane.setRightComponent(this.desktopPane);
        } else {
            if (this.desktopPane.getWidth() != 0) {
                this.mainSplitPane.setDividerLocation(this.desktopPane.getWidth());
            }
            this.mainSplitPane.setLeftComponent(this.desktopPane);
            this.mainSplitPane.setRightComponent(this.navigationBar);
        }
    }

    private void hideMainFrame() {
        this.setVisible(false);
        this.hideTrayMenuItem.setEnabled(false);
        this.restoreTrayMenuItem.setEnabled(true);
    }

    public void restoreMainFrame() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (this.getExtendedState() == 1) {
            this.setExtendedState(0);
        }
        this.toFront();
        this.hideTrayMenuItem.setEnabled(true);
        this.restoreTrayMenuItem.setEnabled(false);
    }

    private void showFolderSettingsDialog() {
        JComponent jComponent;
        final JDialog jDialog = new JDialog(this, Language.getText("folderSettings.title"), true);
        jDialog.setIconImage(Icons.FOLDERS.getImage());
        jDialog.setDefaultCloseOperation(2);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        Box[] boxArray = new Box[4];
        Box box2 = boxArray[0] = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("folderSettings.sc2InstallationFolder")));
        final JTextField jTextField = new JTextField(Settings.getString("settings.folders.sc2Installation"), 30);
        box2.add(jTextField);
        final JButton jButton = new JButton(Language.getText("folderSettings.chooseFolder"), Icons.FOLDER);
        box2.add(jButton);
        box2 = boxArray[1] = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("folderSettings.sc2AutoReplay")));
        final JTextField jTextField2 = new JTextField(Settings.getString("settings.folders.sc2AutoReplay"), 30);
        box2.add(jTextField2);
        final JButton jButton2 = new JButton(Language.getText("folderSettings.chooseFolder"), Icons.FOLDER);
        box2.add(jButton2);
        box2 = boxArray[2] = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("folderSettings.sc2Maps")));
        final JTextField jTextField3 = new JTextField(Settings.getString("settings.folders.sc2Maps"), 30);
        box2.add(jTextField3);
        final JButton jButton3 = new JButton(Language.getText("folderSettings.chooseFolder"), Icons.FOLDER);
        box2.add(jButton3);
        box2 = boxArray[3] = Box.createHorizontalBox();
        box2.add(new JLabel(Language.getText("folderSettings.defaultFolder")));
        final JTextField jTextField4 = new JTextField(Settings.getString("settings.folders.defaultReplay"), 30);
        box2.add(jTextField4);
        final JButton jButton4 = new JButton(Language.getText("folderSettings.chooseFolder"), Icons.FOLDER);
        box2.add(jButton4);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField5 = actionEvent.getSource() == jButton ? jTextField : (actionEvent.getSource() == jButton2 ? jTextField2 : (actionEvent.getSource() == jButton3 ? jTextField3 : (actionEvent.getSource() == jButton4 ? jTextField4 : null)));
                boolean bl = jTextField5 == jTextField2 || jTextField5 == jTextField3;
                String string = System.getProperty("user.home");
                JFileChooser jFileChooser = new JFileChooser(String.valueOf(bl ? string : "") + jTextField5.getText());
                jFileChooser.setDialogTitle(Language.getText("folderSettings.chooseFolder"));
                jFileChooser.setFileSelectionMode(1);
                if (jFileChooser.showOpenDialog(INSTANCE) == 0) {
                    String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                    if (bl && string2.toLowerCase().startsWith(string.toLowerCase())) {
                        string2 = string2.substring(string.length());
                    }
                    jTextField5.setText(string2);
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton3.addActionListener(actionListener);
        jButton4.addActionListener(actionListener);
        int n = 0;
        Box[] boxArray2 = boxArray;
        int n2 = boxArray.length;
        int n3 = 0;
        while (n3 < n2) {
            jComponent = boxArray2[n3];
            box.add(jComponent);
            n = Math.max(jComponent.getComponent((int)0).getPreferredSize().width, n);
            ++n3;
        }
        boxArray2 = boxArray;
        n2 = boxArray.length;
        n3 = 0;
        while (n3 < n2) {
            jComponent = boxArray2[n3];
            jComponent.getComponent(0).setPreferredSize(new Dimension(n, jComponent.getComponent((int)0).getPreferredSize().height));
            ++n3;
        }
        box.add(Box.createVerticalStrut(10));
        jComponent = new JPanel();
        JButton jButton5 = new JButton();
        GuiUtils.updateButtonText(jButton5, "button.ok", new Object[0]);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.set("settings.folders.sc2Installation", jTextField.getText());
                Settings.set("settings.folders.sc2AutoReplay", jTextField2.getText());
                Settings.set("settings.folders.sc2Maps", jTextField3.getText());
                Settings.set("settings.folders.defaultReplay", jTextField4.getText());
                jDialog.dispose();
            }
        });
        jComponent.add(jButton5);
        JButton jButton6 = new JButton();
        GuiUtils.updateButtonText(jButton6, "button.cancel", new Object[0]);
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jComponent.add(jButton6);
        box.add(jComponent);
        jDialog.getContentPane().add(box);
        jDialog.pack();
        GuiUtils.centerWindowToWindow(jDialog, this);
        jButton6.requestFocusInWindow();
        jDialog.setVisible(true);
    }

    private void showAboutDialog() {
        final JDialog jDialog = new JDialog(this, Language.getText("about.title", "Sc2gears"), true);
        jDialog.setDefaultCloseOperation(2);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(30));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(Icons.SC2GEARS_LOGO);
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createRaisedBevelBorder()));
        jPanel.add(Box.createHorizontalStrut(25));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(25));
        box.add(jPanel);
        box.add(Box.createVerticalStrut(20));
        JTable jTable = new JTable(new Object[][]{{Language.getText("about.author"), Language.formatPersonName("Andr\u00e1s", "Belicza")}, {Language.getText("about.email"), Consts.AUTHOR_EMAIL}, {Language.getText("about.version"), "1.30"}, {Language.getText("about.releasedOn"), Language.formatDate(Consts.APPLICATION_RELEASE_DATE)}, {Language.getText("about.currentTranslator"), Language.getTranslatorName()}, {Language.getText("about.languageFileVersion"), Language.getLanguageFileVersion()}}, new Object[]{"Property", "Value"}){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        GuiUtils.packTable(jTable);
        box.add(GuiUtils.wrapInPanel(jTable));
        box.add(Box.createVerticalStrut(15));
        box.add(GuiUtils.wrapInPanel(new JLabel(Language.getText("about.usedIcons", "Sc2gears"))));
        box.add(Box.createVerticalStrut(15));
        JButton jButton = new JButton();
        GuiUtils.updateButtonText(jButton, "button.ok", new Object[0]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        box.add(GuiUtils.wrapInPanel(jButton));
        box.add(Box.createVerticalStrut(15));
        jDialog.getContentPane().add(box);
        jDialog.pack();
        GuiUtils.centerWindowToWindow(jDialog, this);
        jButton.requestFocusInWindow();
        jDialog.setVisible(true);
    }

    private void checkUpdates() {
        this.checkUpdatesMenuItem.setEnabled(false);
        new NormalThread("Update checker"){

            @Override
            public void run() {
                block7: {
                    try {
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new URL("http://sites.google.com/site/sc2gears/storage/latest_version.xml").toURI().toString());
                        Element element = document.getDocumentElement();
                        String string = ((Element)element.getElementsByTagName("latestVersion").item(0)).getTextContent();
                        if ("1.30".equals(string)) break block7;
                        String string2 = Language.getText("updatesAvailable.updateButton");
                        int n = JOptionPane.showOptionDialog(MainFrame.this, new Object[]{Language.getText("updatesAvailable.newVersionAvailable", string), CommonUtils.createLinkLabel(Language.getText("updatesAvailable.viewVersionHistory"), "http://sites.google.com/site/sc2gears/version-history"), " ", Language.getText("updatesAvailable.whatToDo")}, Language.getText("updatesAvailable.title"), -1, 1, null, new Object[]{string2, Language.getText("updatesAvailable.dontUpdateButton")}, string2);
                        if (n != 0) break block7;
                        if (!Sc2gears.checkAndPerformPostUpdate()) {
                            GuiUtils.showErrorDialog(new String[]{Language.getText("updatesAvailable.updaterCannotBeStarted", "Sc2gears Updater"), Language.getText("updatesAvailable.restart", "Sc2gears")});
                            return;
                        }
                        try {
                            String string3 = ((Element)element.getElementsByTagName("archiveUrl").item(0)).getTextContent();
                            String string4 = ((Element)element.getElementsByTagName("requiredMinUpdaterVer").item(0)).getTextContent();
                            String string5 = ((Element)element.getElementsByTagName("archiveSha256").item(0)).getTextContent();
                            MainFrame.this.exit(true, new String[]{string, string4, string3, string5});
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    finally {
                        MainFrame.this.checkUpdatesMenuItem.setEnabled(true);
                    }
                }
            }
        }.start();
    }

    private void exit(boolean bl, String ... stringArray) {
        if (Settings.getBoolean("settings.saveOnExit")) {
            Settings.saveProperties();
        }
        if (bl) {
            try {
                Runtime.getRuntime().exec("java -cp lib-updater/Sc2gearsUpdater.jar hu/belicza/andras/sc2gearsupdater/Updater " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3]);
            }
            catch (IOException iOException) {
                System.err.println("Failed to start Sc2gears Updater!");
                iOException.printStackTrace();
            }
        }
        System.exit(0);
    }
}

