/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay.model;

import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import java.awt.Color;
import java.awt.Point;
import java.util.Arrays;
import java.util.Comparator;

public class Details {
    public Player[] players;
    public String mapName;
    public String mapPreviewFileName;
    private int[] teamOrderPlayerIndices;

    public String getPlayerNames() {
        int[] nArray = this.getTeamOrderPlayerIndeces();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.players[nArray[n]].name);
            ++n;
        }
        return stringBuilder.toString();
    }

    public String getPlayerFullNames() {
        int[] nArray = this.getTeamOrderPlayerIndeces();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.players[nArray[n]].fullName);
            ++n;
        }
        return stringBuilder.toString();
    }

    public String getRaceMatchup() {
        int[] nArray = this.getTeamOrderPlayerIndeces();
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.players[nArray[0]].team;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = this.players[nArray[n2]].team;
            if (n3 != n) {
                stringBuilder.append('v');
                n = n3;
            }
            stringBuilder.append(this.players[nArray[n2]].raceString().charAt(0));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public int[] getTeamOrderPlayerIndeces() {
        if (this.teamOrderPlayerIndices == null) {
            int[][] nArrayArray = new int[this.players.length][];
            int n = 0;
            while (n < nArrayArray.length) {
                nArrayArray[n] = new int[]{this.players[n].team, n};
                ++n;
            }
            Arrays.sort(nArrayArray, new Comparator<int[]>(){

                @Override
                public int compare(int[] nArray, int[] nArray2) {
                    return nArray[0] - nArray2[0];
                }
            });
            this.teamOrderPlayerIndices = new int[this.players.length];
            n = 0;
            while (n < nArrayArray.length) {
                this.teamOrderPlayerIndices[n] = nArrayArray[n][1];
                ++n;
            }
        }
        return this.teamOrderPlayerIndices;
    }

    public static class Player {
        public static final int TEAM_UNKNOWN = Integer.MAX_VALUE;
        public String name;
        public String fullName;
        public String raceString;
        public final int[] argbColor = new int[4];
        public int lastActionFrame;
        public int actionsCount;
        public ReplayConsts.PlayerType type = ReplayConsts.PlayerType.UNKNOWN;
        public ReplayConsts.Race race;
        public int team = Integer.MAX_VALUE;
        public Point startLocation;
        public Boolean isWinner;

        public String raceString() {
            return this.race == null ? this.raceString : (this.race == ReplayConsts.Race.RANDOM ? String.valueOf(this.race.toString()) + " (" + this.raceString + ")" : this.race.toString());
        }

        public Color getColor() {
            return new Color(this.argbColor[1], this.argbColor[2], this.argbColor[3]);
        }

        public Color getDarkerColor() {
            return new Color(this.argbColor[1] >> 1, this.argbColor[2] >> 1, this.argbColor[3] >> 1);
        }

        public Color getBrighterColor() {
            return new Color(127 + (this.argbColor[1] >> 1), 127 + (this.argbColor[2] >> 1), 127 + (this.argbColor[3] >> 1));
        }

        public String getColorName() {
            return "(" + this.argbColor[1] + "," + this.argbColor[2] + "," + this.argbColor[3] + ")";
        }
    }
}

