/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.mpq;

import hu.belicza.andras.sc2gears.mpq.InvalidMpqArchiveException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class AlgorithmUtil {
    private static final long[] CRYPT_TABLE = new long[1280];
    private static final int FLAG_COMPRESSION_ZLIB = 2;

    static {
        long l = 0x100001L;
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n < 256) {
            n2 = n;
            int n3 = 0;
            while (n3 < 5) {
                l = (l * 125L + 3L & 0xFFFFFFFFL) % 0x2AAAABL;
                long l2 = (l & 0xFFFFL) << 16;
                l = (l * 125L + 3L & 0xFFFFFFFFL) % 0x2AAAABL;
                long l3 = l & 0xFFFFL;
                AlgorithmUtil.CRYPT_TABLE[n2] = l2 | l3;
                ++n3;
                n2 += 256;
            }
            ++n;
        }
    }

    private AlgorithmUtil() {
    }

    public static ByteBuffer decryptData(ByteBuffer byteBuffer, int n, int n2) {
        long l = (long)n2 & 0xFFFFFFFFL;
        long l2 = 0xEEEEEEEEL;
        int n3 = 0;
        while (n3 < n) {
            l2 = l2 + CRYPT_TABLE[1024 + (int)(l & 0xFFL)] & 0xFFFFFFFFL;
            int n4 = byteBuffer.getInt(n3) ^ (int)(l + l2);
            l = (((l ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL) << 21) + 0x11111111L & 0xFFFFFFFFL | l >> 11;
            l2 = ((long)n4 & 0xFFFFFFFFL) + l2 + (l2 << 5) + 3L & 0xFFFFFFFFL;
            byteBuffer.putInt(n3, n4);
            n3 += 4;
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    public static int hashString(String string, MpqHashType mpqHashType) {
        int n = mpqHashType.offset;
        long l = 2146271213L;
        long l2 = 0xEEEEEEEEL;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = Character.toUpperCase(string.charAt(n3));
            l = CRYPT_TABLE[n + c] ^ l + l2 & 0xFFFFFFFFL;
            l2 = (long)c + l + l2 + (l2 << 5) + 3L & 0xFFFFFFFFL;
            ++n3;
        }
        return (int)l;
    }

    public static void decompressMultiBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws InvalidMpqArchiveException {
        if (byArray.length >= n) {
            System.arraycopy(byArray, 0, byArray2, n2, n);
        } else {
            byte by = byArray[0];
            if (by != 2) {
                throw new InvalidMpqArchiveException("Compression (" + by + ") not supported!");
            }
            Inflater inflater = new Inflater();
            inflater.setInput(byArray, 1, byArray.length - 1);
            try {
                inflater.inflate(byArray2, n2, n);
                inflater.end();
            }
            catch (DataFormatException dataFormatException) {
                throw new InvalidMpqArchiveException("Data format exception, failed to decompressed block!", dataFormatException);
            }
        }
    }

    public static enum MpqHashType {
        TABLE_OFFSET(0),
        NAME_A(1),
        NAME_B(2),
        FILE_KEY(3);

        public final int offset;

        private MpqHashType(int n2) {
            this.offset = n2 << 8;
        }
    }
}

