/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.language;

import hu.belicza.andras.sc2gears.Consts;
import java.io.File;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Language {
    private String language;
    private String languageFileVersion;
    private String translatorFirstName;
    private String translatorLastName;
    private DateFormat DATE_FORMAT;
    private DateFormat DATE_TIME_FORMAT;
    private DateFormat TIME_FORMAT;
    private boolean personNameFormatFirstNameFirst;
    private final Map<String, String> textMap = new HashMap<String, String>();
    private static final Language DEFAULT_LANGUAGE;
    private static Language loadedLanguage;

    static {
        Language language = null;
        try {
            language = new Language("English");
        }
        catch (Exception exception) {
            System.err.println("Failed to load the default language file, program will exit now!");
            System.exit(0);
        }
        loadedLanguage = DEFAULT_LANGUAGE = language;
    }

    private Language(String string) throws Exception {
        try {
            this.language = string;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File("Languages", String.valueOf(string) + ".xml"));
            Element element = document.getDocumentElement();
            this.languageFileVersion = element.getAttribute("version");
            if (!"1.30".equals(this.languageFileVersion)) {
                System.out.println("The language file (" + string + ") version (" + this.languageFileVersion + ") does not match the application version (" + "1.30" + ").");
                if ("English".equals(string)) {
                    System.out.println("The default language file (English) version MUST match the application version!");
                    if (!Consts.DEVELOPER_MODE) {
                        System.exit(0);
                    }
                } else {
                    System.out.println("Some texts might be displayed in the default language.");
                }
            }
            this.translatorFirstName = element.getAttribute("translatorFirstName");
            this.translatorLastName = element.getAttribute("translatorLastName");
            NodeList nodeList = element.getElementsByTagName("dateFormat");
            this.DATE_FORMAT = new SimpleDateFormat(((Element)nodeList.item(0)).getTextContent());
            nodeList = element.getElementsByTagName("dateTimeFormat");
            this.DATE_TIME_FORMAT = new SimpleDateFormat(((Element)nodeList.item(0)).getTextContent());
            nodeList = element.getElementsByTagName("timeFormat");
            this.TIME_FORMAT = new SimpleDateFormat(((Element)nodeList.item(0)).getTextContent());
            nodeList = element.getElementsByTagName("personNameFormat");
            String string2 = ((Element)nodeList.item(0)).getTextContent();
            if (!"firstName lastName".equals(string2) && !"lastName firstName".equals(string2)) {
                throw new Exception("Invalid person name format!");
            }
            this.personNameFormatFirstNameFirst = "firstName lastName".equals(string2);
            nodeList = element.getElementsByTagName("text");
            if (DEFAULT_LANGUAGE != null) {
                this.textMap.putAll(Language.DEFAULT_LANGUAGE.textMap);
            }
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2 = (Element)nodeList.item(n2);
                this.textMap.put(element2.getAttribute("key"), element2.getTextContent());
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to load language file: " + string);
            exception.printStackTrace(System.err);
            throw exception;
        }
    }

    public static boolean loadLanguage(String string) {
        try {
            loadedLanguage = Language.DEFAULT_LANGUAGE.language.equals(string) ? DEFAULT_LANGUAGE : new Language(string);
            Language.updateUIManagerTexts();
            return true;
        }
        catch (Exception exception) {
            System.err.println("Failed to load language file: " + string);
            return false;
        }
    }

    private static void updateUIManagerTexts() {
        UIManager.put("InternalFrameTitlePane.closeButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.close"));
        UIManager.put("InternalFrameTitlePane.minimizeButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.minimize"));
        UIManager.put("InternalFrameTitlePane.restoreButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.restore"));
        UIManager.put("InternalFrameTitlePane.maximizeButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.maximize"));
        UIManager.put("InternalFrameTitlePane.moveButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.move"));
        UIManager.put("InternalFrameTitlePane.sizeButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.size"));
        UIManager.put("InternalFrame.closeButtonToolTip", Language.loadedLanguage.textMap.get("internalFrame.toolTip.close"));
        UIManager.put("InternalFrame.iconButtonToolTip", Language.loadedLanguage.textMap.get("internalFrame.toolTip.minimize"));
        UIManager.put("InternalFrame.restoreButtonToolTip", Language.loadedLanguage.textMap.get("internalFrame.toolTip.restore"));
        UIManager.put("InternalFrame.maxButtonToolTip", Language.loadedLanguage.textMap.get("internalFrame.toolTip.maximize"));
        UIManager.put("FileChooser.openDialogTitleText", Language.loadedLanguage.textMap.get("fileChooser.openDialogTitle"));
        UIManager.put("FileChooser.saveDialogTitleText", Language.loadedLanguage.textMap.get("fileChooser.saveDialogTitle"));
        UIManager.put("FileChooser.lookInLabelText", Language.loadedLanguage.textMap.get("fileChooser.lookInLabel"));
        UIManager.put("FileChooser.filesOfTypeLabelText", Language.loadedLanguage.textMap.get("fileChooser.filesOfTypeLabel"));
        UIManager.put("FileChooser.fileNameLabelText", Language.loadedLanguage.textMap.get("fileChooser.fileNameLabel"));
        UIManager.put("FileChooser.upFolderToolTipText", Language.loadedLanguage.textMap.get("fileChooser.upFolderToolTip"));
        UIManager.put("FileChooser.homeFolderToolTipText", Language.loadedLanguage.textMap.get("fileChooser.homeFolderToolTip"));
        UIManager.put("FileChooser.newFolderToolTipText", Language.loadedLanguage.textMap.get("fileChooser.newFolderToolTip"));
        UIManager.put("FileChooser.listViewButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.listViewButtonToolTip"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.detailsViewButtonToolTip"));
        UIManager.put("FileChooser.saveButtonText", Language.loadedLanguage.textMap.get("fileChooser.saveButton"));
        UIManager.put("FileChooser.openButtonText", Language.loadedLanguage.textMap.get("fileChooser.openButton"));
        UIManager.put("FileChooser.cancelButtonText", Language.loadedLanguage.textMap.get("fileChooser.cancelButton"));
        UIManager.put("FileChooser.updateButtonText", Language.loadedLanguage.textMap.get("fileChooser.updateButton"));
        UIManager.put("FileChooser.helpButtonText", Language.loadedLanguage.textMap.get("fileChooser.helpButton"));
        UIManager.put("FileChooser.saveButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.saveButtonToolTip"));
        UIManager.put("FileChooser.openButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.openButtonToolTip"));
        UIManager.put("FileChooser.cancelButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.cancelButtonToolTip"));
        UIManager.put("FileChooser.updateButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.updateButtonToolTip"));
        UIManager.put("FileChooser.helpButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.helpButtonToolTip"));
        UIManager.put("FileChooser.acceptAllFileFilterText", Language.loadedLanguage.textMap.get("fileChooser.acceptAllFileFilter"));
    }

    public static String getTranslatorName() {
        return Language.formatPersonName(Language.loadedLanguage.translatorFirstName, Language.loadedLanguage.translatorLastName);
    }

    public static String getLanguageFileVersion() {
        return Language.loadedLanguage.languageFileVersion;
    }

    public static String[] getAvailableLanguages() {
        String[] stringArray = new File("Languages").list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".xml");
            }
        });
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n].substring(0, stringArray[n].lastIndexOf(46));
            ++n;
        }
        Arrays.sort(stringArray2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return "English".equals(string) ? -1 : ("English".equals(string2) ? 1 : string.compareTo(string2));
            }
        });
        return stringArray2;
    }

    public static String getText(String string) {
        return Language.loadedLanguage.textMap.get(string);
    }

    public static String getText(String string, Object ... objectArray) {
        String string2 = Language.loadedLanguage.textMap.get(string);
        int n = 0;
        while (n < objectArray.length) {
            string2 = string2.replace("$" + n, objectArray[n].toString());
            ++n;
        }
        return string2;
    }

    public static String formatDate(Date date) {
        return Language.loadedLanguage.DATE_FORMAT.format(date);
    }

    public static String formatDateTime(Date date) {
        return Language.loadedLanguage.DATE_TIME_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        return Language.loadedLanguage.TIME_FORMAT.format(date);
    }

    public static String formatPersonName(String string, String string2) {
        if (Language.loadedLanguage.personNameFormatFirstNameFirst) {
            return String.valueOf(string) + ' ' + string2;
        }
        return String.valueOf(string2) + ' ' + string;
    }

    public static String getYesNo(boolean bl) {
        return Language.getText(bl ? "general.yes" : "general.no");
    }

    public static Date parseDate(String string) {
        try {
            return Language.loadedLanguage.DATE_FORMAT.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static Date parseDateTime(String string, boolean bl) {
        try {
            return Language.loadedLanguage.DATE_TIME_FORMAT.parse(string);
        }
        catch (ParseException parseException) {
            if (!bl) {
                parseException.printStackTrace();
            }
            return null;
        }
    }
}

