/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.NormalThread;
import hu.belicza.andras.sc2gears.ui.ReplayOperationsPopupMenu;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchFieldGroup;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.BuildOrderSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.BuildingAbilitySearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.BuildingSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.ChatMessageSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.DateSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.FileNameSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.FormatSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.GameLengthSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.GameTypeSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.GatewaySearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.MapNameSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.PlayerNameSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.RaceMatchupSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.ResearchSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.UnitAbilitySearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.UnitSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.UpgradeSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.VersionSearchField;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.PanelUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ReplaySearch
extends ModuleFrame {
    private static final String[] RESULT_HEADER_KEYS = new String[]{"module.repSearch.tab.results.header.version", "module.repSearch.tab.results.header.type", "module.repSearch.tab.results.header.gateway", "module.repSearch.tab.results.header.fileDate", "module.repSearch.tab.results.header.map", "module.repSearch.tab.results.header.raceMatchup", "module.repSearch.tab.results.header.length", "module.repSearch.tab.results.header.players", "module.repSearch.tab.results.header.file", "module.repSearch.tab.results.header.comment"};
    private static final int FILE_NAME_COLUMN_INDEX;
    private static final int COMMENT_COLUMN_INDEX;
    private static final String[] RESULT_HEADER_NAMES;
    private static final AtomicInteger counter;
    private volatile boolean temporarilyDisableFilters;
    private final JList sourceList = new JList(new DefaultListModel());
    private final JCheckBox autoSortSourcesCheckBox = GuiUtils.createCheckBox("module.repSearch.tab.source.autoSort", "module.repSearch.source.autoSort");
    private final JButton performSearchButton = new JButton(Icons.BINOCULAR_ARROW);
    private SearchFieldGroup[] searchFieldGroups;
    private File initialReplayList;

    static {
        RESULT_HEADER_NAMES = new String[RESULT_HEADER_KEYS.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < RESULT_HEADER_KEYS.length) {
            ReplaySearch.RESULT_HEADER_NAMES[n3] = Language.getText(RESULT_HEADER_KEYS[n3]);
            if ("module.repSearch.tab.results.header.file".equals(RESULT_HEADER_KEYS[n3])) {
                n = n3;
            } else if ("module.repSearch.tab.results.header.comment".equals(RESULT_HEADER_KEYS[n3])) {
                n2 = n3;
            }
            ++n3;
        }
        FILE_NAME_COLUMN_INDEX = n;
        COMMENT_COLUMN_INDEX = n2;
        counter = new AtomicInteger();
    }

    public ReplaySearch(Object ... objectArray) {
        super(Language.getText("module.repSearch.title", counter.incrementAndGet()));
        this.setFrameIcon(Icons.BINOCULAR);
        this.buildGui();
        if (objectArray != null) {
            if (objectArray.length > 0 && objectArray[0] != null) {
                this.loadReplaySourceFile((File)objectArray[0]);
            }
            if (objectArray.length > 1 && objectArray[1] != null) {
                this.initialReplayList = (File)objectArray[1];
            }
            if (objectArray.length > 0 && objectArray[0] != null || objectArray.length > 1 && objectArray[1] != null) {
                this.temporarilyDisableFilters = true;
                this.performSearchButton.doClick();
            }
        }
    }

    private void buildGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.sourceList.setCellRenderer(new ListCellRenderer(){
            private final JLabel label = new JLabel();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                File file = (File)object;
                this.label.setText(file.getAbsolutePath());
                this.label.setIcon(file.isDirectory() ? Icons.FOLDER : Icons.SC2);
                if (bl) {
                    this.label.setBackground(jList.getSelectionBackground());
                    this.label.setForeground(jList.getSelectionForeground());
                } else {
                    this.label.setBackground(jList.getBackground());
                    this.label.setForeground(jList.getForeground());
                }
                this.label.setFont(jList.getFont());
                this.label.setOpaque(true);
                return this.label;
            }
        });
        GuiUtils.addNewTab(Language.getText("module.repSearch.tab.source.title"), Icons.FOLDERS_STACK, false, jTabbedPane, this.createSourceTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repSearch.tab.filters.title"), Icons.EDIT_COLUMN, false, jTabbedPane, this.createFiltersTab(jTabbedPane), null);
        this.getContentPane().add(jTabbedPane);
    }

    private JComponent createSourceTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        JButton jButton = new JButton(Icons.FOLDER_OPEN);
        GuiUtils.updateButtonText(jButton, "module.repSearch.tab.source.loadReplaySourceButton", new Object[0]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser("User Content/Replay sources");
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectLoadReplaySource"));
                jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER);
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    ReplaySearch.this.loadReplaySourceFile(jFileChooser.getSelectedFile());
                }
            }
        });
        box2.add(jButton);
        JButton jButton2 = new JButton(Icons.DISK);
        GuiUtils.updateButtonText(jButton2, "module.repSearch.tab.source.saveReplaySourceButton", new Object[0]);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser("User Content/Replay sources");
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectSaveReplaySource"));
                jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER);
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (jFileChooser.showSaveDialog(MainFrame.INSTANCE) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (!GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                        file = new File(String.valueOf(file.getAbsolutePath()) + ".sc2repsrc");
                    }
                    ReplaySearch.this.saveReplaySourceFile(file);
                }
            }
        });
        box2.add(jButton2);
        box.add(box2);
        box2 = Box.createHorizontalBox();
        JButton jButton3 = new JButton(Icons.FOLDERS);
        GuiUtils.updateButtonText(jButton3, "module.repSearch.tab.source.addFoldersButton", new Object[0]);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(Settings.getString("settings.folders.defaultReplay"));
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectFoldersToAdd"));
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(true);
                if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        ((DefaultListModel)ReplaySearch.this.sourceList.getModel()).addElement(file);
                        ++n2;
                    }
                    if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                        ReplaySearch.this.sortSources();
                    }
                }
            }
        });
        box2.add(jButton3);
        JButton jButton4 = new JButton(Icons.SC2);
        GuiUtils.updateButtonText(jButton4, "module.repSearch.tab.source.addFilesButton", new Object[0]);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(Settings.getString("settings.folders.defaultReplay"));
                jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectReplaysToAdd"));
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
                jFileChooser.setAccessory(GuiUtils.createReplayFilePreviewAccessory(jFileChooser));
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        ((DefaultListModel)ReplaySearch.this.sourceList.getModel()).addElement(file);
                        ++n2;
                    }
                    if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                        ReplaySearch.this.sortSources();
                    }
                }
            }
        });
        box2.add(jButton4);
        box.add(box2);
        box2 = Box.createHorizontalBox();
        JButton jButton5 = new JButton(Icons.BINOCULAR_ARROW);
        GuiUtils.updateButtonText(jButton5, "module.repSearch.tab.source.listAllReplays", new Object[0]);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaySearch.this.temporarilyDisableFilters = true;
                ReplaySearch.this.performSearchButton.doClick();
            }
        });
        box2.add(jButton5);
        box.add(box2);
        jPanel.add((Component)box, "North");
        jPanel.add((Component)new JScrollPane(this.sourceList), "Center");
        this.sourceList.setOpaque(false);
        JPanel jPanel2 = new JPanel(new GridLayout(5, 1));
        final JButton jButton6 = new JButton(Icons.SORT_ALPHABET);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton6.setEnabled(!ReplaySearch.this.autoSortSourcesCheckBox.isSelected());
                if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                    ReplaySearch.this.sortSources();
                }
            }
        };
        actionListener.actionPerformed(null);
        this.autoSortSourcesCheckBox.addActionListener(actionListener);
        jPanel2.add(this.autoSortSourcesCheckBox);
        GuiUtils.updateButtonText(jButton6, "module.repSearch.tab.source.sortButton", new Object[0]);
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaySearch.this.sortSources();
            }
        });
        jPanel2.add(jButton6);
        JButton jButton7 = new JButton(Icons.TABLE_DELETE_ROW);
        GuiUtils.updateButtonText(jButton7, "module.repSearch.tab.source.removeSelectedButton", new Object[0]);
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                int[] nArray = ReplaySearch.this.sourceList.getSelectedIndices();
                int n = nArray.length - 1;
                while (n >= 0) {
                    defaultListModel.remove(nArray[n]);
                    --n;
                }
            }
        });
        jPanel2.add(jButton7);
        JButton jButton8 = new JButton(Icons.BROOM);
        GuiUtils.updateButtonText(jButton8, "module.repSearch.tab.source.purgeButton", new Object[0]);
        jButton8.setToolTipText(Language.getText("module.repSearch.tab.source.purgeButtonToopTip"));
        jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                int n = defaultListModel.getSize() - 1;
                while (n >= 0) {
                    File file = (File)defaultListModel.get(n);
                    if (file.exists()) {
                        int n2 = defaultListModel.getSize() - 1;
                        while (n2 >= 0) {
                            if (n2 != n && GeneralUtils.isDescendant((File)defaultListModel.get(n2), file)) {
                                defaultListModel.remove(n);
                                break;
                            }
                            --n2;
                        }
                    } else {
                        defaultListModel.remove(n);
                    }
                    --n;
                }
            }
        });
        jPanel2.add(jButton8);
        jPanel.add((Component)GuiUtils.wrapInPanel(jPanel2), "East");
        return jPanel;
    }

    private void loadReplaySourceFile(File file) {
        block13: {
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    DefaultListModel defaultListModel = (DefaultListModel)this.sourceList.getModel();
                    defaultListModel.removeAllElements();
                    while (bufferedReader.ready()) {
                        defaultListModel.addElement(new File(bufferedReader.readLine()));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.source.failedToLoadRepSource"));
                    if (bufferedReader == null) break block13;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void saveReplaySourceFile(File file) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(file, "UTF-8");
                ListModel listModel = this.sourceList.getModel();
                int n = listModel.getSize();
                int n2 = 0;
                while (n2 < n) {
                    printWriter.println(listModel.getElementAt(n2));
                    ++n2;
                }
                printWriter.flush();
                MainFrame.INSTANCE.refreshNavigationTree();
                GuiUtils.showInfoDialog(Language.getText("module.repSearch.tab.source.repSourceSaved"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.source.failedToSaveRepSource"));
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private List<Object[]> loadReplayListFile(File file) {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            bufferedReader.readLine();
            String[] stringArray = bufferedReader.readLine().split(";");
            int[] nArray = new int[RESULT_HEADER_KEYS.length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = -1;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (RESULT_HEADER_KEYS[n].equals(stringArray[n3])) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
                nArray[n] = n2;
                ++n;
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            while ((string = bufferedReader.readLine()) != null) {
                Object[] objectArray = new Object[RESULT_HEADER_KEYS.length];
                String[] stringArray2 = GeneralUtils.splitBySemicolon(string);
                int n4 = RESULT_HEADER_KEYS.length - 1;
                while (n4 >= 0) {
                    objectArray[n4] = nArray[n4] < 0 ? "" : stringArray2[nArray[n4]];
                    --n4;
                }
                arrayList.add(objectArray);
            }
            ArrayList<Object[]> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.results.failedToLoadRepList"));
            return null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void saveReplayListFile(File file, List<Object[]> list) {
        PrintWriter printWriter = null;
        try {
            try {
                Object[] objectArray;
                printWriter = new PrintWriter(file, "UTF-8");
                String[] stringArray = RESULT_HEADER_NAMES;
                int n = RESULT_HEADER_NAMES.length;
                int n2 = 0;
                while (n2 < n) {
                    objectArray = stringArray[n2];
                    printWriter.print(objectArray.replace(';', '_'));
                    printWriter.print(';');
                    ++n2;
                }
                printWriter.println();
                stringArray = RESULT_HEADER_KEYS;
                n = RESULT_HEADER_KEYS.length;
                n2 = 0;
                while (n2 < n) {
                    objectArray = stringArray[n2];
                    printWriter.print((String)objectArray);
                    printWriter.print(';');
                    ++n2;
                }
                printWriter.println();
                Iterator<Object[]> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray2 = objectArray = iterator.next();
                    int n3 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = objectArray2[n4];
                        printWriter.print(((String)object).replace(';', '_'));
                        printWriter.print(';');
                        ++n4;
                    }
                    printWriter.println();
                }
                printWriter.flush();
                MainFrame.INSTANCE.refreshNavigationTree();
                GuiUtils.showInfoDialog(Language.getText("module.repSearch.tab.results.repListSaved"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.results.failedToSaveRepList"));
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void sortSources() {
        ListModel listModel = this.sourceList.getModel();
        File[] fileArray = new File[listModel.getSize()];
        int n = fileArray.length - 1;
        while (n >= 0) {
            fileArray[n] = (File)listModel.getElementAt(n);
            --n;
        }
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                if (file.isDirectory() && !file2.isDirectory()) {
                    return -1;
                }
                if (!file.isDirectory() && file2.isDirectory()) {
                    return 1;
                }
                return file.compareTo(file2);
            }
        });
        DefaultListModel<File> defaultListModel = new DefaultListModel<File>();
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray2[n3];
            defaultListModel.addElement(file);
            ++n3;
        }
        this.sourceList.setModel(defaultListModel);
    }

    private JComponent createFiltersTab(final JTabbedPane jTabbedPane) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout()){

            @Override
            public void setUI(PanelUI panelUI) {
                super.setUI(panelUI);
                if (ReplaySearch.this.searchFieldGroups != null) {
                    ReplaySearch.this.packSearchFields();
                }
            }
        };
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        this.searchFieldGroups = new SearchFieldGroup[]{new SearchFieldGroup(jScrollPane, FileNameSearchField.class), new SearchFieldGroup(jScrollPane, MapNameSearchField.class), new SearchFieldGroup(jScrollPane, PlayerNameSearchField.class), new SearchFieldGroup(jScrollPane, ChatMessageSearchField.class), new SearchFieldGroup(jScrollPane, RaceMatchupSearchField.class), new SearchFieldGroup(jScrollPane, FormatSearchField.class), new SearchFieldGroup(jScrollPane, GameTypeSearchField.class), new SearchFieldGroup(jScrollPane, GatewaySearchField.class), new SearchFieldGroup(jScrollPane, DateSearchField.class), new SearchFieldGroup(jScrollPane, GameLengthSearchField.class), new SearchFieldGroup(jScrollPane, VersionSearchField.class), new SearchFieldGroup(jScrollPane, BuildOrderSearchField.class), new SearchFieldGroup(jScrollPane, BuildingSearchField.class), new SearchFieldGroup(jScrollPane, UnitSearchField.class), new SearchFieldGroup(jScrollPane, ResearchSearchField.class), new SearchFieldGroup(jScrollPane, UpgradeSearchField.class), new SearchFieldGroup(jScrollPane, UnitAbilitySearchField.class), new SearchFieldGroup(jScrollPane, BuildingAbilitySearchField.class)};
        Box box = Box.createHorizontalBox();
        GuiUtils.updateButtonText(this.performSearchButton, "module.repSearch.tab.filters.performSearchButton", new Object[0]);
        this.performSearchButton.addActionListener(new ActionListener(){
            private int resultsTabCounter = 1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ReplaySearch.this.temporarilyDisableFilters) {
                    ReplaySearch.this.temporarilyDisableFilters = false;
                } else {
                    boolean bl = true;
                    SearchFieldGroup[] searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                    int n = searchFieldGroupArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
                        bl &= searchFieldGroup.validateAll();
                        ++n2;
                    }
                    if (!bl) {
                        GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.filters.invalidFieldsError"));
                        return;
                    }
                }
                Object[] objectArray = ReplaySearch.this.createResultsTab(ReplaySearch.this.searchFieldGroups);
                GuiUtils.addNewTab(Language.getText("module.repSearch.tab.results.title", this.resultsTabCounter++), Icons.TABLE, true, jTabbedPane, (JComponent)objectArray[0], (Runnable)objectArray[1]);
                jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
            }
        });
        box.add(this.performSearchButton);
        JButton jButton = new JButton(Icons.CROSS_WHITE);
        GuiUtils.updateButtonText(jButton, "module.repSearch.tab.filters.resetFieldsButton", new Object[0]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFieldGroup[] searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                int n = searchFieldGroupArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
                    for (SearchField searchField : searchFieldGroup.searchFieldList) {
                        searchField.reset();
                    }
                    ++n2;
                }
            }
        });
        box.add(jButton);
        jPanel.add((Component)GuiUtils.wrapInPanel(box), "North");
        Box box2 = Box.createVerticalBox();
        SearchFieldGroup[] searchFieldGroupArray = this.searchFieldGroups;
        int n = this.searchFieldGroups.length;
        int n2 = 0;
        while (n2 < n) {
            SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
            box2.add(searchFieldGroup.uiComponent);
            ++n2;
        }
        this.packSearchFields();
        jPanel2.add((Component)box2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void packSearchFields() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchFieldGroup searchFieldGroup;
                int n = 0;
                SearchFieldGroup[] searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                int n2 = searchFieldGroupArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    searchFieldGroup = searchFieldGroupArray[n3];
                    for (SearchField searchField : searchFieldGroup.searchFieldList) {
                        searchField.displayLabel.setPreferredSize(null);
                        n = Math.max(n, searchField.displayLabel.getPreferredSize().width);
                    }
                    ++n3;
                }
                searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                n2 = searchFieldGroupArray.length;
                n3 = 0;
                while (n3 < n2) {
                    searchFieldGroup = searchFieldGroupArray[n3];
                    for (SearchField searchField : searchFieldGroup.searchFieldList) {
                        searchField.displayLabel.setPreferredSize(new Dimension(n, searchField.displayLabel.getPreferredSize().height));
                        searchField.displayLabel.invalidate();
                    }
                    searchFieldGroup.parentToNotify.validate();
                    ++n3;
                }
            }
        });
    }

    private Object[] createResultsTab(SearchFieldGroup[] searchFieldGroupArray) {
        Object object;
        Object object2;
        Object object3;
        ListModel listModel = this.sourceList.getModel();
        File[] fileArray = new File[listModel.getSize()];
        int n = fileArray.length - 1;
        while (n >= 0) {
            fileArray[n] = (File)listModel.getElementAt(n);
            --n;
        }
        EnumSet<ReplayParser.ReplayContent> enumSet = EnumSet.copyOf(ReplayParser.GENERAL_INFO_CONTENT);
        ArrayList<ReplayFilter[]> arrayList = new ArrayList<ReplayFilter[]>();
        Object object4 = searchFieldGroupArray;
        int n2 = searchFieldGroupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object3 = object4[n3];
            object2 = ((SearchFieldGroup)object3).getReplayFilters();
            if (object2 != null) {
                arrayList.add((ReplayFilter[])object2);
                object = object2[0].getRequiredReplayContentSet();
                if (object != null) {
                    enumSet.addAll((Collection<ReplayParser.ReplayContent>)object);
                }
            }
            ++n3;
        }
        object3 = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        final JTable jTable = new JTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.getColumnModel().getColumn(n2).getModelIndex() == COMMENT_COLUMN_INDEX;
            }
        };
        object4 = Box.createHorizontalBox();
        object2 = new JButton(Icons.CROSS_OCTAGON);
        GuiUtils.updateButtonText((AbstractButton)object2, "module.repSearch.tab.results.abortButton", new Object[0]);
        ((Container)object4).add((Component)object2);
        object = new JButton(Icons.DISK);
        GuiUtils.updateButtonText((AbstractButton)object, "module.repSearch.tab.results.saveButton", new Object[0]);
        ((AbstractButton)object).setEnabled(false);
        ((Container)object4).add((Component)object);
        JButton jButton = new JButton(Icons.FOLDER_OPEN);
        GuiUtils.updateButtonText(jButton, "module.repSearch.tab.results.loadButton", new Object[0]);
        jButton.setEnabled(false);
        ((Container)object4).add(jButton);
        JButton jButton2 = new JButton(Icons.TABLE_EXPORT);
        GuiUtils.updateButtonText(jButton2, "module.repSearch.tab.results.setAsSourceButton", new Object[0]);
        jButton2.setToolTipText(Language.getText("module.repSearch.tab.results.setAsSourceToolTip"));
        jButton2.setEnabled(false);
        ((Container)object4).add(jButton2);
        JButton jButton3 = new JButton(Icons.CHART_UP_COLOR);
        GuiUtils.updateButtonText(jButton3, "module.repSearch.tab.results.multiRepAnalysisButton", new Object[0]);
        jButton3.setToolTipText(Language.getText("module.repSearch.tab.results.multiRepAnalysisToolTip"));
        jButton3.setEnabled(false);
        ((Container)object4).add(jButton3);
        final JCheckBox jCheckBox = GuiUtils.createCheckBox("module.repSearch.tab.results.stretchToWindow", "module.repSearch.results.stretchToWindow");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTable.setAutoResizeMode(jCheckBox.isSelected() ? 4 : 0);
            }
        };
        actionListener.actionPerformed(null);
        jCheckBox.addActionListener(actionListener);
        ((Container)object4).add(jCheckBox);
        box.add((Component)object4);
        JProgressBar jProgressBar = new JProgressBar();
        box.add(jProgressBar);
        ((Container)object3).add((Component)box, "North");
        Box box2 = Box.createVerticalBox();
        ((DefaultTableModel)jTable.getModel()).setColumnIdentifiers(RESULT_HEADER_NAMES);
        jTable.setAutoCreateRowSorter(true);
        box2.add(jTable.getTableHeader());
        box2.add(new JScrollPane(jTable));
        ((Container)object3).add((Component)box2, "Center");
        final NormalThread normalThread = new NormalThread("Replay search", (JButton)object2, jTable, (JButton)object, jButton, jButton2, jButton3, jProgressBar, fileArray, (Box)object4, (JPanel)object3, enumSet, arrayList){
            private volatile boolean aborted;
            private final List<Object[]> resultList;
            private int replaysCount;
            private int searchedCount;
            private int skippedCount;
            private final /* synthetic */ JButton val$abortButton;
            private final /* synthetic */ JTable val$resultsTable;
            private final /* synthetic */ JButton val$saveReplayListButton;
            private final /* synthetic */ JButton val$loadReplayListButton;
            private final /* synthetic */ JButton val$setAsSourceButton;
            private final /* synthetic */ JButton val$multiRepAnalysisButton;
            private final /* synthetic */ JProgressBar val$progressBar;
            private final /* synthetic */ File[] val$sources;
            private final /* synthetic */ Box val$buttonsBox;
            private final /* synthetic */ JPanel val$resultsPanel;
            private final /* synthetic */ Set val$requiredReplayContentSetForSearch;
            private final /* synthetic */ List val$replayFiltersList;
            {
                this.val$abortButton = jButton;
                this.val$resultsTable = jTable;
                this.val$saveReplayListButton = jButton2;
                this.val$loadReplayListButton = jButton3;
                this.val$setAsSourceButton = jButton4;
                this.val$multiRepAnalysisButton = jButton5;
                this.val$progressBar = jProgressBar;
                this.val$sources = fileArray;
                this.val$buttonsBox = box;
                this.val$resultsPanel = jPanel;
                this.val$requiredReplayContentSetForSearch = set;
                this.val$replayFiltersList = list;
                super(string);
                this.resultList = new ArrayList<Object[]>();
            }

            @Override
            public void run() {
                InternalFrameAdapter internalFrameAdapter = new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                        val$abortButton.doClick();
                    }
                };
                ReplaySearch.this.addInternalFrameListener(internalFrameAdapter);
                this.val$abortButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        val$buttonsBox.remove(val$abortButton);
                        val$resultsPanel.validate();
                        aborted = true;
                    }
                });
                this.val$resultsTable.getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        if (tableModelEvent.getColumn() >= 0 && val$resultsTable.getColumnModel().getColumn(tableModelEvent.getColumn()).getModelIndex() == COMMENT_COLUMN_INDEX) {
                            RowSorter<? extends TableModel> rowSorter = val$resultsTable.getRowSorter();
                            int n = rowSorter.convertRowIndexToModel(tableModelEvent.getFirstRow());
                            ((Object[])(this).resultList.get((int)n))[COMMENT_COLUMN_INDEX] = val$resultsTable.getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                        }
                    }
                });
                this.val$saveReplayListButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = new JFileChooser("User Content/Replay lists");
                        jFileChooser.setDialogTitle(Language.getText("module.repSearch.tab.results.selectSaveReplayList"));
                        jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_LIST_FILE_FILTER);
                        jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                        if (jFileChooser.showSaveDialog(MainFrame.INSTANCE) == 0) {
                            File file = jFileChooser.getSelectedFile();
                            if (!GuiUtils.SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                                file = new File(String.valueOf(file.getAbsolutePath()) + ".csv");
                            }
                            ReplaySearch.this.saveReplayListFile(file, resultList);
                        }
                    }
                });
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object;
                        File file = null;
                        if (actionEvent == null) {
                            file = ReplaySearch.this.initialReplayList;
                            ReplaySearch.this.initialReplayList = null;
                        } else {
                            object = new JFileChooser("User Content/Replay lists");
                            ((JFileChooser)object).setDialogTitle(Language.getText("module.repSearch.tab.results.selectLoadReplayList"));
                            ((JFileChooser)object).setFileFilter(GuiUtils.SC2_REPLAY_LIST_FILE_FILTER);
                            ((JFileChooser)object).setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                            if (((JFileChooser)object).showOpenDialog(MainFrame.INSTANCE) == 0) {
                                file = ((JFileChooser)object).getSelectedFile();
                            }
                        }
                        if (file != null) {
                            val$buttonsBox.remove(val$abortButton);
                            val$resultsPanel.validate();
                            val$progressBar.setString(Language.getText("module.repSearch.tab.results.loadingReplayList", file.getName()));
                            object = ReplaySearch.this.loadReplayListFile(file);
                            if (object != null) {
                                resultList.clear();
                                resultList.addAll(object);
                                this.refreshTableFromResultList();
                            }
                            val$progressBar.setMaximum(resultList.size());
                            val$progressBar.setValue(resultList.size());
                            val$progressBar.setString(Language.getText("module.repSearch.tab.results.loadResult", resultList.size()));
                            val$saveReplayListButton.setEnabled(true);
                            val$loadReplayListButton.setEnabled(true);
                            val$setAsSourceButton.setEnabled(true);
                            val$multiRepAnalysisButton.setEnabled(true);
                        }
                    }
                };
                this.val$loadReplayListButton.addActionListener(actionListener);
                this.val$setAsSourceButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                        defaultListModel.removeAllElements();
                        for (Object[] objectArray : resultList) {
                            defaultListModel.addElement(new File((String)objectArray[FILE_NAME_COLUMN_INDEX]));
                        }
                    }
                });
                this.val$multiRepAnalysisButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        File[] fileArray = new File[resultList.size()];
                        int n = 0;
                        for (Object[] objectArray : resultList) {
                            fileArray[n++] = new File((String)objectArray[FILE_NAME_COLUMN_INDEX]);
                        }
                        MainFrame.INSTANCE.openReplaysInMultiRepAnalysis(fileArray);
                    }
                });
                this.val$progressBar.setStringPainted(true);
                if (ReplaySearch.this.initialReplayList != null) {
                    actionListener.actionPerformed(null);
                } else {
                    File file;
                    this.val$progressBar.setString(Language.getText("module.repSearch.tab.results.countingReplays"));
                    File[] fileArray = this.val$sources;
                    int n = this.val$sources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        file = fileArray[n2];
                        if (this.aborted) break;
                        this.replaysCount += this.countReplays(file);
                        ++n2;
                    }
                    if (this.aborted) {
                        this.val$progressBar.setString(String.valueOf(Language.getText("module.repSearch.tab.results.searchAborted")) + " [" + this.val$progressBar.getString() + "]");
                        this.val$loadReplayListButton.setEnabled(true);
                    } else {
                        this.val$progressBar.setMaximum(this.replaysCount);
                        this.updateProgressBar();
                        fileArray = this.val$sources;
                        n = this.val$sources.length;
                        n2 = 0;
                        while (n2 < n) {
                            file = fileArray[n2];
                            if (this.aborted) break;
                            this.searchReplays(file);
                            ++n2;
                        }
                        if (this.aborted) {
                            this.val$progressBar.setString(String.valueOf(Language.getText("module.repSearch.tab.results.searchAborted")) + " [" + this.val$progressBar.getString() + "]");
                        } else {
                            this.val$buttonsBox.remove(this.val$abortButton);
                            this.val$resultsPanel.validate();
                        }
                        this.val$saveReplayListButton.setEnabled(true);
                        this.val$loadReplayListButton.setEnabled(true);
                        this.val$setAsSourceButton.setEnabled(true);
                        this.val$multiRepAnalysisButton.setEnabled(true);
                        this.refreshTableFromResultList();
                    }
                }
                this.val$resultsTable.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() == 3) {
                            int[] nArray;
                            if (val$resultsTable.getSelectedRow() < 0) {
                                int n = val$resultsTable.rowAtPoint(mouseEvent.getPoint());
                                val$resultsTable.getSelectionModel().setSelectionInterval(n, n);
                            }
                            if ((nArray = val$resultsTable.getSelectedRows()).length > 0) {
                                Object object;
                                final File[] fileArray = new File[nArray.length];
                                int n = nArray.length - 1;
                                while (n >= 0) {
                                    object = val$resultsTable.getRowSorter();
                                    nArray[n] = ((RowSorter)object).convertRowIndexToModel(nArray[n]);
                                    fileArray[n] = new File((String)((Object[])resultList.get(nArray[n]))[FILE_NAME_COLUMN_INDEX]);
                                    --n;
                                }
                                ReplayOperationsPopupMenu replayOperationsPopupMenu = new ReplayOperationsPopupMenu(fileArray, new ReplayOperationsPopupMenu.ReplayOpCallback(){
                                    final List<Object[]> removedList = new ArrayList<Object[]>();

                                    @Override
                                    public void replayRenamed(File file, File file2, int n) {
                                        ((Object[])((this).this).resultList.get((int)nArray[n]))[FILE_NAME_COLUMN_INDEX] = file2.getAbsolutePath();
                                    }

                                    @Override
                                    public void replayMoved(File file, File file2, int n) {
                                        ((Object[])((this).this).resultList.get((int)nArray[n]))[FILE_NAME_COLUMN_INDEX] = new File(file2, file.getName()).getAbsolutePath();
                                    }

                                    @Override
                                    public void replayDeleted(File file, int n) {
                                        this.removedList.add((Object[])resultList.get(nArray[n]));
                                    }

                                    @Override
                                    public void moveRenameDeleteEnded() {
                                        if (!this.removedList.isEmpty()) {
                                            resultList.removeAll(this.removedList);
                                        }
                                        this.refreshTableFromResultList();
                                    }
                                });
                                replayOperationsPopupMenu.addSeparator();
                                object = new JMenuItem(Icons.TABLE_DELETE_ROW);
                                ((AbstractButton)object).setText(Language.getText("module.repSearch.tab.results.removeSelectedMenuItem"));
                                ((AbstractButton)object).addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        Arrays.sort(nArray);
                                        int n = nArray.length - 1;
                                        while (n >= 0) {
                                            resultList.remove(nArray[n]);
                                            --n;
                                        }
                                        this.refreshTableFromResultList();
                                    }
                                });
                                replayOperationsPopupMenu.add((JMenuItem)object);
                                JMenuItem jMenuItem = new JMenuItem(Icons.TABLE_EXPORT);
                                jMenuItem.setText(Language.getText("module.repSearch.tab.results.setSelectedAsSourceMenuItem"));
                                jMenuItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        DefaultListModel defaultListModel = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                                        defaultListModel.removeAllElements();
                                        File[] fileArray2 = fileArray;
                                        int n = fileArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            File file = fileArray2[n2];
                                            defaultListModel.addElement(file);
                                            ++n2;
                                        }
                                    }
                                });
                                replayOperationsPopupMenu.add(jMenuItem);
                                replayOperationsPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        }
                        if (mouseEvent.getButton() == 1 && val$resultsTable.getSelectedRow() >= 0 && mouseEvent.getClickCount() == 2) {
                            MainFrame.INSTANCE.openReplayFile(new File((String)((Object[])resultList.get(val$resultsTable.getRowSorter().convertRowIndexToModel(val$resultsTable.rowAtPoint(mouseEvent.getPoint()))))[FILE_NAME_COLUMN_INDEX]));
                        }
                    }
                });
                ReplaySearch.this.removeInternalFrameListener(internalFrameAdapter);
            }

            private int countReplays(File file) {
                if (file.isFile()) {
                    return GuiUtils.SC2_REPLAY_FILTER.accept(file) ? 1 : 0;
                }
                File[] fileArray = file.listFiles();
                int n = 0;
                if (fileArray != null) {
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File file2 = fileArray2[n3];
                        if (this.aborted) {
                            return 0;
                        }
                        n += this.countReplays(file2);
                        ++n3;
                    }
                }
                return n;
            }

            private void searchReplays(File file) {
                if (file.isFile()) {
                    if (GuiUtils.SC2_REPLAY_FILTER.accept(file)) {
                        ++this.searchedCount;
                        Replay replay = ReplayParser.parseReplay(file.getAbsolutePath(), this.val$requiredReplayContentSetForSearch);
                        if (replay != null) {
                            boolean bl = true;
                            for (ReplayFilter[] replayFilterArray : this.val$replayFiltersList) {
                                boolean bl2 = false;
                                ReplayFilter[] replayFilterArray2 = replayFilterArray;
                                int n = replayFilterArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ReplayFilter replayFilter = replayFilterArray2[n2];
                                    if (replayFilter.accept(file, replay)) {
                                        bl2 = true;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (bl2) continue;
                                bl = false;
                                break;
                            }
                            if (bl) {
                                this.resultList.add(new Object[]{replay.version, replay.initData.gameType.toString(), replay.initData.gateway == null ? "" : replay.initData.gateway.toString(), Language.formatDateTime(new Date(file.lastModified())), replay.details.mapName, replay.details.getRaceMatchup(), ReplayUtils.formatMs(replay.gameLength * 500), replay.details.getPlayerNames(), file.getAbsolutePath(), ""});
                            }
                        } else {
                            ++this.skippedCount;
                        }
                        this.updateProgressBar();
                    }
                } else {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        File[] fileArray2 = fileArray;
                        int n = fileArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            File file2 = fileArray2[n3];
                            if (this.aborted) {
                                return;
                            }
                            this.searchReplays(file2);
                            ++n3;
                        }
                    }
                }
            }

            private void updateProgressBar() {
                this.val$progressBar.setValue(this.searchedCount);
                this.val$progressBar.setString(Language.getText("module.repSearch.tab.results.searchStatus", this.resultList.size(), this.searchedCount, this.skippedCount, this.replaysCount, this.replaysCount == 0 ? 100 : 100 * this.searchedCount / this.replaysCount));
            }

            private void refreshTableFromResultList() {
                DefaultTableModel defaultTableModel = (DefaultTableModel)this.val$resultsTable.getModel();
                defaultTableModel.setDataVector((Object[][])this.resultList.toArray((T[])new Object[this.resultList.size()][]), RESULT_HEADER_NAMES);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GuiUtils.packTable(val$resultsTable);
                    }
                });
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                normalThread.start();
            }
        });
        return new Object[]{object3, new Runnable((JButton)object2){
            private final /* synthetic */ JButton val$abortButton;
            {
                this.val$abortButton = jButton;
            }

            @Override
            public void run() {
                this.val$abortButton.doClick();
            }
        }};
    }
}

