/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.multirepanal;

import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartSegmentStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.MultiRepAnalysis;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlayerGameParticipationStats;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlayerStatistics;
import hu.belicza.andras.sc2gears.util.IntHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

class ChartData {
    public final MultiRepAnalysis.ChartGranularity chartGranularity;
    public final ChartSegmentStatistics[] segmentStats;

    public ChartData(PlayerStatistics playerStatistics, MultiRepAnalysis.ChartGranularity chartGranularity) {
        int n;
        this.chartGranularity = chartGranularity;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(playerStatistics.firstDate);
        int n2 = playerStatistics.getPresence();
        switch (chartGranularity) {
            default: {
                n = n2;
                break;
            }
            case WEEK: {
                n = 2 + n2 / 7;
                gregorianCalendar.set(7, 2);
                break;
            }
            case MONTH: {
                n = 2 + n2 / 31;
                gregorianCalendar.set(5, 1);
                break;
            }
            case YEAR: {
                n = 2 + n2 / 366;
                gregorianCalendar.set(6, 1);
            }
        }
        if (n == 1) {
            n = 3;
        }
        ArrayList<Date> arrayList = new ArrayList<Date>(n);
        while (!gregorianCalendar.getTime().after(playerStatistics.lastDate)) {
            arrayList.add(gregorianCalendar.getTime());
            switch (chartGranularity) {
                case DAY: {
                    gregorianCalendar.add(5, 1);
                    break;
                }
                case WEEK: {
                    gregorianCalendar.add(5, 7);
                    break;
                }
                case MONTH: {
                    gregorianCalendar.add(2, 1);
                    break;
                }
                case YEAR: {
                    gregorianCalendar.add(1, 1);
                }
            }
        }
        if (arrayList.size() == 1) {
            arrayList.add(gregorianCalendar.getTime());
            switch (chartGranularity) {
                case DAY: {
                    gregorianCalendar.add(5, -2);
                    break;
                }
                case WEEK: {
                    gregorianCalendar.add(5, -14);
                    break;
                }
                case MONTH: {
                    gregorianCalendar.add(2, -2);
                    break;
                }
                case YEAR: {
                    gregorianCalendar.add(1, -2);
                }
            }
            arrayList.add(0, gregorianCalendar.getTime());
        }
        this.segmentStats = new ChartSegmentStatistics[arrayList.size()];
        int n3 = this.segmentStats.length - 1;
        while (n3 >= 0) {
            this.segmentStats[n3] = new ChartSegmentStatistics((Date)arrayList.get(n3));
            --n3;
        }
        n3 = this.segmentStats.length - 1;
        int n4 = 0;
        for (PlayerGameParticipationStats playerGameParticipationStats : playerStatistics.playerGameParticipationStatsList) {
            while (n4 < n3 && !this.segmentStats[n4 + 1].lowerDate.after(playerGameParticipationStats.date)) {
                ++n4;
            }
            ChartSegmentStatistics chartSegmentStatistics = this.segmentStats[n4];
            ++chartSegmentStatistics.record.totalGames;
            if (playerGameParticipationStats.isWinner != null) {
                if (playerGameParticipationStats.isWinner.booleanValue()) {
                    ++chartSegmentStatistics.record.wins;
                } else {
                    ++chartSegmentStatistics.record.losses;
                }
            }
            chartSegmentStatistics.totalTimeSecInGames += (long)playerGameParticipationStats.timeSecInGame;
            chartSegmentStatistics.totalActions += (long)playerGameParticipationStats.actions;
            IntHolder intHolder = chartSegmentStatistics.raceDistributionMap.get((Object)playerGameParticipationStats.race);
            if (intHolder == null) {
                chartSegmentStatistics.raceDistributionMap.put(playerGameParticipationStats.race, new IntHolder(1));
                continue;
            }
            ++intHolder.value;
        }
    }
}

