/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ReplayOperationsPopupMenu
extends JPopupMenu
implements ActionListener {
    public final JMenuItem openInAnalyzerMenuItem = new JMenuItem(Language.getText("replayops.openInAnalyzer"), Icons.CHART);
    public final JMenuItem openInMultiRepAnalMenuItem = new JMenuItem(Language.getText("replayops.openInMultiRepAnal"), Icons.CHART_UP_COLOR);
    public final JMenuItem watchReplayMenuItem = new JMenuItem(Language.getText("replayops.watchReplay"), Icons.WATCH_REPLAY);
    public final JMenuItem copyReplaysMenuItem = new JMenuItem(Language.getText("replayops.copyReplays"), Icons.DOCUMENT_COPY);
    public final JMenuItem moveReplaysMenuItem = new JMenuItem(Language.getText("replayops.moveReplays"), Icons.DOCUMENT_EXPORT);
    public final JMenuItem packReplaysMenuItem = new JMenuItem(Language.getText("replayops.packReplays"), Icons.DOCUMENT_ZIPPER);
    public final JMenuItem renameReplaysMenuItem = new JMenuItem(Language.getText("replayops.renameReplays"), Icons.DOCUMENT_RENAME);
    public final JMenuItem deleteReplaysMenuItem = new JMenuItem(Language.getText("replayops.deleteReplays"), Icons.CROSS);
    public final JMenuItem openReplaysFolderMenuItem = new JMenuItem(Language.getText("replayops.openReplaysFolder"), Icons.FOLDER_OPEN);
    private final File[] files;
    private final ReplayOpCallback replayOpCallback;

    public ReplayOperationsPopupMenu(File[] fileArray, ReplayOpCallback replayOpCallback) {
        this.files = fileArray;
        this.replayOpCallback = replayOpCallback;
        this.openInAnalyzerMenuItem.addActionListener(this);
        this.add(this.openInAnalyzerMenuItem);
        this.openInMultiRepAnalMenuItem.addActionListener(this);
        this.add(this.openInMultiRepAnalMenuItem);
        this.watchReplayMenuItem.addActionListener(this);
        this.add(this.watchReplayMenuItem);
        this.addSeparator();
        this.copyReplaysMenuItem.addActionListener(this);
        this.add(this.copyReplaysMenuItem);
        this.moveReplaysMenuItem.addActionListener(this);
        this.add(this.moveReplaysMenuItem);
        this.packReplaysMenuItem.addActionListener(this);
        this.add(this.packReplaysMenuItem);
        this.renameReplaysMenuItem.addActionListener(this);
        this.add(this.renameReplaysMenuItem);
        this.deleteReplaysMenuItem.addActionListener(this);
        this.add(this.deleteReplaysMenuItem);
        this.addSeparator();
        this.openReplaysFolderMenuItem.setEnabled(Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN));
        this.openReplaysFolderMenuItem.addActionListener(this);
        this.add(this.openReplaysFolderMenuItem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block69: {
            Object object;
            if (actionEvent.getSource() == this.openInAnalyzerMenuItem) {
                MainFrame.INSTANCE.openReplayFile(this.files[0]);
                return;
            }
            if (actionEvent.getSource() == this.openInMultiRepAnalMenuItem) {
                MainFrame.INSTANCE.openReplaysInMultiRepAnalysis(this.files);
                return;
            }
            if (actionEvent.getSource() == this.watchReplayMenuItem) {
                try {
                    Runtime.getRuntime().exec(new String[]{new File(Settings.getString("settings.folders.sc2Installation"), GeneralUtils.isOsMac() ? "StarCraft II.app/Contents/MacOS/StarCraft II" : "StarCraft II.exe").getAbsolutePath(), this.files[0].getAbsolutePath()});
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            if (actionEvent.getSource() != this.copyReplaysMenuItem && actionEvent.getSource() != this.moveReplaysMenuItem && actionEvent.getSource() != this.deleteReplaysMenuItem) break block69;
            boolean bl = actionEvent.getSource() == this.copyReplaysMenuItem;
            boolean bl2 = actionEvent.getSource() == this.moveReplaysMenuItem;
            boolean bl3 = actionEvent.getSource() == this.deleteReplaysMenuItem;
            boolean bl4 = bl || bl2;
            boolean bl5 = bl2 || bl3;
            File file = null;
            if (bl4) {
                object = new JFileChooser();
                ((JFileChooser)object).setFileSelectionMode(1);
                ((JFileChooser)object).setDialogTitle(Language.getText(bl ? "replayops.selectCopyTargetFolder" : "replayops.selectMoveTargetFolder"));
                ((JFileChooser)object).setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (((JFileChooser)object).showOpenDialog(MainFrame.INSTANCE) != 0) return;
                file = ((JFileChooser)object).getSelectedFile();
            } else if (GuiUtils.showConfirmDialog(Language.getText("replayops.deleteConfirmation", this.files.length), true) != 0) {
                return;
            }
            object = new byte[16384];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.files.length) {
                block71: {
                    File file2;
                    block70: {
                        file2 = this.files[n3];
                        if (!bl4) break block70;
                        if (!GeneralUtils.copyFile(file2, file, (byte[])object, null)) break block71;
                        ++n;
                    }
                    if (bl5) {
                        if (file2.delete()) {
                            if (!bl2 && this.replayOpCallback != null) {
                                this.replayOpCallback.replayDeleted(file2, n3);
                            }
                            ++n2;
                        }
                        if (bl2 && this.replayOpCallback != null) {
                            this.replayOpCallback.replayMoved(file2, file, n3);
                        }
                    }
                }
                ++n3;
            }
            if (this.replayOpCallback != null) {
                this.replayOpCallback.moveRenameDeleteEnded();
            }
            ArrayList<String> arrayList = new ArrayList<String>(3);
            if (bl) {
                arrayList.add(Language.getText("replayops.successfullyCopied", n));
                if (n < this.files.length) {
                    arrayList.add(Language.getText("replayops.failedToCopy", this.files.length - n));
                }
            } else if (bl2) {
                arrayList.add(Language.getText("replayops.successfullyMoved", n2));
                if (n2 < n) {
                    arrayList.add(Language.getText("replayops.successfullyCopied", n - n2));
                    arrayList.add(Language.getText("replayops.failedToDelete", n - n2));
                }
                if (n < this.files.length) {
                    arrayList.add(Language.getText("replayops.failedToCopy", this.files.length - n));
                }
            } else if (bl3) {
                arrayList.add(Language.getText("replayops.successfullyDeleted", n2));
                if (n2 < this.files.length) {
                    arrayList.add(Language.getText("replayops.failedToDelete", this.files.length - n2));
                }
            }
            if (bl4 && n != this.files.length) {
                GuiUtils.showErrorDialog(arrayList.toArray());
                return;
            } else {
                GuiUtils.showInfoDialog(arrayList.toArray());
            }
            return;
        }
        if (actionEvent.getSource() == this.packReplaysMenuItem) {
            int n;
            block68: {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(Language.getText("replayops.selectFileToPackTo"));
                jFileChooser.setFileFilter(GuiUtils.ZIP_FILE_FILTER);
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                JCheckBox jCheckBox = GuiUtils.createCheckBox("replayops.includePathInZip", "module.repSearch.results.includePathInZip");
                jFileChooser.setAccessory(jCheckBox);
                if (jFileChooser.showSaveDialog(MainFrame.INSTANCE) != 0) return;
                File file = jFileChooser.getSelectedFile();
                if (!GuiUtils.ZIP_FILE_FILTER.accept(file)) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".zip");
                }
                n = 0;
                ZipOutputStream zipOutputStream = null;
                try {
                    try {
                        zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
                        boolean bl = jCheckBox.isSelected();
                        byte[] byArray = new byte[16384];
                        File[] fileArray = this.files;
                        int n4 = this.files.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            block66: {
                                File file3 = fileArray[n5];
                                ZipEntry zipEntry = new ZipEntry(bl ? file3.getAbsolutePath() : file3.getName());
                                zipEntry.setTime(file3.lastModified());
                                zipOutputStream.putNextEntry(zipEntry);
                                FileInputStream fileInputStream = null;
                                try {
                                    try {
                                        int n6;
                                        fileInputStream = new FileInputStream(file3);
                                        while ((n6 = fileInputStream.read(byArray)) > 0) {
                                            zipOutputStream.write(byArray, 0, n6);
                                        }
                                        fileInputStream.close();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        if (fileInputStream != null) {
                                            try {
                                                fileInputStream.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        break block66;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (fileInputStream == null) throw throwable;
                                    try {
                                        fileInputStream.close();
                                        throw throwable;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                if (fileInputStream != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                            zipOutputStream.closeEntry();
                            ++n;
                            ++n5;
                        }
                        zipOutputStream.flush();
                        zipOutputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (zipOutputStream != null) {
                            try {
                                zipOutputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block68;
                    }
                }
                catch (Throwable throwable) {
                    if (zipOutputStream == null) throw throwable;
                    try {
                        zipOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (n == this.files.length) {
                GuiUtils.showInfoDialog(Language.getText("replayops.successfullyPacked", n));
                return;
            } else {
                GuiUtils.showErrorDialog(new Object[]{Language.getText("replayops.successfullyPacked", n), Language.getText("replayops.failedToPack", this.files.length - n)});
            }
            return;
        }
        if (actionEvent.getSource() == this.renameReplaysMenuItem) {
            final JDialog jDialog = new JDialog((Frame)MainFrame.INSTANCE, Language.getText("replayops.renameDialog.title"));
            jDialog.setDefaultCloseOperation(2);
            JPanel jPanel = new JPanel(new BorderLayout());
            Box box = Box.createVerticalBox();
            int n = 1;
            while (n <= 4) {
                if (n == 2 || n == 4) {
                    box.add(Box.createVerticalStrut(10));
                }
                box.add(new JLabel(Language.getText("replayops.renameDialog.description" + n)));
                ++n;
            }
            box.add(new JLabel("          /n    " + Language.getText("replayops.renameDialog.symbol.name")));
            box.add(new JLabel("          /e    " + Language.getText("replayops.renameDialog.symbol.extension")));
            box.add(new JLabel("          /d    " + Language.getText("replayops.renameDialog.symbol.date")));
            box.add(new JLabel("          /D    " + Language.getText("replayops.renameDialog.symbol.dateTime")));
            box.add(new JLabel("          /c    " + Language.getText("replayops.renameDialog.symbol.counter")));
            box.add(new JLabel("          /m   " + Language.getText("replayops.renameDialog.symbol.mapName")));
            box.add(new JLabel("          /px  " + Language.getText("replayops.renameDialog.symbol.playerName")));
            box.add(new JLabel("          /q   " + Language.getText("replayops.renameDialog.symbol.allPlayerNames")));
            box.add(new JLabel("          /rx   " + Language.getText("replayops.renameDialog.symbol.playerRaceFirstLetter")));
            box.add(new JLabel("          /Rx  " + Language.getText("replayops.renameDialog.symbol.playerRace")));
            box.add(new JLabel("          /Px  " + Language.getText("replayops.renameDialog.symbol.fullPlayerName")));
            box.add(new JLabel("          /Q   " + Language.getText("replayops.renameDialog.symbol.allFullPlayerNames")));
            box.add(new JLabel("          /f    " + Language.getText("replayops.renameDialog.symbol.format")));
            box.add(new JLabel("          /T   " + Language.getText("replayops.renameDialog.symbol.raceMatchup")));
            final JTextField jTextField = new JTextField(Settings.getString("module.repSearch.results.renameTemplate"));
            box.add(jTextField);
            jPanel.add((Component)box, "Center");
            JPanel jPanel2 = new JPanel();
            final JButton jButton = new JButton();
            GuiUtils.updateButtonText(jButton, "replayops.renameDialog.previewButton", new Object[0]);
            jPanel2.add(jButton);
            JButton jButton2 = new JButton();
            GuiUtils.updateButtonText(jButton2, "replayops.renameDialog.renameButton", new Object[0]);
            jPanel2.add(jButton2);
            JButton jButton3 = new JButton();
            GuiUtils.updateButtonText(jButton3, "button.cancel", new Object[0]);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            jPanel2.add(jButton3);
            jPanel.add((Component)jPanel2, "South");
            jDialog.getContentPane().add((Component)jPanel, "North");
            final JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jDialog.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    boolean bl2 = bl = actionEvent.getSource() == jButton;
                    if (bl) {
                        jTextArea.setText("");
                    }
                    int n = 1;
                    int n2 = 0;
                    char[] cArray = jTextField.getText().toCharArray();
                    int n3 = 0;
                    while (n3 < ReplayOperationsPopupMenu.this.files.length) {
                        try {
                            File file = ReplayOperationsPopupMenu.this.files[n3];
                            StringBuilder stringBuilder = new StringBuilder();
                            Replay replay = null;
                            int n4 = 0;
                            while (n4 < cArray.length) {
                                block42: {
                                    block41: {
                                        if (cArray[n4] != '/') break block41;
                                        char c = cArray[++n4];
                                        switch (c) {
                                            case 'n': {
                                                stringBuilder.append(GeneralUtils.getFileNameWithoutExt(file));
                                                break block42;
                                            }
                                            case 'e': {
                                                stringBuilder.append("SC2Replay");
                                                break block42;
                                            }
                                            case 'd': {
                                                stringBuilder.append(Language.formatDate(new Date(file.lastModified())).replace('/', '-').replace('\\', '-').replace(':', '-'));
                                                break block42;
                                            }
                                            case 'D': {
                                                stringBuilder.append(Language.formatDateTime(new Date(file.lastModified())).replace('/', '-').replace('\\', '-').replace(':', '-'));
                                                break block42;
                                            }
                                            case 'c': {
                                                stringBuilder.append(Integer.toString(n++));
                                                break block42;
                                            }
                                            case 'P': 
                                            case 'Q': 
                                            case 'R': 
                                            case 'T': 
                                            case 'f': 
                                            case 'm': 
                                            case 'p': 
                                            case 'q': 
                                            case 'r': {
                                                if (replay == null) {
                                                    replay = ReplayParser.parseReplay(file.getAbsolutePath(), ReplayParser.GENERAL_INFO_CONTENT);
                                                }
                                                if (replay == null) {
                                                    System.out.println("Could not parse replay!");
                                                    ++n2;
                                                } else {
                                                    block9 : switch (c) {
                                                        case 'm': {
                                                            stringBuilder.append(replay.details.mapName);
                                                            break;
                                                        }
                                                        case 'q': {
                                                            stringBuilder.append(replay.details.getPlayerNames());
                                                            break;
                                                        }
                                                        case 'Q': {
                                                            stringBuilder.append(replay.details.getPlayerFullNames());
                                                            break;
                                                        }
                                                        case 'f': {
                                                            stringBuilder.append((Object)replay.initData.format);
                                                            break;
                                                        }
                                                        case 'T': {
                                                            stringBuilder.append(replay.details.getRaceMatchup());
                                                            break;
                                                        }
                                                        case 'P': 
                                                        case 'R': 
                                                        case 'p': 
                                                        case 'r': {
                                                            int n5 = cArray[++n4] - 49;
                                                            if (n5 < 0 || n5 > replay.details.players.length) {
                                                                System.out.println("Invalid player index!");
                                                                ++n2;
                                                                break;
                                                            }
                                                            switch (c) {
                                                                case 'p': {
                                                                    stringBuilder.append(replay.details.players[n5].name);
                                                                    break block9;
                                                                }
                                                                case 'R': {
                                                                    stringBuilder.append((Object)replay.details.players[n5].race);
                                                                    break block9;
                                                                }
                                                                case 'r': {
                                                                    stringBuilder.append(replay.details.players[n5].raceString().charAt(0));
                                                                    break block9;
                                                                }
                                                                case 'P': {
                                                                    stringBuilder.append(replay.details.players[n5].fullName);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                break block42;
                                            }
                                            default: {
                                                System.out.println("Invalid symbol!");
                                                GuiUtils.showErrorDialog(Language.getText("replayops.renameDialog.invalidTemplate"));
                                                return;
                                            }
                                        }
                                    }
                                    stringBuilder.append(cArray[n4]);
                                }
                                ++n4;
                            }
                            if (bl) {
                                jTextArea.append(String.valueOf(stringBuilder.toString()) + "\n");
                                jTextField.requestFocusInWindow();
                            } else {
                                File file2 = new File(file.getParent(), stringBuilder.toString());
                                if (file.renameTo(file2)) {
                                    if (ReplayOperationsPopupMenu.this.replayOpCallback != null) {
                                        ReplayOperationsPopupMenu.this.replayOpCallback.replayRenamed(file, file2, n3);
                                    }
                                } else {
                                    System.out.println("Failed to rename replay file!");
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            GuiUtils.showErrorDialog(Language.getText("replayops.renameDialog.invalidTemplate"));
                            return;
                        }
                        ++n3;
                    }
                    if (bl) {
                        jTextArea.setCaretPosition(0);
                    } else {
                        if (ReplayOperationsPopupMenu.this.replayOpCallback != null) {
                            ReplayOperationsPopupMenu.this.replayOpCallback.moveRenameDeleteEnded();
                        }
                        Settings.set("module.repSearch.results.renameTemplate", jTextField.getText());
                        if (n2 == 0) {
                            GuiUtils.showInfoDialog(Language.getText("replayops.renameDialog.successfullyRenamed", ReplayOperationsPopupMenu.this.files.length));
                        } else {
                            GuiUtils.showErrorDialog(new Object[]{Language.getText("replayops.renameDialog.successfullyRenamed", ReplayOperationsPopupMenu.this.files.length - n2), Language.getText("replayops.renameDialog.failedToRename", n2)});
                        }
                        jDialog.dispose();
                    }
                }
            };
            jButton.addActionListener(actionListener);
            jButton2.addActionListener(actionListener);
            jButton.doClick();
            jDialog.setSize(750, 600);
            GuiUtils.centerWindowToWindow(jDialog, MainFrame.INSTANCE);
            jDialog.setVisible(true);
            return;
        }
        if (actionEvent.getSource() != this.openReplaysFolderMenuItem) return;
        try {
            Desktop.getDesktop().open(this.files[0].getParentFile());
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static interface ReplayOpCallback {
        public void replayMoved(File var1, File var2, int var3);

        public void replayDeleted(File var1, int var2);

        public void replayRenamed(File var1, File var2, int var3);

        public void moveRenameDeleteEnded();
    }
}

