/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.AbilityCodes;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class ReplayUtils {
    public static final Comparator<GameEvents.Action> ACTION_FRAME_COMPARATOR = new Comparator<GameEvents.Action>(){

        @Override
        public int compare(GameEvents.Action action, GameEvents.Action action2) {
            return action.frame - action2.frame;
        }
    };
    public static final AbilityCodes CURRENT_ABILITY_CODES;
    private static final List<AbilityCodes> abilityCodesList;

    static {
        abilityCodesList = new ArrayList<AbilityCodes>();
        String[] stringArray = new String[]{"ability_codes_0.16-", "ability_codes_0.11-0.14"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String string2 = string.substring(string.lastIndexOf(95) + 1, string.indexOf(45));
            String string3 = string.substring(string.indexOf(45) + 1);
            AbilityCodes abilityCodes = new AbilityCodes(ReplayUtils.parseVersion(string2), ReplayUtils.parseVersion(string3));
            BufferedReader bufferedReader = null;
            try {
                try {
                    String string4;
                    bufferedReader = new BufferedReader(new InputStreamReader(ReplayUtils.class.getResourceAsStream(string)));
                    while ((string4 = bufferedReader.readLine()) != null) {
                        String string5;
                        Number number;
                        if (string4.charAt(4) == ' ') {
                            number = Short.valueOf(string4.substring(0, 4), 16);
                            abilityCodes.UNIT_TYPE_NAME.put((Short)number, string4.substring(6, string4.length() - 1));
                            continue;
                        }
                        number = Integer.valueOf(string4.substring(0, 6), 16);
                        if ((string4 = string4.substring(7)).charAt(0) == '\"') {
                            int n3 = string4.indexOf(34, 1);
                            string5 = string4.substring(1, n3);
                            String string6 = ReplayUtils.getNextToken(string4, n3 + 2);
                            string6 = "null".equals(string6) ? null : string6.substring(string6.indexOf(46) + 1);
                            abilityCodes.COMMON_BASE_ABILITY_CODES.put((Integer)number, new Object[]{string5, string6 == null ? null : ReplayConsts.AbilityGroup.valueOf(string6)});
                            continue;
                        }
                        string5 = ReplayUtils.getNextToken(string4, string4.indexOf(46) + 1);
                        if (string4.startsWith("Unit.")) {
                            abilityCodes.TRAIN_ABILITY_CODES.put((Integer)number, ReplayConsts.Unit.valueOf(string5));
                            continue;
                        }
                        if (string4.startsWith("WUnit.")) {
                            abilityCodes.WARP_ABILITY_CODES.put((Integer)number, ReplayConsts.Unit.valueOf(string5));
                            continue;
                        }
                        if (string4.startsWith("HUnit.")) {
                            abilityCodes.TRAIN_HALLU_ABILITY_CODES.put((Integer)number, ReplayConsts.Unit.valueOf(string5));
                            continue;
                        }
                        if (string4.startsWith("Building.")) {
                            abilityCodes.BUILD_ABILITY_CODES.put((Integer)number, ReplayConsts.Building.valueOf(string5));
                            continue;
                        }
                        if (string4.startsWith("Research.")) {
                            abilityCodes.RESEARCH_ABILITY_CODES.put((Integer)number, ReplayConsts.Research.valueOf(string5));
                            continue;
                        }
                        if (string4.startsWith("Upgrade.")) {
                            abilityCodes.UPGRADE_ABILITY_CODES.put((Integer)number, ReplayConsts.Upgrade.valueOf(string5));
                            continue;
                        }
                        if (string4.startsWith("UnitAbility.")) {
                            abilityCodes.USE_UNIT_ABILITY.put((Integer)number, new Object[]{ReplayConsts.UnitAbility.valueOf(string5), ReplayConsts.Unit.valueOf(ReplayUtils.getNextToken(string4, string4.indexOf("Unit.") + 5))});
                            continue;
                        }
                        if (!string4.startsWith("BuildingAbility.")) continue;
                        abilityCodes.USE_BUILDING_ABILITY.put((Integer)number, new Object[]{ReplayConsts.BuildingAbility.valueOf(string5), ReplayConsts.Building.valueOf(ReplayUtils.getNextToken(string4, string4.indexOf("Building.") + 9))});
                    }
                    abilityCodesList.add(abilityCodes);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException("Internal error: failed to load ability codes!");
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            ++n2;
        }
        CURRENT_ABILITY_CODES = abilityCodesList.get(0);
    }

    public static String formatFrames(int n) {
        return ReplayUtils.formatMs(n * 125 >> 3);
    }

    public static String formatMs(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
        ((Calendar)gregorianCalendar).add(14, n);
        return Language.formatTime(gregorianCalendar.getTime());
    }

    public static String formatFramesShort(int n) {
        int n2 = n >> 6;
        int n3 = 0;
        int n4 = 0;
        if (n2 >= 3600) {
            n3 = n2 / 3600;
            n2 %= 3600;
        }
        if (n2 >= 60) {
            n4 = n2 / 60;
            n2 %= 60;
        }
        return n3 > 0 ? String.valueOf(n3) + (n4 < 10 ? ":0" : ":") + n4 + (n2 < 10 ? ":0" : ":") + n2 : String.valueOf(n4) + (n2 < 10 ? ":0" : ":") + n2;
    }

    public static String formatCoordinate(int n) {
        return String.format(Locale.ENGLISH, "%.1f", Float.valueOf((float)n / 65536.0f));
    }

    public static ImageIcon parseTgaImage(byte[] byArray) {
        int n = byArray[12] & 0xFF | (byArray[13] & 0xFF) << 8;
        int n2 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        int n3 = 18;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = 0;
            while (n9 < n) {
                int n10 = (byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF;
                if (n10 != 0) {
                    bufferedImage.setRGB(n9, n8, n10);
                    if (n9 < n4) {
                        n4 = n9;
                    }
                    if (n9 > n6) {
                        n6 = n9;
                    }
                    if (n8 < n5) {
                        n5 = n8;
                    }
                    if (n8 > n7) {
                        n7 = n8;
                    }
                }
                n3 += 3;
                ++n9;
            }
            ++n8;
        }
        return new ImageIcon(bufferedImage.getSubimage(n4, n5, n6 - n4 + 1, n7 - n5 + 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] parseVersion(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
            while (stringTokenizer.hasMoreTokens()) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n < 0) {
                    return null;
                }
                arrayList.add(n);
            }
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = (Integer)arrayList.get(n);
                ++n;
            }
            return nArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int compareVersions(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < nArray.length && n < nArray2.length) {
            if (nArray[n] != nArray2[n]) {
                return nArray[n] - nArray2[n];
            }
            ++n;
        }
        return 0;
    }

    public static AbilityCodes getAbilityCodesForVersion(int[] nArray) {
        for (AbilityCodes abilityCodes : abilityCodesList) {
            if (ReplayUtils.compareVersions(nArray, abilityCodes.minVersion) < 0) continue;
            return abilityCodes;
        }
        return null;
    }

    private static String getNextToken(String string, int n) {
        while (string.charAt(n) == ' ') {
            ++n;
        }
        int n2 = n;
        while (n2 < string.length() && string.charAt(n2) != ',' && string.charAt(n2) != ' ') {
            ++n2;
        }
        return string.substring(n, n2);
    }
}

