/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.mpq;

import hu.belicza.andras.sc2gears.mpq.AlgorithmUtil;
import hu.belicza.andras.sc2gears.mpq.InvalidMpqArchiveException;
import hu.belicza.andras.sc2gears.mpq.model.BlockTable;
import hu.belicza.andras.sc2gears.mpq.model.HashTable;
import hu.belicza.andras.sc2gears.mpq.model.Header;
import hu.belicza.andras.sc2gears.mpq.model.MpqArchive;
import hu.belicza.andras.sc2gears.mpq.model.UserData;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class MpqParser {
    private static final int HASH_TABLE_DECRYPTION_KEY = -1011927184;
    private static final int BLOCK_TABLE_DECRYPTION_KEY = -326913117;
    private final MpqArchive mpqArchive = new MpqArchive();
    private final FileInputStream input;
    private final FileChannel channel;

    public MpqParser(String string) throws InvalidMpqArchiveException {
        try {
            this.input = new FileInputStream(string);
            byte[] byArray = new byte[4];
            this.input.read(byArray);
            if (UserData.isMpqMagicExt(byArray)) {
                this.mpqArchive.userData = this.readUserData();
                this.input.skip(this.mpqArchive.userData.archiveHeaderOffset - (this.mpqArchive.userData.userDataSize + 12));
                this.input.read(byArray);
            }
            if (!Header.isMpqMagic(byArray)) {
                throw new InvalidMpqArchiveException("Invalid MPQ archive!");
            }
            this.mpqArchive.header = this.readHeader();
            this.mpqArchive.blockSize = 512 << this.mpqArchive.header.sectorSizeShift;
            this.channel = this.input.getChannel();
            this.channel.position(((long)this.mpqArchive.header.hashTableOffsetHigh << 32) + ((long)this.mpqArchive.header.hashTableOffset & 0xFFFFFFFFL) + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset));
            this.mpqArchive.hashTables = this.readHashTableEntries(this.mpqArchive.header.hashTableEntries);
            this.channel.position(((long)this.mpqArchive.header.blockTableOffsetHigh << 32) + ((long)this.mpqArchive.header.blockTableOffset & 0xFFFFFFFFL) + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset));
            this.mpqArchive.blockTables = this.readBlockTableEntries(this.mpqArchive.header.blockTableEntries);
            if (this.mpqArchive.header.extendedBlockTableOffset > 0L) {
                this.channel.position(this.mpqArchive.header.extendedBlockTableOffset + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset));
                this.mpqArchive.extBlockTableHighOffsets = this.readExtBlockTableEntries(this.mpqArchive.header.blockTableEntries);
            }
            this.mpqArchive.blockTableIndices = new int[this.mpqArchive.header.blockTableEntries];
            int n = 0;
            while (n < this.mpqArchive.header.blockTableEntries) {
                if ((this.mpqArchive.blockTables[n].flags & Integer.MIN_VALUE) != 0) {
                    this.mpqArchive.blockTableIndices[this.mpqArchive.filesCount++] = n;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.close();
            throw new InvalidMpqArchiveException(exception.getMessage(), exception);
        }
    }

    private UserData readUserData() throws IOException {
        UserData userData = new UserData();
        userData.userDataSize = this.readFullBuffer(4).getInt();
        userData.archiveHeaderOffset = this.readFullBuffer(4).getInt();
        userData.userData = this.readFullBuffer(userData.userDataSize).array();
        return userData;
    }

    private Header readHeader() throws IOException {
        Header header = new Header();
        header.headerSize = this.readFullBuffer(4).getInt();
        ByteBuffer byteBuffer = this.readFullBuffer(header.headerSize - 8);
        header.archiveSize = byteBuffer.getInt();
        header.formatVersion = byteBuffer.getShort();
        header.sectorSizeShift = byteBuffer.getShort();
        header.hashTableOffset = byteBuffer.getInt();
        header.blockTableOffset = byteBuffer.getInt();
        header.hashTableEntries = byteBuffer.getInt();
        header.blockTableEntries = byteBuffer.getInt();
        if (header.formatVersion == 1) {
            header.extendedBlockTableOffset = byteBuffer.getLong();
            header.hashTableOffsetHigh = byteBuffer.getShort();
            header.blockTableOffsetHigh = byteBuffer.getShort();
        }
        return header;
    }

    private HashTable[] readHashTableEntries(int n) throws IOException {
        int n2 = n * 16;
        ByteBuffer byteBuffer = AlgorithmUtil.decryptData(this.readFullBuffer(n2), n2, -1011927184);
        HashTable[] hashTableArray = new HashTable[n];
        int n3 = 0;
        while (n3 < hashTableArray.length) {
            HashTable hashTable = new HashTable();
            hashTable.filePathHashA = byteBuffer.getInt();
            hashTable.filePathHashB = byteBuffer.getInt();
            hashTable.language = byteBuffer.getShort();
            hashTable.platform = byteBuffer.getShort();
            hashTable.fileBlockIndex = byteBuffer.getInt();
            hashTableArray[n3] = hashTable;
            ++n3;
        }
        return hashTableArray;
    }

    private BlockTable[] readBlockTableEntries(int n) throws IOException {
        int n2 = n * 16;
        ByteBuffer byteBuffer = AlgorithmUtil.decryptData(this.readFullBuffer(n2), n2, -326913117);
        BlockTable[] blockTableArray = new BlockTable[n];
        int n3 = 0;
        while (n3 < blockTableArray.length) {
            BlockTable blockTable = new BlockTable();
            blockTable.blockOffset = byteBuffer.getInt();
            blockTable.blockSize = byteBuffer.getInt();
            blockTable.fileSize = byteBuffer.getInt();
            blockTable.flags = byteBuffer.getInt();
            blockTableArray[n3] = blockTable;
            ++n3;
        }
        return blockTableArray;
    }

    private short[] readExtBlockTableEntries(int n) throws IOException {
        ByteBuffer byteBuffer = this.readFullBuffer(n * 2);
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < sArray.length) {
            sArray[n2] = byteBuffer.getShort();
            ++n2;
        }
        return sArray;
    }

    public UserData getUserData() {
        return this.mpqArchive.userData;
    }

    public int getFileSize(int n, int n2, int n3) {
        int n4 = this.mpqArchive.header.hashTableEntries;
        int n5 = 0;
        int n6 = n & n4 - 1;
        while (n6 < n4) {
            HashTable hashTable = this.mpqArchive.hashTables[n6];
            if (hashTable.fileBlockIndex != -1 && hashTable.filePathHashA == n2 && hashTable.filePathHashB == n3) {
                int n7 = 0;
                while (n7 < hashTable.fileBlockIndex) {
                    if ((this.mpqArchive.blockTables[n7].flags & Integer.MIN_VALUE) == 0) {
                        ++n5;
                    }
                    ++n7;
                }
                n7 = hashTable.fileBlockIndex - n5;
                if (n7 < 0 || n7 >= this.mpqArchive.filesCount) {
                    return -1;
                }
                return this.mpqArchive.blockTables[this.mpqArchive.blockTableIndices[n7]].fileSize;
            }
            ++n6;
        }
        return -1;
    }

    public byte[] getFile(String string) throws InvalidMpqArchiveException {
        int n = AlgorithmUtil.hashString(string, AlgorithmUtil.MpqHashType.TABLE_OFFSET);
        int n2 = AlgorithmUtil.hashString(string, AlgorithmUtil.MpqHashType.NAME_A);
        int n3 = AlgorithmUtil.hashString(string, AlgorithmUtil.MpqHashType.NAME_B);
        return this.getFile(n, n2, n3);
    }

    public byte[] getFile(int n, int n2, int n3) throws InvalidMpqArchiveException {
        int n4 = this.mpqArchive.header.hashTableEntries;
        int n5 = 0;
        int n6 = n & n4 - 1;
        while (n6 < n4) {
            HashTable hashTable = this.mpqArchive.hashTables[n6];
            if (hashTable.fileBlockIndex != -1 && hashTable.filePathHashA == n2 && hashTable.filePathHashB == n3) {
                int n7 = 0;
                while (n7 < hashTable.fileBlockIndex) {
                    if ((this.mpqArchive.blockTables[n7].flags & Integer.MIN_VALUE) == 0) {
                        ++n5;
                    }
                    ++n7;
                }
                n7 = hashTable.fileBlockIndex - n5;
                if (n7 < 0 || n7 >= this.mpqArchive.filesCount) {
                    return null;
                }
                int n8 = this.mpqArchive.blockTableIndices[n7];
                BlockTable blockTable = this.mpqArchive.blockTables[n8];
                try {
                    int n9;
                    Object object;
                    int n10 = (blockTable.flags & 0x1000000) != 0 ? 1 : (blockTable.fileSize + this.mpqArchive.blockSize - 1) / this.mpqArchive.blockSize;
                    int[] nArray = new int[n10 + ((blockTable.flags & 0x4000000) != 0 ? 2 : 1)];
                    if ((blockTable.flags & 0xFF00) != 0 && (blockTable.flags & 0x1000000) == 0) {
                        this.channel.position((this.mpqArchive.extBlockTableHighOffsets == null ? 0L : ((long)this.mpqArchive.extBlockTableHighOffsets[n8] & 0xFFFFL) << 32) + ((long)blockTable.blockOffset & 0xFFFFFFFFL) + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset));
                        object = this.readFullBuffer(nArray.length * 4);
                        n9 = 0;
                        while (n9 < nArray.length) {
                            nArray[n9] = ((ByteBuffer)object).getInt();
                            ++n9;
                        }
                        if ((blockTable.flags & 0x10000) != 0) {
                            throw new InvalidMpqArchiveException("Decryption of packed block offset table is not yet implemented!");
                        }
                    } else if ((blockTable.flags & 0x1000000) == 0) {
                        int n11 = 0;
                        while (n11 < n10) {
                            nArray[n11] = n11 * this.mpqArchive.blockSize;
                            ++n11;
                        }
                        nArray[n10] = blockTable.blockSize;
                    } else {
                        nArray[0] = 0;
                        nArray[1] = blockTable.blockSize;
                    }
                    object = new byte[blockTable.fileSize];
                    n9 = 0;
                    int n12 = 0;
                    while (n12 < n10) {
                        int n13 = (blockTable.flags & 0x1000000) != 0 ? blockTable.fileSize : (n12 < n10 - 1 ? this.mpqArchive.blockSize : blockTable.fileSize - this.mpqArchive.blockSize * n12);
                        int n14 = nArray[n12 + 1] - nArray[n12];
                        this.channel.position((this.mpqArchive.extBlockTableHighOffsets == null ? 0L : ((long)this.mpqArchive.extBlockTableHighOffsets[n8] & 0xFFFFL) << 32) + ((long)blockTable.blockOffset & 0xFFFFFFFFL) + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset) + (long)nArray[n12]);
                        byte[] byArray = this.readFullBuffer(n14).array();
                        if ((blockTable.flags & 0x10000) != 0) {
                            throw new InvalidMpqArchiveException("Decryption of data block is not yet implemented!");
                        }
                        if ((blockTable.flags & 0x200) != 0) {
                            AlgorithmUtil.decompressMultiBlock(byArray, n13, (byte[])object, n9);
                        } else {
                            if ((blockTable.flags & 0x100) != 0) {
                                throw new InvalidMpqArchiveException("Explosion of data block is not yet implemented!");
                            }
                            System.arraycopy(byArray, 0, object, n9, n14);
                        }
                        n9 += n13;
                        ++n12;
                    }
                    return object;
                }
                catch (IOException iOException) {
                    throw new InvalidMpqArchiveException(iOException.getMessage(), iOException);
                }
            }
            ++n6;
        }
        return null;
    }

    private ByteBuffer readFullBuffer(int n) throws IOException {
        byte[] byArray = new byte[n];
        if (this.input.read(byArray) < n) {
            throw new IOException("Unexpected end of file, tried to read " + n + " bytes but EOF reached!");
        }
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
    }

    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

