/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.shared;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import javax.swing.JLabel;

public class CommonUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String OS_NAME = System.getProperty("os.name");

    private CommonUtils() {
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("nix") >= 0 || string.indexOf("nux") >= 0;
    }

    public static void showURLInBrowser(String string) {
        try {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URL(string).toURI());
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String[] stringArray = null;
            if (CommonUtils.isWindows()) {
                stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", string};
            } else {
                String[] stringArray2;
                String[] stringArray3 = stringArray2 = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                int n = stringArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray3[n2];
                    if (Runtime.getRuntime().exec(new String[]{"which", string2}).waitFor() == 0) {
                        stringArray = new String[]{string2, string};
                        break;
                    }
                    ++n2;
                }
            }
            if (stringArray != null) {
                Runtime.getRuntime().exec(stringArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JLabel createLinkLabel(String string, final String string2) {
        JLabel jLabel = CommonUtils.createLinkStyledLabel(string);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CommonUtils.showURLInBrowser(string2);
            }
        });
        return jLabel;
    }

    public static JLabel createLinkStyledLabel(String string) {
        JLabel jLabel = new JLabel("<html><a href='#'>" + string + "</a></html>");
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        return jLabel;
    }

    /*
     * Loose catch block
     */
    public static String calculateFileSha256(File file) {
        String string;
        FileInputStream fileInputStream;
        block13: {
            int n;
            fileInputStream = null;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[16384];
            while ((n = fileInputStream.read(byArray)) > 0) {
                messageDigest.update(byArray, 0, n);
            }
            string = CommonUtils.convertToHexString(messageDigest.digest());
            if (fileInputStream == null) break block13;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
        catch (Exception exception) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return "";
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static String convertToHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            stringBuilder.append(HEX_DIGITS[(by & 0xFF) >> 4]).append(HEX_DIGITS[by & 0xF]);
            ++n2;
        }
        return stringBuilder.toString();
    }
}

