/*
 * Decompiled with CFR 0.152.
 */
package com.easynth.designer.laf.popup;

import java.awt.Dimension;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;

public class EaSynthComboBoxPopupMenuListener
implements PopupMenuListener {
    private int deltaWidth = -1;
    private int deltaHeight = -1;
    private int bgTop = 4;
    private int bgLeft = 4;
    private int bgRight = 9;
    private int bgBottom = 10;
    private int preferredItemHeight = -1;

    public EaSynthComboBoxPopupMenuListener() {
    }

    public EaSynthComboBoxPopupMenuListener(int deltaWidth, int deltaHeight, int bgTop, int bgLeft, int bgRight, int bgBottom) {
        this.deltaWidth = deltaWidth;
        this.deltaHeight = deltaHeight;
        this.bgTop = bgTop;
        this.bgLeft = bgLeft;
        this.bgRight = bgRight;
        this.bgBottom = bgBottom;
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JComboBox box = (JComboBox)e.getSource();
        Accessible comp = box.getUI().getAccessibleChild(box, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        JPopupMenu popupMenu = (JPopupMenu)comp;
        popupMenu.setBorder(null);
        if (popupMenu.getComponent(0) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)popupMenu.getComponent(0);
            scrollPane.setBorder(BorderFactory.createEmptyBorder(this.bgTop, this.bgLeft, this.bgBottom, this.bgRight));
            scrollPane.setOpaque(false);
            scrollPane.getViewport().setOpaque(false);
            if (popupMenu instanceof ComboPopup) {
                ComboPopup popup = (ComboPopup)((Object)popupMenu);
                JList<Object> list = popup.getList();
                list.setBorder(null);
            }
            Dimension size = new Dimension();
            size.width = this.deltaWidth == -1 ? box.getSize().width + this.bgRight : box.getPreferredSize().width + this.deltaWidth + this.bgRight;
            size.height = this.deltaHeight == -1 ? scrollPane.getPreferredSize().height + box.getItemCount() : scrollPane.getPreferredSize().height + this.deltaHeight;
            if (box.getItemCount() != 0) {
                int curPrefItemHeight = scrollPane.getPreferredSize().height / box.getItemCount();
                if (this.preferredItemHeight == -1 || curPrefItemHeight <= this.preferredItemHeight) {
                    size.height += this.bgBottom + this.bgTop;
                }
                if (this.preferredItemHeight == -1) {
                    this.preferredItemHeight = curPrefItemHeight;
                }
            }
            scrollPane.setPreferredSize(size);
            scrollPane.setMaximumSize(size);
        }
    }
}

