/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.util;

import hu.belicza.andras.sc2gears.shared.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Set;

public class GeneralUtils {
    private GeneralUtils() {
    }

    public static String getFileNameWithoutExt(File file) {
        String fileName = file.getName();
        int lastDotIndex = fileName.lastIndexOf(46);
        return lastDotIndex < 0 ? fileName : fileName.substring(0, lastDotIndex);
    }

    public static boolean isDescendant(File f1, File f2) {
        f1 = f1.getAbsoluteFile();
        f2 = f2.getAbsoluteFile();
        while (f2 != null) {
            if (f1.equals(f2)) {
                return true;
            }
            f2 = f2.getParentFile();
        }
        return false;
    }

    public static boolean copyFile(File sourceFile, File targetFolder, byte[] buffer, String targetName) {
        if (!targetFolder.exists() && !targetFolder.mkdirs()) {
            return false;
        }
        if (targetFolder.exists() && !targetFolder.isDirectory()) {
            return false;
        }
        File targetFile = new File(targetFolder, targetName == null ? sourceFile.getName() : targetName);
        if (targetFile.exists()) {
            System.out.println("Copy failed: target file already exists!");
            return false;
        }
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            inputStream = new FileInputStream(sourceFile);
            outputStream = new FileOutputStream(targetFile);
            if (buffer == null) {
                buffer = new byte[4096];
            }
            while ((bytesRead = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String[] splitBySemicolon(String text) {
        int index;
        ArrayList<String> partList = new ArrayList<String>();
        int lastIndex = 0;
        while ((index = text.indexOf(59, lastIndex)) >= 0) {
            partList.add(text.substring(lastIndex, index));
            lastIndex = index + 1;
        }
        return partList.toArray(new String[partList.size()]);
    }

    public static int maxValue(int[] array) {
        if (array.length == 0) {
            return 0;
        }
        int max = array[0];
        int i = array.length - 1;
        while (i > 0) {
            if (max < array[i]) {
                max = array[i];
            }
            --i;
        }
        return max;
    }

    public static String convertConstNameToNormal(String text) {
        StringBuilder sb = new StringBuilder();
        boolean nextCharIsUpper = true;
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (ch == '_') {
                sb.append(' ');
                nextCharIsUpper = true;
            } else if (nextCharIsUpper) {
                sb.append(ch);
                nextCharIsUpper = false;
            } else {
                sb.append(Character.toLowerCase(ch));
            }
            ++n2;
        }
        return sb.toString();
    }

    public static boolean isOsWindows7() {
        return "Windows 7".equals(CommonUtils.OS_NAME);
    }

    public static boolean isOsWindowsVista() {
        return "Windows Vista".equals(CommonUtils.OS_NAME);
    }

    public static boolean isOsWindowsXp() {
        return "Windows XP".equals(CommonUtils.OS_NAME);
    }

    public static boolean isOsMac() {
        return CommonUtils.OS_NAME.startsWith("Mac");
    }

    public static int countElements(Object[] array, Object element) {
        int occurrencesCount = 0;
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element_ = objectArray[n2];
            if (element_.equals(element)) {
                ++occurrencesCount;
            }
            ++n2;
        }
        return occurrencesCount;
    }

    public static <T> T[] remainingElements(T[] elements, Set<T> excludeSet) {
        ArrayList<T> remainingList = new ArrayList<T>(elements.length - excludeSet.size());
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (!excludeSet.contains(element)) {
                remainingList.add(element);
            }
            ++n2;
        }
        return remainingList.toArray((Object[])Array.newInstance(elements[0].getClass(), remainingList.size()));
    }
}

