/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public abstract class ComboBoxSearchField
extends SearchField {
    protected JComboBox comboBox = new JComboBox();
    protected JSpinner minOccurrenceSpinner;

    public ComboBoxSearchField(String displayKey, Vector<Object> valueVector) {
        this(displayKey, valueVector, true);
    }

    public ComboBoxSearchField(String displayKey, Vector<Object> valueVector, boolean showMinOccurence) {
        super(displayKey);
        this.comboBox = new JComboBox<Object>(valueVector);
        this.comboBox.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object value) {
                return ComboBoxSearchField.this.getIcon(value);
            }
        });
        this.comboBox.setPreferredSize(new Dimension(100, this.comboBox.getMinimumSize().height));
        this.uiComponent.add(this.comboBox);
        if (showMinOccurence) {
            this.minOccurrenceSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
            this.uiComponent.add(new JLabel(Language.getText("module.repSearch.tab.filters.name.minOccurrenceText")));
            this.minOccurrenceSpinner.setEditor(new JSpinner.NumberEditor(this.minOccurrenceSpinner));
            this.minOccurrenceSpinner.setMaximumSize(new Dimension(50, this.minOccurrenceSpinner.getPreferredSize().height));
            this.uiComponent.add(this.minOccurrenceSpinner);
        }
    }

    protected Icon getIcon(Object value) {
        return null;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void reset() {
        this.comboBox.setSelectedIndex(0);
        if (this.minOccurrenceSpinner != null) {
            this.minOccurrenceSpinner.setValue(1);
        }
    }

    protected static Vector<Object> createDataVector(Collection<?> valueCollection) {
        Vector<Object> valueVector = new Vector<Object>(valueCollection);
        Collections.sort(valueVector, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        valueVector.insertElementAt(" ", 0);
        return valueVector;
    }
}

