/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class BuildOrderSearchField
extends SearchField {
    private static final String ANY_BUILDING_NAME = "*";
    private static final Vector<Object> BUILDING_VECTOR = new Vector<ReplayConsts.Building>(ReplayUtils.CURRENT_ABILITY_CODES.BUILD_ABILITY_CODES.values());
    protected JTextField textField = new JTextField(1);
    protected JComboBox comboBox = new JComboBox<Object>(BUILDING_VECTOR);

    static {
        Collections.sort(BUILDING_VECTOR, new Comparator<Object>(){

            @Override
            public int compare(Object b1, Object b2) {
                return b1.toString().compareTo(b2.toString());
            }
        });
        BUILDING_VECTOR.insertElementAt("* (" + Language.getText("module.repSearch.tab.filters.name.buildOrderAnyBuilding") + ")", 0);
    }

    public BuildOrderSearchField() {
        super("module.repSearch.tab.filters.name.buildOrder");
        this.textField.setToolTipText(Language.getText("module.repSearch.tab.filters.name.buildOrderTextToolTip"));
        this.uiComponent.add(this.textField);
        JButton addButton = new JButton(Icons.ARROW_180);
        addButton.setToolTipText(Language.getText("module.repSearch.tab.filters.name.buildOrderAddToolTip"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String currentText = BuildOrderSearchField.this.textField.getText();
                BuildOrderSearchField.this.textField.setText(String.valueOf(currentText) + (currentText.length() == 0 ? "" : (currentText.trim().endsWith(",") ? "" : ", ")) + (BuildOrderSearchField.this.comboBox.getSelectedIndex() == 0 ? BuildOrderSearchField.ANY_BUILDING_NAME : BuildOrderSearchField.this.comboBox.getSelectedItem()));
            }
        });
        this.uiComponent.add(addButton);
        this.comboBox.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object value) {
                return value instanceof ReplayConsts.Building ? Icons.getBuildingIcon((ReplayConsts.Building)((Object)value), IconHandler.Size.BIG) : IconHandler.NULL.get((Object)IconHandler.Size.BIG);
            }
        });
        this.uiComponent.add(this.comboBox);
    }

    @Override
    public boolean validate() {
        if (BuildOrderSearchField.parseBuildOrder(this.textField.getText()) == null) {
            this.textField.setBackground(ERROR_COLOR);
            return false;
        }
        this.textField.setBackground(null);
        return true;
    }

    @Override
    public void reset() {
        this.comboBox.setSelectedIndex(0);
        this.textField.setText("");
        this.textField.setBackground(null);
    }

    @Override
    public ReplayFilter getFilter() {
        final ReplayConsts.Building[] buildings = BuildOrderSearchField.parseBuildOrder(this.textField.getText());
        if (buildings == null || buildings.length == 0) {
            return null;
        }
        return new ReplayFilter(){

            @Override
            public Set<ReplayParser.ReplayContent> getRequiredReplayContentSet() {
                return GAME_EVENTS_REPLAY_CONTENT_SET;
            }

            @Override
            public boolean accept(File file, Replay replay) {
                GameEvents.Action[] actions = replay.gameEvents.actions;
                int actionsLength = actions.length;
                int[] matchedBuildingCounts = new int[replay.details.players.length];
                int stillInRaceCount = matchedBuildingCounts.length;
                int i = 0;
                while (i < actionsLength) {
                    GameEvents.Action action = actions[i];
                    if (action.type == ReplayConsts.ActionType.BUILD && matchedBuildingCounts[action.player] >= 0) {
                        ReplayConsts.Building building = ((GameEvents.BuildAction)action).building;
                        ReplayConsts.Building boBuilding = buildings[matchedBuildingCounts[action.player]];
                        if (boBuilding == null || boBuilding == building) {
                            byte by = action.player;
                            matchedBuildingCounts[by] = matchedBuildingCounts[by] + 1;
                            if (matchedBuildingCounts[by] == buildings.length) {
                                return true;
                            }
                        } else {
                            matchedBuildingCounts[action.player] = -1;
                            if (--stillInRaceCount == 0) {
                                return false;
                            }
                        }
                    }
                    ++i;
                }
                return false;
            }
        };
    }

    private static ReplayConsts.Building[] parseBuildOrder(String text) {
        if (text.length() == 0) {
            return new ReplayConsts.Building[0];
        }
        String[] buildingNames = text.split(",");
        ArrayList<ReplayConsts.Building> buildingList = new ArrayList<ReplayConsts.Building>();
        String[] stringArray = buildingNames;
        int n = buildingNames.length;
        int n2 = 0;
        while (n2 < n) {
            String buildingName = stringArray[n2];
            if ((buildingName = buildingName.trim()).length() == 0) {
                return null;
            }
            if (buildingName.equals(ANY_BUILDING_NAME)) {
                buildingList.add(null);
            } else {
                boolean found = false;
                ReplayConsts.Building[] buildingArray = ReplayConsts.Building.values();
                int n3 = buildingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ReplayConsts.Building building = buildingArray[n4];
                    if (building.toString().equalsIgnoreCase(buildingName)) {
                        buildingList.add(building);
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    return null;
                }
            }
            ++n2;
        }
        return buildingList.toArray(new ReplayConsts.Building[buildingList.size()]);
    }
}

