/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.ui.NormalThread;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JProgressBar;

public class Downloader
extends NormalThread {
    private final String url;
    private final File destination;
    private final Callback callback;
    public final JProgressBar progressBar = new JProgressBar();
    private volatile boolean requestedToCancel;

    public Downloader(String url, File destination, Callback callback) {
        super("Downloader");
        this.url = url;
        this.destination = destination;
        this.callback = callback;
        this.progressBar.setString("");
        this.progressBar.setStringPainted(true);
    }

    @Override
    public void run() {
        InputStream input = null;
        File tempFile = null;
        OutputStream output = null;
        try {
            int bytesRead;
            URLConnection archiveUrlConnection = new URL(this.url).openConnection();
            int length = archiveUrlConnection.getContentLength();
            if (length < 0) {
                this.progressBar.setString("Downloading... (size unknown)");
            } else {
                this.progressBar.setString(null);
                this.progressBar.setMaximum(length);
            }
            input = archiveUrlConnection.getInputStream();
            tempFile = File.createTempFile("Sc2gears", "s2ma");
            tempFile.deleteOnExit();
            output = new FileOutputStream(tempFile);
            int totalBytesRead = 0;
            byte[] buffer = new byte[8192];
            while (!this.requestedToCancel && (bytesRead = input.read(buffer)) > 0) {
                output.write(buffer, 0, bytesRead);
                totalBytesRead += bytesRead;
                if (length <= 0) continue;
                this.progressBar.setValue(totalBytesRead);
            }
            output.flush();
            if (!this.requestedToCancel && length < 0) {
                this.progressBar.setValue(this.progressBar.getMaximum());
                this.progressBar.setString(null);
            }
            if (this.requestedToCancel) {
                this.callback.downloadFinished(false);
                return;
            }
            try {
                this.callback.downloadFinished(GeneralUtils.copyFile(tempFile, this.destination.getParentFile(), buffer, this.destination.getName()));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.callback.downloadFinished(false);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (tempFile != null) {
                tempFile.delete();
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void requestToCancel() {
        this.requestedToCancel = true;
    }

    public static interface Callback {
        public void downloadFinished(boolean var1);
    }
}

