/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.settings;

import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.Properties;

public class Settings {
    private static final File SETTINGS_FILE;
    public static final String KEY_NAVIGATION_SHOW_BAR = "navigation.showNavbar";
    public static final String KEY_NAVIGATION_USE_SMALL_FONT = "navigation.useSmallFont";
    public static final String KEY_NAVIGATION_BAR_POSITION = "navigation.position";
    public static final String KEY_SETTINGS_LANGUAGE = "settings.language";
    public static final String KEY_SETTINGS_LAF = "settings.laf";
    public static final String KEY_SETTINGS_FOLDER_SC2_INSTALLATION = "settings.folders.sc2Installation";
    public static final String KEY_SETTINGS_FOLDER_SC2_AUTO_REPLAY = "settings.folders.sc2AutoReplay";
    public static final String KEY_SETTINGS_FOLDER_SC2_MAPS = "settings.folders.sc2Maps";
    public static final String KEY_SETTINGS_FOLDER_DEFAULT_REPLAY = "settings.folders.defaultReplay";
    public static final String KEY_SETTINGS_SAVE_ON_EXIT = "settings.saveOnExit";
    public static final String KEY_ALLOW_ONLY_ONE_INSTANCE = "settings.allowOnlyOneInstance";
    public static final String KEY_CHECK_UPDATES_ON_STARTUP = "settings.checkUpdatesOnStartup";
    public static final String KEY_WINDOW_VERTICAL_TILE_STRATEGY = "window.verticalTileStrategy";
    public static final String KEY_REP_ANALYZER_CHARTS_CHART_TYPE = "module.repAnalyzer.charts.chartType";
    public static final String KEY_REP_ANALYZER_CHARTS_ALL_PLAYERS_ON_1_CHART = "module.repAnalyzer.charts.allPlayersOn1Chart";
    public static final String KEY_REP_ANALYZER_CHARTS_USE_PLAYERS_COLORS = "module.repAnalyzer.charts.usePlayersColors";
    public static final String KEY_REP_ANALYZER_CHARTS_DISPLAY_IN_SECONDS = "module.repAnalyzer.charts.displayInSeconds";
    public static final String KEY_REP_ANALYZER_CHARTS_ZOOM = "module.repAnalyzer.charts.zoom";
    public static final String KEY_REP_ANALYZER_CHARTS_APM_GRANULARITY = "module.repAnalyzer.charts.apm.granularity";
    public static final String KEY_REP_ANALYZER_CHARTS_APM_GRAPH_APPROXIMATION = "module.repAnalyzer.charts.apm.graphApproximation";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_SELECT_HOTKEYS = "module.repAnalyzer.charts.hotkeys.showSelectHotkeys";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_BUILDS = "module.repAnalyzer.charts.buildsTech.showBuilds";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_TRAINS = "module.repAnalyzer.charts.buildsTech.showTrains";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_WORKERS = "module.repAnalyzer.charts.buildsTech.showWorkers";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_RESEARCHES = "module.repAnalyzer.charts.buildsTech.showResearches";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_UPGRADES = "module.repAnalyzer.charts.buildsTech.showUpgrades";
    public static final String KEY_REP_ANALYZER_CHARTS_USE_ICONS = "module.repAnalyzer.charts.buildsTech.useIcons";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_UNITS_STAT = "module.repAnalyzer.charts.buildsTechStat.showUnits";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_BUILDINGS_STAT = "module.repAnalyzer.charts.buildsTechStat.showBuildings";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_RESEARCHES_STAT = "module.repAnalyzer.charts.buildsTechStat.showResearches";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_UPGRADES_STAT = "module.repAnalyzer.charts.buildsTechStat.showUpgrades";
    public static final String KEY_REP_ANALYZER_CHARTS_SHOW_ABILITY_GROUPS_STAT = "module.repAnalyzer.charts.buildsTechStat.showAbilityGroups";
    public static final String KEY_REP_ANALYZER_CHARTS_BAR_SIZE = "module.repAnalyzer.charts.buildsTechStat.barSize";
    public static final String KEY_REP_ANALYZER_CHARTS_ACTIONS_INVERT_COLORS = "module.repAnalyzer.charts.actions.invertColors";
    public static final String KEY_REP_ANALYZER_CHARTS_ACTIONS_ICON_SIZE = "module.repAnalyzer.charts.actions.iconSize";
    public static final String KEY_REP_ANALYZER_CHARTS_ACTIONS_USE_LISTED_AS_INPUT = "module.repAnalyzer.charts.actions.useListedAsInput";
    public static final String KEY_REP_ANALYZER_IN_GAME_CHAT_HIDE_MESSAGE_TARGETS = "module.repAnalyzer.inGameChat.hideMessageTargets";
    public static final String KEY_REP_ANALYZER_IN_GAME_CHAT_SHOW_BLINKS = "module.repAnalyzer.inGameChat.showBlinks";
    public static final String KEY_REP_ANALYZER_IN_GAME_FORMAT_INTO_PARAGRAPHS = "module.repAnalyzer.inGameChat.formatIntoParagraphs";
    public static final String KEY_REP_ANALYZER_MAP_PREVIEW_DOWNLOAD_FROM_GATEWAY = "module.repAnalyzer.mapPreview.downloadFromGateway";
    public static final String KEY_REP_ANALYZER_MAP_PREVIEW_ZOOM = "module.repAnalyzer.mapPreview.zoom";
    public static final String KEY_REP_SEARCH_SOURCE_AUTO_SORT = "module.repSearch.source.autoSort";
    public static final String KEY_REP_SEARCH_RESULTS_STRETCH_TO_WINDOW = "module.repSearch.results.stretchToWindow";
    public static final String KEY_REP_SEARCH_RESULTS_INCLUDE_PATH_IN_ZIP = "module.repSearch.results.includePathInZip";
    public static final String KEY_REP_SEARCH_RESULTS_RENAME_TEMPLATE = "module.repSearch.results.renameTemplate";
    public static final String DEFAULT_APP_LANGUAGE = "English";
    public static final String DEFAULT_APP_LAF = "Nimbus";
    private static final Properties DEFAULT_PROPERTIES;
    private static Properties properties;

    static {
        String mapsFolder;
        String autoReplayFolder;
        String programFilesFolder;
        SETTINGS_FILE = new File("User Content", "settings.xml");
        DEFAULT_PROPERTIES = new Properties();
        DEFAULT_PROPERTIES.setProperty(KEY_NAVIGATION_SHOW_BAR, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_NAVIGATION_USE_SMALL_FONT, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_NAVIGATION_BAR_POSITION, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_LANGUAGE, DEFAULT_APP_LANGUAGE);
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_LAF, DEFAULT_APP_LAF);
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_SAVE_ON_EXIT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_ALLOW_ONLY_ONE_INSTANCE, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_CHECK_UPDATES_ON_STARTUP, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_WINDOW_VERTICAL_TILE_STRATEGY, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_CHART_TYPE, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ALL_PLAYERS_ON_1_CHART, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_USE_PLAYERS_COLORS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_DISPLAY_IN_SECONDS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ZOOM, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_APM_GRANULARITY, "5");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_APM_GRAPH_APPROXIMATION, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_SELECT_HOTKEYS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_BUILDS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_TRAINS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_WORKERS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_RESEARCHES, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_UPGRADES, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_USE_ICONS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_UNITS_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_BUILDINGS_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_RESEARCHES_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_UPGRADES_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_SHOW_ABILITY_GROUPS_STAT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_BAR_SIZE, "1");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ACTIONS_INVERT_COLORS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ACTIONS_ICON_SIZE, "2");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_CHARTS_ACTIONS_USE_LISTED_AS_INPUT, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_MAP_PREVIEW_DOWNLOAD_FROM_GATEWAY, "0");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_MAP_PREVIEW_ZOOM, "2");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_IN_GAME_CHAT_HIDE_MESSAGE_TARGETS, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_IN_GAME_CHAT_SHOW_BLINKS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_ANALYZER_IN_GAME_FORMAT_INTO_PARAGRAPHS, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_SEARCH_SOURCE_AUTO_SORT, "true");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_SEARCH_RESULTS_STRETCH_TO_WINDOW, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_SEARCH_RESULTS_INCLUDE_PATH_IN_ZIP, "false");
        DEFAULT_PROPERTIES.setProperty(KEY_REP_SEARCH_RESULTS_RENAME_TEMPLATE, "/T - /m - /q./e");
        if (GeneralUtils.isOsWindows7() || GeneralUtils.isOsWindowsVista()) {
            programFilesFolder = new File("c:/Program Files (x86)").exists() ? "C:/Program Files (x86)" : "C:/Program Files";
            autoReplayFolder = "/Documents/StarCraft II Beta/Replays/Recent";
            mapsFolder = "/AppData/Local/Blizzard Entertainment/Battle.net/Cache";
        } else if (GeneralUtils.isOsWindowsXp()) {
            programFilesFolder = new File("c:/Program Files (x86)").exists() ? "C:/Program Files (x86)" : "C:/Program Files";
            autoReplayFolder = "/My Documents/StarCraft II Beta/Replays/Recent";
            mapsFolder = "/Local Settings/Application Data/Blizzard Entertainment/Battle.net/Cache";
        } else if (GeneralUtils.isOsMac()) {
            programFilesFolder = "/Applications";
            autoReplayFolder = "/Documents/Blizzard/StarCraft II Beta/Replays/Recent";
            mapsFolder = "/Documents/Blizzard/StarCraft II Beta/Maps/Cache";
        } else {
            programFilesFolder = "/Applications";
            autoReplayFolder = "/Documents/Blizzard/StarCraft II Beta/Replays/Recent";
            mapsFolder = "/Documents/Blizzard/StarCraft II Beta/Maps/Cache";
        }
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_SC2_INSTALLATION, String.valueOf(programFilesFolder) + "/StarCraft II Beta");
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_SC2_AUTO_REPLAY, autoReplayFolder);
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_SC2_MAPS, mapsFolder);
        DEFAULT_PROPERTIES.setProperty(KEY_SETTINGS_FOLDER_DEFAULT_REPLAY, "");
        properties = new Properties(DEFAULT_PROPERTIES);
    }

    private Settings() {
    }

    public static boolean doesSettingsFileExist() {
        return SETTINGS_FILE.exists();
    }

    public static void loadProperties() {
        if (SETTINGS_FILE.exists()) {
            try {
                properties.loadFromXML(new FileInputStream(SETTINGS_FILE));
            }
            catch (Exception e) {
                System.err.println("Failed to load properties!");
                e.printStackTrace(System.err);
            }
        } else {
            System.err.println("Warning: settings file does not exist, the default settings will be used.");
        }
    }

    public static void saveProperties() {
        try {
            FileOutputStream output = new FileOutputStream(SETTINGS_FILE);
            properties.storeToXML(output, "Saved at " + new Date());
            output.close();
        }
        catch (Exception e) {
            System.err.println("Failed to save properties!");
            e.printStackTrace(System.err);
        }
    }

    public static void set(String key, Object value) {
        properties.setProperty(key, value.toString());
    }

    public static String getString(String key) {
        return properties.getProperty(key);
    }

    public static int getInt(String key) {
        return Integer.parseInt(properties.getProperty(key));
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(properties.getProperty(key));
    }
}

