/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.AbilityCodes;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class ReplayUtils {
    public static final Comparator<GameEvents.Action> ACTION_FRAME_COMPARATOR = new Comparator<GameEvents.Action>(){

        @Override
        public int compare(GameEvents.Action a1, GameEvents.Action a2) {
            return a1.frame - a2.frame;
        }
    };
    public static final AbilityCodes CURRENT_ABILITY_CODES;
    private static final List<AbilityCodes> abilityCodesList;

    static {
        abilityCodesList = new ArrayList<AbilityCodes>();
        String[] stringArray = new String[]{"ability_codes_0.16-", "ability_codes_0.11-0.14"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            String minVersionString = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.indexOf(45));
            String maxVersionString = fileName.substring(fileName.indexOf(45) + 1);
            AbilityCodes abilityCodes = new AbilityCodes(ReplayUtils.parseVersion(minVersionString), ReplayUtils.parseVersion(maxVersionString));
            BufferedReader input = null;
            try {
                try {
                    String line;
                    input = new BufferedReader(new InputStreamReader(ReplayUtils.class.getResourceAsStream(fileName)));
                    while ((line = input.readLine()) != null) {
                        if (line.charAt(4) == ' ') {
                            Short unitType = Short.valueOf(line.substring(0, 4), 16);
                            abilityCodes.UNIT_TYPE_NAME.put(unitType, line.substring(6, line.length() - 1));
                            continue;
                        }
                        Integer abilityCode = Integer.valueOf(line.substring(0, 6), 16);
                        if ((line = line.substring(7)).charAt(0) == '\"') {
                            int index = line.indexOf(34, 1);
                            String abilityName = line.substring(1, index);
                            String abilityGroupName = ReplayUtils.getNextToken(line, index + 2);
                            abilityGroupName = "null".equals(abilityGroupName) ? null : abilityGroupName.substring(abilityGroupName.indexOf(46) + 1);
                            abilityCodes.COMMON_BASE_ABILITY_CODES.put(abilityCode, new Object[]{abilityName, abilityGroupName == null ? null : ReplayConsts.AbilityGroup.valueOf(abilityGroupName)});
                            continue;
                        }
                        String entity = ReplayUtils.getNextToken(line, line.indexOf(46) + 1);
                        if (line.startsWith("Unit.")) {
                            abilityCodes.TRAIN_ABILITY_CODES.put(abilityCode, ReplayConsts.Unit.valueOf(entity));
                            continue;
                        }
                        if (line.startsWith("WUnit.")) {
                            abilityCodes.WARP_ABILITY_CODES.put(abilityCode, ReplayConsts.Unit.valueOf(entity));
                            continue;
                        }
                        if (line.startsWith("HUnit.")) {
                            abilityCodes.TRAIN_HALLU_ABILITY_CODES.put(abilityCode, ReplayConsts.Unit.valueOf(entity));
                            continue;
                        }
                        if (line.startsWith("Building.")) {
                            abilityCodes.BUILD_ABILITY_CODES.put(abilityCode, ReplayConsts.Building.valueOf(entity));
                            continue;
                        }
                        if (line.startsWith("Research.")) {
                            abilityCodes.RESEARCH_ABILITY_CODES.put(abilityCode, ReplayConsts.Research.valueOf(entity));
                            continue;
                        }
                        if (line.startsWith("Upgrade.")) {
                            abilityCodes.UPGRADE_ABILITY_CODES.put(abilityCode, ReplayConsts.Upgrade.valueOf(entity));
                            continue;
                        }
                        if (line.startsWith("UnitAbility.")) {
                            abilityCodes.USE_UNIT_ABILITY.put(abilityCode, new Object[]{ReplayConsts.UnitAbility.valueOf(entity), ReplayConsts.Unit.valueOf(ReplayUtils.getNextToken(line, line.indexOf("Unit.") + 5))});
                            continue;
                        }
                        if (!line.startsWith("BuildingAbility.")) continue;
                        abilityCodes.USE_BUILDING_ABILITY.put(abilityCode, new Object[]{ReplayConsts.BuildingAbility.valueOf(entity), ReplayConsts.Building.valueOf(ReplayUtils.getNextToken(line, line.indexOf("Building.") + 9))});
                    }
                    abilityCodesList.add(abilityCodes);
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                    throw new RuntimeException("Internal error: failed to load ability codes!");
                }
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
            }
            ++n2;
        }
        CURRENT_ABILITY_CODES = abilityCodesList.get(0);
    }

    public static String formatFrames(int frames) {
        return ReplayUtils.formatMs(frames * 125 >> 3);
    }

    public static String formatMs(int ms) {
        GregorianCalendar calendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
        ((Calendar)calendar).add(14, ms);
        return Language.formatTime(calendar.getTime());
    }

    public static String formatFramesShort(int frames) {
        int sec = frames >> 6;
        int hour = 0;
        int min = 0;
        if (sec >= 3600) {
            hour = sec / 3600;
            sec %= 3600;
        }
        if (sec >= 60) {
            min = sec / 60;
            sec %= 60;
        }
        return hour > 0 ? String.valueOf(hour) + (min < 10 ? ":0" : ":") + min + (sec < 10 ? ":0" : ":") + sec : String.valueOf(min) + (sec < 10 ? ":0" : ":") + sec;
    }

    public static String formatCoordinate(int coord) {
        return String.format(Locale.ENGLISH, "%.1f", Float.valueOf((float)coord / 65536.0f));
    }

    public static ImageIcon parseTgaImage(byte[] data) {
        int width = data[12] & 0xFF | (data[13] & 0xFF) << 8;
        int height = data[14] & 0xFF | (data[15] & 0xFF) << 8;
        BufferedImage bufferedImage = new BufferedImage(width, height, 5);
        int pos = 18;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int rgb = (data[pos + 2] & 0xFF) << 16 | (data[pos + 1] & 0xFF) << 8 | data[pos] & 0xFF;
                pos += 3;
                bufferedImage.setRGB(x, y, rgb);
                ++x;
            }
            ++y;
        }
        return new ImageIcon(bufferedImage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] parseVersion(String text) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(text, ".");
            ArrayList<Integer> numberList = new ArrayList<Integer>(4);
            while (tokenizer.hasMoreTokens()) {
                int n = Integer.parseInt(tokenizer.nextToken());
                if (n < 0) {
                    return null;
                }
                numberList.add(n);
            }
            int[] version = new int[numberList.size()];
            int i = 0;
            while (i < version.length) {
                version[i] = (Integer)numberList.get(i);
                ++i;
            }
            return version;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int compareVersions(int[] v1, int[] v2) {
        int i = 0;
        while (i < v1.length && i < v2.length) {
            if (v1[i] != v2[i]) {
                return v1[i] - v2[i];
            }
            ++i;
        }
        return 0;
    }

    public static AbilityCodes getAbilityCodesForVersion(int[] version) {
        for (AbilityCodes abilityCodes : abilityCodesList) {
            if (ReplayUtils.compareVersions(version, abilityCodes.minVersion) < 0) continue;
            return abilityCodes;
        }
        return null;
    }

    private static String getNextToken(String source, int fromIndex) {
        while (source.charAt(fromIndex) == ' ') {
            ++fromIndex;
        }
        int endPos = fromIndex;
        while (endPos < source.length() && source.charAt(endPos) != ',' && source.charAt(endPos) != ' ') {
            ++endPos;
        }
        return source.substring(fromIndex, endPos);
    }
}

