/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay;

import hu.belicza.andras.sc2gears.mpq.MpqParser;
import hu.belicza.andras.sc2gears.mpq.model.UserData;
import hu.belicza.andras.sc2gears.replay.AbilityCodes;
import hu.belicza.andras.sc2gears.replay.BitBufferView;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Details;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import hu.belicza.andras.sc2gears.replay.model.InitData;
import hu.belicza.andras.sc2gears.replay.model.MapInfo;
import hu.belicza.andras.sc2gears.replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.CommonUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public class ReplayParser {
    private static final byte[] STAR_S2MA = new byte[]{42, 115, 50, 109, 97};
    private static final byte[] S2MA = new byte[]{115, 50, 109, 97};
    public static final Set<ReplayContent> ALL_CONTENT = EnumSet.allOf(ReplayContent.class);
    public static final Set<ReplayContent> GENERAL_INFO_CONTENT = EnumSet.of(ReplayContent.INIT_DATA, ReplayContent.DETAILS, ReplayContent.ATTRIBUTES_EVENTS);

    private ReplayParser() {
    }

    public static Replay parseReplay(String fileName, Set<ReplayContent> contentToExtractSet) {
        MpqParser mpqParser = null;
        try {
            mpqParser = new MpqParser(fileName);
            Replay replay = new Replay();
            UserData userData = mpqParser.getUserData();
            ByteBuffer udWrapper = ByteBuffer.wrap(userData.userData).order(ByteOrder.BIG_ENDIAN);
            udWrapper.position(27);
            replay.buildNumbers = new int[4];
            replay.buildNumbers[0] = udWrapper.get() & 0xFF;
            replay.buildNumbers[1] = udWrapper.get() & 0xFF;
            replay.buildNumbers[2] = udWrapper.get() & 0xFF;
            replay.buildNumbers[3] = udWrapper.getInt();
            replay.version = String.valueOf(replay.buildNumbers[0]) + "." + replay.buildNumbers[1] + "." + replay.buildNumbers[2] + "." + replay.buildNumbers[3];
            if (ReplayUtils.getAbilityCodesForVersion(replay.buildNumbers) == null) {
                System.out.println("Unsupported replay version (" + replay.version + ")!");
                return null;
            }
            udWrapper.position(udWrapper.position() + 6);
            replay.gameLength = udWrapper.getShort() & 0xFFFF;
            replay.gameLengthSec = replay.gameLength >> 1;
            if (contentToExtractSet.contains((Object)ReplayContent.INIT_DATA)) {
                ReplayParser.parseInitData(replay, mpqParser.getFile(ReplayContent.INIT_DATA.hash1, ReplayContent.INIT_DATA.hash2, ReplayContent.INIT_DATA.hash3));
            }
            if (contentToExtractSet.contains((Object)ReplayContent.DETAILS)) {
                ReplayParser.parseDetails(replay, mpqParser.getFile(ReplayContent.DETAILS.hash1, ReplayContent.DETAILS.hash2, ReplayContent.DETAILS.hash3));
            }
            if (contentToExtractSet.contains((Object)ReplayContent.ATTRIBUTES_EVENTS)) {
                ReplayParser.parseAttributesEvents(replay, mpqParser.getFile(ReplayContent.ATTRIBUTES_EVENTS.hash1, ReplayContent.ATTRIBUTES_EVENTS.hash2, ReplayContent.ATTRIBUTES_EVENTS.hash3));
            }
            for (ReplayContent replayContent : contentToExtractSet) {
                byte[] fileContent = mpqParser.getFile(replayContent.hash1, replayContent.hash2, replayContent.hash3);
                switch (replayContent) {
                    case GAME_EVENTS: {
                        ReplayParser.parseGameEvents(fileContent, replay);
                        break;
                    }
                    case MESSAGE_EVENTS: {
                        ReplayParser.parseMessageEvents(fileContent, replay);
                        break;
                    }
                    case SMARTCAM_EVENTS: {
                        break;
                    }
                    case SYNC_EVENTS: {
                        break;
                    }
                    case MAP_INFO: {
                        ReplayParser.parseMapInfo(replay);
                    }
                }
            }
            if (replay.frames <= 0) {
                replay.frames = mpqParser.getFileSize(ReplayContent.SYNC_EVENTS.hash1, ReplayContent.SYNC_EVENTS.hash2, ReplayContent.SYNC_EVENTS.hash3);
            }
            Replay replay2 = replay;
            return replay2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            if (mpqParser != null) {
                mpqParser.close();
            }
        }
    }

    private static void parseInitData(Replay replay, byte[] data) {
        InitData initData = replay.initData = new InitData();
        ByteBuffer wrapper = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        int maxClientsCount = wrapper.get() & 0xFF;
        ArrayList<String> clientNameList = new ArrayList<String>();
        int i = 0;
        while (i < maxClientsCount) {
            String clientName = ReplayParser.readString(wrapper);
            clientNameList.add(clientName);
            wrapper.position(wrapper.position() + 5);
            ++i;
        }
        initData.clientNames = clientNameList.toArray(new String[clientNameList.size()]);
        if (ReplayParser.positionAfter(STAR_S2MA, wrapper)) {
            wrapper.get();
            initData.gateway = ReplayConsts.Gateway.fromBinaryValue(ReplayParser.readStringWithLength(3, wrapper));
            boolean foundMapHash = true;
            int i2 = 0;
            while (i2 < 4 && foundMapHash) {
                foundMapHash &= ReplayParser.positionAfter(S2MA, wrapper);
                ++i2;
            }
            if (foundMapHash) {
                wrapper.position(wrapper.position() + 4);
                byte[] mapFileHash = new byte[32];
                wrapper.get(mapFileHash);
                String mapFileHashString = CommonUtils.convertToHexString(mapFileHash);
                StringBuilder mapFileNameBuilder = new StringBuilder();
                mapFileNameBuilder.append(mapFileHashString.charAt(0)).append(mapFileHashString.charAt(1)).append('/').append(mapFileHashString.charAt(2)).append(mapFileHashString.charAt(3)).append('/').append(mapFileHashString).append(".s2ma");
                initData.mapFileName = mapFileNameBuilder.toString();
            }
        } else {
            initData.gameType = ReplayConsts.GameType.SINGLE_PLAYER;
        }
    }

    private static void parseDetails(Replay replay, byte[] data) {
        Details details = replay.details = new Details();
        ByteBuffer wrapper = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        int maxPlayersCount = 16;
        wrapper.position(63);
        ArrayList<Details.Player> playerList = new ArrayList<Details.Player>(16);
        int i = 0;
        while (i < 16) {
            Details.Player player = new Details.Player();
            wrapper.getInt();
            player.name = ReplayParser.readStringWithLength(ReplayParser.readValueStrut(wrapper), wrapper);
            if (player.name.length() == 0) {
                wrapper.position(wrapper.position() + 51 + (16 - i - 2) * 56);
                break;
            }
            wrapper.get();
            wrapper.getInt();
            ReplayParser.readValueStrut(wrapper);
            wrapper.getShort();
            wrapper.getInt();
            wrapper.getShort();
            ReplayParser.readValueStrut(wrapper);
            wrapper.getShort();
            player.fullName = ReplayParser.readStringWithLength(ReplayParser.readValueStrut(wrapper), wrapper).replace('#', '.');
            if (player.fullName.length() == 0 && player.name.length() > 0) {
                player.fullName = player.name;
            }
            wrapper.getShort();
            player.raceString = ReplayParser.readStringWithLength(ReplayParser.readValueStrut(wrapper), wrapper);
            wrapper.getShort();
            int count = wrapper.get() & 0xFF;
            int j = 0;
            while (j < 4) {
                wrapper.getShort();
                player.argbColor[j] = ReplayParser.readValueStrut(wrapper);
                ++j;
            }
            j = 4;
            while (j <= count) {
                wrapper.getShort();
                ReplayParser.readValueStrut(wrapper);
                ++j;
            }
            playerList.add(player);
            ++i;
        }
        details.players = playerList.toArray(new Details.Player[playerList.size()]);
        wrapper.getShort();
        details.mapName = ReplayParser.readStringWithLength(ReplayParser.readValueStrut(wrapper), wrapper);
        wrapper.getShort();
        ReplayParser.readStringWithLength(ReplayParser.readValueStrut(wrapper), wrapper);
        wrapper.getShort();
        wrapper.get();
        wrapper.getShort();
        details.mapPreviewFileName = ReplayParser.readStringWithLength(ReplayParser.readValueStrut(wrapper), wrapper);
    }

    private static void parseAttributesEvents(Replay replay, byte[] data) {
        ByteBuffer wrapper = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        wrapper.getInt();
        int attributesCount = wrapper.getInt();
        int maxPlayerIdx = 0;
        int i = 0;
        while (i < attributesCount) {
            wrapper.getInt();
            short attributeId = wrapper.getShort();
            wrapper.getShort();
            int player = (wrapper.get() & 0xFF) - 1;
            String value = ReplayParser.readStringWithLength(4, wrapper);
            switch (attributeId) {
                case 500: {
                    replay.details.players[player].type = ReplayConsts.PlayerType.fromBinaryValue(value);
                    break;
                }
                case 3001: {
                    replay.details.players[player].race = ReplayConsts.Race.fromBinaryValue(value);
                    break;
                }
                case 2001: {
                    replay.initData.format = ReplayConsts.Format.fromBinaryValue(value.indexOf(0) < 0 ? value : value.substring(0, value.indexOf(0)));
                    break;
                }
                case 2005: {
                    replay.details.players[player].team = value.charAt(0) - 48;
                    break;
                }
                case 3000: {
                    replay.initData.gameSpeed = ReplayConsts.GameSpeed.fromBinaryValue(value);
                    break;
                }
                case 3009: {
                    replay.initData.gameType = ReplayConsts.GameType.fromBinaryValue(value.indexOf(0) < 0 ? value : value.substring(0, value.indexOf(0)));
                    break;
                }
                case 3003: {
                    break;
                }
                case 3007: {
                    if (maxPlayerIdx >= player) break;
                    maxPlayerIdx = player;
                }
            }
            ++i;
        }
        if (replay.details.players.length - 1 > maxPlayerIdx) {
            replay.details.players = Arrays.copyOfRange(replay.details.players, 0, maxPlayerIdx + 1);
        }
    }

    private static void parseMessageEvents(byte[] data, Replay replay) {
        MessageEvents messageEvents = replay.messageEvents = new MessageEvents();
        ByteBuffer wrapper = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        int position = 0;
        while (position + 2 < data.length && data[position] == 0 && data[position + 2] == -128) {
            position += 7;
        }
        wrapper.position(position);
        ArrayList<MessageEvents.Blink> messageList = new ArrayList<MessageEvents.Blink>();
        while (wrapper.hasRemaining()) {
            int indicator = wrapper.get() & 0xFF;
            int time = indicator >> 2;
            if ((indicator & 1) != 0) {
                time = (time << 8) + (wrapper.get() & 0xFF);
            } else if ((indicator & 2) != 0) {
                time = (time << 16) + ((wrapper.get() & 0xFF) << 8) + (wrapper.get() & 0xFF);
            }
            time = time * 125 / 2;
            int client = (wrapper.get() & 0xF) - 1;
            byte opCode = wrapper.get();
            MessageEvents.Message message = opCode == -125 ? new MessageEvents.Blink() : new MessageEvents.Text((byte)(opCode & 7));
            message.time = time;
            message.client = client;
            if (opCode == -125) {
                message.x = Integer.reverseBytes(wrapper.getInt()) >> 1;
                message.y = Integer.reverseBytes(wrapper.getInt()) >> 1;
            } else {
                ((MessageEvents.Text)message).text = ReplayParser.readStringWithLength((wrapper.get() & 0xFF) + ((opCode & 8) != 0 ? 64 : 0), wrapper);
            }
            messageList.add((MessageEvents.Blink)message);
        }
        messageEvents.messages = messageList.toArray(new MessageEvents.Message[messageList.size()]);
    }

    private static void parseGameEvents(byte[] data, Replay replay) {
        AbilityCodes abilityCodes = ReplayUtils.getAbilityCodesForVersion(replay.buildNumbers);
        Details.Player[] players = replay.details.players;
        byte playersCount = (byte)players.length;
        GameEvents gameEvents = replay.gameEvents = new GameEvents(players, abilityCodes.UNIT_TYPE_NAME);
        ByteBuffer wrapper = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<GameEvents.SendResourcesAction> actionList = new ArrayList<GameEvents.SendResourcesAction>();
        int accumulatedFrames = 0;
        int lastActionStart = 0;
        int actionStart = 0;
        byte opCode = 0;
        while (wrapper.hasRemaining()) {
            lastActionStart = actionStart;
            byte lastOpCode = opCode;
            actionStart = wrapper.position();
            int indicator = wrapper.get() & 0xFF;
            int time = indicator >> 2;
            if ((indicator & 1) != 0) {
                time = (time << 8) + (wrapper.get() & 0xFF);
            } else if ((indicator & 2) != 0) {
                time = (wrapper.get() & 0xFF) >> 2;
            }
            accumulatedFrames += time << 2;
            byte eventDesc = wrapper.get();
            byte player = (byte)((eventDesc & 0xF) - 1);
            opCode = wrapper.get();
            if (opCode != 6 && ((eventDesc & 0xE0) == 64 || (eventDesc & 0xE0) == 0 || (eventDesc & 0xE0) >= 192)) continue;
            GameEvents.Action action = null;
            switch (opCode) {
                case -116: 
                case -100: 
                case -84: 
                case 12: 
                case 28: 
                case 44: 
                case 60: 
                case 76: 
                case 92: 
                case 108: 
                case 124: {
                    if ((eventDesc & 0xF0) == 128) break;
                    GameEvents.SelectAction sa = gameEvents.new GameEvents.SelectAction();
                    action = sa;
                    boolean bl = sa.automatic = opCode != -84;
                    if (sa.automatic) {
                        sa.type = ReplayConsts.ActionType.INACTION;
                    }
                    wrapper.get();
                    sa.deselectionBitsCount = wrapper.get() & 0xFF;
                    if ((sa.deselectionBitsCount & 7) == 0) {
                        if (sa.deselectionBitsCount > 0) {
                            sa.deselectionUnitBitmap = new byte[sa.deselectionBitsCount >> 3];
                            int i = 0;
                            while (i < sa.deselectionUnitBitmap.length) {
                                sa.deselectionUnitBitmap[i] = wrapper.get();
                                ++i;
                            }
                        }
                        int unitTypesCount = wrapper.get() & 0xFF;
                        sa.unitTypes = new short[unitTypesCount];
                        sa.unitsOfTypeCounts = new byte[unitTypesCount];
                        int i = 0;
                        while (i < unitTypesCount) {
                            sa.unitTypes[i] = (short)(((wrapper.get() & 0xFF) << 8) + (wrapper.get() & 0xFF));
                            wrapper.get();
                            sa.unitsOfTypeCounts[i] = wrapper.get();
                            ++i;
                        }
                        int totalUnitsCount = wrapper.get() & 0xFF;
                        sa.unitIds = new int[totalUnitsCount];
                        int i2 = 0;
                        while (i2 < totalUnitsCount) {
                            sa.unitIds[i2] = wrapper.getInt();
                            ++i2;
                        }
                        break;
                    }
                    sa.deselectionUnitBitmap = new byte[sa.deselectionBitsCount + 7 >> 3];
                    int i = 0;
                    while (i < sa.deselectionUnitBitmap.length - 1) {
                        sa.deselectionUnitBitmap[i] = wrapper.get();
                        ++i;
                    }
                    BitBufferView bitBuffer = new BitBufferView(wrapper, sa.deselectionBitsCount & 7);
                    sa.deselectionUnitBitmap[sa.deselectionUnitBitmap.length - 1] = bitBuffer.initialBits;
                    int unitTypesCount = bitBuffer.get();
                    sa.unitTypes = new short[unitTypesCount];
                    sa.unitsOfTypeCounts = new byte[unitTypesCount];
                    int i3 = 0;
                    while (i3 < unitTypesCount) {
                        sa.unitTypes[i3] = bitBuffer.get2Bytes();
                        bitBuffer.get();
                        sa.unitsOfTypeCounts[i3] = (byte)bitBuffer.get();
                        ++i3;
                    }
                    int totalUnitsCount = bitBuffer.get();
                    sa.unitIds = new int[totalUnitsCount];
                    int i4 = 0;
                    while (i4 < totalUnitsCount) {
                        sa.unitIds[i4] = bitBuffer.getInt();
                        ++i4;
                    }
                    int remainder = bitBuffer.getRemainder();
                    if (remainder <= 0) break;
                    wrapper.position(wrapper.position() + remainder);
                    break;
                }
                case -127: {
                    GameEvents.MoveScreenAction msa = gameEvents.new GameEvents.MoveScreenAction();
                    action = msa;
                    msa.x = Integer.reverseBytes(wrapper.getInt());
                    msa.y = Integer.reverseBytes(wrapper.getInt());
                    msa.hor = Integer.reverseBytes(wrapper.getInt());
                    msa.vert = Integer.reverseBytes(wrapper.getInt());
                    wrapper.getInt();
                    break;
                }
                case -115: 
                case -99: 
                case 13: 
                case 29: 
                case 45: 
                case 61: 
                case 77: 
                case 93: 
                case 109: 
                case 125: {
                    GameEvents.HotkeyAction ha = gameEvents.new GameEvents.HotkeyAction();
                    action = ha;
                    int flag = (wrapper.get() & 0xFF) << 8 | wrapper.get() & 0xFF;
                    boolean bl = ha.isSelect = (flag & 0x200) == 512;
                    if (ha.isSelect) {
                        action.type = ReplayConsts.ActionType.SELECT;
                    }
                    wrapper.position(wrapper.position() + (flag >> 11) + ((flag & 0x400) == 1024 && (flag & 3) == 3 ? 1 : 0));
                    break;
                }
                case -119: {
                    wrapper.getInt();
                    break;
                }
                case 11: {
                    wrapper.get();
                    wrapper.get();
                    wrapper.get();
                    wrapper.get();
                    int abilityCode = ((wrapper.get() & 0xFF) << 16) + ((wrapper.get() & 0xFF) << 8) + (wrapper.get() & 0xFF);
                    ReplayConsts.Unit unit = null;
                    ReplayConsts.Building building = null;
                    ReplayConsts.Upgrade upgrade = null;
                    ReplayConsts.Research research = null;
                    Object[] abilityParams = abilityCodes.COMMON_BASE_ABILITY_CODES.get(abilityCode);
                    if (abilityParams != null) {
                        GameEvents gameEvents2 = gameEvents;
                        gameEvents2.getClass();
                        action = gameEvents2.new GameEvents.BaseUseAbilityAction((String)abilityParams[0], (ReplayConsts.AbilityGroup)((Object)abilityParams[1]));
                    } else {
                        unit = abilityCodes.TRAIN_ABILITY_CODES.get(abilityCode);
                        if (unit != null) {
                            GameEvents gameEvents3 = gameEvents;
                            gameEvents3.getClass();
                            action = gameEvents3.new GameEvents.TrainAction(unit);
                        } else {
                            building = abilityCodes.BUILD_ABILITY_CODES.get(abilityCode);
                            if (building != null) {
                                GameEvents gameEvents4 = gameEvents;
                                gameEvents4.getClass();
                                action = gameEvents4.new GameEvents.BuildAction(building);
                            } else {
                                abilityParams = abilityCodes.USE_UNIT_ABILITY.get(abilityCode);
                                if (abilityParams != null) {
                                    GameEvents gameEvents5 = gameEvents;
                                    gameEvents5.getClass();
                                    action = gameEvents5.new GameEvents.UseUnitAbilityAction((ReplayConsts.UnitAbility)((Object)abilityParams[0]), (ReplayConsts.Unit)((Object)abilityParams[1]));
                                } else {
                                    abilityParams = abilityCodes.USE_BUILDING_ABILITY.get(abilityCode);
                                    if (abilityParams != null) {
                                        GameEvents gameEvents6 = gameEvents;
                                        gameEvents6.getClass();
                                        action = gameEvents6.new GameEvents.UseBuildingAbilityAction((ReplayConsts.BuildingAbility)((Object)abilityParams[0]), (ReplayConsts.Building)((Object)abilityParams[1]));
                                    } else {
                                        unit = abilityCodes.WARP_ABILITY_CODES.get(abilityCode);
                                        if (unit != null) {
                                            GameEvents gameEvents7 = gameEvents;
                                            gameEvents7.getClass();
                                            action = gameEvents7.new GameEvents.WarpAction(unit);
                                        } else {
                                            unit = abilityCodes.TRAIN_HALLU_ABILITY_CODES.get(abilityCode);
                                            if (unit != null) {
                                                GameEvents gameEvents8 = gameEvents;
                                                gameEvents8.getClass();
                                                action = gameEvents8.new GameEvents.TrainHallucinatedAction(unit);
                                            } else {
                                                upgrade = abilityCodes.UPGRADE_ABILITY_CODES.get(abilityCode);
                                                if (upgrade != null) {
                                                    GameEvents gameEvents9 = gameEvents;
                                                    gameEvents9.getClass();
                                                    action = gameEvents9.new GameEvents.UpgradeAction(upgrade);
                                                } else {
                                                    research = abilityCodes.RESEARCH_ABILITY_CODES.get(abilityCode);
                                                    if (research != null) {
                                                        GameEvents gameEvents10 = gameEvents;
                                                        gameEvents10.getClass();
                                                        action = gameEvents10.new GameEvents.ResearchAction(research);
                                                    } else {
                                                        action = gameEvents.new GameEvents.BaseUseAbilityAction();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ((GameEvents.BaseUseAbilityAction)action).abilityCode = abilityCode;
                    if ((wrapper.get() & 0x10) != 0) {
                        wrapper.position(wrapper.position() + 25);
                        break;
                    }
                    wrapper.position(wrapper.position() + 24);
                    break;
                }
                case 0: {
                    wrapper.getInt();
                    break;
                }
                case 22: {
                    GameEvents.RequestResoucesAction rra = gameEvents.new GameEvents.RequestResoucesAction();
                    action = rra;
                    wrapper.getInt();
                    wrapper.getInt();
                    wrapper.getInt();
                    rra.minRequested = wrapper.getInt();
                    rra.gasRequested = wrapper.getInt();
                    wrapper.getInt();
                    break;
                }
                case -113: 
                case -97: 
                case 15: 
                case 31: 
                case 47: 
                case 63: 
                case 79: 
                case 95: 
                case 111: 
                case 127: {
                    action = gameEvents.new GameEvents.SendResourcesAction();
                    wrapper.position(wrapper.position() + 17);
                    break;
                }
                case 24: {
                    action = gameEvents.new GameEvents.CancelResRequestAction();
                    wrapper.getInt();
                    break;
                }
                case 6: {
                    action = gameEvents.new GameEvents.Action();
                    wrapper.position(wrapper.position() + 8);
                    break;
                }
                case 9: {
                    action = gameEvents.new GameEvents.LeaveGameAction();
                    break;
                }
                case 27: {
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    if ((eventDesc & 0xF0) == 128) break;
                    System.out.println("Unrecognized action (opCode=0x" + Integer.toHexString(opCode & 0xFF) + "), aborting parse (last opcode: 0x" + Integer.toHexString(lastOpCode & 0xFF) + ", total parsed: " + actionList.size() + ", stream pos: 0x" + Integer.toHexString(wrapper.position()) + ", last action startPos: 0x" + Integer.toHexString(lastActionStart) + " ).");
                    wrapper.position(wrapper.limit());
                }
            }
            if (action == null || player < 0 || player >= playersCount) continue;
            action.player = player;
            action.opCode = opCode;
            action.frame = accumulatedFrames;
            if (action.type != ReplayConsts.ActionType.INACTION) {
                players[player].lastActionFrame = accumulatedFrames;
            }
            actionList.add((GameEvents.SendResourcesAction)action);
        }
        gameEvents.actions = actionList.toArray(new GameEvents.Action[actionList.size()]);
    }

    private static void parseMapInfo(Replay replay) {
        File mapFile = ReplayParser.getMapFile(replay);
        if (mapFile == null || !mapFile.exists()) {
            return;
        }
        MpqParser mpqParser = null;
        try {
            mpqParser = new MpqParser(mapFile.getAbsolutePath());
            MapInfo mapInfo = new MapInfo();
            byte[] mapInfoData = mpqParser.getFile(ReplayContent.MAP_INFO.hash1, ReplayContent.MAP_INFO.hash2, ReplayContent.MAP_INFO.hash3);
            ByteBuffer wrapper = ByteBuffer.wrap(mapInfoData).order(ByteOrder.LITTLE_ENDIAN);
            if (wrapper.getInt() != 1298231369) {
                return;
            }
            try {
                wrapper.getInt();
                mapInfo.width = wrapper.getInt();
                mapInfo.height = wrapper.getInt();
                mapInfo.previewIcon = ReplayUtils.parseTgaImage(mpqParser.getFile(replay.details.mapPreviewFileName));
                replay.mapInfo = mapInfo;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (mpqParser != null) {
                mpqParser.close();
            }
        }
    }

    public static File getMapFile(Replay replay) {
        if (replay.initData.mapFileName == null) {
            return null;
        }
        File relativeMapsFolder = new File(Settings.getString("settings.folders.sc2Maps"));
        File mapsFolder = relativeMapsFolder.exists() ? relativeMapsFolder : new File(System.getProperty("user.home"), Settings.getString("settings.folders.sc2Maps"));
        return new File(mapsFolder, replay.initData.mapFileName);
    }

    private static int readValueStrut(ByteBuffer wrapper) {
        int value = (wrapper.get() & 0xFF) >> 1;
        if ((value & 0x40) == 0) {
            return value;
        }
        return (wrapper.get() & 0xFF) << 6 | value & 0x3F;
    }

    private static String readString(ByteBuffer wrapper) {
        byte[] buffer = new byte[wrapper.get() & 0xFF];
        wrapper.get(buffer);
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            return new String(buffer);
        }
    }

    private static String readStringWithLength(int length, ByteBuffer wrapper) {
        byte[] buffer = new byte[length];
        wrapper.get(buffer);
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            return new String(buffer);
        }
    }

    private static boolean positionAfter(byte[] pattern, ByteBuffer wrapper) {
        byte[] data = wrapper.array();
        int position = wrapper.position();
        while (position <= data.length - pattern.length) {
            int i = 0;
            while (i < pattern.length) {
                if (data[position + i] != pattern[i]) break;
                ++i;
            }
            if (i == pattern.length) break;
            ++position;
        }
        if (position <= data.length - pattern.length) {
            wrapper.position(position + pattern.length);
            return true;
        }
        return false;
    }

    public static enum ReplayContent {
        INIT_DATA("replay.initData", -750801643, 1518242780, -14336164),
        DETAILS("replay.details", 620083690, -746339684, -281006446),
        ATTRIBUTES_EVENTS("replay.attributes.events", 1306016990, 497594575, -1563492568),
        GAME_EVENTS("replay.game.events", 496563520, -1430084277, -193582187),
        MESSAGE_EVENTS("replay.message.events", 1089231967, 831857289, 1784674979),
        SMARTCAM_EVENTS("replay.smartcam.events", 1029411303, 992681632, -1221660585),
        SYNC_EVENTS("replay.sync.events", 1206425669, -907692176, 991491766),
        MAP_INFO("MapInfo", 456326858, 2000504491, 1514959542);

        public final String fileName;
        public final int hash1;
        public final int hash2;
        public final int hash3;

        private ReplayContent(String fileName, int hash1, int hash2, int hash3) {
            this.fileName = fileName;
            this.hash1 = hash1;
            this.hash2 = hash2;
            this.hash3 = hash3;
        }
    }
}

