/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.language;

import hu.belicza.andras.sc2gears.Consts;
import java.io.File;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Language {
    private String language;
    private String languageFileVersion;
    private String translatorFirstName;
    private String translatorLastName;
    private DateFormat DATE_FORMAT;
    private DateFormat DATE_TIME_FORMAT;
    private DateFormat TIME_FORMAT;
    private boolean personNameFormatFirstNameFirst;
    private final Map<String, String> textMap = new HashMap<String, String>();
    private static final Language DEFAULT_LANGUAGE;
    private static Language loadedLanguage;

    static {
        Language DEFAULT_LANGUAGE_ = null;
        try {
            DEFAULT_LANGUAGE_ = new Language("English");
        }
        catch (Exception e) {
            System.err.println("Failed to load the default language file, program will exit now!");
            System.exit(0);
        }
        loadedLanguage = DEFAULT_LANGUAGE = DEFAULT_LANGUAGE_;
    }

    private Language(String language) throws Exception {
        try {
            this.language = language;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File("Languages", String.valueOf(language) + ".xml"));
            Element docElement = document.getDocumentElement();
            this.languageFileVersion = docElement.getAttribute("version");
            if (!"1.10".equals(this.languageFileVersion)) {
                System.out.println("The language file (" + language + ") version (" + this.languageFileVersion + ") does not match the application version (" + "1.10" + ").");
                if ("English".equals(language)) {
                    System.out.println("The default language file (English) version MUST match the application version!");
                    if (!Consts.DEVELOPER_MODE) {
                        System.exit(0);
                    }
                } else {
                    System.out.println("Some texts might be displayed in the default language.");
                }
            }
            this.translatorFirstName = docElement.getAttribute("translatorFirstName");
            this.translatorLastName = docElement.getAttribute("translatorLastName");
            NodeList nodeList = docElement.getElementsByTagName("dateFormat");
            this.DATE_FORMAT = new SimpleDateFormat(((Element)nodeList.item(0)).getTextContent());
            nodeList = docElement.getElementsByTagName("dateTimeFormat");
            this.DATE_TIME_FORMAT = new SimpleDateFormat(((Element)nodeList.item(0)).getTextContent());
            nodeList = docElement.getElementsByTagName("timeFormat");
            this.TIME_FORMAT = new SimpleDateFormat(((Element)nodeList.item(0)).getTextContent());
            nodeList = docElement.getElementsByTagName("personNameFormat");
            String personNameFormat = ((Element)nodeList.item(0)).getTextContent();
            if (!"firstName lastName".equals(personNameFormat) && !"lastName firstName".equals(personNameFormat)) {
                throw new Exception("Invalid person name format!");
            }
            this.personNameFormatFirstNameFirst = "firstName lastName".equals(personNameFormat);
            nodeList = docElement.getElementsByTagName("text");
            if (DEFAULT_LANGUAGE != null) {
                this.textMap.putAll(Language.DEFAULT_LANGUAGE.textMap);
            }
            int length = nodeList.getLength();
            int i = 0;
            while (i < length) {
                Element text = (Element)nodeList.item(i);
                this.textMap.put(text.getAttribute("key"), text.getTextContent());
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load language file: " + language);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public static boolean loadLanguage(String language) {
        try {
            loadedLanguage = Language.DEFAULT_LANGUAGE.language.equals(language) ? DEFAULT_LANGUAGE : new Language(language);
            Language.updateUIManagerTexts();
            return true;
        }
        catch (Exception e) {
            System.err.println("Failed to load language file: " + language);
            return false;
        }
    }

    private static void updateUIManagerTexts() {
        UIManager.put("InternalFrameTitlePane.closeButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.close"));
        UIManager.put("InternalFrameTitlePane.minimizeButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.minimize"));
        UIManager.put("InternalFrameTitlePane.restoreButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.restore"));
        UIManager.put("InternalFrameTitlePane.maximizeButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.maximize"));
        UIManager.put("InternalFrameTitlePane.moveButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.move"));
        UIManager.put("InternalFrameTitlePane.sizeButtonText", Language.loadedLanguage.textMap.get("internalFrame.menu.size"));
        UIManager.put("InternalFrame.closeButtonToolTip", Language.loadedLanguage.textMap.get("internalFrame.toolTip.close"));
        UIManager.put("InternalFrame.iconButtonToolTip", Language.loadedLanguage.textMap.get("internalFrame.toolTip.minimize"));
        UIManager.put("InternalFrame.restoreButtonToolTip", Language.loadedLanguage.textMap.get("internalFrame.toolTip.restore"));
        UIManager.put("InternalFrame.maxButtonToolTip", Language.loadedLanguage.textMap.get("internalFrame.toolTip.maximize"));
        UIManager.put("FileChooser.openDialogTitleText", Language.loadedLanguage.textMap.get("fileChooser.openDialogTitle"));
        UIManager.put("FileChooser.saveDialogTitleText", Language.loadedLanguage.textMap.get("fileChooser.saveDialogTitle"));
        UIManager.put("FileChooser.lookInLabelText", Language.loadedLanguage.textMap.get("fileChooser.lookInLabel"));
        UIManager.put("FileChooser.filesOfTypeLabelText", Language.loadedLanguage.textMap.get("fileChooser.filesOfTypeLabel"));
        UIManager.put("FileChooser.fileNameLabelText", Language.loadedLanguage.textMap.get("fileChooser.fileNameLabel"));
        UIManager.put("FileChooser.upFolderToolTipText", Language.loadedLanguage.textMap.get("fileChooser.upFolderToolTip"));
        UIManager.put("FileChooser.homeFolderToolTipText", Language.loadedLanguage.textMap.get("fileChooser.homeFolderToolTip"));
        UIManager.put("FileChooser.newFolderToolTipText", Language.loadedLanguage.textMap.get("fileChooser.newFolderToolTip"));
        UIManager.put("FileChooser.listViewButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.listViewButtonToolTip"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.detailsViewButtonToolTip"));
        UIManager.put("FileChooser.saveButtonText", Language.loadedLanguage.textMap.get("fileChooser.saveButton"));
        UIManager.put("FileChooser.openButtonText", Language.loadedLanguage.textMap.get("fileChooser.openButton"));
        UIManager.put("FileChooser.cancelButtonText", Language.loadedLanguage.textMap.get("fileChooser.cancelButton"));
        UIManager.put("FileChooser.updateButtonText", Language.loadedLanguage.textMap.get("fileChooser.updateButton"));
        UIManager.put("FileChooser.helpButtonText", Language.loadedLanguage.textMap.get("fileChooser.helpButton"));
        UIManager.put("FileChooser.saveButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.saveButtonToolTip"));
        UIManager.put("FileChooser.openButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.openButtonToolTip"));
        UIManager.put("FileChooser.cancelButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.cancelButtonToolTip"));
        UIManager.put("FileChooser.updateButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.updateButtonToolTip"));
        UIManager.put("FileChooser.helpButtonToolTipText", Language.loadedLanguage.textMap.get("fileChooser.helpButtonToolTip"));
        UIManager.put("FileChooser.acceptAllFileFilterText", Language.loadedLanguage.textMap.get("fileChooser.acceptAllFileFilter"));
    }

    public static String getTranslatorName() {
        return Language.formatPersonName(Language.loadedLanguage.translatorFirstName, Language.loadedLanguage.translatorLastName);
    }

    public static String getLanguageFileVersion() {
        return Language.loadedLanguage.languageFileVersion;
    }

    public static String[] getAvailableLanguages() {
        String[] languageFileNames = new File("Languages").list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        String[] languages = new String[languageFileNames.length];
        int i = 0;
        while (i < languageFileNames.length) {
            languages[i] = languageFileNames[i].substring(0, languageFileNames[i].lastIndexOf(46));
            ++i;
        }
        Arrays.sort(languages, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return "English".equals(s1) ? -1 : ("English".equals(s2) ? 1 : s1.compareTo(s2));
            }
        });
        return languages;
    }

    public static String getText(String key) {
        return Language.loadedLanguage.textMap.get(key);
    }

    public static String getText(String key, Object ... arguments) {
        String text = Language.loadedLanguage.textMap.get(key);
        int i = 0;
        while (i < arguments.length) {
            text = text.replace("$" + i, arguments[i].toString());
            ++i;
        }
        return text;
    }

    public static String formatDate(Date date) {
        return Language.loadedLanguage.DATE_FORMAT.format(date);
    }

    public static String formatDateTime(Date dateTime) {
        return Language.loadedLanguage.DATE_TIME_FORMAT.format(dateTime);
    }

    public static String formatTime(Date time) {
        return Language.loadedLanguage.TIME_FORMAT.format(time);
    }

    public static String formatPersonName(String firstName, String lastName) {
        if (Language.loadedLanguage.personNameFormatFirstNameFirst) {
            return String.valueOf(firstName) + ' ' + lastName;
        }
        return String.valueOf(lastName) + ' ' + firstName;
    }

    public static String getYesNo(boolean value) {
        return Language.getText(value ? "general.yes" : "general.no");
    }
}

