/*
 * Decompiled with CFR 0.152.
 */
package org.fife.plaf.OfficeXP;

import com.sun.java.swing.plaf.windows.WindowsMenuUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.text.View;
import org.fife.plaf.OfficeXP.OfficeXPGraphicsUtils;
import org.fife.plaf.OfficeXP.OfficeXPLookAndFeel;
import org.fife.plaf.OfficeXP.OfficeXPMenuItemUI;
import org.fife.plaf.OfficeXP.OfficeXPUtilities;

public class OfficeXPMenuUI
extends WindowsMenuUI {
    private boolean isMouseOver = false;
    protected static final Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    protected static Rectangle iconRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle arrowIconRect = new Rectangle();
    protected static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    protected static Rectangle r = new Rectangle();

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new OfficeXPMenuUI();
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        JMenu jMenu = (JMenu)jComponent;
        Dimension dimension = null;
        if (jMenu.isTopLevelMenu()) {
            dimension = super.getPreferredMenuItemSize((JComponent)jMenu, icon, icon2, n);
            dimension.width += 4;
            dimension.height = 22;
        } else {
            dimension = this.getPreferredNonTopLevelMenuSize(jMenu, icon, icon2, n);
        }
        return dimension;
    }

    protected Dimension getPreferredNonTopLevelMenuSize(JMenu jMenu, Icon icon, Icon icon2, int n) {
        Serializable serializable;
        Icon icon3 = jMenu.getIcon();
        String string = jMenu.getText();
        Font font = jMenu.getFont();
        FontMetrics fontMetrics = jMenu.getFontMetrics(font);
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, icon3, icon2, viewRect, iconRect, textRect, arrowIconRect, string == null ? 0 : n, n);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(OfficeXPMenuUI.iconRect.x, OfficeXPMenuUI.iconRect.y, OfficeXPMenuUI.iconRect.width, OfficeXPMenuUI.iconRect.height, r);
        Container container = jMenu.getParent();
        if (container != null && container instanceof JComponent) {
            int n2;
            serializable = (JComponent)container;
            Integer n3 = (Integer)serializable.getClientProperty("maxTextWidth");
            int n4 = n2 = n3 != null ? n3 : 0;
            if (OfficeXPMenuUI.r.width < n2) {
                OfficeXPMenuUI.r.width = n2;
            } else {
                serializable.putClientProperty("maxTextWidth", new Integer(OfficeXPMenuUI.r.width));
            }
            OfficeXPMenuUI.r.width += n;
        }
        OfficeXPMenuUI.r.width += 20;
        OfficeXPMenuUI.r.width += n;
        OfficeXPMenuUI.r.width += n;
        OfficeXPMenuUI.r.width += 12;
        OfficeXPMenuUI.r.width += 2 * n;
        serializable = jMenu.getInsets();
        if (serializable != null) {
            OfficeXPMenuUI.r.width += ((Insets)serializable).left + ((Insets)serializable).right;
            OfficeXPMenuUI.r.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (OfficeXPMenuUI.r.width % 2 == 0) {
            ++OfficeXPMenuUI.r.width;
        }
        if (OfficeXPMenuUI.r.height % 2 == 0) {
            ++OfficeXPMenuUI.r.height;
        }
        return new Dimension((int)r.getWidth(), 23);
    }

    protected boolean isMouseOver() {
        return this.isMouseOver;
    }

    protected String layoutMenuItem(FontMetrics fontMetrics, String string, Icon icon, Icon icon2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, int n, int n2) {
        OfficeXPMenuItemUI.layoutCompoundLabel(this.menuItem, fontMetrics, string, rectangle, rectangle2, rectangle3);
        if (icon2 != null) {
            rectangle4.width = icon2.getIconWidth();
            rectangle4.height = icon2.getIconHeight();
        } else {
            rectangle4.height = 0;
            rectangle4.width = 0;
        }
        int n3 = rectangle.x;
        rectangle3.x += n3;
        rectangle2.x += n3;
        rectangle4.x = this.menuItem.getComponentOrientation().isLeftToRight() ? rectangle.x + rectangle.width - n2 - rectangle4.width : rectangle.x + n2;
        rectangle4.y = 8;
        return string;
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        JMenu jMenu;
        if (OfficeXPLookAndFeel.isClassicWindows()) {
            super.paintBackground(graphics, jMenuItem, color);
        }
        if (!(jMenu = (JMenu)jMenuItem).isTopLevelMenu()) {
            this.paintSubmenuBackground(graphics, jMenu);
        } else {
            this.paintTopLevelMenuBackground(graphics, jMenu);
        }
    }

    protected void paintIcon(Graphics graphics, JMenuItem jMenuItem) {
        OfficeXPUtilities.paintMenuItemIcon(graphics, jMenuItem, iconRect);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        JMenu jMenu = (JMenu)jComponent;
        if (jMenu.isTopLevelMenu()) {
            super.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n);
        } else {
            JMenuItem jMenuItem = (JMenuItem)jComponent;
            int n2 = jMenuItem.getWidth();
            int n3 = jMenuItem.getHeight();
            this.resetRects();
            viewRect.setBounds(0, 0, n2, n3);
            Font font = graphics.getFont();
            Font font2 = jComponent.getFont();
            graphics.setFont(font2);
            FontMetrics fontMetrics = jComponent.getFontMetrics(font2);
            String string = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), jMenuItem.getIcon(), icon2, viewRect, iconRect, textRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n);
            this.paintBackground(graphics, jMenuItem, color);
            Color color3 = graphics.getColor();
            this.paintIcon(graphics, this.menuItem);
            if (string != null) {
                View view = (View)jComponent.getClientProperty("html");
                if (view != null) {
                    view.paint(graphics, textRect);
                } else {
                    this.paintText(graphics, jMenuItem, textRect, string);
                }
            }
            if (icon2 != null) {
                icon2.paintIcon(jComponent, graphics, OfficeXPMenuUI.arrowIconRect.x, OfficeXPMenuUI.arrowIconRect.y);
            }
            graphics.setColor(color3);
            graphics.setFont(font);
        }
    }

    protected void paintSubmenuBackground(Graphics graphics, JMenu jMenu) {
        JPopupMenu jPopupMenu;
        Container container;
        ButtonModel buttonModel = jMenu.getModel();
        Color color = graphics.getColor();
        int n = jMenu.getWidth();
        int n2 = jMenu.getHeight();
        this.paintUnarmedBackground(graphics, jMenu);
        if (buttonModel.isSelected()) {
            int n3 = n - 3;
            int n4 = n2 - 2;
            graphics.setColor(UIManager.getColor("OfficeLnF.HighlightBorderColor"));
            graphics.drawRect(1, 0, n3, n4);
            graphics.setColor(UIManager.getColor("OfficeLnF.HighlightColor"));
            graphics.fillRect(2, 1, n3 - 1, n4 - 1);
            graphics.setColor(color);
        }
        if ((container = jMenu.getParent()) instanceof JPopupMenu && (jPopupMenu = (JPopupMenu)container).getComponentIndex(jMenu) == jPopupMenu.getComponentCount() - 1) {
            graphics.setColor(jMenu.getBackground());
            int n5 = n2 - 1;
            graphics.drawLine(0, n5, n - 1, n5);
        }
        graphics.setColor(color);
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!buttonModel.isEnabled()) {
            OfficeXPGraphicsUtils.paintText(graphics, jMenuItem, rectangle, string, 0);
        } else {
            FontMetrics fontMetrics = jMenuItem.getFontMetrics(graphics.getFont());
            int n = jMenuItem.getDisplayedMnemonicIndex();
            OfficeXPGraphicsUtils.drawStringUnderlineCharAt(graphics, fontMetrics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    protected void paintTopLevelMenuBackground(Graphics graphics, JMenu jMenu) {
        ButtonModel buttonModel = jMenu.getModel();
        Color color = graphics.getColor();
        int n = jMenu.getWidth();
        int n2 = jMenu.getHeight();
        if (buttonModel.isArmed() || buttonModel.isSelected()) {
            graphics.setColor(UIManager.getColor("OfficeXPLnF.ChosenMenuColor"));
            graphics.fillRect(0, 0, n, n2);
            JPopupMenu jPopupMenu = jMenu.getPopupMenu();
            JMenuBar jMenuBar = (JMenuBar)jMenu.getParent();
            Point point = jMenu.getLocation();
            Point point2 = SwingUtilities.convertPoint(jPopupMenu, jPopupMenu.getLocation(), jMenuBar);
            graphics.setColor(UIManager.getDefaults().getColor("OfficeLnF.MenuBorderColor"));
            if (point.y < point2.y || !jMenu.isPopupMenuVisible()) {
                graphics.drawLine(0, 2, 0, n2 - 1);
                graphics.drawLine(0, 2, n - 5, 2);
                graphics.drawLine(n - 5, 2, n - 5, n2 - 1);
            } else {
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(0, n2 - 2, n - 5, n2 - 2);
                graphics.drawLine(n - 5, 0, n - 5, n2 - 2);
            }
        } else {
            graphics.setColor(jMenu.getBackground());
            graphics.fillRect(0, 0, n, n2);
            if (this.isMouseOver() && buttonModel.isEnabled()) {
                graphics.setColor(UIManager.getColor("OfficeLnF.HighlightBorderColor"));
                graphics.drawRect(0, 2, n - 5, n2 - 3);
                graphics.setColor(UIManager.getColor("OfficeLnF.HighlightColor"));
                graphics.fillRect(1, 3, n - 6, n2 - 4);
            }
        }
        graphics.setColor(color);
    }

    protected void paintUnarmedBackground(Graphics graphics, JMenuItem jMenuItem) {
        OfficeXPUtilities.paintMenuItemBackground(graphics, jMenuItem);
    }

    protected void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
    }

    protected class MouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected MouseInputHandler() {
            super((BasicMenuUI)((Object)OfficeXPMenuUI.this));
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            if (!OfficeXPLookAndFeel.isClassicWindows()) {
                OfficeXPMenuUI.this.setMouseOver(true);
                OfficeXPMenuUI.this.menuItem.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (!OfficeXPLookAndFeel.isClassicWindows()) {
                OfficeXPMenuUI.this.setMouseOver(false);
                OfficeXPMenuUI.this.menuItem.repaint();
            }
        }
    }
}

