/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.Sc2gears;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.logger.Log;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.CommonUtils;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.NormalThread;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ReplayAnalyzer;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplaySearch;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MainFrame
extends JFrame {
    public static MainFrame INSTANCE;
    private TrayIcon trayIcon;
    private final JSplitPane mainSplitPane = new JSplitPane(1, true);
    public final JMenuItem viewSystemMessagesMenuItem = new JMenuItem(Icons.REPORT_EXCLAMATION);
    private final JMenuItem checkUpdatesMenuItem = new JMenuItem(Icons.ARROW_CIRCLE_DOUBLE);
    private final JScrollPane navigationBar = new JScrollPane();
    private final JTree navigationTree = new JTree();
    private final DefaultMutableTreeNode repAnalNode = new DefaultMutableTreeNode(Language.getText("module.repAnalyzer.name"));
    public final DefaultMutableTreeNode newRepAnalNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode repSearchNode = new DefaultMutableTreeNode(Language.getText("module.repSearch.name"));
    private final DefaultMutableTreeNode newRepSearchNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode repSourcesNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repSources.name"));
    public final DefaultMutableTreeNode emptyRepSourceNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.empty") + '>');
    private final DefaultMutableTreeNode repListsNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repLists.name"));
    public final DefaultMutableTreeNode emptyRepListNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.empty") + '>');
    private final JDesktopPane desktopPane = new JDesktopPane();
    private MenuItem hideTrayMenuItem;
    private MenuItem restoreTrayMenuItem;

    public MainFrame(String[] arguments) {
        super("Sc2gears");
        if (INSTANCE != null) {
            throw new RuntimeException("Only one instance of MainFrame is allowed!");
        }
        INSTANCE = this;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MainFrame.this.exit(false, new String[0]);
            }
        });
        this.setIconImage(Icons.SC2GEARS.getImage());
        this.installTrayIcon();
        this.buildGUI();
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        this.setBounds(bounds.x + insets.left + 10, bounds.y + insets.top + 10, bounds.width - insets.left - insets.right - 20, bounds.height - insets.top - insets.bottom - 20);
        this.setVisible(true);
        ToolTipManager.sharedInstance().setInitialDelay(200);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        double dividerLoc = 0.24;
        if ((double)this.getWidth() * dividerLoc > 250.0) {
            dividerLoc = 250.0 / (double)this.getWidth();
        }
        this.mainSplitPane.setDividerLocation(Settings.getInt("navigation.position") == 0 ? dividerLoc : 1.0 - dividerLoc);
        if (Settings.getBoolean("settings.checkUpdatesOnStartup")) {
            this.checkUpdatesMenuItem.doClick();
        }
        if (arguments.length > 0) {
            this.openArguments(arguments);
        } else {
            Enum[] enumArray = ReplayConsts.Building.values();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReplayConsts.Building building = enumArray[n2];
                Icons.getBuildingIcon(building, IconHandler.Size.BIG);
                ++n2;
            }
            enumArray = ReplayConsts.Unit.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                Enum unit = enumArray[n2];
                Icons.getUnitIcon((ReplayConsts.Unit)unit, IconHandler.Size.BIG);
                ++n2;
            }
            enumArray = ReplayConsts.AbilityGroup.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                Enum abilityGroup = enumArray[n2];
                Icons.getAbilityGroupIcon((ReplayConsts.AbilityGroup)abilityGroup, IconHandler.Size.BIG);
                ++n2;
            }
        }
    }

    public void openArguments(final String[] arguments) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] stringArray = arguments;
                int n = arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    String argument = stringArray[n2];
                    File file = new File(argument);
                    if (GuiUtils.SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, null, file);
                    } else if (GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, file, null);
                    } else {
                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepAnalNode, new File(argument));
                    }
                    ++n2;
                }
            }
        });
    }

    private void installTrayIcon() {
        if (SystemTray.isSupported()) {
            TrayIcon trayIcon = new TrayIcon(Icons.SC2GEARS.getImage(), Language.getText("trayIcon.running", "Sc2gears"));
            trayIcon.setImageAutoSize(true);
            PopupMenu popupMenu = new PopupMenu();
            this.hideTrayMenuItem = new MenuItem(Language.getText("tray.hide"));
            this.hideTrayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.hideMainFrame();
                }
            });
            popupMenu.add(this.hideTrayMenuItem);
            this.restoreTrayMenuItem = new MenuItem(Language.getText("tray.restore"));
            this.restoreTrayMenuItem.setEnabled(false);
            this.restoreTrayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.restoreMainFrame();
                }
            });
            popupMenu.add(this.restoreTrayMenuItem);
            popupMenu.addSeparator();
            MenuItem exitMenuItem = new MenuItem(Language.getText("tray.exit"));
            exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.exit(false, new String[0]);
                }
            });
            popupMenu.add(exitMenuItem);
            trayIcon.setPopupMenu(popupMenu);
            trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.restoreMainFrame();
                }
            });
            try {
                SystemTray.getSystemTray().add(trayIcon);
                this.trayIcon = trayIcon;
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    private void buildGUI() {
        this.buildNavigationBar();
        this.mainSplitPane.setDividerSize(6);
        this.getContentPane().add(this.mainSplitPane);
        this.arrangeContent();
        this.buildMenuBar();
    }

    private void buildNavigationBar() {
        DefaultMutableTreeNode navigationRoot = new DefaultMutableTreeNode();
        this.repAnalNode.add(this.newRepAnalNode);
        navigationRoot.add(this.repAnalNode);
        this.repSearchNode.add(this.newRepSearchNode);
        navigationRoot.add(this.repSearchNode);
        navigationRoot.add(this.repSourcesNode);
        navigationRoot.add(this.repListsNode);
        this.refreshNavigationTree();
        ((DefaultTreeModel)this.navigationTree.getModel()).setRoot(navigationRoot);
        this.navigationTree.setRootVisible(false);
        this.navigationTree.setShowsRootHandles(true);
        this.navigationTree.getSelectionModel().setSelectionMode(1);
        this.navigationTree.setCellRenderer(this.createTreeCellRenderer());
        if (Settings.getBoolean("navigation.useSmallFont")) {
            this.navigationTree.setFont(new Font(this.navigationTree.getFont().getName(), 0, 10));
        }
        int i = 0;
        while (i < this.navigationTree.getRowCount()) {
            this.navigationTree.expandRow(i);
            ++i;
        }
        this.navigationTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 3 || event.getClickCount() == 2) {
                    TreePath path = MainFrame.this.navigationTree.getPathForLocation(event.getX(), event.getY());
                    if (path == null) {
                        return;
                    }
                    DefaultMutableTreeNode clickedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                    DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)clickedNode.getParent();
                    if (parentNode == MainFrame.this.repSourcesNode || parentNode == MainFrame.this.repListsNode) {
                        if (clickedNode == MainFrame.this.emptyRepSourceNode) {
                            GuiUtils.showInfoDialog(Language.getText("navigationTree.info.newRepSource"));
                        } else if (clickedNode == MainFrame.this.emptyRepListNode) {
                            GuiUtils.showInfoDialog(Language.getText("navigationTree.info.newRepList"));
                        } else {
                            File file;
                            File file2 = file = parentNode == MainFrame.this.repSourcesNode ? new File("User Content/Replay sources", String.valueOf(clickedNode.getUserObject().toString()) + ".sc2repsrc") : new File("User Content/Replay lists", String.valueOf(clickedNode.getUserObject().toString()) + ".csv");
                            if (event.getButton() == 3) {
                                MainFrame.this.navigationTree.setSelectionPath(path);
                                JPopupMenu popup = new JPopupMenu();
                                JMenuItem deleteReplaySourceMenuItem = new JMenuItem(Icons.CROSS);
                                GuiUtils.updateButtonText(deleteReplaySourceMenuItem, "navigationTree.popup.deleteItem", new Object[0]);
                                deleteReplaySourceMenuItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent event) {
                                        if (file.delete()) {
                                            MainFrame.this.refreshNavigationTree();
                                        }
                                    }
                                });
                                popup.add(deleteReplaySourceMenuItem);
                                popup.show(MainFrame.this.navigationTree, event.getX(), event.getY());
                            } else if (parentNode == MainFrame.this.repSourcesNode) {
                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, file, null);
                            } else {
                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, null, file);
                            }
                        }
                    } else if (event.getClickCount() == 2) {
                        MainFrame.this.createNewInternalFrame(clickedNode, new Object[0]);
                    }
                }
            }
        });
        this.navigationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                if (node.getUserObject() instanceof JInternalFrame) {
                    JInternalFrame iframe = (JInternalFrame)node.getUserObject();
                    try {
                        if (iframe.isIcon()) {
                            iframe.setIcon(false);
                        }
                        iframe.setSelected(true);
                    }
                    catch (PropertyVetoException pve) {
                        pve.printStackTrace();
                    }
                }
            }
        });
        this.navigationBar.setViewportView(this.navigationTree);
        this.navigationBar.setVisible(Settings.getBoolean("navigation.showNavbar"));
    }

    private TreeCellRenderer createTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node != MainFrame.this.newRepAnalNode && node != MainFrame.this.newRepSearchNode && node != MainFrame.this.emptyRepSourceNode && node != MainFrame.this.emptyRepListNode) {
                    TreeNode parentNode = node.getParent();
                    if (parentNode == MainFrame.this.repAnalNode) {
                        this.setIcon(Icons.CHART);
                    } else if (parentNode == MainFrame.this.repSearchNode) {
                        this.setIcon(Icons.BINOCULAR);
                    } else if (parentNode == MainFrame.this.repSourcesNode) {
                        this.setIcon(Icons.FOLDERS_STACK);
                    } else if (parentNode == MainFrame.this.repListsNode) {
                        this.setIcon(Icons.TABLE);
                    }
                }
                return this;
            }
        };
    }

    public void refreshNavigationTree() {
        int i = 0;
        while (i < 2) {
            DefaultMutableTreeNode node = i == 0 ? this.repSourcesNode : this.repListsNode;
            String folderName = i == 0 ? "User Content/Replay sources" : "User Content/Replay lists";
            final String extension = i == 0 ? ".sc2repsrc" : ".csv";
            node.removeAllChildren();
            String[] fileNames = new File(folderName).list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(extension);
                }
            });
            if (fileNames == null || fileNames.length == 0) {
                node.add(node == this.repSourcesNode ? this.emptyRepSourceNode : this.emptyRepListNode);
            } else {
                Arrays.sort(fileNames, String.CASE_INSENSITIVE_ORDER);
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    node.add(new DefaultMutableTreeNode(fileName.substring(0, fileName.lastIndexOf(46))));
                    ++n2;
                }
            }
            ((DefaultTreeModel)this.navigationTree.getModel()).reload(node);
            ++i;
        }
    }

    public void refreshRepAnalNavigationNode() {
        ((DefaultTreeModel)this.navigationTree.getModel()).reload(this.repAnalNode);
    }

    private void buildMenuBar() {
        String[] lafMenuItem;
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        GuiUtils.updateButtonText(fileMenu, "menu.file", new Object[0]);
        JMenuItem openReplayMenuItem = new JMenuItem(Icons.SC2);
        GuiUtils.updateButtonText(openReplayMenuItem, "menu.file.openReplay", new Object[0]);
        openReplayMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        openReplayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepAnalNode, new Object[0]);
            }
        });
        fileMenu.add(openReplayMenuItem);
        JMenuItem openLastReplayMenuItem = new JMenuItem(Icons.SC2);
        GuiUtils.updateButtonText(openLastReplayMenuItem, "menu.file.openLastReplay", new Object[0]);
        openLastReplayMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        openLastReplayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File relativeAutorepFolder = new File(Settings.getString("settings.folders.sc2AutoReplay"));
                File autorepFolder = relativeAutorepFolder.exists() ? relativeAutorepFolder : new File(System.getProperty("user.home"), Settings.getString("settings.folders.sc2AutoReplay"));
                File[] replayFiles = autorepFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && GuiUtils.SC2_REPLAY_FILTER.accept(pathname);
                    }
                });
                if (replayFiles == null || replayFiles.length == 0) {
                    GuiUtils.showErrorDialog(new Object[]{Language.getText(replayFiles == null ? "misc.autorepFolderNotExists" : "misc.autorepFolderEmpty"), autorepFolder.getAbsolutePath()});
                    return;
                }
                File lastReplayFile = replayFiles[replayFiles.length - 1];
                long lastReplayTime = lastReplayFile.lastModified();
                File[] fileArray = replayFiles;
                int n = replayFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.lastModified() > lastReplayTime) {
                        lastReplayFile = file;
                        lastReplayTime = file.lastModified();
                    }
                    ++n2;
                }
                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepAnalNode, lastReplayFile);
            }
        });
        fileMenu.add(openLastReplayMenuItem);
        fileMenu.addSeparator();
        JMenuItem exitMenuItem = new JMenuItem(Icons.DOOR_OPEN_IN);
        GuiUtils.updateButtonText(exitMenuItem, "menu.file.exit", new Object[0]);
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 512));
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainFrame.this.exit(false, new String[0]);
            }
        });
        fileMenu.add(exitMenuItem);
        menuBar.add(fileMenu);
        JMenu navigationMenu = new JMenu();
        GuiUtils.updateButtonText(navigationMenu, "menu.navigation", new Object[0]);
        JMenuItem refreshTreeMenuItem = new JMenuItem(Icons.ARROW_CIRCLE_315);
        GuiUtils.updateButtonText(refreshTreeMenuItem, "menu.navigation.refreshTree", new Object[0]);
        refreshTreeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainFrame.this.refreshNavigationTree();
            }
        });
        navigationMenu.add(refreshTreeMenuItem);
        navigationMenu.addSeparator();
        final JCheckBoxMenuItem useSmallFontMenuItem = GuiUtils.createCheckBoxMenuItem("menu.navigation.useSmallFont", "navigation.useSmallFont", Icons.APPLICATION_SIDEBAR_LIST);
        final JMenu navigationBarPositionMenu = new JMenu();
        final JCheckBoxMenuItem showNavigationBarMenuItem = GuiUtils.createCheckBoxMenuItem("menu.navigation.showNavbar", "navigation.showNavbar", Icons.APPLICATION_SIDEBAR);
        showNavigationBarMenuItem.addActionListener(new ActionListener(){
            private int storedLeftComponentWidth = 170;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!showNavigationBarMenuItem.isSelected()) {
                    this.storedLeftComponentWidth = MainFrame.this.mainSplitPane.getLeftComponent().getWidth();
                }
                MainFrame.this.navigationBar.setVisible(showNavigationBarMenuItem.isSelected());
                useSmallFontMenuItem.setEnabled(showNavigationBarMenuItem.isSelected());
                navigationBarPositionMenu.setEnabled(showNavigationBarMenuItem.isSelected());
                if (showNavigationBarMenuItem.isSelected()) {
                    MainFrame.this.mainSplitPane.setDividerLocation(this.storedLeftComponentWidth);
                }
                MainFrame.this.mainSplitPane.validate();
            }
        });
        navigationMenu.add(showNavigationBarMenuItem);
        useSmallFontMenuItem.setEnabled(Settings.getBoolean("navigation.showNavbar"));
        useSmallFontMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainFrame.this.navigationTree.setFont(new Font(MainFrame.this.navigationTree.getFont().getName(), 0, useSmallFontMenuItem.isSelected() ? 10 : 12));
            }
        });
        navigationMenu.add(useSmallFontMenuItem);
        navigationBarPositionMenu.setEnabled(Settings.getBoolean("navigation.showNavbar"));
        GuiUtils.updateButtonText(navigationBarPositionMenu, "menu.navigation.navbarPosition", new Object[0]);
        JRadioButtonMenuItem[] navigationBarPositionMenuItems22 = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem(), new JRadioButtonMenuItem()};
        GuiUtils.updateButtonText(navigationBarPositionMenuItems22[0], "menu.navigation.navbarPosition.left", new Object[0]);
        GuiUtils.updateButtonText(navigationBarPositionMenuItems22[1], "menu.navigation.navbarPosition.right", new Object[0]);
        navigationBarPositionMenuItems22[0].setIcon(Icons.APPLICATION_DOCK_180);
        navigationBarPositionMenuItems22[1].setIcon(Icons.APPLICATION_DOCK);
        navigationBarPositionMenuItems22[Settings.getInt("navigation.position")].setSelected(true);
        ButtonGroup buttonGroup22 = new ButtonGroup();
        int i322 = 0;
        while (i322 < navigationBarPositionMenuItems22.length) {
            JRadioButtonMenuItem navigationBarPositionMenuItem = navigationBarPositionMenuItems22[i322];
            buttonGroup22.add(navigationBarPositionMenuItem);
            final int i_ = i322++;
            navigationBarPositionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Settings.set("navigation.position", i_);
                    MainFrame.this.arrangeContent();
                }
            });
            navigationBarPositionMenu.add(navigationBarPositionMenuItem);
        }
        navigationMenu.add(navigationBarPositionMenu);
        menuBar.add(navigationMenu);
        JMenu settingsMenu = new JMenu();
        GuiUtils.updateButtonText(settingsMenu, "menu.settings", new Object[0]);
        JMenu lafMenu = new JMenu();
        GuiUtils.updateButtonText(lafMenu, "menu.settings.laf", new Object[0]);
        lafMenu.setIcon(Icons.UI_FLOW);
        ButtonGroup buttonGroup = new ButtonGroup();
        UIManager.LookAndFeelInfo[] i322 = GuiUtils.getSortedInstalledLAFInfos();
        int buttonGroup22 = i322.length;
        int navigationBarPositionMenuItems22 = 0;
        while (navigationBarPositionMenuItems22 < buttonGroup22) {
            final UIManager.LookAndFeelInfo lookAndFeelInfo = i322[navigationBarPositionMenuItems22];
            lafMenuItem = new JRadioButtonMenuItem(lookAndFeelInfo.getName(), lookAndFeelInfo.getName().equals(UIManager.getLookAndFeel().getName()));
            buttonGroup.add((AbstractButton)lafMenuItem);
            lafMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (GuiUtils.setLAF(lookAndFeelInfo.getName())) {
                        SwingUtilities.updateComponentTreeUI(MainFrame.this);
                        MainFrame.this.navigationTree.setCellRenderer(MainFrame.this.createTreeCellRenderer());
                        Settings.set("settings.laf", lookAndFeelInfo.getName());
                    }
                }
            });
            ((Container)lafMenu).add((Component)lafMenuItem);
            ++navigationBarPositionMenuItems22;
        }
        settingsMenu.add(lafMenu);
        JMenu languageMenu = new JMenu();
        GuiUtils.updateButtonText(languageMenu, "menu.settings.language", new Object[0]);
        languageMenu.setIcon(Icons.LOCALE);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        lafMenuItem = Language.getAvailableLanguages();
        int i322 = lafMenuItem.length;
        buttonGroup22 = 0;
        while (buttonGroup22 < i322) {
            final String language = lafMenuItem[buttonGroup22];
            boolean isCurrentLanguage = language.equals(Settings.getString("settings.language"));
            JRadioButtonMenuItem languageMenuItem = new JRadioButtonMenuItem(isCurrentLanguage ? String.valueOf('*') + language + '*' : language, Icons.getLanguageIcon(language), isCurrentLanguage);
            buttonGroup3.add(languageMenuItem);
            languageMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Settings.set("settings.language", language);
                }
            });
            languageMenu.add(languageMenuItem);
            ++buttonGroup22;
        }
        settingsMenu.add(languageMenu);
        settingsMenu.addSeparator();
        JMenuItem folderSettingsMenuItem = new JMenuItem(Icons.FOLDERS);
        GuiUtils.updateButtonText(folderSettingsMenuItem, "menu.settings.folders", new Object[0]);
        folderSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainFrame.this.showFolderSettingsDialog();
            }
        });
        settingsMenu.add(folderSettingsMenuItem);
        settingsMenu.addSeparator();
        JCheckBoxMenuItem allowOnlyOneInstanceMenuItem = GuiUtils.createCheckBoxMenuItem("menu.settings.allowOnlyOneInstance", "settings.allowOnlyOneInstance", Icons.APPLICATION_SHARE);
        settingsMenu.add(allowOnlyOneInstanceMenuItem);
        JCheckBoxMenuItem checkUpdatesOnStartupMenuItem = GuiUtils.createCheckBoxMenuItem("menu.settings.checkUpdatesOnStartup", "settings.checkUpdatesOnStartup", Icons.ARROW_CIRCLE_DOUBLE);
        settingsMenu.add(checkUpdatesOnStartupMenuItem);
        settingsMenu.addSeparator();
        JMenuItem saveSettingsNowMenuItem = new JMenuItem(Icons.DISK);
        GuiUtils.updateButtonText(saveSettingsNowMenuItem, "menu.settings.saveNow", new Object[0]);
        saveSettingsNowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Settings.saveProperties();
            }
        });
        settingsMenu.add(saveSettingsNowMenuItem);
        JCheckBoxMenuItem saveSettingsOnExitMenuItem = GuiUtils.createCheckBoxMenuItem("menu.settings.saveOnExit", "settings.saveOnExit", null);
        settingsMenu.add(saveSettingsOnExitMenuItem);
        menuBar.add(settingsMenu);
        JMenu windowMenu = new JMenu();
        GuiUtils.updateButtonText(windowMenu, "menu.window", new Object[0]);
        final JCheckBoxMenuItem fullscreenMenuItem = new JCheckBoxMenuItem();
        GuiUtils.updateButtonText(fullscreenMenuItem, "menu.window.fullscreen", new Object[0]);
        fullscreenMenuItem.setIcon(Icons.APPLICATION_RESIZE_FULL);
        fullscreenMenuItem.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        fullscreenMenuItem.addActionListener(new ActionListener(){
            private Rectangle storedBounds;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                    if (fullscreenMenuItem.isSelected()) {
                        this.storedBounds = MainFrame.this.getBounds();
                    }
                    MainFrame.this.dispose();
                    MainFrame.this.setUndecorated(fullscreenMenuItem.isSelected());
                    MainFrame.this.setExtendedState(fullscreenMenuItem.isSelected() ? 6 : 0);
                    if (!fullscreenMenuItem.isSelected()) {
                        MainFrame.this.setBounds(this.storedBounds);
                    }
                    MainFrame.this.setVisible(true);
                    fullscreenMenuItem.setIcon(fullscreenMenuItem.isSelected() ? Icons.APPLICATION_RESIZE_ACTUAL : Icons.APPLICATION_RESIZE_FULL);
                }
            }
        });
        windowMenu.add(fullscreenMenuItem);
        JMenuItem minimizeToTrayMenuItem = new JMenuItem(Icons.APPLICATION_DOCK_TAB);
        GuiUtils.updateButtonText(minimizeToTrayMenuItem, "menu.window.mimimizeToTray", new Object[0]);
        minimizeToTrayMenuItem.setEnabled(this.trayIcon != null);
        minimizeToTrayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainFrame.this.hideMainFrame();
            }
        });
        windowMenu.add(minimizeToTrayMenuItem);
        windowMenu.addSeparator();
        final JMenuItem tileAllWindowsMenuItem = new JMenuItem(Icons.APPLICATION_SPLIT_TILE);
        final JMenuItem cascadeAllWindowsMenuItem = new JMenuItem(Icons.APPLICATIONS_STACK);
        final JMenuItem tileVisibleWindowsMenuItem = new JMenuItem(Icons.APPLICATION_SPLIT_TILE);
        JMenuItem cascadeVisibleWindowsMenuItem = new JMenuItem(Icons.APPLICATIONS_STACK);
        int WINDOW_SHIFT_SIZE = 25;
        ActionListener windowArrangeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int height;
                int width;
                boolean arrangeTile = event.getSource() == tileAllWindowsMenuItem || event.getSource() == tileVisibleWindowsMenuItem;
                boolean arrangeAll = event.getSource() == tileAllWindowsMenuItem || event.getSource() == cascadeAllWindowsMenuItem;
                JInternalFrame[] allFrames = MainFrame.this.desktopPane.getAllFrames();
                int visibleFramesCount = allFrames.length;
                if (!arrangeAll) {
                    JInternalFrame[] jInternalFrameArray = allFrames;
                    int n = allFrames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JInternalFrame iframe = jInternalFrameArray[n2];
                        if (iframe.isIcon()) {
                            --visibleFramesCount;
                        }
                        ++n2;
                    }
                }
                int columns = 1;
                int rows = 1;
                if (arrangeTile) {
                    boolean useHorizontalTileStrategy = Settings.getBoolean("window.verticalTileStrategy");
                    while (columns * rows < visibleFramesCount) {
                        if (useHorizontalTileStrategy) {
                            if (columns == rows) {
                                ++rows;
                                continue;
                            }
                            ++columns;
                            continue;
                        }
                        if (columns == rows) {
                            ++columns;
                            continue;
                        }
                        ++rows;
                    }
                }
                if (arrangeTile) {
                    width = MainFrame.this.desktopPane.getWidth() / columns;
                    height = (MainFrame.this.desktopPane.getHeight() - (arrangeAll ? 0 : 25)) / rows;
                } else {
                    width = MainFrame.this.desktopPane.getWidth() - visibleFramesCount * 25;
                    height = MainFrame.this.desktopPane.getHeight() - visibleFramesCount * 25;
                }
                int i = 0;
                while (i < allFrames.length) {
                    try {
                        JInternalFrame iframe = allFrames[i];
                        if (arrangeAll && iframe.isIcon()) {
                            iframe.setIcon(false);
                        }
                        if (iframe.isMaximum()) {
                            iframe.setMaximum(false);
                        }
                        if (arrangeTile) {
                            iframe.setBounds(i % columns * width, i / columns * height, width, height);
                        } else {
                            iframe.setBounds(i * 25, i * 25, width, height);
                        }
                    }
                    catch (PropertyVetoException pve) {
                        pve.printStackTrace();
                    }
                    ++i;
                }
            }
        };
        GuiUtils.updateButtonText(tileAllWindowsMenuItem, "menu.window.tileAllWindows", new Object[0]);
        tileAllWindowsMenuItem.addActionListener(windowArrangeActionListener);
        windowMenu.add(tileAllWindowsMenuItem);
        GuiUtils.updateButtonText(cascadeAllWindowsMenuItem, "menu.window.cascadeAllWindows", new Object[0]);
        cascadeAllWindowsMenuItem.addActionListener(windowArrangeActionListener);
        windowMenu.add(cascadeAllWindowsMenuItem);
        GuiUtils.updateButtonText(tileVisibleWindowsMenuItem, "menu.window.tileVisibleWindows", new Object[0]);
        tileVisibleWindowsMenuItem.addActionListener(windowArrangeActionListener);
        windowMenu.add(tileVisibleWindowsMenuItem);
        GuiUtils.updateButtonText(cascadeVisibleWindowsMenuItem, "menu.window.cascadeVisibleWindows", new Object[0]);
        cascadeVisibleWindowsMenuItem.addActionListener(windowArrangeActionListener);
        windowMenu.add(cascadeVisibleWindowsMenuItem);
        JMenuItem minimizeAllMenuItem = new JMenuItem(Icons.APPLICATION_DIALOG);
        GuiUtils.updateButtonText(minimizeAllMenuItem, "menu.window.minimizeAll", new Object[0]);
        minimizeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame iframe = jInternalFrameArray[n2];
                    try {
                        iframe.setIcon(true);
                    }
                    catch (PropertyVetoException pve) {
                        pve.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
        windowMenu.add(minimizeAllMenuItem);
        JMenuItem closeAllMenuItem = new JMenuItem(Icons.CROSS_BUTTON);
        GuiUtils.updateButtonText(closeAllMenuItem, "menu.window.closeAll", new Object[0]);
        closeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame iframe = jInternalFrameArray[n2];
                    try {
                        iframe.setClosed(true);
                    }
                    catch (PropertyVetoException pve) {
                        pve.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
        windowMenu.add(closeAllMenuItem);
        windowMenu.addSeparator();
        JCheckBoxMenuItem useVerticalTileStrategyMenuItem = GuiUtils.createCheckBoxMenuItem("menu.window.useVerticalTileStrategy", "window.verticalTileStrategy", Icons.APPLICATION_TILE_VERTICAL);
        windowMenu.add(useVerticalTileStrategyMenuItem);
        menuBar.add(windowMenu);
        JMenu helpMenu = new JMenu();
        GuiUtils.updateButtonText(helpMenu, "menu.help", new Object[0]);
        JMenuItem visitHomePageMenuItem = new JMenuItem(Icons.HOME_ARROW);
        GuiUtils.updateButtonText(visitHomePageMenuItem, "menu.help.visitHomePage", new Object[0]);
        visitHomePageMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        visitHomePageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CommonUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/");
            }
        });
        helpMenu.add(visitHomePageMenuItem);
        JMenuItem viewVersionHistoryMenuItem = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(viewVersionHistoryMenuItem, "menu.help.viewVersionHistory", new Object[0]);
        viewVersionHistoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CommonUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/version-history");
            }
        });
        helpMenu.add(viewVersionHistoryMenuItem);
        JMenuItem faqMenuItem = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(faqMenuItem, "menu.help.viewFaq", new Object[0]);
        faqMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CommonUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/faq");
            }
        });
        helpMenu.add(faqMenuItem);
        JMenuItem visitForumMenuItem = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(visitForumMenuItem, "menu.help.visitForum", new Object[0]);
        visitForumMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CommonUtils.showURLInBrowser("http://groups.google.com/group/sc2gears");
            }
        });
        helpMenu.add(visitForumMenuItem);
        helpMenu.addSeparator();
        GuiUtils.updateButtonText(this.viewSystemMessagesMenuItem, "menu.help.viewSystemMessages", new Object[0]);
        this.viewSystemMessagesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final JDialog dialog = new JDialog(MainFrame.this, Language.getText("dialog.systemMessages.title"), true);
                dialog.setDefaultCloseOperation(2);
                JTextArea logTextArea = new JTextArea(Log.getLog(), 15, 40);
                logTextArea.setEditable(false);
                dialog.getContentPane().add((Component)new JScrollPane(logTextArea), "Center");
                final JButton closeButton = new JButton();
                GuiUtils.updateButtonText(closeButton, "button.close", new Object[0]);
                closeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        dialog.dispose();
                    }
                });
                dialog.getContentPane().add((Component)GuiUtils.wrapInPanel(closeButton), "South");
                dialog.setSize(700, 500);
                GuiUtils.centerWindowToWindow(dialog, MainFrame.this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        closeButton.requestFocusInWindow();
                    }
                });
                dialog.setVisible(true);
            }
        });
        helpMenu.add(this.viewSystemMessagesMenuItem);
        helpMenu.addSeparator();
        GuiUtils.updateButtonText(this.checkUpdatesMenuItem, "menu.help.checkUpdates", new Object[0]);
        this.checkUpdatesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainFrame.this.checkUpdates();
            }
        });
        helpMenu.add(this.checkUpdatesMenuItem);
        helpMenu.addSeparator();
        JMenuItem aboutMenuItem = new JMenuItem(Icons.INFORMATION);
        GuiUtils.updateButtonText(aboutMenuItem, "menu.help.about", "Sc2gears");
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainFrame.this.showAboutDialog();
            }
        });
        helpMenu.add(aboutMenuItem);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    public void createNewInternalFrame(MutableTreeNode referenceNewTreeNode, Object ... arguments) {
        ModuleFrame moduleFrame = null;
        if (referenceNewTreeNode == this.newRepAnalNode) {
            moduleFrame = new ReplayAnalyzer(arguments);
        } else if (referenceNewTreeNode == this.newRepSearchNode) {
            moduleFrame = new ReplaySearch(arguments);
        }
        if (moduleFrame != null && !moduleFrame.isClosed()) {
            moduleFrame.setDefaultCloseOperation(2);
            final DefaultMutableTreeNode newTreeNode = new DefaultMutableTreeNode(moduleFrame);
            ((DefaultTreeModel)this.navigationTree.getModel()).insertNodeInto(newTreeNode, (DefaultMutableTreeNode)referenceNewTreeNode.getParent(), 1);
            final TreePath newPath = new TreePath(newTreeNode.getPath());
            this.navigationTree.setSelectionPath(newPath);
            moduleFrame.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent event) {
                    ((DefaultTreeModel)MainFrame.this.navigationTree.getModel()).removeNodeFromParent(newTreeNode);
                }

                @Override
                public void internalFrameActivated(InternalFrameEvent event) {
                    if (!((JInternalFrame)event.getSource()).isIcon()) {
                        MainFrame.this.navigationTree.setSelectionPath(newPath);
                        MainFrame.this.navigationTree.scrollPathToVisible(newPath);
                    }
                }
            });
            this.desktopPane.add(moduleFrame);
            moduleFrame.setVisible(true);
            try {
                moduleFrame.setMaximum(true);
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace();
            }
        }
    }

    private void arrangeContent() {
        this.mainSplitPane.setLeftComponent(null);
        this.mainSplitPane.setRightComponent(null);
        if (Settings.getInt("navigation.position") == 0) {
            if (this.navigationBar.getWidth() != 0) {
                this.mainSplitPane.setDividerLocation(this.navigationBar.getWidth());
            }
            this.mainSplitPane.setLeftComponent(this.navigationBar);
            this.mainSplitPane.setRightComponent(this.desktopPane);
        } else {
            if (this.desktopPane.getWidth() != 0) {
                this.mainSplitPane.setDividerLocation(this.desktopPane.getWidth());
            }
            this.mainSplitPane.setLeftComponent(this.desktopPane);
            this.mainSplitPane.setRightComponent(this.navigationBar);
        }
    }

    private void hideMainFrame() {
        this.setVisible(false);
        this.hideTrayMenuItem.setEnabled(false);
        this.restoreTrayMenuItem.setEnabled(true);
    }

    public void restoreMainFrame() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (this.getExtendedState() == 1) {
            this.setExtendedState(0);
        }
        this.toFront();
        this.hideTrayMenuItem.setEnabled(true);
        this.restoreTrayMenuItem.setEnabled(false);
    }

    private void showFolderSettingsDialog() {
        Box fb;
        final JDialog dialog = new JDialog(this, Language.getText("folderSettings.title"), true);
        dialog.setIconImage(Icons.FOLDERS.getImage());
        dialog.setDefaultCloseOperation(2);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        Box[] folderBoxes = new Box[4];
        Box folderBox = folderBoxes[0] = Box.createHorizontalBox();
        folderBox.add(new JLabel(Language.getText("folderSettings.sc2InstallationFolder")));
        final JTextField sc2InstallationFolderTextField = new JTextField(Settings.getString("settings.folders.sc2Installation"), 30);
        folderBox.add(sc2InstallationFolderTextField);
        final JButton chooseSc2InstallationFolderButton = new JButton(Language.getText("folderSettings.chooseFolder"), Icons.FOLDER);
        folderBox.add(chooseSc2InstallationFolderButton);
        folderBox = folderBoxes[1] = Box.createHorizontalBox();
        folderBox.add(new JLabel(Language.getText("folderSettings.sc2AutoReplay")));
        final JTextField sc2AutoReplayFolderTextField = new JTextField(Settings.getString("settings.folders.sc2AutoReplay"), 30);
        folderBox.add(sc2AutoReplayFolderTextField);
        final JButton chooseSc2AutoReplayFolderButton = new JButton(Language.getText("folderSettings.chooseFolder"), Icons.FOLDER);
        folderBox.add(chooseSc2AutoReplayFolderButton);
        folderBox = folderBoxes[2] = Box.createHorizontalBox();
        folderBox.add(new JLabel(Language.getText("folderSettings.sc2Maps")));
        final JTextField sc2MapsFolderTextField = new JTextField(Settings.getString("settings.folders.sc2Maps"), 30);
        folderBox.add(sc2MapsFolderTextField);
        final JButton chooseSc2MapsFolderButton = new JButton(Language.getText("folderSettings.chooseFolder"), Icons.FOLDER);
        folderBox.add(chooseSc2MapsFolderButton);
        folderBox = folderBoxes[3] = Box.createHorizontalBox();
        folderBox.add(new JLabel(Language.getText("folderSettings.defaultFolder")));
        final JTextField defaultReplayFolderTextField = new JTextField(Settings.getString("settings.folders.defaultReplay"), 30);
        folderBox.add(defaultReplayFolderTextField);
        final JButton chooseDefaultReplayFolderButton = new JButton(Language.getText("folderSettings.chooseFolder"), Icons.FOLDER);
        folderBox.add(chooseDefaultReplayFolderButton);
        ActionListener chooseFolderActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JTextField textField = event.getSource() == chooseSc2InstallationFolderButton ? sc2InstallationFolderTextField : (event.getSource() == chooseSc2AutoReplayFolderButton ? sc2AutoReplayFolderTextField : (event.getSource() == chooseSc2MapsFolderButton ? sc2MapsFolderTextField : (event.getSource() == chooseDefaultReplayFolderButton ? defaultReplayFolderTextField : null)));
                boolean relative = textField == sc2AutoReplayFolderTextField || textField == sc2MapsFolderTextField;
                String userHome = System.getProperty("user.home");
                JFileChooser fileChooser = new JFileChooser(String.valueOf(relative ? userHome : "") + textField.getText());
                fileChooser.setDialogTitle(Language.getText("folderSettings.chooseFolder"));
                fileChooser.setFileSelectionMode(1);
                if (fileChooser.showOpenDialog(INSTANCE) == 0) {
                    String selectedFilePath = fileChooser.getSelectedFile().getAbsolutePath();
                    if (relative && selectedFilePath.toLowerCase().startsWith(userHome.toLowerCase())) {
                        selectedFilePath = selectedFilePath.substring(userHome.length());
                    }
                    textField.setText(selectedFilePath);
                }
            }
        };
        chooseSc2InstallationFolderButton.addActionListener(chooseFolderActionListener);
        chooseSc2AutoReplayFolderButton.addActionListener(chooseFolderActionListener);
        chooseSc2MapsFolderButton.addActionListener(chooseFolderActionListener);
        chooseDefaultReplayFolderButton.addActionListener(chooseFolderActionListener);
        int maxWidth = 0;
        Box[] boxArray = folderBoxes;
        int n = folderBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            fb = boxArray[n2];
            box.add(fb);
            maxWidth = Math.max(fb.getComponent((int)0).getPreferredSize().width, maxWidth);
            ++n2;
        }
        boxArray = folderBoxes;
        n = folderBoxes.length;
        n2 = 0;
        while (n2 < n) {
            fb = boxArray[n2];
            fb.getComponent(0).setPreferredSize(new Dimension(maxWidth, fb.getComponent((int)0).getPreferredSize().height));
            ++n2;
        }
        box.add(Box.createVerticalStrut(10));
        JPanel buttonsPanel = new JPanel();
        JButton okButton = new JButton();
        GuiUtils.updateButtonText(okButton, "button.ok", new Object[0]);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Settings.set("settings.folders.sc2Installation", sc2InstallationFolderTextField.getText());
                Settings.set("settings.folders.sc2AutoReplay", sc2AutoReplayFolderTextField.getText());
                Settings.set("settings.folders.sc2Maps", sc2MapsFolderTextField.getText());
                Settings.set("settings.folders.defaultReplay", defaultReplayFolderTextField.getText());
                dialog.dispose();
            }
        });
        buttonsPanel.add(okButton);
        JButton cancelButton = new JButton();
        GuiUtils.updateButtonText(cancelButton, "button.cancel", new Object[0]);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
            }
        });
        buttonsPanel.add(cancelButton);
        box.add(buttonsPanel);
        dialog.getContentPane().add(box);
        dialog.pack();
        GuiUtils.centerWindowToWindow(dialog, this);
        cancelButton.requestFocusInWindow();
        dialog.setVisible(true);
    }

    private void showAboutDialog() {
        final JDialog dialog = new JDialog(this, Language.getText("about.title", "Sc2gears"), true);
        dialog.setDefaultCloseOperation(2);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(30));
        JPanel panel = new JPanel();
        JLabel logoLabel = new JLabel(Icons.SC2GEARS_LOGO);
        logoLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createRaisedBevelBorder()));
        panel.add(Box.createHorizontalStrut(25));
        panel.add(logoLabel);
        panel.add(Box.createHorizontalStrut(25));
        box.add(panel);
        box.add(Box.createVerticalStrut(20));
        JTable infoTable = new JTable(new Object[][]{{Language.getText("about.author"), Language.formatPersonName("Andr\u00e1s", "Belicza")}, {Language.getText("about.email"), Consts.AUTHOR_EMAIL}, {Language.getText("about.version"), "1.10"}, {Language.getText("about.releasedOn"), Language.formatDate(Consts.APPLICATION_RELEASE_DATE)}, {Language.getText("about.currentTranslator"), Language.getTranslatorName()}, {Language.getText("about.languageFileVersion"), Language.getLanguageFileVersion()}}, new Object[]{"Property", "Value"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        GuiUtils.packTable(infoTable);
        box.add(GuiUtils.wrapInPanel(infoTable));
        box.add(Box.createVerticalStrut(15));
        box.add(GuiUtils.wrapInPanel(new JLabel(Language.getText("about.usedIcons", "Sc2gears"))));
        box.add(Box.createVerticalStrut(15));
        JButton okButton = new JButton();
        GuiUtils.updateButtonText(okButton, "button.ok", new Object[0]);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
            }
        });
        box.add(GuiUtils.wrapInPanel(okButton));
        box.add(Box.createVerticalStrut(15));
        dialog.getContentPane().add(box);
        dialog.pack();
        GuiUtils.centerWindowToWindow(dialog, this);
        okButton.requestFocusInWindow();
        dialog.setVisible(true);
    }

    private void checkUpdates() {
        this.checkUpdatesMenuItem.setEnabled(false);
        new NormalThread("Update checker"){

            @Override
            public void run() {
                block7: {
                    try {
                        Document latestVersionDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new URL("http://sites.google.com/site/sc2gears/storage/latest_version.xml").toURI().toString());
                        Element docElement = latestVersionDocument.getDocumentElement();
                        String latestVersion = ((Element)docElement.getElementsByTagName("latestVersion").item(0)).getTextContent();
                        if ("1.10".equals(latestVersion)) break block7;
                        String installButtonText = Language.getText("updatesAvailable.updateButton");
                        int answer = JOptionPane.showOptionDialog(MainFrame.this, new Object[]{Language.getText("updatesAvailable.newVersionAvailable", latestVersion), CommonUtils.createLinkLabel(Language.getText("updatesAvailable.viewVersionHistory"), "http://sites.google.com/site/sc2gears/version-history"), " ", Language.getText("updatesAvailable.whatToDo")}, Language.getText("updatesAvailable.title"), -1, 1, null, new Object[]{installButtonText, Language.getText("updatesAvailable.dontUpdateButton")}, installButtonText);
                        if (answer != 0) break block7;
                        if (!Sc2gears.checkAndPerformPostUpdate()) {
                            GuiUtils.showErrorDialog(new String[]{Language.getText("updatesAvailable.updaterCannotBeStarted", "Sc2gears Updater"), Language.getText("updatesAvailable.restart", "Sc2gears")});
                            return;
                        }
                        try {
                            String archiveUrl = ((Element)docElement.getElementsByTagName("archiveUrl").item(0)).getTextContent();
                            String requiredMinUpdaterVer = ((Element)docElement.getElementsByTagName("requiredMinUpdaterVer").item(0)).getTextContent();
                            String archiveSha256 = ((Element)docElement.getElementsByTagName("archiveSha256").item(0)).getTextContent();
                            MainFrame.this.exit(true, new String[]{latestVersion, requiredMinUpdaterVer, archiveUrl, archiveSha256});
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        MainFrame.this.checkUpdatesMenuItem.setEnabled(true);
                    }
                }
            }
        }.start();
    }

    private void exit(boolean startUpdater, String ... arguments) {
        if (Settings.getBoolean("settings.saveOnExit")) {
            Settings.saveProperties();
        }
        if (startUpdater) {
            try {
                Runtime.getRuntime().exec("java -cp lib-updater/Sc2gearsUpdater.jar hu/belicza/andras/sc2gearsupdater/Updater " + arguments[0] + " " + arguments[1] + " " + arguments[2] + " " + arguments[3]);
            }
            catch (IOException ie) {
                System.err.println("Failed to start Sc2gears Updater!");
                ie.printStackTrace();
            }
        }
        System.exit(0);
    }
}

