/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.CommonUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.TableColumnModel;

public class GuiUtils {
    public static final FileView SC2GEARS_FILE_VIEW = new FileView(){

        @Override
        public Icon getIcon(File file) {
            if (file.isDirectory()) {
                return null;
            }
            if (SC2_REPLAY_FILTER.accept(file)) {
                return Icons.SC2;
            }
            if (SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                return Icons.FOLDERS_STACK;
            }
            if (SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                return Icons.TABLE;
            }
            if (ZIP_FILE_FILTER.accept(file)) {
                return Icons.DOCUMENT_ZIPPER;
            }
            return null;
        }
    };
    public static FileFilter SC2_REPLAY_FILTER;
    public static FileFilter SC2_REPLAY_SOURCE_FILE_FILTER;
    public static FileFilter SC2_REPLAY_LIST_FILE_FILTER;
    public static FileFilter ZIP_FILE_FILTER;

    private GuiUtils() {
    }

    public static void initFileFilters() {
        SC2_REPLAY_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.sc2ReplayFiles"), "SC2Replay");
        SC2_REPLAY_SOURCE_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.sc2ReplaySources"), ".sc2repsrc".substring(1));
        SC2_REPLAY_LIST_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.sc2ReplayLists"), ".csv".substring(1));
        ZIP_FILE_FILTER = new FileNameExtensionFilter(Language.getText("fileChooser.zipFiles"), "zip");
    }

    public static void updateButtonText(AbstractButton button, String textKey, Object ... arguments) {
        String text = arguments == null ? Language.getText(textKey) : Language.getText(textKey, arguments);
        int mnemonicIndex = text.indexOf(95);
        if (mnemonicIndex < 0) {
            button.setText(text);
        } else {
            button.setText(text.replace("_", ""));
            button.setMnemonic(text.charAt(mnemonicIndex + 1));
        }
    }

    public static JPanel wrapInPanel(JComponent component) {
        JPanel panel = new JPanel();
        panel.add(component);
        return panel;
    }

    public static void centerWindow(Window window) {
        window.setLocationRelativeTo(null);
    }

    public static void centerWindowToWindow(Window window, Window toWindow) {
        window.setLocation(toWindow.getX() + (toWindow.getWidth() - window.getWidth()) / 2, toWindow.getY() + (toWindow.getHeight() - window.getHeight()) / 2);
    }

    public static boolean setLAF(String lafName) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n2];
            if (lookAndFeelInfo.getName().equals(lafName)) {
                try {
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                    return true;
                }
                catch (Exception e) {
                    System.err.println("Failed to set " + lookAndFeelInfo.getName() + " look and feel!");
                    e.printStackTrace(System.err);
                    return false;
                }
            }
            ++n2;
        }
        System.err.println(String.valueOf(lafName) + " look and feel was not found!");
        return false;
    }

    public static void packTable(JTable table) {
        int column = table.getColumnCount() - 1;
        while (column >= 0) {
            int maxWidth = 70;
            int row = table.getRowCount() - 1;
            while (row >= 0) {
                maxWidth = Math.max(maxWidth, table.getRowMargin() + table.getCellRenderer((int)row, (int)column).getTableCellRendererComponent((JTable)table, (Object)table.getValueAt((int)row, (int)column), (boolean)false, (boolean)false, (int)row, (int)column).getPreferredSize().width);
                --row;
            }
            table.getColumnModel().getColumn(column).setPreferredWidth(maxWidth);
            --column;
        }
    }

    public static UIManager.LookAndFeelInfo[] getSortedInstalledLAFInfos() {
        UIManager.LookAndFeelInfo[] installedLookAndFeels = UIManager.getInstalledLookAndFeels();
        Arrays.sort(installedLookAndFeels, new Comparator<UIManager.LookAndFeelInfo>(){

            @Override
            public int compare(UIManager.LookAndFeelInfo l1, UIManager.LookAndFeelInfo l2) {
                if ("Nimbus".equals(l1.getName())) {
                    return -1;
                }
                if ("Nimbus".equals(l2.getName())) {
                    return 1;
                }
                if ("Metal".equals(l1.getName())) {
                    return -1;
                }
                if ("Metal".equals(l2.getName())) {
                    return 1;
                }
                if ("Office 2003".equals(l1.getName())) {
                    return -1;
                }
                if ("Office 2003".equals(l2.getName())) {
                    return 1;
                }
                if ("Office XP".equals(l1.getName())) {
                    return -1;
                }
                if ("Office XP".equals(l2.getName())) {
                    return 1;
                }
                if ("Visual Studio 2005".equals(l1.getName())) {
                    return -1;
                }
                if ("Visual Studio 2005".equals(l2.getName())) {
                    return 1;
                }
                if ("InfoNode".equals(l1.getName())) {
                    return -1;
                }
                if ("InfoNode".equals(l2.getName())) {
                    return 1;
                }
                if ("EaSynthLookAndFeel".equals(l1.getName())) {
                    return -1;
                }
                if ("EaSynthLookAndFeel".equals(l2.getName())) {
                    return 1;
                }
                return 0;
            }
        });
        return installedLookAndFeels;
    }

    public static void addNewTab(String title, Icon icon, boolean closeable, final JTabbedPane tabbedPane, final JComponent tab, final Runnable beforeCloseTask) {
        JLabel titleLabel;
        tabbedPane.addTab(null, tab);
        if (tabbedPane.getTabCount() < 10) {
            titleLabel = new JLabel(String.valueOf(tabbedPane.getTabCount()) + " " + title, icon, 2);
            titleLabel.setDisplayedMnemonicIndex(0);
            tabbedPane.setMnemonicAt(tabbedPane.getTabCount() - 1, 48 + tabbedPane.getTabCount());
        } else {
            titleLabel = new JLabel(title, icon, 2);
        }
        if (closeable) {
            Box titleBox = Box.createHorizontalBox();
            titleBox.add(titleLabel);
            final AbstractAction closeTabAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (beforeCloseTask != null) {
                        beforeCloseTask.run();
                    }
                    tabbedPane.remove(tab);
                }
            };
            JLabel closeLabel = new JLabel(Icons.CROSS_SMALL);
            closeLabel.setToolTipText(Language.getText("tab.close.tooltop"));
            closeLabel.setCursor(Cursor.getPredefinedCursor(12));
            MouseAdapter closeTabMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    closeTabAction.actionPerformed(null);
                }
            };
            closeLabel.addMouseListener(closeTabMouseListener);
            titleBox.add(closeLabel);
            Object closeTabActionKey = new Object();
            tab.getInputMap(1).put(KeyStroke.getKeyStroke(87, 2), closeTabActionKey);
            tab.getActionMap().put(closeTabActionKey, closeTabAction);
            tabbedPane.setTabComponentAt(tabbedPane.getTabCount() - 1, titleBox);
        } else {
            tabbedPane.setTabComponentAt(tabbedPane.getTabCount() - 1, titleLabel);
        }
        if (tab.getComponentCount() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tab.getComponent(0).requestFocusInWindow();
                }
            });
        }
    }

    public static void appendNewLine(JTextArea textArea, String line) {
        textArea.append(line);
        textArea.append("\n");
    }

    public static void showErrorDialog(Object message) {
        JLabel detailsLink = CommonUtils.createLinkStyledLabel(Language.getText("general.errorDetails"));
        detailsLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                MainFrame.INSTANCE.viewSystemMessagesMenuItem.doClick();
            }
        });
        String buttonText = Language.getText("general.okButton");
        JOptionPane.showOptionDialog(MainFrame.INSTANCE, new Object[]{message, new JLabel(" "), detailsLink}, Language.getText("general.errorTitle"), -1, 0, null, new Object[]{buttonText}, buttonText);
    }

    public static void showInfoDialog(Object message) {
        String buttonText = Language.getText("general.okButton");
        JOptionPane.showOptionDialog(MainFrame.INSTANCE, message, Language.getText("general.infoTitle"), -1, 1, null, new Object[]{buttonText}, buttonText);
    }

    public static int showConfirmDialog(Object message, boolean isWarning) {
        String yesButtonText = Language.getText("general.yesButton");
        return JOptionPane.showOptionDialog(MainFrame.INSTANCE, message, Language.getText("general.confirmationTitle"), -1, isWarning ? 2 : 3, null, new Object[]{yesButtonText, Language.getText(isWarning ? "general.cancelButton" : "general.noButton")}, yesButtonText);
    }

    public static JComponent createReplayFilePreviewAccessory(JFileChooser fileChooser) {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder(Language.getText("module.repAnalyzer.tab.gameInfo.title")));
        final JLabel versionLabel = new JLabel();
        box.add(versionLabel);
        final JLabel lengthLabel = new JLabel();
        box.add(lengthLabel);
        final JLabel speedLabel = new JLabel();
        box.add(speedLabel);
        final JLabel typeLabel = new JLabel();
        box.add(typeLabel);
        final JLabel gatewayLabel = new JLabel();
        box.add(gatewayLabel);
        final JLabel mapLabel = new JLabel();
        box.add(mapLabel);
        final JLabel playersLabel = new JLabel();
        box.add(playersLabel);
        final JLabel mapPreviewLabel = new JLabel();
        box.add(mapPreviewLabel);
        fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("SelectedFileChangedProperty".equals(event.getPropertyName())) {
                    File file = (File)event.getNewValue();
                    if (file == null || file.isDirectory()) {
                        return;
                    }
                    Replay replay = ReplayParser.parseReplay(file.getAbsolutePath(), EnumSet.of(ReplayParser.ReplayContent.INIT_DATA, ReplayParser.ReplayContent.DETAILS, ReplayParser.ReplayContent.ATTRIBUTES_EVENTS, ReplayParser.ReplayContent.MAP_INFO));
                    if (replay == null) {
                        versionLabel.setText(Language.getText("fileChooser.failedToParseRepaly"));
                        lengthLabel.setText("");
                        speedLabel.setText("");
                        typeLabel.setText("");
                        gatewayLabel.setText("");
                        playersLabel.setText("");
                        mapLabel.setText("");
                        mapPreviewLabel.setIcon(null);
                    } else {
                        versionLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.version", replay.version));
                        lengthLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.gameLength", ReplayUtils.formatMs(replay.gameLength * 500)));
                        speedLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.gameSpeed", new Object[]{replay.initData.gameSpeed}));
                        typeLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.gameType", new Object[]{replay.initData.gameType}));
                        gatewayLabel.setText(replay.initData.gateway == null ? "" : Language.getText("module.repAnalyzer.tab.gameInfo.gateway", new Object[]{replay.initData.gateway}));
                        playersLabel.setText(String.valueOf(Language.getText("module.repAnalyzer.tab.gameInfo.players")) + " " + replay.details.getPlayerNames());
                        mapLabel.setText(Language.getText("module.repAnalyzer.tab.gameInfo.mapName", replay.details.mapName));
                        mapPreviewLabel.setIcon(replay.mapInfo == null ? null : replay.mapInfo.previewIcon);
                    }
                }
            }
        });
        box.setPreferredSize(new Dimension(300, 420));
        return new JScrollPane(box);
    }

    public static int getColumnViewIndex(JTable table, int columnModelIndex) {
        TableColumnModel columnModel = table.getColumnModel();
        int i = columnModel.getColumnCount() - 1;
        while (i >= 0) {
            if (columnModel.getColumn(i).getModelIndex() == columnModelIndex) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static JCheckBox createCheckBox(String textKey, final String settingsKey) {
        final JCheckBox checkBox = new JCheckBox(Language.getText(textKey), Settings.getBoolean(settingsKey));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Settings.set(settingsKey, checkBox.isSelected());
            }
        });
        return checkBox;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(String textKey, final String settingsKey, Icon icon) {
        final JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem();
        GuiUtils.updateButtonText(checkBoxMenuItem, textKey, new Object[0]);
        if (icon != null) {
            checkBoxMenuItem.setIcon(icon);
        }
        checkBoxMenuItem.setSelected(Settings.getBoolean(settingsKey));
        checkBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Settings.set(settingsKey, checkBoxMenuItem.isSelected());
            }
        });
        return checkBoxMenuItem;
    }

    public static JComboBox createComboBox(Object[] values, final String settingsKey) {
        final JComboBox<Object> comboBox = new JComboBox<Object>(values);
        comboBox.setSelectedIndex(Settings.getInt(settingsKey));
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Settings.set(settingsKey, comboBox.getSelectedIndex());
            }
        });
        comboBox.putClientProperty("JComponent.sizeVariant", "small");
        comboBox.updateUI();
        return comboBox;
    }

    public static void makeComponentDragScrollable(final JComponent component) {
        MouseAdapter dragHandler = new MouseAdapter(){
            int dragStartX;
            int dragStartY;

            @Override
            public void mousePressed(MouseEvent event) {
                if ((event.getModifiers() & 0x10) != 0) {
                    this.dragStartX = event.getXOnScreen();
                    this.dragStartY = event.getYOnScreen();
                }
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                if ((event.getModifiers() & 0x10) != 0) {
                    Rectangle visibleRect = component.getVisibleRect();
                    visibleRect.x += (this.dragStartX - event.getXOnScreen()) * 2;
                    visibleRect.y += (this.dragStartY - event.getYOnScreen()) * 2;
                    component.scrollRectToVisible(visibleRect);
                    this.dragStartX = event.getXOnScreen();
                    this.dragStartY = event.getYOnScreen();
                }
            }
        };
        component.addMouseListener(dragHandler);
        component.addMouseMotionListener(dragHandler);
    }

    public static void changeFontToBold(JComponent component) {
        Font oldFont = component.getFont();
        component.setFont(new Font(oldFont.getName(), 1, oldFont.getSize()));
    }
}

