/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay.model;

import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Details;
import java.util.Map;

public class GameEvents {
    public static final byte OP_CODE_AUTO_SYNC = 0;
    public static final byte OP_CODE_GAME_START = 5;
    public static final byte OP_CODE_ALLIANCE = 6;
    public static final byte OP_CODE_PLAYER_LEAVE = 9;
    public static final byte OP_CODE_USE_AB_OR_ASSIGN = 11;
    public static final byte OP_CODE_REQUEST_RESOURCES = 22;
    public static final byte OP_CODE_CANCEL_RES_REQUEST = 24;
    public static final byte OP_CODE_PLAYER_INIT_JOIN = 27;
    public static final byte OP_CODE_MOVE_SCREEN = -127;
    public static final byte OP_CODE_SELECT_FOLLOW_UP = -119;
    public static final byte OP_CODE_SELECT_DESELECT = -84;
    public String[] playerNames;
    public boolean displayInSeconds;
    public Action[] actions;
    public final Map<Short, String> unitTypeNameMap;
    private static String[] SPACES = new String[30];

    static {
        GameEvents.SPACES[0] = "";
        int i = 1;
        while (i < SPACES.length) {
            GameEvents.SPACES[i] = String.valueOf(SPACES[i - 1]) + ' ';
            ++i;
        }
    }

    public GameEvents(Details.Player[] players, Map<Short, String> unitTypeNameMap) {
        int maxLength = 0;
        Details.Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Details.Player player = playerArray[n2];
            if (maxLength < player.name.length()) {
                maxLength = player.name.length();
            }
            ++n2;
        }
        this.playerNames = new String[players.length];
        int i = 0;
        while (i < this.playerNames.length) {
            this.playerNames[i] = "  " + players[i].name + SPACES[maxLength - players[i].name.length() + 2];
            ++i;
        }
        this.unitTypeNameMap = unitTypeNameMap;
    }

    public class Action {
        public int frame;
        public byte player;
        public byte opCode;
        public ReplayConsts.ActionType type = ReplayConsts.ActionType.OTHER;

        protected String toStringTemplate() {
            return String.valueOf(GameEvents.this.displayInSeconds ? ReplayUtils.formatFramesShort(this.frame) : String.format("%6d", this.frame)) + GameEvents.this.playerNames[this.player];
        }

        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "0x" + Integer.toHexString(this.opCode & 0xFF);
        }
    }

    public class BaseUseAbilityAction
    extends Action {
        public int abilityCode;
        public String abilityName;
        public ReplayConsts.AbilityGroup abilityGroup;

        public BaseUseAbilityAction() {
        }

        public BaseUseAbilityAction(String abilityName, ReplayConsts.AbilityGroup abilityGroup) {
            this.abilityName = abilityName;
            this.abilityGroup = abilityGroup;
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + (this.abilityName == null ? "Use ability " + String.format("%6x", this.abilityCode) : this.abilityName);
        }
    }

    public class BuildAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Building building;

        public BuildAction(ReplayConsts.Building building) {
            this.type = ReplayConsts.ActionType.BUILD;
            this.building = building;
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Build " + (Object)((Object)this.building);
        }
    }

    public class CancelResRequestAction
    extends Action {
        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Cancel trade";
        }
    }

    public class HotkeyAction
    extends Action {
        public boolean isSelect;

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Hotkey " + (this.isSelect ? "Select " : "Assign ") + ((this.opCode & 0xFF) >> 4);
        }
    }

    public class LeaveGameAction
    extends Action {
        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Leave game";
        }
    }

    public class MoveScreenAction
    extends Action {
        public int x;
        public int y;
        public int hor;
        public int vert;

        public MoveScreenAction() {
            this.type = ReplayConsts.ActionType.INACTION;
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Move screen " + ReplayUtils.formatCoordinate(this.x) + "," + ReplayUtils.formatCoordinate(this.y) + "," + ReplayUtils.formatCoordinate(this.hor) + "," + ReplayUtils.formatCoordinate(this.vert);
        }
    }

    public class RequestResoucesAction
    extends Action {
        public int minRequested;
        public int gasRequested;

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Request resources " + this.minRequested + "," + this.gasRequested;
        }
    }

    public class ResearchAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Research research;

        public ResearchAction(ReplayConsts.Research research) {
            this.type = ReplayConsts.ActionType.RESEARCH;
            this.research = research;
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Research " + (Object)((Object)this.research);
        }
    }

    public class SelectAction
    extends Action {
        public boolean automatic;
        public int deselectionBitsCount;
        public byte[] deselectionUnitBitmap;
        public short[] unitTypes;
        public byte[] unitsOfTypeCounts;
        public int[] unitIds;

        public SelectAction() {
            this.type = ReplayConsts.ActionType.SELECT;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.toStringTemplate());
            if (this.automatic) {
                sb.append("Selection auto-update ");
            }
            int unitIdIdx = 0;
            if (this.unitTypes != null) {
                int i = 0;
                while (i < this.unitTypes.length) {
                    sb.append(i == 0 ? "Select " : ", ");
                    String unitName = GameEvents.this.unitTypeNameMap.get(this.unitTypes[i]);
                    if (unitName == null) {
                        sb.append("Unknown[").append(Integer.toHexString(this.unitTypes[i])).append(']');
                    } else {
                        sb.append(unitName);
                    }
                    int unitsOfTypeCount = this.unitsOfTypeCounts[i];
                    if (unitsOfTypeCount > 1) {
                        sb.append(" x").append(this.unitsOfTypeCounts[i]);
                    }
                    sb.append(" (");
                    int j = unitsOfTypeCount;
                    while (j > 0) {
                        sb.append(Integer.toHexString(this.unitIds[unitIdIdx])).append(',');
                        --j;
                        ++unitIdIdx;
                    }
                    sb.setCharAt(sb.length() - 1, ')');
                    ++i;
                }
            }
            if (this.deselectionBitsCount > 0) {
                if (this.unitTypes.length > 0) {
                    sb.append(", ");
                }
                sb.append("Deselect ").append(this.deselectionBitsCount).append(this.deselectionBitsCount == 1 ? " unit" : " units");
            }
            return sb.toString();
        }
    }

    public class SendResourcesAction
    extends Action {
        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Send resources";
        }
    }

    public class TrainAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Unit unit;

        public TrainAction(ReplayConsts.Unit unit) {
            this.type = ReplayConsts.ActionType.TRAIN;
            this.unit = unit;
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Train " + (Object)((Object)this.unit);
        }
    }

    public class TrainHallucinatedAction
    extends TrainAction {
        public TrainHallucinatedAction(ReplayConsts.Unit unit) {
            super(unit);
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Train " + (Object)((Object)this.unit) + " Hallucination (Sentry)";
        }
    }

    public class UpgradeAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Upgrade upgrade;

        public UpgradeAction(ReplayConsts.Upgrade upgrade) {
            this.type = ReplayConsts.ActionType.UPGRADE;
            this.upgrade = upgrade;
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Upgrade " + (Object)((Object)this.upgrade);
        }
    }

    public class UseBuildingAbilityAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.BuildingAbility buildingAbility;
        public final ReplayConsts.Building building;

        public UseBuildingAbilityAction(ReplayConsts.BuildingAbility buildingAbility, ReplayConsts.Building building) {
            this.buildingAbility = buildingAbility;
            this.building = building;
            this.abilityGroup = buildingAbility.abilityGroup;
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + this.buildingAbility.toString() + " (" + (Object)((Object)this.building) + ')';
        }
    }

    public class UseUnitAbilityAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.UnitAbility unitAbility;
        public final ReplayConsts.Unit unit;

        public UseUnitAbilityAction(ReplayConsts.UnitAbility unitAbility, ReplayConsts.Unit unit) {
            this.unitAbility = unitAbility;
            this.unit = unit;
            this.abilityGroup = unitAbility.abilityGroup;
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + this.unitAbility.toString() + " (" + (Object)((Object)this.unit) + ')';
        }
    }

    public class WarpAction
    extends TrainAction {
        public WarpAction(ReplayConsts.Unit unit) {
            super(unit);
        }

        @Override
        public String toString() {
            return String.valueOf(this.toStringTemplate()) + "Train " + (Object)((Object)this.unit) + " (Warp gate)";
        }
    }
}

