/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.util.GeneralUtils;

public class ReplayConsts {
    public static final byte MAX_PLAYERS = 15;
    public static final int FRAME_BITS_IN_SECOND = 6;
    public static final int FRAMES_IN_SECOND = 64;

    private ReplayConsts() {
    }

    public static enum AbilityGroup {
        STOP,
        MOVE,
        PATROL,
        HOLD_POSITION,
        RETURN_CHARGO,
        ATTACK,
        CANCEL,
        GATHER_TERRAN,
        GATHER_ZERG,
        GATHER_PROTOSS,
        BURROW("Burrow/Root"),
        UNBURROW("Unburrow/Uproot"),
        SET_RALLY_POINT,
        SET_WORKER_RALLY_POINT,
        CALLDOWN_MULE("Calldown MULE"),
        CALLDOWN_EXTRA_SUPPLIES,
        LIFT_OFF,
        LAND,
        SCANNER_SWEEP,
        SPAWN_CREEP_TUMOR,
        GENERATE_CREEP,
        STOP_GENERATING_CREEP,
        REPAIR,
        LOAD,
        UNLOAD_ALL,
        CHRONO_BOOST,
        LOWER,
        RAISE,
        TANK_MODE,
        SIEGE_MODE,
        TRANSFUSION,
        FORCE_FIELD,
        GUARDIAN_SHIELD,
        UPGRADE_TO_WARP_GATE,
        MUTATE_INTO_A_GATEWAY,
        SALVAGE,
        UPGRADE_TO_ORBITAL_COMMAND,
        CHARGE,
        BLINK,
        SPAWN_CHANGELING,
        FEEDBACK,
        PSIONIC_STORM,
        MORPH_TO_BANELING,
        EXPLODE,
        HEAL,
        CORRUPTION,
        MORPH_TO_BROOD_LORD,
        TRAIN_AN_INTERCEPTOR,
        T250MM_STRIKE_CANNONS,
        CLOACK,
        DECLOACK,
        INFESTED_TERRAN,
        NEURAL_PARASITE,
        UPGRADE_TO_PLANETARY_FORTRESS,
        MUTATE_INTO_HIVE,
        FUNGAL_GROWTH,
        MORPH_TO_OVERSEER,
        STIMPACK,
        MUTATE_INTO_GREATER_SPIRE,
        MUTATE_INTO_LAIR,
        ARM_SILO_WITH_NUKE,
        PHASING_MODE,
        TRANSPORT_MODE,
        ARCHON_WARP,
        TAC_NUCLEAR_STRIKE,
        HOLD_FIRE,
        EMP_ROUND,
        SNIPER_ROUND,
        BUILD_AUTO_TURRET,
        BUILD_POINT_DEFENSE_DRONE,
        SEEKER_MISSILE,
        ASSAULT_MODE,
        FIGHTER_MODE,
        YAMATO_CANNON,
        VORTEX,
        GRAVITON_BEAM,
        MASS_RECALL,
        SPAWN_LARVA,
        ATTACK_STRUCTURE,
        FRENZY;

        private final String stringValue;

        private AbilityGroup() {
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private AbilityGroup(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum ActionType {
        SELECT("sc2.actionType.select"),
        BUILD("sc2.actionType.build"),
        TRAIN("sc2.actionType.train"),
        RESEARCH("sc2.actionType.research"),
        UPGRADE("sc2.actionType.upgrade"),
        OTHER("sc2.actionType.other"),
        INACTION("sc2.actionType.inaction");

        private final String stringValue;

        private ActionType(String textKey) {
            this.stringValue = Language.getText(textKey);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Building {
        COMMAND_CENTER,
        SUPPLY_DEPOT,
        REFINERY,
        BARRACKS,
        ENGINEERING_BAY,
        MISSILE_TURRET,
        BUNKER,
        SENSOR_TOWER,
        GHOST_ACADEMY,
        FACTORY,
        STARPORT,
        ARMORY,
        FUSION_CORE,
        TECH_LAB_BARRACKS("Tech Lab (Barracks)"),
        REACTOR_BARRACKS("Reactor (Barracks)"),
        TECH_LAB_FACTORY("Tech Lab (Factory)"),
        TECH_LAB_STARPORT("Tech Lab (Starport)"),
        REACTOR_FACTORY("Reactor (Factory)"),
        REACTOR_STARPORT("Reactor (Starport)"),
        ORBITAL_COMMAND,
        PLANETARY_FORTRESS,
        HATCHERY,
        CREEP_TUMOR,
        EXTRACTOR,
        SPAWNING_POOL,
        EVOLUTION_CHAMBER,
        HYDRALISK_DEN,
        SPIRE,
        ULTRALISK_CAVERN,
        INFESTATION_PIT,
        NYDUS_NETWORK,
        BANELING_NEST,
        ROACH_WARREN,
        SPINE_CRAWLER,
        SPORE_CRAWLER,
        LAIR,
        HIVE,
        NYDUS_WORM,
        NEXUS,
        PYLON,
        ASSIMILATOR,
        GATEWAY,
        FORGE,
        FLEET_BEACON,
        TWILIGHT_COUNCIL,
        PHOTON_CANNON,
        STARGATE,
        TEMPLAR_ARCHIVES,
        DARK_SHRINE,
        ROBOTICS_BAY,
        ROBOTICS_FACILITY,
        CYBERNETICS_CORE,
        WARP_GATE,
        OBELISK;

        private final String stringValue;

        private Building() {
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private Building(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum BuildingAbility {
        CALLDOWN_MULE(AbilityGroup.CALLDOWN_MULE, "Calldown MULE"),
        SET_RALLY_POINT(AbilityGroup.SET_RALLY_POINT),
        SET_WORKER_RALLY_POINT(AbilityGroup.SET_WORKER_RALLY_POINT),
        CALLDOWN_EXTRA_SUPPLIES(AbilityGroup.CALLDOWN_EXTRA_SUPPLIES),
        CHRONO_BOOST(AbilityGroup.CHRONO_BOOST),
        SCANNER_SWEEP(AbilityGroup.SCANNER_SWEEP),
        CANCEL_AN_ADDON(AbilityGroup.CANCEL, "Cancel an Addon"),
        MUTATE_INTO_LAIR(AbilityGroup.MUTATE_INTO_LAIR, "Mutate into Lair"),
        CANCEL_LAIR_UPGRADE(AbilityGroup.CANCEL),
        MUTATE_INTO_HIVE(AbilityGroup.MUTATE_INTO_HIVE, "Mutate into Hive"),
        CANCEL_HIVE_UPGRADE(AbilityGroup.CANCEL),
        MUTATE_INTO_GREATER_SPIRE(AbilityGroup.MUTATE_INTO_GREATER_SPIRE, "Mutate into Greater Spire"),
        CANCEL_GREATER_SPIRE_UPGRADE(AbilityGroup.CANCEL),
        UPGRADE_TO_PLANETARY_FORTRESS(AbilityGroup.UPGRADE_TO_PLANETARY_FORTRESS, "Upgrade to Planetary Fortress"),
        CANCEL_PLANETARY_FORTRESS_UPGRADE(AbilityGroup.CANCEL),
        UPGRADE_TO_ORBITAL_COMMAND(AbilityGroup.UPGRADE_TO_ORBITAL_COMMAND, "Upgrade to Orbital Command"),
        CANCEL_ORBITAL_COMMAND_UPGRADE(AbilityGroup.CANCEL),
        UPGRADE_TO_WARP_GATE(AbilityGroup.UPGRADE_TO_WARP_GATE, "Upgrade to Warp Gate"),
        CANCEL_WARP_GATE_UPGRADE(AbilityGroup.CANCEL),
        MUTATE_INTO_A_GATEWAY(AbilityGroup.MUTATE_INTO_A_GATEWAY, "Mutate into a Gateway"),
        CANCEL_GATEWAY_MUTATION(AbilityGroup.CANCEL),
        LOAD(AbilityGroup.LOAD),
        UNLOAD_ALL(AbilityGroup.UNLOAD_ALL),
        UNLOAD_ALL_AT(null),
        UNLOAD_UNIT(null),
        LOAD_ALL(null),
        LIFT_OFF(AbilityGroup.LIFT_OFF),
        LAND(AbilityGroup.LAND),
        SALVAGE(AbilityGroup.SALVAGE),
        BURROW(AbilityGroup.BURROW),
        UPROOT(AbilityGroup.UNBURROW),
        ROOT(AbilityGroup.BURROW),
        BUILD_CREEP_TUMOR(AbilityGroup.SPAWN_CREEP_TUMOR),
        LOWER(AbilityGroup.LOWER, "Lower Supply Depot"),
        RAISE(AbilityGroup.RAISE, "Raiser Supply Depot"),
        ARM_SILO_WITH_NUKE(AbilityGroup.ARM_SILO_WITH_NUKE, "Arm Silo with Nuke");

        private final String stringValue;
        public final AbilityGroup abilityGroup;

        private BuildingAbility(AbilityGroup abilityGroup) {
            this.abilityGroup = abilityGroup;
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private BuildingAbility(AbilityGroup abilityGroup, String stringValue) {
            this.abilityGroup = abilityGroup;
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Format {
        ONE_VS_ONE("1v1", "1v1"),
        TWO_VS_TWO("2v2", "2v2"),
        THREE_VS_THREE("3v3", "3v3"),
        FOUR_VS_FOUR("4v4", "4v4"),
        FREE_FOR_ALL("AFF", "FFA"),
        UNKNOWN("", null);

        public final String binaryValue;
        private final String stringValue;

        private Format(String binaryValue, String stringValue) {
            this.binaryValue = binaryValue;
            this.stringValue = stringValue == null ? Language.getText("general.unknown") : stringValue;
        }

        public static Format fromBinaryValue(String binaryValue) {
            Format[] formatArray = Format.values();
            int n = formatArray.length;
            int n2 = 0;
            while (n2 < n) {
                Format format = formatArray[n2];
                if (format.binaryValue.equals(binaryValue)) {
                    return format;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum GameSpeed {
        SLOWER("rolS", "sc2.gameSpeed.slower"),
        SLOW("wolS", "sc2.gameSpeed.slow"),
        NORMAL("mroN", "sc2.gameSpeed.normal"),
        FAST("tsaF", "sc2.gameSpeed.fast"),
        FASTER("rsaF", "sc2.gameSpeed.faster"),
        UNKNOWN("", "general.unknown");

        public final String binaryValue;
        private final String stringValue;

        private GameSpeed(String binaryValue, String textKey) {
            this.binaryValue = binaryValue;
            this.stringValue = Language.getText(textKey);
        }

        public static GameSpeed fromBinaryValue(String binaryValue) {
            GameSpeed[] gameSpeedArray = GameSpeed.values();
            int n = gameSpeedArray.length;
            int n2 = 0;
            while (n2 < n) {
                GameSpeed gameSpeed = gameSpeedArray[n2];
                if (gameSpeed.binaryValue.equals(binaryValue)) {
                    return gameSpeed;
                }
                ++n2;
            }
            int ordinal = binaryValue.charAt(0) - 48;
            if (ordinal >= 0 && ordinal <= 4) {
                return GameSpeed.values()[ordinal];
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum GameType {
        PRIVATE("virP", "sc2.gameType.private"),
        PUBLIC("buP", "sc2.gameType.public"),
        AMM("mmA", "sc2.gameType.amm"),
        SINGLE_PLAYER("", "sc2.gameType.singlePlayer"),
        UNKNOWN("", "general.unknown");

        public final String binaryValue;
        private final String stringValue;

        private GameType(String binaryValue, String textKey) {
            this.binaryValue = binaryValue;
            this.stringValue = Language.getText(textKey);
        }

        public static GameType fromBinaryValue(String binaryValue) {
            GameType[] gameTypeArray = GameType.values();
            int n = gameTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GameType gameType = gameTypeArray[n2];
                if (gameType.binaryValue.equals(binaryValue)) {
                    return gameType;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Gateway {
        AMERICA("USB", "sc2.gateway.america", "http://usb.depot.battle.net:1119/"),
        ASIA("KRB", "sc2.gateway.asia", "http://krb.depot.battle.net:1119/"),
        EUROPE("EUB", "sc2.gateway.europe", "http://eub.depot.battle.net:1119/"),
        UNKNOWN("", "general.unknown", null);

        public final String binaryValue;
        private final String stringValue;
        public final String depotServerUrl;

        private Gateway(String binaryValue, String textKey, String depotServerUrl) {
            this.binaryValue = binaryValue;
            this.stringValue = Language.getText(textKey);
            this.depotServerUrl = depotServerUrl;
        }

        public static Gateway fromBinaryValue(String binaryValue) {
            Gateway[] gatewayArray = Gateway.values();
            int n = gatewayArray.length;
            int n2 = 0;
            while (n2 < n) {
                Gateway gateway = gatewayArray[n2];
                if (gateway.binaryValue.equals(binaryValue)) {
                    return gateway;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum PlayerType {
        HUMAN("nmuH", "sc2.playerType.human"),
        COMPUTER("pmoC", "sc2.playerType.computer"),
        UNKNOWN("", "general.unknown");

        public final String binaryValue;
        private final String stringValue;

        private PlayerType(String binaryValue, String textKey) {
            this.binaryValue = binaryValue;
            this.stringValue = Language.getText(textKey);
        }

        public static PlayerType fromBinaryValue(String binaryValue) {
            PlayerType[] playerTypeArray = PlayerType.values();
            int n = playerTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlayerType playerType = playerTypeArray[n2];
                if (playerType.binaryValue.equals(binaryValue)) {
                    return playerType;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Race {
        RANDOM("DNAR", "sc2.race.random", "sc2.race.random.letter"),
        PROTOSS("torP", "sc2.race.protoss", "sc2.race.protoss.letter"),
        TERRAN("rreT", "sc2.race.terran", "sc2.race.terran.letter"),
        ZERG("greZ", "sc2.race.zerg", "sc2.race.zerg.letter"),
        ANY("*", null, "sc2.race.any.letter"),
        UNKNOWN("", "general.unknown", null);

        public final String binaryValue;
        private final String stringValue;
        public final char letter;

        private Race(String binaryValue, String textKey, String letterTextKey) {
            this.binaryValue = binaryValue;
            this.stringValue = textKey == null ? null : Language.getText(textKey);
            this.letter = (char)(letterTextKey == null ? 32 : (int)Character.toUpperCase(Language.getText(letterTextKey).charAt(0)));
        }

        public static Race fromLetter(char letter) {
            Race[] raceArray = Race.values();
            int n = raceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Race race = raceArray[n2];
                if (race.letter == letter) {
                    return race;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public static Race fromBinaryValue(String binaryValue) {
            Race[] raceArray = Race.values();
            int n = raceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Race race = raceArray[n2];
                if (race.binaryValue.equals(binaryValue)) {
                    return race;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Research {
        TERRAN_NITRO_PACKS,
        TERRAN_STIMPACK,
        TERRAN_COMBAT_SHIELD,
        TERRAN_CONCUSSIVE_SHELLS,
        TERRAN_SIEGE_TECH,
        TERRAN_INFERNAL_PRE_IGNITER("Terran Infernal Pre-Igniter"),
        TERRAN_CLOACKING_FIELD,
        TERRAN_CADUCEUS_REACTOR,
        TERRAN_CORVID_REACTOR,
        TERRAN_SEEKER_MISSILE,
        TERRAN_DURABLE_MATERIALS,
        TERRAN_PERSONAL_CLOACKING,
        TERRAN_MOEBIUS_REACTOR,
        TERRAN_WEAPON_REFIT,
        TERRAN_BEHEMOTH_REACTOR,
        TERRAN_250MM_STRIKE_CANNONS,
        ZERG_BURROW,
        ZERG_PNEUMATICED_CARAPACE("Zerg Pneumaticed Carapace (Overlord Speed)"),
        ZERG_VENTRAL_SACKS("Zerg Ventral Sacks (Overlord Transport)"),
        ZERG_ADRENAL_GLANDS("Zerg Adrenal Glands (Zergling Attack Speed)"),
        ZERG_METALIC_BOOST("Zerg Metalic Boost (Zergling Movement Speed)"),
        ZERG_GROOVED_SNIPES("Zerg Grooved Snipes (Hydralisk Range)"),
        ZERG_PERISTALSIS,
        ZERG_PATHOGEN_GLANDS("Zerg Pathogen Glands (Infestor Energy Upgrade)"),
        ZERG_NEURAL_PARASITE,
        ZERG_CENTRIFUGAL_HOOKS,
        ZERG_ORGANIC_CARAPACE,
        ZERG_GLIAL_RECONSTITUTION,
        ZERG_TUNNELING_CLAWS,
        ZERG_ANABOLIC_SYNTHESIS,
        ZERG_CHITINOUS_PLATING,
        PROTOSS_GRAVITIC_BOOSTER,
        PROTOSS_GRAVITIC_DRIVE,
        PROTOSS_EXTENDED_THERMAL_LANCE,
        PROTOSS_KHAYDARIN_AMULET("Protoss Khaydarin Amulet (High Templar Energy Upgrade)"),
        PROTOSS_PSIONIC_STORM,
        PROTOSS_WARP_GATE,
        PROTOSS_HALLUCINATION,
        PROTOSS_CHARGE,
        PROTOSS_BLINK,
        PROTOSS_FLUX_VANES("Protoss Flux Vanes (Void Ray Speed Upgrade)"),
        PROTOSS_GRAVITON_CATAPULT("Protoss Graviton Catapult (Interceptor Launch Speed Upgrade)");

        private final String stringValue;

        private Research() {
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private Research(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Unit {
        SCV("SCV"),
        MARINE,
        REAPER,
        GHOST,
        MARADEUR,
        SIEGE_TANK,
        THOR,
        HELLION,
        MEDIVAC,
        BANSHEE,
        RAVEN,
        BATTLECRUISER,
        VIKING,
        MULE("MULE"),
        NUCLEAR_MISSILE,
        DRONE,
        ZERGLING,
        OVERLORD,
        HYDRALISK,
        MUTALISK,
        ULTRALISK,
        ROACH,
        INFESTOR,
        CORRUPTOR,
        BROOD_LORD,
        QUEEN,
        BANELING,
        OVERSEER,
        CHANGELING,
        INFESTED_TERRAN,
        ZEALOT,
        STALKER,
        HIGH_TEMPLAR,
        DARK_TEMPLAR,
        SENTRY,
        PHOENIX,
        CARRIER,
        VOID_RAY,
        WARP_PRISM,
        OBSERVER,
        COLOSSUS,
        IMMORTAL,
        PROBE,
        MOTHERSHIP,
        ARCHON;

        private final String stringValue;

        private Unit() {
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private Unit(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum UnitAbility {
        CORRUPTION(AbilityGroup.CORRUPTION),
        EXPLODE(AbilityGroup.EXPLODE),
        FUNGAL_GROWTH(AbilityGroup.FUNGAL_GROWTH),
        GUARDIAN_SHIELD(AbilityGroup.GUARDIAN_SHIELD),
        REPAIR(AbilityGroup.REPAIR),
        FEEDBACK(AbilityGroup.FEEDBACK),
        MASS_RECALL(AbilityGroup.MASS_RECALL),
        BUILD_POINT_DEFENSE_DRONE(AbilityGroup.BUILD_POINT_DEFENSE_DRONE),
        SEEKER_MISSILE(AbilityGroup.SEEKER_MISSILE),
        GRAVITON_BEAM(AbilityGroup.GRAVITON_BEAM),
        SPAWN_CHANGELING(AbilityGroup.SPAWN_CHANGELING),
        DISGUISE(null),
        DISGUISE_AS_ZEALOT(null),
        DISGUISE_AS_MARINE_WITH_SHIELD(null),
        DISGUISE_AS_MARINE_WITHOUT_SHIELD(null),
        DISGUISE_AS_ZERGLING_WITH_WINGS(null),
        DISGUISE_AS_ZERGLING_WITHOUT_WINGS(null),
        INFESTED_TERRAN(AbilityGroup.INFESTED_TERRAN),
        NEURAL_PARASITE(AbilityGroup.NEURAL_PARASITE),
        SPAWN_LARVA(AbilityGroup.SPAWN_LARVA),
        STIMPACK(AbilityGroup.STIMPACK),
        T250MM_STRIKE_CANNONS(AbilityGroup.T250MM_STRIKE_CANNONS, "250mm Strike Cannons"),
        GATHER_RESOURCES_TERRAN(AbilityGroup.GATHER_TERRAN),
        GATHER_RESOURCES_PROTOSS(AbilityGroup.GATHER_PROTOSS),
        GATHER_RESOURCES_ZERG(AbilityGroup.GATHER_ZERG),
        RETURN_CHARGO(AbilityGroup.RETURN_CHARGO),
        BUILD_AUTO_TURRET(AbilityGroup.BUILD_AUTO_TURRET),
        CLOACK(AbilityGroup.CLOACK),
        DECLOACK(AbilityGroup.DECLOACK),
        SNIPER_ROUND(AbilityGroup.SNIPER_ROUND),
        HEAL(AbilityGroup.HEAL),
        SIEGE_MODE(AbilityGroup.SIEGE_MODE),
        TANK_MODE(AbilityGroup.TANK_MODE),
        LOAD(AbilityGroup.LOAD),
        UNLOAD_ALL(AbilityGroup.UNLOAD_ALL),
        UNLOAD_ALL_AT(null),
        UNLOAD_UNIT(null),
        LOAD_ALL(null),
        YAMATO_CANNON(AbilityGroup.YAMATO_CANNON),
        ASSAULT_MODE(AbilityGroup.ASSAULT_MODE),
        FIGHTER_MODE(AbilityGroup.FIGHTER_MODE),
        PSIONIC_STORM(AbilityGroup.PSIONIC_STORM),
        TRAIN_AN_INTERCEPTOR(AbilityGroup.TRAIN_AN_INTERCEPTOR, "Train an Interceptor"),
        MORPH_TO_BROOD_LORD(AbilityGroup.MORPH_TO_BROOD_LORD, "Morph to Brood Lord"),
        CANCEL_BROOD_LORD_MORPHING(AbilityGroup.CANCEL),
        BURROW(AbilityGroup.BURROW),
        UNBURROW(AbilityGroup.UNBURROW),
        MORPH_TO_BANELING(AbilityGroup.MORPH_TO_BANELING, "Morph to Baneling"),
        BLINK(AbilityGroup.BLINK),
        MORPH_TO_OVERSEER(AbilityGroup.MORPH_TO_OVERSEER, "Morph to Overseer"),
        CANCEL_OVERSEER_MORPHING(AbilityGroup.CANCEL),
        FORCE_FIELD(AbilityGroup.FORCE_FIELD),
        PHASING_MODE(AbilityGroup.PHASING_MODE),
        TRANSPORT_MODE(AbilityGroup.TRANSPORT_MODE),
        TAC_NUCLEAR_STRIKE(AbilityGroup.TAC_NUCLEAR_STRIKE),
        CANCEL_TAC_NUCLEAR_STRIKE(AbilityGroup.CANCEL),
        EMP_ROUND(AbilityGroup.EMP_ROUND, "EMP Round"),
        VORTEX(AbilityGroup.VORTEX),
        TRANSFUSION(AbilityGroup.TRANSFUSION),
        ATTACK(AbilityGroup.ATTACK),
        STOP(AbilityGroup.STOP),
        GENERATE_CREEP(AbilityGroup.GENERATE_CREEP),
        STOP_GENERATING_CREEP(AbilityGroup.STOP_GENERATING_CREEP),
        SPAWN_CREEP_TUMOR(AbilityGroup.SPAWN_CREEP_TUMOR),
        TRAIN_A_BROODLING_ESCORT(null, "Train a Broodling Escort"),
        CHARGE(AbilityGroup.CHARGE),
        ATTACK_STRUCTURE(AbilityGroup.ATTACK_STRUCTURE),
        FRENZY(AbilityGroup.FRENZY),
        CONTAMINATE(AbilityGroup.FUNGAL_GROWTH);

        private final String stringValue;
        public final AbilityGroup abilityGroup;

        private UnitAbility(AbilityGroup abilityGroup) {
            this.abilityGroup = abilityGroup;
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private UnitAbility(AbilityGroup abilityGroup, String stringValue) {
            this.abilityGroup = abilityGroup;
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Upgrade {
        TERRAN_HI_SEC_AUTO_TRACKING("Terran Hi-sec Auto Tracking"),
        TERRAN_BUILDING_ARMOR,
        TERRAN_INFANTRY_WEAPONS_1,
        TERRAN_INFANTRY_WEAPONS_2,
        TERRAN_INFANTRY_WEAPONS_3,
        TERRAN_INFANTRY_ARMOR_1,
        TERRAN_INFANTRY_ARMOR_2,
        TERRAN_INFANTRY_ARMOR_3,
        TERRAN_NEOSTEEL_FRAME,
        TERRAN_VEHICLE_PLATING_1,
        TERRAN_VEHICLE_PLATING_2,
        TERRAN_VEHICLE_PLATING_3,
        TERRAN_VEHICLE_WEAPONS_1,
        TERRAN_VEHICLE_WEAPONS_2,
        TERRAN_VEHICLE_WEAPONS_3,
        TERRAN_SHIP_PLATING_1,
        TERRAN_SHIP_PLATING_2,
        TERRAN_SHIP_PLATING_3,
        TERRAN_SHIP_WEAPONS_1,
        TERRAN_SHIP_WEAPONS_2,
        TERRAN_SHIP_WEAPONS_3,
        ZERG_MELEE_ATTACKS_1,
        ZERG_MELEE_ATTACKS_2,
        ZERG_MELEE_ATTACKS_3,
        ZERG_GROUND_CARAPACE_1,
        ZERG_GROUND_CARAPACE_2,
        ZERG_GROUND_CARAPACE_3,
        ZERG_MISSILE_ATTACKS_1,
        ZERG_MISSILE_ATTACKS_2,
        ZERG_MISSILE_ATTACKS_3,
        ZERG_FLYER_ATTACKS_1,
        ZERG_FLYER_ATTACKS_2,
        ZERG_FLYER_ATTACKS_3,
        ZERG_FLYER_CARAPACE_1,
        ZERG_FLYER_CARAPACE_2,
        ZERG_FLYER_CARAPACE_3,
        PROTOSS_GROUND_WEAPONS_1,
        PROTOSS_GROUND_WEAPONS_2,
        PROTOSS_GROUND_WEAPONS_3,
        PROTOSS_GROUND_ARMOR_1,
        PROTOSS_GROUND_ARMOR_2,
        PROTOSS_GROUND_ARMOR_3,
        PROTOSS_SHIELD_1,
        PROTOSS_SHIELD_2,
        PROTOSS_SHIELD_3,
        PROTOSS_AIR_WEAPONS_1,
        PROTOSS_AIR_WEAPONS_2,
        PROTOSS_AIR_WEAPONS_3,
        PROTOSS_AIR_ARMOR_1,
        PROTOSS_AIR_ARMOR_2,
        PROTOSS_AIR_ARMOR_3;

        private final String stringValue;

        private Upgrade() {
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private Upgrade(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

