/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.mpq;

import hu.belicza.andras.sc2gears.mpq.AlgorithmUtil;
import hu.belicza.andras.sc2gears.mpq.InvalidMpqArchiveException;
import hu.belicza.andras.sc2gears.mpq.model.BlockTable;
import hu.belicza.andras.sc2gears.mpq.model.HashTable;
import hu.belicza.andras.sc2gears.mpq.model.Header;
import hu.belicza.andras.sc2gears.mpq.model.MpqArchive;
import hu.belicza.andras.sc2gears.mpq.model.UserData;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class MpqParser {
    private static final int HASH_TABLE_DECRYPTION_KEY = -1011927184;
    private static final int BLOCK_TABLE_DECRYPTION_KEY = -326913117;
    private final MpqArchive mpqArchive = new MpqArchive();
    private final FileInputStream input;
    private final FileChannel channel;

    public MpqParser(String fileName) throws InvalidMpqArchiveException {
        try {
            this.input = new FileInputStream(fileName);
            byte[] magic = new byte[4];
            this.input.read(magic);
            if (UserData.isMpqMagicExt(magic)) {
                this.mpqArchive.userData = this.readUserData();
                this.input.skip(this.mpqArchive.userData.archiveHeaderOffset - (this.mpqArchive.userData.userDataSize + 12));
                this.input.read(magic);
            }
            if (!Header.isMpqMagic(magic)) {
                throw new InvalidMpqArchiveException("Invalid MPQ archive!");
            }
            this.mpqArchive.header = this.readHeader();
            this.mpqArchive.blockSize = 512 << this.mpqArchive.header.sectorSizeShift;
            this.channel = this.input.getChannel();
            this.channel.position(((long)this.mpqArchive.header.hashTableOffsetHigh << 32) + ((long)this.mpqArchive.header.hashTableOffset & 0xFFFFFFFFL) + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset));
            this.mpqArchive.hashTables = this.readHashTableEntries(this.mpqArchive.header.hashTableEntries);
            this.channel.position(((long)this.mpqArchive.header.blockTableOffsetHigh << 32) + ((long)this.mpqArchive.header.blockTableOffset & 0xFFFFFFFFL) + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset));
            this.mpqArchive.blockTables = this.readBlockTableEntries(this.mpqArchive.header.blockTableEntries);
            if (this.mpqArchive.header.extendedBlockTableOffset > 0L) {
                this.channel.position(this.mpqArchive.header.extendedBlockTableOffset + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset));
                this.mpqArchive.extBlockTableHighOffsets = this.readExtBlockTableEntries(this.mpqArchive.header.blockTableEntries);
            }
            this.mpqArchive.blockTableIndices = new int[this.mpqArchive.header.blockTableEntries];
            int i = 0;
            while (i < this.mpqArchive.header.blockTableEntries) {
                if ((this.mpqArchive.blockTables[i].flags & Integer.MIN_VALUE) != 0) {
                    this.mpqArchive.blockTableIndices[this.mpqArchive.filesCount++] = i;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.close();
            throw new InvalidMpqArchiveException(e.getMessage(), e);
        }
    }

    private UserData readUserData() throws IOException {
        UserData userData = new UserData();
        userData.userDataSize = this.readFullBuffer(4).getInt();
        userData.archiveHeaderOffset = this.readFullBuffer(4).getInt();
        userData.userData = this.readFullBuffer(userData.userDataSize).array();
        return userData;
    }

    private Header readHeader() throws IOException {
        Header header = new Header();
        header.headerSize = this.readFullBuffer(4).getInt();
        ByteBuffer headerBuffer = this.readFullBuffer(header.headerSize - 8);
        header.archiveSize = headerBuffer.getInt();
        header.formatVersion = headerBuffer.getShort();
        header.sectorSizeShift = headerBuffer.getShort();
        header.hashTableOffset = headerBuffer.getInt();
        header.blockTableOffset = headerBuffer.getInt();
        header.hashTableEntries = headerBuffer.getInt();
        header.blockTableEntries = headerBuffer.getInt();
        if (header.formatVersion == 1) {
            header.extendedBlockTableOffset = headerBuffer.getLong();
            header.hashTableOffsetHigh = headerBuffer.getShort();
            header.blockTableOffsetHigh = headerBuffer.getShort();
        }
        return header;
    }

    private HashTable[] readHashTableEntries(int hashTableEntires) throws IOException {
        int size = hashTableEntires * 16;
        ByteBuffer hashTablesBuffer = AlgorithmUtil.decryptData(this.readFullBuffer(size), size, -1011927184);
        HashTable[] hashTables = new HashTable[hashTableEntires];
        int i = 0;
        while (i < hashTables.length) {
            HashTable hashTable = new HashTable();
            hashTable.filePathHashA = hashTablesBuffer.getInt();
            hashTable.filePathHashB = hashTablesBuffer.getInt();
            hashTable.language = hashTablesBuffer.getShort();
            hashTable.platform = hashTablesBuffer.getShort();
            hashTable.fileBlockIndex = hashTablesBuffer.getInt();
            hashTables[i] = hashTable;
            ++i;
        }
        return hashTables;
    }

    private BlockTable[] readBlockTableEntries(int blockTableEntires) throws IOException {
        int size = blockTableEntires * 16;
        ByteBuffer blockTablesBuffer = AlgorithmUtil.decryptData(this.readFullBuffer(size), size, -326913117);
        BlockTable[] blockTables = new BlockTable[blockTableEntires];
        int i = 0;
        while (i < blockTables.length) {
            BlockTable blockTable = new BlockTable();
            blockTable.blockOffset = blockTablesBuffer.getInt();
            blockTable.blockSize = blockTablesBuffer.getInt();
            blockTable.fileSize = blockTablesBuffer.getInt();
            blockTable.flags = blockTablesBuffer.getInt();
            blockTables[i] = blockTable;
            ++i;
        }
        return blockTables;
    }

    private short[] readExtBlockTableEntries(int blockTableEntires) throws IOException {
        ByteBuffer extBlockTablesBuffer = this.readFullBuffer(blockTableEntires * 2);
        short[] extBlockTableHighOffsets = new short[blockTableEntires];
        int i = 0;
        while (i < extBlockTableHighOffsets.length) {
            extBlockTableHighOffsets[i] = extBlockTablesBuffer.getShort();
            ++i;
        }
        return extBlockTableHighOffsets;
    }

    public UserData getUserData() {
        return this.mpqArchive.userData;
    }

    public int getFileSize(int hash1, int hash2, int hash3) {
        int hashTableEntries = this.mpqArchive.header.hashTableEntries;
        int counter = 0;
        int i = hash1 & hashTableEntries - 1;
        while (i < hashTableEntries) {
            HashTable hashTable = this.mpqArchive.hashTables[i];
            if (hashTable.fileBlockIndex != -1 && hashTable.filePathHashA == hash2 && hashTable.filePathHashB == hash3) {
                int j = 0;
                while (j < hashTable.fileBlockIndex) {
                    if ((this.mpqArchive.blockTables[j].flags & Integer.MIN_VALUE) == 0) {
                        ++counter;
                    }
                    ++j;
                }
                int fileIndex = hashTable.fileBlockIndex - counter;
                if (fileIndex < 0 || fileIndex >= this.mpqArchive.filesCount) {
                    return -1;
                }
                return this.mpqArchive.blockTables[this.mpqArchive.blockTableIndices[fileIndex]].fileSize;
            }
            ++i;
        }
        return -1;
    }

    public byte[] getFile(String fileName) throws InvalidMpqArchiveException {
        int hash1 = AlgorithmUtil.hashString(fileName, AlgorithmUtil.MpqHashType.TABLE_OFFSET);
        int hash2 = AlgorithmUtil.hashString(fileName, AlgorithmUtil.MpqHashType.NAME_A);
        int hash3 = AlgorithmUtil.hashString(fileName, AlgorithmUtil.MpqHashType.NAME_B);
        return this.getFile(hash1, hash2, hash3);
    }

    public byte[] getFile(int hash1, int hash2, int hash3) throws InvalidMpqArchiveException {
        int hashTableEntries = this.mpqArchive.header.hashTableEntries;
        int counter = 0;
        int i = hash1 & hashTableEntries - 1;
        while (i < hashTableEntries) {
            HashTable hashTable = this.mpqArchive.hashTables[i];
            if (hashTable.fileBlockIndex != -1 && hashTable.filePathHashA == hash2 && hashTable.filePathHashB == hash3) {
                int j = 0;
                while (j < hashTable.fileBlockIndex) {
                    if ((this.mpqArchive.blockTables[j].flags & Integer.MIN_VALUE) == 0) {
                        ++counter;
                    }
                    ++j;
                }
                int fileIndex = hashTable.fileBlockIndex - counter;
                if (fileIndex < 0 || fileIndex >= this.mpqArchive.filesCount) {
                    return null;
                }
                int blockTableIndex = this.mpqArchive.blockTableIndices[fileIndex];
                BlockTable blockTable = this.mpqArchive.blockTables[blockTableIndex];
                try {
                    int blocksCount = (blockTable.flags & 0x1000000) != 0 ? 1 : (blockTable.fileSize + this.mpqArchive.blockSize - 1) / this.mpqArchive.blockSize;
                    int[] packedBlockOffsetTable = new int[blocksCount + ((blockTable.flags & 0x4000000) != 0 ? 2 : 1)];
                    if ((blockTable.flags & 0xFF00) != 0 && (blockTable.flags & 0x1000000) == 0) {
                        this.channel.position((this.mpqArchive.extBlockTableHighOffsets == null ? 0L : ((long)this.mpqArchive.extBlockTableHighOffsets[blockTableIndex] & 0xFFFFL) << 32) + ((long)blockTable.blockOffset & 0xFFFFFFFFL) + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset));
                        ByteBuffer buffer = this.readFullBuffer(packedBlockOffsetTable.length * 4);
                        int k = 0;
                        while (k < packedBlockOffsetTable.length) {
                            packedBlockOffsetTable[k] = buffer.getInt();
                            ++k;
                        }
                        if ((blockTable.flags & 0x10000) != 0) {
                            throw new InvalidMpqArchiveException("Decryption of packed block offset table is not yet implemented!");
                        }
                    } else if ((blockTable.flags & 0x1000000) == 0) {
                        int k = 0;
                        while (k < blocksCount) {
                            packedBlockOffsetTable[k] = k * this.mpqArchive.blockSize;
                            ++k;
                        }
                        packedBlockOffsetTable[blocksCount] = blockTable.blockSize;
                    } else {
                        packedBlockOffsetTable[0] = 0;
                        packedBlockOffsetTable[1] = blockTable.blockSize;
                    }
                    byte[] content = new byte[blockTable.fileSize];
                    int contentIndex = 0;
                    int k = 0;
                    while (k < blocksCount) {
                        int unpackedSize = (blockTable.flags & 0x1000000) != 0 ? blockTable.fileSize : (k < blocksCount - 1 ? this.mpqArchive.blockSize : blockTable.fileSize - this.mpqArchive.blockSize * k);
                        int inSize = packedBlockOffsetTable[k + 1] - packedBlockOffsetTable[k];
                        this.channel.position((this.mpqArchive.extBlockTableHighOffsets == null ? 0L : ((long)this.mpqArchive.extBlockTableHighOffsets[blockTableIndex] & 0xFFFFL) << 32) + ((long)blockTable.blockOffset & 0xFFFFFFFFL) + (long)(this.mpqArchive.userData == null ? 0 : this.mpqArchive.userData.archiveHeaderOffset) + (long)packedBlockOffsetTable[k]);
                        byte[] inBuffer = this.readFullBuffer(inSize).array();
                        if ((blockTable.flags & 0x10000) != 0) {
                            throw new InvalidMpqArchiveException("Decryption of data block is not yet implemented!");
                        }
                        if ((blockTable.flags & 0x200) != 0) {
                            AlgorithmUtil.decompressMultiBlock(inBuffer, unpackedSize, content, contentIndex);
                        } else {
                            if ((blockTable.flags & 0x100) != 0) {
                                throw new InvalidMpqArchiveException("Explosion of data block is not yet implemented!");
                            }
                            System.arraycopy(inBuffer, 0, content, contentIndex, inSize);
                        }
                        contentIndex += unpackedSize;
                        ++k;
                    }
                    return content;
                }
                catch (IOException ie) {
                    throw new InvalidMpqArchiveException(ie.getMessage(), ie);
                }
            }
            ++i;
        }
        return null;
    }

    private ByteBuffer readFullBuffer(int size) throws IOException {
        byte[] data = new byte[size];
        if (this.input.read(data) < size) {
            throw new IOException("Unexpected end of file, tried to read " + size + " bytes but EOF reached!");
        }
        return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
    }

    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

