/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.mpq;

import hu.belicza.andras.sc2gears.mpq.InvalidMpqArchiveException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class AlgorithmUtil {
    private static final long[] CRYPT_TABLE = new long[1280];
    private static final int FLAG_COMPRESSION_ZLIB = 2;

    static {
        long seed = 0x100001L;
        int index1 = 0;
        int index2 = 0;
        index1 = 0;
        while (index1 < 256) {
            index2 = index1;
            int i = 0;
            while (i < 5) {
                seed = (seed * 125L + 3L & 0xFFFFFFFFL) % 0x2AAAABL;
                long temp1 = (seed & 0xFFFFL) << 16;
                seed = (seed * 125L + 3L & 0xFFFFFFFFL) % 0x2AAAABL;
                long temp2 = seed & 0xFFFFL;
                AlgorithmUtil.CRYPT_TABLE[index2] = temp1 | temp2;
                ++i;
                index2 += 256;
            }
            ++index1;
        }
    }

    private AlgorithmUtil() {
    }

    public static ByteBuffer decryptData(ByteBuffer buffer, int size, int key) {
        long seed1 = (long)key & 0xFFFFFFFFL;
        long seed2 = 0xEEEEEEEEL;
        int i = 0;
        while (i < size) {
            seed2 = seed2 + CRYPT_TABLE[1024 + (int)(seed1 & 0xFFL)] & 0xFFFFFFFFL;
            int ch = buffer.getInt(i) ^ (int)(seed1 + seed2);
            seed1 = (((seed1 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL) << 21) + 0x11111111L & 0xFFFFFFFFL | seed1 >> 11;
            seed2 = ((long)ch & 0xFFFFFFFFL) + seed2 + (seed2 << 5) + 3L & 0xFFFFFFFFL;
            buffer.putInt(i, ch);
            i += 4;
        }
        buffer.position(0);
        return buffer;
    }

    public static int hashString(String string, MpqHashType mpqHash) {
        int offset = mpqHash.offset;
        long seed1 = 2146271213L;
        long seed2 = 0xEEEEEEEEL;
        int length = string.length();
        int i = 0;
        while (i < length) {
            char ch = Character.toUpperCase(string.charAt(i));
            seed1 = CRYPT_TABLE[offset + ch] ^ seed1 + seed2 & 0xFFFFFFFFL;
            seed2 = (long)ch + seed1 + seed2 + (seed2 << 5) + 3L & 0xFFFFFFFFL;
            ++i;
        }
        return (int)seed1;
    }

    public static void decompressMultiBlock(byte[] block, int outSize, byte[] dest, int destPos) throws InvalidMpqArchiveException {
        if (block.length >= outSize) {
            System.arraycopy(block, 0, dest, destPos, outSize);
        } else {
            byte compressionFlag = block[0];
            if (compressionFlag != 2) {
                throw new InvalidMpqArchiveException("Compression (" + compressionFlag + ") not supported!");
            }
            Inflater inflater = new Inflater();
            inflater.setInput(block, 1, block.length - 1);
            try {
                inflater.inflate(dest, destPos, outSize);
                inflater.end();
            }
            catch (DataFormatException dfe) {
                throw new InvalidMpqArchiveException("Data format exception, failed to decompressed block!", dfe);
            }
        }
    }

    public static enum MpqHashType {
        TABLE_OFFSET(0),
        NAME_A(1),
        NAME_B(2),
        FILE_KEY(3);

        public final int offset;

        private MpqHashType(int offsetBase) {
            this.offset = offsetBase << 8;
        }
    }
}

