/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gearsupdater;

import hu.belicza.andras.sc2gears.shared.CommonUtils;
import hu.belicza.andras.sc2gears.shared.Consts;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipInputStream;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class Updater
extends JFrame {
    private static final String VERSION = "1.1";
    public static final String URL_DOWNLOADS = "http://sites.google.com/site/sc2gears/version-history";
    private static final File CURRENT_FOLDER = new File("lib").getAbsoluteFile().getParentFile();
    private static final File UPDATE_CACHE_FOLDER = new File("_Update cache").getAbsoluteFile();
    private static final File USER_CONTENT_FOLDER = new File("User content").getAbsoluteFile();
    private static final File SC2GEARS_JAR = new File("lib/Sc2gears.jar").getAbsoluteFile();
    private static final File ARCHIVE_SC2GEARS_FOLDER = new File(UPDATE_CACHE_FOLDER, "Sc2gears");
    private static final File ARCHIVE_UPDATER_LIB = new File(ARCHIVE_SC2GEARS_FOLDER, String.valueOf(Consts.LIB_UPDATER_FOLDER.getName()) + "/" + "Sc2gearsUpdater.jar");
    private final JTextArea logTextArea = new JTextArea();
    private final JProgressBar dlProgressBar = new JProgressBar();
    private final JPanel controlButtonsPanel = new JPanel();
    private final JButton closeAndStartSc2gearsButton = new JButton("Close and Start Sc2gears", new ImageIcon(new ImageIcon(Updater.class.getResource("sc2gears.png")).getImage().getScaledInstance(16, 16, 4)));
    private final JButton closeButton = new JButton("Close", new ImageIcon(Updater.class.getResource("door-open-in.png")));
    private final JButton abortButton = new JButton("Abort", new ImageIcon(Updater.class.getResource("cross-octagon.png")));
    private volatile boolean updateInProgress;
    private volatile boolean abortAllowed;
    private final byte[] buffer = new byte[8192];
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss - ");

    public static void main(String[] arguments) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n2];
            if ("Nimbus".equals(lookAndFeelInfo.getName())) {
                try {
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        if (arguments.length < 4) {
            JOptionPane.showMessageDialog(null, new String[]{"Sc2gears Updater is handled by Sc2gears internally.", "You do not need to run it."}, "Sc2gears Updater", 2);
            System.exit(0);
        }
        new Updater(arguments[0], arguments[1], arguments[2], arguments[3]);
    }

    public Updater(String latestVersion, String requiredMinUpdaterVer, String archiveUrl, String archiveSha256) {
        super("Sc2gears Updater");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Updater.this.exit();
            }
        });
        this.setIconImage(new ImageIcon(Updater.class.getResource("sc2gears.png")).getImage());
        this.buildGui();
        this.setBounds(100, 100, 700, 500);
        this.setVisible(true);
        this.startUpdate(latestVersion, requiredMinUpdaterVer, archiveUrl, archiveSha256);
    }

    private void buildGui() {
        JPanel wrapper = new JPanel();
        JLabel infoLabel = new JLabel("Sc2gears Updater ver. 1.1 \u00a9 Andr\u00e1s Belicza, 2010", 0);
        wrapper.add(infoLabel);
        this.getContentPane().add((Component)wrapper, "North");
        this.logTextArea.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(this.logTextArea), "Center");
        Box southBox = Box.createVerticalBox();
        JPanel dlStatusPanel = new JPanel();
        dlStatusPanel.add(new JLabel("Download status:"));
        this.dlProgressBar.setString("");
        this.dlProgressBar.setStringPainted(true);
        this.dlProgressBar.setPreferredSize(new Dimension(300, 23));
        dlStatusPanel.add(this.dlProgressBar);
        southBox.add(dlStatusPanel);
        JPanel linksPanel = new JPanel();
        linksPanel.add(CommonUtils.createLinkLabel("View version history", URL_DOWNLOADS));
        linksPanel.add(Box.createHorizontalStrut(10));
        linksPanel.add(CommonUtils.createLinkLabel("View download page", URL_DOWNLOADS));
        linksPanel.add(Box.createHorizontalStrut(10));
        linksPanel.add(CommonUtils.createLinkLabel("Visit home page", "http://sites.google.com/site/sc2gears/"));
        southBox.add(linksPanel);
        this.closeAndStartSc2gearsButton.setEnabled(false);
        this.closeAndStartSc2gearsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (CommonUtils.isWindows() || CommonUtils.isMac() || CommonUtils.isUnix()) {
                    if (CommonUtils.isMac() || CommonUtils.isUnix()) {
                        try {
                            Runtime.getRuntime().exec(CommonUtils.isMac() ? "chmod +x Sc2gears-os-x.sh" : (CommonUtils.isUnix() ? "chmod +x Sc2gears-unix.sh" : ""));
                        }
                        catch (IOException ie) {
                            ie.printStackTrace();
                        }
                    }
                    try {
                        Runtime.getRuntime().exec(CommonUtils.isWindows() ? "Sc2gears.exe" : (CommonUtils.isMac() ? "./Sc2gears-os-x.sh" : (CommonUtils.isUnix() ? "./Sc2gears-unix.sh" : "")));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e);
                        e.printStackTrace();
                    }
                }
                Updater.this.exit();
            }
        });
        this.controlButtonsPanel.add(this.closeAndStartSc2gearsButton);
        this.closeButton.setEnabled(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Updater.this.exit();
            }
        });
        this.controlButtonsPanel.add(this.closeButton);
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Updater.this.exit();
            }
        });
        this.controlButtonsPanel.add(this.abortButton);
        southBox.add(this.controlButtonsPanel);
        this.getContentPane().add((Component)southBox, "South");
    }

    private void exit() {
        if (this.updateInProgress && this.abortAllowed && 1 == JOptionPane.showConfirmDialog(this, new String[]{"Are you sure you want to abort the update?", "Hit 'No' to continue."}, "Warning!", 0, 2)) {
            return;
        }
        if (this.updateInProgress && !this.abortAllowed) {
            JOptionPane.showMessageDialog(this, new String[]{"The Update process cannot be aborted at this time without damaging Sc2gears!"}, "Error!", 0);
            return;
        }
        System.exit(0);
    }

    /*
     * Unable to fully structure code
     */
    private void startUpdate(String latestVersion, String requiredMinUpdaterVer, String archiveUrl, String archiveSha256) {
        this.updateInProgress = true;
        this.abortAllowed = true;
        try {
            try {
                this.logTextArea.append("If the update fails and you cannot start Sc2gears, visit the home page and download it manually.\n\n");
                this.logMessage("Available latest version: " + latestVersion);
                if (new BigDecimal(requiredMinUpdaterVer).compareTo(new BigDecimal("1.1")) > 0) {
                    this.logMessage("The update cannot be performed, because this update requires a newer version of Updater (" + requiredMinUpdaterVer + ")!");
                    this.logMessage("Please download the latest version manually.");
                    throw new Exception();
                }
                this.logMessage("Preparing for update...");
                if (Updater.SC2GEARS_JAR.exists()) ** GOTO lbl18
                this.logMessage("It appears you did not start Sc2gears from its folder, aborting update!");
                throw new Exception();
lbl-1000:
                // 1 sources

                {
                    if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not delete folder:", Updater.UPDATE_CACHE_FOLDER.getAbsolutePath(), " ", "Retry?"}, "Error!", 0, 0)) continue;
                    this.logMessage("Failed to delete file: " + Updater.UPDATE_CACHE_FOLDER.getAbsolutePath());
                    throw new Exception();
lbl18:
                    // 2 sources

                    ** while (!Updater.deleteFile((File)Updater.UPDATE_CACHE_FOLDER))
                }
lbl19:
                // 2 sources

                while (!Updater.UPDATE_CACHE_FOLDER.mkdir()) {
                    if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not create folder:", Updater.UPDATE_CACHE_FOLDER.getAbsolutePath(), " ", "Retry?"}, "Error!", 0, 0)) continue;
                    this.logMessage("Could not create update cache folder!");
                    throw new Exception();
                }
                this.logMessage("Downloading archive...");
                ARCHIVE_FILE = new File(Updater.UPDATE_CACHE_FOLDER, "archive.zip");
                try {
                    archiveUrlConnection = new URL(archiveUrl).openConnection();
                    length = archiveUrlConnection.getContentLength();
                    if (length < 0) {
                        this.dlProgressBar.setString("Downloading... (size unknown)");
                    } else {
                        this.dlProgressBar.setString(null);
                        this.dlProgressBar.setMaximum(length);
                    }
                    input = archiveUrlConnection.getInputStream();
                    output = new FileOutputStream(ARCHIVE_FILE);
                    totalBytesRead = 0;
                    while ((bytesRead = input.read(this.buffer)) > 0) {
                        output.write(this.buffer, 0, bytesRead);
                        totalBytesRead += bytesRead;
                        if (length <= 0) continue;
                        this.dlProgressBar.setValue(totalBytesRead);
                    }
                    if (length < 0) {
                        this.dlProgressBar.setValue(this.dlProgressBar.getMaximum());
                        this.dlProgressBar.setString(null);
                    }
                    output.flush();
                    output.close();
                    input.close();
                    this.logMessage("Download complete.");
                }
                catch (Exception e) {
                    this.logMessage("Failed to download archive.");
                    throw e;
                }
                this.logMessage("Checking SHA-256 checksum of the archive...");
                if (!archiveSha256.equals(CommonUtils.calculateFileSha256(ARCHIVE_FILE))) {
                    this.logMessage("SHA-256 checksum does not match!");
                    this.logMessage("To protect your computer, the update process has been aborted!");
                    this.logMessage("You can start the update process again if you think this is due to a download error.");
                    this.logMessage("If the SHA-256 checksum test fails repeatedly, please contact the author.");
                    throw new Exception("SHA-256 checksum test failed, aborting update!");
                }
                this.logMessage("SHA-256 checksum OK.");
                this.logMessage("Extracting archive...");
                try {
                    zipInput = new ZipInputStream(new FileInputStream(ARCHIVE_FILE));
                    while ((zipEntry = zipInput.getNextEntry()) != null) {
                        entryFile = new File(Updater.UPDATE_CACHE_FOLDER, zipEntry.getName());
                        if (zipEntry.isDirectory()) {
                            entryFile.mkdirs();
                            continue;
                        }
                        size = zipEntry.getSize();
                        output = new FileOutputStream(entryFile);
                        while (size > 0L) {
                            bytesRead = zipInput.read(this.buffer);
                            output.write(this.buffer, 0, bytesRead);
                            size -= (long)bytesRead;
                        }
                        output.flush();
                        output.close();
                    }
                    zipInput.close();
                    this.logMessage("Extracting done.");
                    if (!Updater.ARCHIVE_SC2GEARS_FOLDER.exists()) {
                        this.logMessage("Error: the extracted archive does not seem to be a valid archive! Aborting update!");
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    this.logMessage("Failed to extract archive!");
                    throw e;
                }
                this.logMessage("Replacing/patching files...");
                newArchiveUpdaterLib = new File(Updater.ARCHIVE_UPDATER_LIB.getParent(), "Sc2gearsUpdater2.jar");
                while (!Updater.ARCHIVE_UPDATER_LIB.renameTo(newArchiveUpdaterLib)) {
                    if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not rename file:", Updater.ARCHIVE_UPDATER_LIB.getAbsolutePath(), "To:", newArchiveUpdaterLib.getAbsolutePath(), " ", "Retry?"}, "Error!", 0, 0)) continue;
                    this.logMessage("Failed to rename file: " + Updater.ARCHIVE_UPDATER_LIB.getAbsolutePath());
                    throw new Exception();
                }
                this.abortAllowed = false;
                this.abortButton.setEnabled(false);
                var10_18 = Updater.CURRENT_FOLDER.listFiles();
                var9_16 = var10_18.length;
                var8_13 = 0;
                while (var8_13 < var9_16) {
                    file = var10_18[var8_13];
                    if (!(file.equals(Updater.UPDATE_CACHE_FOLDER) || file.equals(Updater.USER_CONTENT_FOLDER) || file.equals(Consts.LIB_UPDATER_FOLDER))) {
                        while (!Updater.deleteFile(file)) {
                            if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not delete file or folder:", file.getAbsolutePath(), " ", "At this point your Sc2gears is probably damaged.", "Retry?"}, "Error!", 0, 0)) continue;
                            this.logMessage("Failed to delete file or folder: " + file.getAbsolutePath());
                            this.logMessage("Your Sc2gears is probably damaged now.");
                            throw new Exception();
                        }
                    }
                    ++var8_13;
                }
                var10_18 = Updater.ARCHIVE_SC2GEARS_FOLDER.listFiles();
                var9_16 = var10_18.length;
                var8_13 = 0;
                while (var8_13 < var9_16) {
                    sourceFile = var10_18[var8_13];
                    if (!sourceFile.getName().equals(Updater.USER_CONTENT_FOLDER.getName())) {
                        while (!this.copyFile(sourceFile, Updater.CURRENT_FOLDER)) {
                            if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not copy file or folder from:", sourceFile.getAbsolutePath(), "To:", Updater.CURRENT_FOLDER.getAbsolutePath(), " ", "At this point your Sc2gears is probably damaged.", "Retry?"}, "Error!", 0, 0)) continue;
                            this.logMessage("Failed to copy file or folder: " + sourceFile.getAbsolutePath());
                            this.logMessage("Your Sc2gears is probably damaged now.");
                            throw new Exception();
                        }
                    }
                    ++var8_13;
                }
                this.abortAllowed = true;
                this.logMessage("Replace/patch complete.");
                this.logMessage("Cleaning up...");
                if (!Updater.deleteFile(Updater.UPDATE_CACHE_FOLDER)) {
                    this.logMessage("Warning: there were some errors during cleanup.");
                } else {
                    this.logMessage("Cleanup complete.");
                }
                this.logMessage("Sc2gears has been successfully updated to version: " + latestVersion);
            }
            catch (Exception e) {
                this.logMessage("Update failed!");
                this.closeAndStartSc2gearsButton.setEnabled(true);
                this.closeAndStartSc2gearsButton.requestFocusInWindow();
                this.closeButton.setEnabled(true);
                this.abortButton.setEnabled(false);
                this.updateInProgress = false;
            }
        }
        finally {
            this.closeAndStartSc2gearsButton.setEnabled(true);
            this.closeAndStartSc2gearsButton.requestFocusInWindow();
            this.closeButton.setEnabled(true);
            this.abortButton.setEnabled(false);
            this.updateInProgress = false;
        }
    }

    private static boolean deleteFile(File file) {
        File[] list;
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        File[] fileArray = list = file.listFiles();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File childFile = fileArray[n2];
            if (!Updater.deleteFile(childFile)) {
                return false;
            }
            ++n2;
        }
        return file.delete();
    }

    /*
     * Loose catch block
     */
    private boolean copyFile(File sourceFile, File destinationFolder) {
        InputStream input;
        FileOutputStream output;
        block26: {
            int readBytes;
            File targetFile = new File(destinationFolder, sourceFile.getName()).getAbsoluteFile();
            if (sourceFile.isDirectory()) {
                if (!targetFile.equals(Consts.LIB_UPDATER_FOLDER) && !targetFile.mkdir()) {
                    return false;
                }
                File[] fileArray = sourceFile.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!this.copyFile(file, targetFile)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            output = null;
            input = null;
            output = new FileOutputStream(targetFile);
            input = new FileInputStream(sourceFile);
            while ((readBytes = input.read(this.buffer)) > 0) {
                ((OutputStream)output).write(this.buffer, 0, readBytes);
            }
            output.flush();
            input.close();
            ((OutputStream)output).close();
            if (input == null) break block26;
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
        catch (Exception e) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (output != null) {
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void logMessage(String message) {
        this.logTextArea.append(String.valueOf(TIME_FORMAT.format(new Date())) + message + "\n");
        this.logTextArea.setCaretPosition(this.logTextArea.getDocument().getLength());
    }
}

