/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.shared;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import javax.swing.JLabel;

public class CommonUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String OS_NAME = System.getProperty("os.name");

    private CommonUtils() {
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0;
    }

    public static void showURLInBrowser(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URL(url).toURI());
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String[] cmdArray = null;
            if (CommonUtils.isWindows()) {
                cmdArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", url};
            } else {
                String[] browsers;
                String[] stringArray = browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                int n = browsers.length;
                int n2 = 0;
                while (n2 < n) {
                    String browser = stringArray[n2];
                    if (Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0) {
                        cmdArray = new String[]{browser, url};
                        break;
                    }
                    ++n2;
                }
            }
            if (cmdArray != null) {
                Runtime.getRuntime().exec(cmdArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JLabel createLinkLabel(String text, final String targetUrl) {
        JLabel label = CommonUtils.createLinkStyledLabel(text);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CommonUtils.showURLInBrowser(targetUrl);
            }
        });
        return label;
    }

    public static JLabel createLinkStyledLabel(String text) {
        JLabel label = new JLabel("<html><a href='#'>" + text + "</a></html>");
        label.setCursor(Cursor.getPredefinedCursor(12));
        return label;
    }

    /*
     * Loose catch block
     */
    public static String calculateFileSha256(File file) {
        String string;
        FileInputStream input;
        block13: {
            int bytesRead;
            input = null;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            input = new FileInputStream(file);
            byte[] buffer = new byte[16384];
            while ((bytesRead = input.read(buffer)) > 0) {
                md.update(buffer, 0, bytesRead);
            }
            string = CommonUtils.convertToHexString(md.digest());
            if (input == null) break block13;
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
        catch (Exception e) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return "";
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static String convertToHexString(byte[] data) {
        StringBuilder hexBuilder = new StringBuilder(data.length << 1);
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hexBuilder.append(HEX_DIGITS[(b & 0xFF) >> 4]).append(HEX_DIGITS[b & 0xF]);
            ++n2;
        }
        return hexBuilder.toString();
    }
}

