/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalSearchField;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class GameLengthSearchField
extends IntervalSearchField {
    private static final DateFormat MIN_SEC_PARSER = new SimpleDateFormat("m:s");
    private static final DateFormat HOUR_MIN_SEC_PARSER = new SimpleDateFormat("H:m:s");

    public GameLengthSearchField() {
        super("module.repSearch.tab.filters.name.gameLength");
        this.minTextField.setToolTipText(Language.getText("module.repSearch.tab.filters.timeFormatToolTip"));
        this.maxTextField.setToolTipText(Language.getText("module.repSearch.tab.filters.timeFormatToolTip"));
    }

    @Override
    public boolean customValidateMin() {
        String minText = this.minTextField.getText();
        if (minText.length() == 0) {
            return true;
        }
        Integer min = this.parseSeconds(minText);
        return min != null && min >= 0;
    }

    @Override
    public boolean customValidateMax() {
        String maxText = this.maxTextField.getText();
        if (maxText.length() == 0) {
            return true;
        }
        Integer max = this.parseSeconds(maxText);
        return max != null && max >= 0;
    }

    @Override
    public ReplayFilter getFilter() {
        return this.minTextField.getText().length() == 0 && this.maxTextField.getText().length() == 0 ? null : new IntervalReplayFilter(this){
            private final Integer minSeconds;
            private final Integer maxSeconds;
            {
                this.minSeconds = this.minText.length() > 0 ? GameLengthSearchField.this.parseSeconds(this.minText) : null;
                this.maxSeconds = this.maxText.length() > 0 ? GameLengthSearchField.this.parseSeconds(this.maxText) : null;
            }

            @Override
            public boolean accept(File file, Replay replay) {
                if (this.minSeconds != null && replay.gameLengthSec < this.minSeconds) {
                    return false;
                }
                return this.maxSeconds == null || replay.gameLengthSec <= this.maxSeconds;
            }
        };
    }

    private Integer parseSeconds(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (Exception exception) {
            Date time = null;
            try {
                time = HOUR_MIN_SEC_PARSER.parse(text);
            }
            catch (Exception e) {
                try {
                    time = MIN_SEC_PARSER.parse(text);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (time == null) {
                return null;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(time);
            return calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
        }
    }
}

