/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.NormalThread;
import hu.belicza.andras.sc2gears.ui.ReplayOperationsPopupMenu;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchFieldGroup;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.BuildOrderSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.BuildingAbilitySearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.BuildingSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.ChatMessageSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.FileNameSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.FormatSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.GameLengthSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.GameTypeSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.GatewaySearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.MapNameSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.PlayerNameSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.RaceMatchupSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.ResearchSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.UnitAbilitySearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.UnitSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.UpgradeSearchField;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.VersionSearchField;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.PanelUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ReplaySearch
extends ModuleFrame {
    private static final String[] RESULT_HEADER_KEYS = new String[]{"module.repSearch.tab.results.header.version", "module.repSearch.tab.results.header.type", "module.repSearch.tab.results.header.gateway", "module.repSearch.tab.results.header.fileDate", "module.repSearch.tab.results.header.map", "module.repSearch.tab.results.header.raceMatchup", "module.repSearch.tab.results.header.length", "module.repSearch.tab.results.header.players", "module.repSearch.tab.results.header.file", "module.repSearch.tab.results.header.comment"};
    private static final int FILE_NAME_COLUMN_INDEX;
    private static final int COMMENT_COLUMN_INDEX;
    private static final String[] RESULT_HEADER_NAMES;
    private static final AtomicInteger counter;
    private volatile boolean temporarilyDisableFilters;
    private final JList sourceList = new JList(new DefaultListModel());
    private final JCheckBox autoSortSourcesCheckBox = GuiUtils.createCheckBox("module.repSearch.tab.source.autoSort", "module.repSearch.source.autoSort");
    private final JButton performSearchButton = new JButton(Icons.BINOCULAR_ARROW);
    private SearchFieldGroup[] searchFieldGroups;
    private File initialReplayList;

    static {
        RESULT_HEADER_NAMES = new String[RESULT_HEADER_KEYS.length];
        int FILE_NAME_COLUMN_INDEX_ = 0;
        int COMMENT_COLUMN_INDEX_ = 0;
        int i = 0;
        while (i < RESULT_HEADER_KEYS.length) {
            ReplaySearch.RESULT_HEADER_NAMES[i] = Language.getText(RESULT_HEADER_KEYS[i]);
            if ("module.repSearch.tab.results.header.file".equals(RESULT_HEADER_KEYS[i])) {
                FILE_NAME_COLUMN_INDEX_ = i;
            } else if ("module.repSearch.tab.results.header.comment".equals(RESULT_HEADER_KEYS[i])) {
                COMMENT_COLUMN_INDEX_ = i;
            }
            ++i;
        }
        FILE_NAME_COLUMN_INDEX = FILE_NAME_COLUMN_INDEX_;
        COMMENT_COLUMN_INDEX = COMMENT_COLUMN_INDEX_;
        counter = new AtomicInteger();
    }

    public ReplaySearch(Object ... arguments) {
        super(Language.getText("module.repSearch.title", counter.incrementAndGet()));
        this.setFrameIcon(Icons.BINOCULAR);
        this.buildGui();
        if (arguments != null) {
            if (arguments.length > 0 && arguments[0] != null) {
                this.loadReplaySourceFile((File)arguments[0]);
            }
            if (arguments.length > 1 && arguments[1] != null) {
                this.initialReplayList = (File)arguments[1];
            }
            if (arguments.length > 0 && arguments[0] != null || arguments.length > 1 && arguments[1] != null) {
                this.temporarilyDisableFilters = true;
                this.performSearchButton.doClick();
            }
        }
    }

    private void buildGui() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.sourceList.setCellRenderer(new ListCellRenderer(){
            private final JLabel label = new JLabel();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                File file = (File)value;
                this.label.setText(file.getAbsolutePath());
                this.label.setIcon(file.isDirectory() ? Icons.FOLDER : Icons.SC2);
                if (isSelected) {
                    this.label.setBackground(list.getSelectionBackground());
                    this.label.setForeground(list.getSelectionForeground());
                } else {
                    this.label.setBackground(list.getBackground());
                    this.label.setForeground(list.getForeground());
                }
                this.label.setFont(list.getFont());
                this.label.setOpaque(true);
                return this.label;
            }
        });
        GuiUtils.addNewTab(Language.getText("module.repSearch.tab.source.title"), Icons.FOLDERS_STACK, false, tabbedPane, this.createSourceTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repSearch.tab.filters.title"), Icons.EDIT_COLUMN, false, tabbedPane, this.createFiltersTab(tabbedPane), null);
        this.getContentPane().add(tabbedPane);
    }

    private JComponent createSourceTab() {
        JPanel sourcePanel = new JPanel(new BorderLayout());
        Box buttonsBox = Box.createVerticalBox();
        Box buttonsRow = Box.createHorizontalBox();
        JButton loadReplaySourceButton = new JButton(Icons.FOLDER_OPEN);
        GuiUtils.updateButtonText(loadReplaySourceButton, "module.repSearch.tab.source.loadReplaySourceButton", new Object[0]);
        loadReplaySourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser("User Content/Replay sources");
                fileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectLoadReplaySource"));
                fileChooser.setFileFilter(GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER);
                fileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (fileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    ReplaySearch.this.loadReplaySourceFile(fileChooser.getSelectedFile());
                }
            }
        });
        buttonsRow.add(loadReplaySourceButton);
        JButton saveReplaySourceButton = new JButton(Icons.DISK);
        GuiUtils.updateButtonText(saveReplaySourceButton, "module.repSearch.tab.source.saveReplaySourceButton", new Object[0]);
        saveReplaySourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser("User Content/Replay sources");
                fileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectSaveReplaySource"));
                fileChooser.setFileFilter(GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER);
                fileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (fileChooser.showSaveDialog(MainFrame.INSTANCE) == 0) {
                    File sourceFile = fileChooser.getSelectedFile();
                    if (!GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER.accept(sourceFile)) {
                        sourceFile = new File(String.valueOf(sourceFile.getAbsolutePath()) + ".sc2repsrc");
                    }
                    ReplaySearch.this.saveReplaySourceFile(sourceFile);
                }
            }
        });
        buttonsRow.add(saveReplaySourceButton);
        buttonsBox.add(buttonsRow);
        buttonsRow = Box.createHorizontalBox();
        JButton addFoldersButton = new JButton(Icons.FOLDERS);
        GuiUtils.updateButtonText(addFoldersButton, "module.repSearch.tab.source.addFoldersButton", new Object[0]);
        addFoldersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(Settings.getString("settings.folders.defaultReplay"));
                fileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectFoldersToAdd"));
                fileChooser.setFileSelectionMode(1);
                fileChooser.setMultiSelectionEnabled(true);
                if (fileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    File[] fileArray = fileChooser.getSelectedFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        ((DefaultListModel)ReplaySearch.this.sourceList.getModel()).addElement(file);
                        ++n2;
                    }
                    if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                        ReplaySearch.this.sortSources();
                    }
                }
            }
        });
        buttonsRow.add(addFoldersButton);
        JButton addFilesButton = new JButton(Icons.SC2);
        GuiUtils.updateButtonText(addFilesButton, "module.repSearch.tab.source.addFilesButton", new Object[0]);
        addFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(Settings.getString("settings.folders.defaultReplay"));
                fileChooser.setDialogTitle(Language.getText("module.repSearch.tab.source.selectReplaysToAdd"));
                fileChooser.setMultiSelectionEnabled(true);
                fileChooser.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
                fileChooser.setAccessory(GuiUtils.createReplayFilePreviewAccessory(fileChooser));
                fileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (fileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                    File[] fileArray = fileChooser.getSelectedFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        ((DefaultListModel)ReplaySearch.this.sourceList.getModel()).addElement(file);
                        ++n2;
                    }
                    if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                        ReplaySearch.this.sortSources();
                    }
                }
            }
        });
        buttonsRow.add(addFilesButton);
        buttonsBox.add(buttonsRow);
        buttonsRow = Box.createHorizontalBox();
        JButton listAllReplaysButton = new JButton(Icons.BINOCULAR_ARROW);
        GuiUtils.updateButtonText(listAllReplaysButton, "module.repSearch.tab.source.listAllReplays", new Object[0]);
        listAllReplaysButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ReplaySearch.this.temporarilyDisableFilters = true;
                ReplaySearch.this.performSearchButton.doClick();
            }
        });
        buttonsRow.add(listAllReplaysButton);
        buttonsBox.add(buttonsRow);
        sourcePanel.add((Component)buttonsBox, "North");
        sourcePanel.add((Component)new JScrollPane(this.sourceList), "Center");
        this.sourceList.setOpaque(false);
        JPanel operationsPanel = new JPanel(new GridLayout(5, 1));
        final JButton sortButton = new JButton(Icons.SORT_ALPHABET);
        ActionListener autoSortActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                sortButton.setEnabled(!ReplaySearch.this.autoSortSourcesCheckBox.isSelected());
                if (ReplaySearch.this.autoSortSourcesCheckBox.isSelected()) {
                    ReplaySearch.this.sortSources();
                }
            }
        };
        autoSortActionListener.actionPerformed(null);
        this.autoSortSourcesCheckBox.addActionListener(autoSortActionListener);
        operationsPanel.add(this.autoSortSourcesCheckBox);
        GuiUtils.updateButtonText(sortButton, "module.repSearch.tab.source.sortButton", new Object[0]);
        sortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ReplaySearch.this.sortSources();
            }
        });
        operationsPanel.add(sortButton);
        JButton removeSelectedButton = new JButton(Icons.TABLE_DELETE_ROW);
        GuiUtils.updateButtonText(removeSelectedButton, "module.repSearch.tab.source.removeSelectedButton", new Object[0]);
        removeSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultListModel model = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                int[] selectedIndices = ReplaySearch.this.sourceList.getSelectedIndices();
                int i = selectedIndices.length - 1;
                while (i >= 0) {
                    model.remove(selectedIndices[i]);
                    --i;
                }
            }
        });
        operationsPanel.add(removeSelectedButton);
        JButton purgeButton = new JButton(Icons.BROOM);
        GuiUtils.updateButtonText(purgeButton, "module.repSearch.tab.source.purgeButton", new Object[0]);
        purgeButton.setToolTipText(Language.getText("module.repSearch.tab.source.purgeButtonToopTip"));
        purgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultListModel model = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                int i = model.getSize() - 1;
                while (i >= 0) {
                    File file = (File)model.get(i);
                    if (file.exists()) {
                        int j = model.getSize() - 1;
                        while (j >= 0) {
                            if (j != i && GeneralUtils.isDescendant((File)model.get(j), file)) {
                                model.remove(i);
                                break;
                            }
                            --j;
                        }
                    } else {
                        model.remove(i);
                    }
                    --i;
                }
            }
        });
        operationsPanel.add(purgeButton);
        sourcePanel.add((Component)GuiUtils.wrapInPanel(operationsPanel), "East");
        return sourcePanel;
    }

    private void loadReplaySourceFile(File replaySource) {
        block13: {
            BufferedReader input = null;
            try {
                try {
                    input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(replaySource), "UTF-8"));
                    DefaultListModel model = (DefaultListModel)this.sourceList.getModel();
                    model.removeAllElements();
                    while (input.ready()) {
                        model.addElement(new File(input.readLine()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.source.failedToLoadRepSource"));
                    if (input == null) break block13;
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void saveReplaySourceFile(File replaySource) {
        PrintWriter output = null;
        try {
            try {
                output = new PrintWriter(replaySource, "UTF-8");
                ListModel model = this.sourceList.getModel();
                int size = model.getSize();
                int i = 0;
                while (i < size) {
                    output.println(model.getElementAt(i));
                    ++i;
                }
                output.flush();
                MainFrame.INSTANCE.refreshNavigationTree();
                GuiUtils.showInfoDialog(Language.getText("module.repSearch.tab.source.repSourceSaved"));
            }
            catch (Exception e) {
                e.printStackTrace();
                GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.source.failedToSaveRepSource"));
                if (output != null) {
                    output.close();
                }
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private List<Object[]> loadReplayListFile(File replayList) {
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(replayList), "UTF-8"));
            input.readLine();
            String[] headerKeys = input.readLine().split(";");
            int[] modelFromFileIndices = new int[RESULT_HEADER_KEYS.length];
            int i = 0;
            while (i < modelFromFileIndices.length) {
                int index = -1;
                int j = 0;
                while (j < headerKeys.length) {
                    if (RESULT_HEADER_KEYS[i].equals(headerKeys[j])) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                modelFromFileIndices[i] = index;
                ++i;
            }
            ArrayList<Object[]> dataList = new ArrayList<Object[]>();
            while ((line = input.readLine()) != null) {
                Object[] replayData = new Object[RESULT_HEADER_KEYS.length];
                String[] fileData = GeneralUtils.splitBySemicolon(line);
                int i2 = RESULT_HEADER_KEYS.length - 1;
                while (i2 >= 0) {
                    replayData[i2] = modelFromFileIndices[i2] < 0 ? "" : fileData[modelFromFileIndices[i2]];
                    --i2;
                }
                dataList.add(replayData);
            }
            ArrayList<Object[]> arrayList = dataList;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.results.failedToLoadRepList"));
            return null;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void saveReplayListFile(File replayList, List<Object[]> dataList) {
        PrintWriter output = null;
        try {
            try {
                output = new PrintWriter(replayList, "UTF-8");
                String[] stringArray = RESULT_HEADER_NAMES;
                int n = RESULT_HEADER_NAMES.length;
                int n2 = 0;
                while (n2 < n) {
                    String headerName = stringArray[n2];
                    output.print(headerName.replace(';', '_'));
                    output.print(';');
                    ++n2;
                }
                output.println();
                stringArray = RESULT_HEADER_KEYS;
                n = RESULT_HEADER_KEYS.length;
                n2 = 0;
                while (n2 < n) {
                    String headerKey = stringArray[n2];
                    output.print(headerKey);
                    output.print(';');
                    ++n2;
                }
                output.println();
                Iterator<Object[]> iterator = dataList.iterator();
                while (iterator.hasNext()) {
                    Object[] replayData;
                    Object[] objectArray = replayData = iterator.next();
                    int n3 = replayData.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object data = objectArray[n4];
                        output.print(((String)data).replace(';', '_'));
                        output.print(';');
                        ++n4;
                    }
                    output.println();
                }
                output.flush();
                MainFrame.INSTANCE.refreshNavigationTree();
                GuiUtils.showInfoDialog(Language.getText("module.repSearch.tab.results.repListSaved"));
            }
            catch (Exception e) {
                e.printStackTrace();
                GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.results.failedToSaveRepList"));
                if (output != null) {
                    output.close();
                }
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private void sortSources() {
        ListModel model = this.sourceList.getModel();
        File[] sources = new File[model.getSize()];
        int i = sources.length - 1;
        while (i >= 0) {
            sources[i] = (File)model.getElementAt(i);
            --i;
        }
        Arrays.sort(sources, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                if (f1.isDirectory() && !f2.isDirectory()) {
                    return -1;
                }
                if (!f1.isDirectory() && f2.isDirectory()) {
                    return 1;
                }
                return f1.compareTo(f2);
            }
        });
        DefaultListModel<File> newModel = new DefaultListModel<File>();
        File[] fileArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            newModel.addElement(file);
            ++n2;
        }
        this.sourceList.setModel(newModel);
    }

    private JComponent createFiltersTab(final JTabbedPane tabbedPane) {
        JPanel filtersPanel = new JPanel(new BorderLayout());
        JPanel fieldsPanel = new JPanel(new BorderLayout()){

            @Override
            public void setUI(PanelUI ui) {
                super.setUI(ui);
                if (ReplaySearch.this.searchFieldGroups != null) {
                    ReplaySearch.this.packSearchFields();
                }
            }
        };
        JScrollPane fieldsScrollPane = new JScrollPane(fieldsPanel);
        this.searchFieldGroups = new SearchFieldGroup[]{new SearchFieldGroup(fieldsScrollPane, FileNameSearchField.class), new SearchFieldGroup(fieldsScrollPane, MapNameSearchField.class), new SearchFieldGroup(fieldsScrollPane, PlayerNameSearchField.class), new SearchFieldGroup(fieldsScrollPane, ChatMessageSearchField.class), new SearchFieldGroup(fieldsScrollPane, RaceMatchupSearchField.class), new SearchFieldGroup(fieldsScrollPane, FormatSearchField.class), new SearchFieldGroup(fieldsScrollPane, GameTypeSearchField.class), new SearchFieldGroup(fieldsScrollPane, GatewaySearchField.class), new SearchFieldGroup(fieldsScrollPane, GameLengthSearchField.class), new SearchFieldGroup(fieldsScrollPane, VersionSearchField.class), new SearchFieldGroup(fieldsScrollPane, BuildOrderSearchField.class), new SearchFieldGroup(fieldsScrollPane, BuildingSearchField.class), new SearchFieldGroup(fieldsScrollPane, UnitSearchField.class), new SearchFieldGroup(fieldsScrollPane, ResearchSearchField.class), new SearchFieldGroup(fieldsScrollPane, UpgradeSearchField.class), new SearchFieldGroup(fieldsScrollPane, UnitAbilitySearchField.class), new SearchFieldGroup(fieldsScrollPane, BuildingAbilitySearchField.class)};
        Box buttonsBox = Box.createHorizontalBox();
        GuiUtils.updateButtonText(this.performSearchButton, "module.repSearch.tab.filters.performSearchButton", new Object[0]);
        this.performSearchButton.addActionListener(new ActionListener(){
            private int resultsTabCounter = 1;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ReplaySearch.this.temporarilyDisableFilters) {
                    ReplaySearch.this.temporarilyDisableFilters = false;
                } else {
                    boolean validAll = true;
                    SearchFieldGroup[] searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                    int n = searchFieldGroupArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
                        validAll &= searchFieldGroup.validateAll();
                        ++n2;
                    }
                    if (!validAll) {
                        GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.filters.invalidFieldsError"));
                        return;
                    }
                }
                Object[] resultsTabObjects = ReplaySearch.this.createResultsTab(ReplaySearch.this.searchFieldGroups);
                GuiUtils.addNewTab(Language.getText("module.repSearch.tab.results.title", this.resultsTabCounter++), Icons.TABLE, true, tabbedPane, (JComponent)resultsTabObjects[0], (Runnable)resultsTabObjects[1]);
                tabbedPane.setSelectedIndex(tabbedPane.getTabCount() - 1);
            }
        });
        buttonsBox.add(this.performSearchButton);
        JButton resetFieldsButton = new JButton(Icons.CROSS_WHITE);
        GuiUtils.updateButtonText(resetFieldsButton, "module.repSearch.tab.filters.resetFieldsButton", new Object[0]);
        resetFieldsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchFieldGroup[] searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                int n = searchFieldGroupArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
                    for (SearchField searchField : searchFieldGroup.searchFieldList) {
                        searchField.reset();
                    }
                    ++n2;
                }
            }
        });
        buttonsBox.add(resetFieldsButton);
        filtersPanel.add((Component)GuiUtils.wrapInPanel(buttonsBox), "North");
        Box fieldsBox = Box.createVerticalBox();
        SearchFieldGroup[] searchFieldGroupArray = this.searchFieldGroups;
        int n = this.searchFieldGroups.length;
        int n2 = 0;
        while (n2 < n) {
            SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
            fieldsBox.add(searchFieldGroup.uiComponent);
            ++n2;
        }
        this.packSearchFields();
        fieldsPanel.add((Component)fieldsBox, "North");
        filtersPanel.add((Component)fieldsScrollPane, "Center");
        return filtersPanel;
    }

    private void packSearchFields() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchFieldGroup searchFieldGroup;
                int maxWidth = 0;
                SearchFieldGroup[] searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                int n = searchFieldGroupArray.length;
                int n2 = 0;
                while (n2 < n) {
                    searchFieldGroup = searchFieldGroupArray[n2];
                    for (SearchField searchField : searchFieldGroup.searchFieldList) {
                        searchField.displayLabel.setPreferredSize(null);
                        maxWidth = Math.max(maxWidth, searchField.displayLabel.getPreferredSize().width);
                    }
                    ++n2;
                }
                searchFieldGroupArray = ReplaySearch.this.searchFieldGroups;
                n = searchFieldGroupArray.length;
                n2 = 0;
                while (n2 < n) {
                    searchFieldGroup = searchFieldGroupArray[n2];
                    for (SearchField searchField : searchFieldGroup.searchFieldList) {
                        searchField.displayLabel.setPreferredSize(new Dimension(maxWidth, searchField.displayLabel.getPreferredSize().height));
                        searchField.displayLabel.invalidate();
                    }
                    searchFieldGroup.parentToNotify.validate();
                    ++n2;
                }
            }
        });
    }

    private Object[] createResultsTab(SearchFieldGroup[] searchFieldGroups) {
        ListModel model = this.sourceList.getModel();
        final File[] sources = new File[model.getSize()];
        int i = sources.length - 1;
        while (i >= 0) {
            sources[i] = (File)model.getElementAt(i);
            --i;
        }
        final EnumSet<ReplayParser.ReplayContent> requiredReplayContentSetForSearch = EnumSet.copyOf(ReplayParser.GENERAL_INFO_CONTENT);
        final ArrayList<ReplayFilter[]> replayFiltersList = new ArrayList<ReplayFilter[]>();
        SearchFieldGroup[] searchFieldGroupArray = searchFieldGroups;
        int n = searchFieldGroups.length;
        int n2 = 0;
        while (n2 < n) {
            SearchFieldGroup searchFieldGroup = searchFieldGroupArray[n2];
            ReplayFilter[] replayFilters = searchFieldGroup.getReplayFilters();
            if (replayFilters != null) {
                replayFiltersList.add(replayFilters);
                Set<ReplayParser.ReplayContent> requiredReplayContentSet = replayFilters[0].getRequiredReplayContentSet();
                if (requiredReplayContentSet != null) {
                    requiredReplayContentSetForSearch.addAll(requiredReplayContentSet);
                }
            }
            ++n2;
        }
        JPanel resultsPanel = new JPanel(new BorderLayout());
        Box northBox = Box.createVerticalBox();
        final JTable resultsTable = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return this.getColumnModel().getColumn(column).getModelIndex() == COMMENT_COLUMN_INDEX;
            }
        };
        final Box buttonsBox = Box.createHorizontalBox();
        final JButton abortButton = new JButton(Icons.CROSS_OCTAGON);
        GuiUtils.updateButtonText(abortButton, "module.repSearch.tab.results.abortButton", new Object[0]);
        buttonsBox.add(abortButton);
        final JButton saveReplayListButton = new JButton(Icons.DISK);
        GuiUtils.updateButtonText(saveReplayListButton, "module.repSearch.tab.results.saveButton", new Object[0]);
        saveReplayListButton.setEnabled(false);
        buttonsBox.add(saveReplayListButton);
        final JButton loadReplayListButton = new JButton(Icons.FOLDER_OPEN);
        GuiUtils.updateButtonText(loadReplayListButton, "module.repSearch.tab.results.loadButton", new Object[0]);
        loadReplayListButton.setEnabled(false);
        buttonsBox.add(loadReplayListButton);
        final JButton setAsSourceButton = new JButton(Icons.TABLE_EXPORT);
        GuiUtils.updateButtonText(setAsSourceButton, "module.repSearch.tab.results.setAsSourceButton", new Object[0]);
        setAsSourceButton.setToolTipText(Language.getText("module.repSearch.tab.results.setAsSourceToolTip"));
        setAsSourceButton.setEnabled(false);
        buttonsBox.add(setAsSourceButton);
        final JCheckBox stretchToWindowCheckBox = GuiUtils.createCheckBox("module.repSearch.tab.results.stretchToWindow", "module.repSearch.results.stretchToWindow");
        ActionListener stretchToWindowActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                resultsTable.setAutoResizeMode(stretchToWindowCheckBox.isSelected() ? 4 : 0);
            }
        };
        stretchToWindowActionListener.actionPerformed(null);
        stretchToWindowCheckBox.addActionListener(stretchToWindowActionListener);
        buttonsBox.add(stretchToWindowCheckBox);
        northBox.add(buttonsBox);
        final JProgressBar progressBar = new JProgressBar();
        northBox.add(progressBar);
        resultsPanel.add((Component)northBox, "North");
        Box tableBox = Box.createVerticalBox();
        ((DefaultTableModel)resultsTable.getModel()).setColumnIdentifiers(RESULT_HEADER_NAMES);
        resultsTable.setAutoCreateRowSorter(true);
        tableBox.add(resultsTable.getTableHeader());
        tableBox.add(new JScrollPane(resultsTable));
        resultsPanel.add((Component)tableBox, "Center");
        final NormalThread searchThread = new NormalThread("Replay search"){
            private volatile boolean aborted;
            private final List<Object[]> resultList;
            private int replaysCount;
            private int searchedCount;
            private int skippedCount;
            {
                super($anonymous0);
                this.resultList = new ArrayList<Object[]>();
            }

            @Override
            public void run() {
                abortButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        buttonsBox.remove(abortButton);
                        buttonsBox.getParent().validate();
                        aborted = true;
                    }
                });
                resultsTable.getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent event) {
                        if (event.getColumn() >= 0 && resultsTable.getColumnModel().getColumn(event.getColumn()).getModelIndex() == COMMENT_COLUMN_INDEX) {
                            RowSorter<? extends TableModel> rowSorter = resultsTable.getRowSorter();
                            int row = rowSorter.convertRowIndexToModel(event.getFirstRow());
                            ((Object[])(this).resultList.get((int)row))[COMMENT_COLUMN_INDEX] = resultsTable.getValueAt(event.getFirstRow(), event.getColumn());
                        }
                    }
                });
                saveReplayListButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        JFileChooser fileChooser = new JFileChooser("User Content/Replay lists");
                        fileChooser.setDialogTitle(Language.getText("module.repSearch.tab.results.selectSaveReplayList"));
                        fileChooser.setFileFilter(GuiUtils.SC2_REPLAY_LIST_FILE_FILTER);
                        fileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                        if (fileChooser.showSaveDialog(MainFrame.INSTANCE) == 0) {
                            File listFile = fileChooser.getSelectedFile();
                            if (!GuiUtils.SC2_REPLAY_LIST_FILE_FILTER.accept(listFile)) {
                                listFile = new File(String.valueOf(listFile.getAbsolutePath()) + ".csv");
                            }
                            ReplaySearch.this.saveReplayListFile(listFile, resultList);
                        }
                    }
                });
                ActionListener loadReplayListActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        File listFile = null;
                        if (event == null) {
                            listFile = ReplaySearch.this.initialReplayList;
                            ReplaySearch.this.initialReplayList = null;
                        } else {
                            JFileChooser fileChooser = new JFileChooser("User Content/Replay lists");
                            fileChooser.setDialogTitle(Language.getText("module.repSearch.tab.results.selectLoadReplayList"));
                            fileChooser.setFileFilter(GuiUtils.SC2_REPLAY_LIST_FILE_FILTER);
                            fileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                            if (fileChooser.showOpenDialog(MainFrame.INSTANCE) == 0) {
                                listFile = fileChooser.getSelectedFile();
                            }
                        }
                        if (listFile != null) {
                            buttonsBox.remove(abortButton);
                            buttonsBox.getParent().validate();
                            progressBar.setString(Language.getText("module.repSearch.tab.results.loadingReplayList", listFile.getName()));
                            List loadedResultList = ReplaySearch.this.loadReplayListFile(listFile);
                            if (loadedResultList != null) {
                                resultList.clear();
                                resultList.addAll(loadedResultList);
                                this.refreshTableFromResultList();
                            }
                            progressBar.setMaximum(resultList.size());
                            progressBar.setValue(resultList.size());
                            progressBar.setString(Language.getText("module.repSearch.tab.results.loadResult", resultList.size()));
                            saveReplayListButton.setEnabled(true);
                            loadReplayListButton.setEnabled(true);
                            setAsSourceButton.setEnabled(true);
                        }
                    }
                };
                loadReplayListButton.addActionListener(loadReplayListActionListener);
                setAsSourceButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        DefaultListModel model = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                        model.removeAllElements();
                        for (Object[] result : resultList) {
                            model.addElement(new File((String)result[FILE_NAME_COLUMN_INDEX]));
                        }
                    }
                });
                progressBar.setStringPainted(true);
                if (ReplaySearch.this.initialReplayList != null) {
                    loadReplayListActionListener.actionPerformed(null);
                } else {
                    File source;
                    progressBar.setString(Language.getText("module.repSearch.tab.results.countingReplays"));
                    File[] fileArray = sources;
                    int n = sources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        source = fileArray[n2];
                        if (this.aborted) break;
                        this.replaysCount += this.countReplays(source);
                        ++n2;
                    }
                    if (this.aborted) {
                        progressBar.setString(String.valueOf(Language.getText("module.repSearch.tab.results.searchAborted")) + " [" + progressBar.getString() + "]");
                        loadReplayListButton.setEnabled(true);
                    } else {
                        progressBar.setMaximum(this.replaysCount);
                        this.updateProgressBar();
                        fileArray = sources;
                        n = sources.length;
                        n2 = 0;
                        while (n2 < n) {
                            source = fileArray[n2];
                            if (this.aborted) break;
                            this.searchReplays(source);
                            ++n2;
                        }
                        if (this.aborted) {
                            progressBar.setString(String.valueOf(Language.getText("module.repSearch.tab.results.searchAborted")) + " [" + progressBar.getString() + "]");
                        } else {
                            buttonsBox.remove(abortButton);
                            buttonsBox.getParent().validate();
                        }
                        saveReplayListButton.setEnabled(true);
                        loadReplayListButton.setEnabled(true);
                        setAsSourceButton.setEnabled(true);
                        this.refreshTableFromResultList();
                    }
                }
                resultsTable.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        if (event.getButton() == 3) {
                            int[] selectedRows;
                            if (resultsTable.getSelectedRow() < 0) {
                                int row = resultsTable.rowAtPoint(event.getPoint());
                                resultsTable.getSelectionModel().setSelectionInterval(row, row);
                            }
                            if ((selectedRows = resultsTable.getSelectedRows()).length > 0) {
                                final File[] files = new File[selectedRows.length];
                                int i = selectedRows.length - 1;
                                while (i >= 0) {
                                    RowSorter<? extends TableModel> rowSorter = resultsTable.getRowSorter();
                                    selectedRows[i] = rowSorter.convertRowIndexToModel(selectedRows[i]);
                                    files[i] = new File((String)((Object[])resultList.get(selectedRows[i]))[FILE_NAME_COLUMN_INDEX]);
                                    --i;
                                }
                                ReplayOperationsPopupMenu repOpPopup = new ReplayOperationsPopupMenu(files, new ReplayOperationsPopupMenu.ReplayOpCallback(){
                                    final List<Object[]> removedList = new ArrayList<Object[]>();

                                    @Override
                                    public void replayRenamed(File file, File newFile, int fileIndex) {
                                        ((Object[])((this).this).resultList.get((int)selectedRows[fileIndex]))[FILE_NAME_COLUMN_INDEX] = newFile.getAbsolutePath();
                                    }

                                    @Override
                                    public void replayMoved(File file, File targetFolder, int fileIndex) {
                                        ((Object[])((this).this).resultList.get((int)selectedRows[fileIndex]))[FILE_NAME_COLUMN_INDEX] = new File(targetFolder, file.getName()).getAbsolutePath();
                                    }

                                    @Override
                                    public void replayDeleted(File file, int fileIndex) {
                                        this.removedList.add((Object[])resultList.get(selectedRows[fileIndex]));
                                    }

                                    @Override
                                    public void moveRenameDeleteEnded() {
                                        if (!this.removedList.isEmpty()) {
                                            resultList.removeAll(this.removedList);
                                        }
                                        this.refreshTableFromResultList();
                                    }
                                });
                                repOpPopup.addSeparator();
                                JMenuItem removeSelectedFromTableMenuItem = new JMenuItem(Icons.TABLE_DELETE_ROW);
                                removeSelectedFromTableMenuItem.setText(Language.getText("module.repSearch.tab.results.removeSelectedMenuItem"));
                                removeSelectedFromTableMenuItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent event) {
                                        Arrays.sort(selectedRows);
                                        int i = selectedRows.length - 1;
                                        while (i >= 0) {
                                            resultList.remove(selectedRows[i]);
                                            --i;
                                        }
                                        this.refreshTableFromResultList();
                                    }
                                });
                                repOpPopup.add(removeSelectedFromTableMenuItem);
                                JMenuItem setSelectedAsSourceMenuItem = new JMenuItem(Icons.TABLE_EXPORT);
                                setSelectedAsSourceMenuItem.setText(Language.getText("module.repSearch.tab.results.setSelectedAsSourceMenuItem"));
                                setSelectedAsSourceMenuItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent event) {
                                        DefaultListModel model = (DefaultListModel)ReplaySearch.this.sourceList.getModel();
                                        model.removeAllElements();
                                        File[] fileArray = files;
                                        int n = files.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            File file = fileArray[n2];
                                            model.addElement(file);
                                            ++n2;
                                        }
                                    }
                                });
                                repOpPopup.add(setSelectedAsSourceMenuItem);
                                repOpPopup.show(event.getComponent(), event.getX(), event.getY());
                            }
                        }
                        if (event.getButton() == 1 && resultsTable.getSelectedRow() >= 0 && event.getClickCount() == 2) {
                            MainFrame.INSTANCE.createNewInternalFrame(MainFrame.INSTANCE.newRepAnalNode, new File((String)((Object[])resultList.get(resultsTable.getRowSorter().convertRowIndexToModel(resultsTable.rowAtPoint(event.getPoint()))))[FILE_NAME_COLUMN_INDEX]));
                        }
                    }
                });
            }

            private int countReplays(File file) {
                if (file.isFile()) {
                    return GuiUtils.SC2_REPLAY_FILTER.accept(file) ? 1 : 0;
                }
                File[] children = file.listFiles();
                int replaysCount = 0;
                if (children != null) {
                    File[] fileArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        if (this.aborted) {
                            return 0;
                        }
                        replaysCount += this.countReplays(child);
                        ++n2;
                    }
                }
                return replaysCount;
            }

            private void searchReplays(File file) {
                if (file.isFile()) {
                    if (GuiUtils.SC2_REPLAY_FILTER.accept(file)) {
                        ++this.searchedCount;
                        Replay replay = ReplayParser.parseReplay(file.getAbsolutePath(), requiredReplayContentSetForSearch);
                        if (replay != null) {
                            boolean accepted = true;
                            for (ReplayFilter[] replayFilters : replayFiltersList) {
                                boolean acceptedByGroup = false;
                                ReplayFilter[] replayFilterArray = replayFilters;
                                int n = replayFilters.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ReplayFilter replayFilter = replayFilterArray[n2];
                                    if (replayFilter.accept(file, replay)) {
                                        acceptedByGroup = true;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (acceptedByGroup) continue;
                                accepted = false;
                                break;
                            }
                            if (accepted) {
                                this.resultList.add(new Object[]{replay.version, replay.initData.gameType.toString(), replay.initData.gateway == null ? "" : replay.initData.gateway.toString(), Language.formatDateTime(new Date(file.lastModified())), replay.details.mapName, replay.details.getRaceMatchup(), ReplayUtils.formatMs(replay.gameLength * 500), replay.details.getPlayerNames(), file.getAbsolutePath(), ""});
                            }
                        } else {
                            ++this.skippedCount;
                        }
                        this.updateProgressBar();
                    }
                } else {
                    File[] children = file.listFiles();
                    if (children != null) {
                        File[] fileArray = children;
                        int n = children.length;
                        int n3 = 0;
                        while (n3 < n) {
                            File child = fileArray[n3];
                            if (this.aborted) {
                                return;
                            }
                            this.searchReplays(child);
                            ++n3;
                        }
                    }
                }
            }

            private void updateProgressBar() {
                progressBar.setValue(this.searchedCount);
                progressBar.setString(Language.getText("module.repSearch.tab.results.searchStatus", this.resultList.size(), this.searchedCount, this.skippedCount, this.replaysCount, this.replaysCount == 0 ? 100 : 100 * this.searchedCount / this.replaysCount));
            }

            private void refreshTableFromResultList() {
                DefaultTableModel model = (DefaultTableModel)resultsTable.getModel();
                model.setDataVector((Object[][])this.resultList.toArray((T[])new Object[this.resultList.size()][]), RESULT_HEADER_NAMES);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GuiUtils.packTable(resultsTable);
                    }
                });
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                searchThread.start();
            }
        });
        return new Object[]{resultsPanel, new Runnable(){

            @Override
            public void run() {
                abortButton.doClick();
            }
        }};
    }
}

