/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayConsts;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Details;
import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import hu.belicza.andras.sc2gears.replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.Downloader;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.ReplayOperationsPopupMenu;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartPainter;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.PaintChartParams;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ReplayAnalyzer
extends ModuleFrame {
    private static final int MAX_MAP_PREVIEW_ZOOM = 6;
    private static final Dictionary<Integer, JComponent> LABEL_DICTIONARY = new Hashtable<Integer, JComponent>();
    private File replayFile;
    private final Replay replay;
    private final JList actionsList = new JList();
    private final Map<ReplayConsts.ActionType, JCheckBox> displayActionTypeCheckboxMap = new EnumMap<ReplayConsts.ActionType, JCheckBox>(ReplayConsts.ActionType.class);

    static {
        int i = 0;
        while (i <= 6) {
            LABEL_DICTIONARY.put(i, new JLabel(i == 0 ? "1/2x" : String.valueOf(i) + "x"));
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public ReplayAnalyzer(Object ... arguments) {
        super(Language.getText("module.replayAnalyzer.opening"));
        if (arguments == null || arguments.length < 1) {
            JFileChooser fileChooser = new JFileChooser(Settings.getString("settings.folders.defaultReplay"));
            fileChooser.setDialogTitle(Language.getText("module.repAnalyzer.openTitle"));
            fileChooser.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
            fileChooser.setAccessory(GuiUtils.createReplayFilePreviewAccessory(fileChooser));
            fileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
            if (fileChooser.showOpenDialog(MainFrame.INSTANCE) != 0) {
                this.dispose();
                this.replayFile = null;
                this.replay = null;
                return;
            }
            this.replayFile = fileChooser.getSelectedFile();
        } else {
            this.replayFile = (File)arguments[0];
        }
        this.replay = ReplayParser.parseReplay(this.replayFile.getAbsolutePath(), ReplayParser.ALL_CONTENT);
        if (this.replay == null) {
            GuiUtils.showErrorDialog(Language.getText("module.repAnalyzer.openError"));
            this.dispose();
            return;
        }
        this.setTitle(GeneralUtils.getFileNameWithoutExt(this.replayFile));
        this.setFrameIcon(Icons.SC2);
        this.buildGui();
    }

    private void buildGui() {
        JTabbedPane tabbedPane = new JTabbedPane();
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.charts.title"), Icons.CHART, false, tabbedPane, this.createChartsTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.gameInfo.title"), Icons.INFORMATION_BALLOON, false, tabbedPane, this.createGameInfoTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.inGameChat.title"), Icons.BALLOONS, false, tabbedPane, this.createInGameChatTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.mapPreview.title"), Icons.MAP, false, tabbedPane, this.createMapPreviewTab(), null);
        this.getContentPane().add(tabbedPane);
    }

    private JComponent createChartsTab() {
        final JPanel chartsPanel = new JPanel(new BorderLayout());
        final JCheckBox useListedActionsAsInputCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.actions.useListedActionsAsInput", "module.repAnalyzer.charts.actions.useListedAsInput");
        final JComponent[] chartCanvasHolder = new JComponent[1];
        ActionListener chartCanvasRepaintListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                chartCanvasHolder[0].repaint();
            }
        };
        final GameEvents.Action[][] displayableActionsWrapper = new GameEvents.Action[1][];
        final JCheckBox[] playerCheckBoxes = new JCheckBox[this.replay.details.players.length];
        final int[] playerCheckBoxToPlayerIndices = this.replay.details.getTeamOrderPlayerIndeces();
        final String[][][] textFilterGroupsHolder = new String[1][][];
        final ActionListener actionsListRebuilderActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EnumSet<ReplayConsts.ActionType> displayActionTypeSet = EnumSet.noneOf(ReplayConsts.ActionType.class);
                ReplayConsts.ActionType[] actionTypeArray = ReplayConsts.ActionType.values();
                int n = actionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReplayConsts.ActionType actionType = actionTypeArray[n2];
                    if (((JCheckBox)ReplayAnalyzer.this.displayActionTypeCheckboxMap.get((Object)actionType)).isSelected()) {
                        displayActionTypeSet.add(actionType);
                    }
                    ++n2;
                }
                String[][] textFilterGroups = textFilterGroupsHolder[0];
                boolean[] playerDisplayable = new boolean[playerCheckBoxes.length];
                int i = 0;
                while (i < playerDisplayable.length) {
                    playerDisplayable[playerCheckBoxToPlayerIndices[i]] = playerCheckBoxes[i].isSelected();
                    ++i;
                }
                ArrayList<GameEvents.Action> displayableActionList = new ArrayList<GameEvents.Action>();
                GameEvents.Action[] actionArray = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions;
                int n3 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions.length;
                int n4 = 0;
                while (n4 < n3) {
                    block11: {
                        GameEvents.Action action;
                        block12: {
                            action = actionArray[n4];
                            if (!playerDisplayable[action.player] || !displayActionTypeSet.contains((Object)action.type)) break block11;
                            if (textFilterGroups == null) break block12;
                            boolean filterApplies = true;
                            String actionString = action.toString().toLowerCase();
                            String[][] stringArray = textFilterGroups;
                            int n5 = textFilterGroups.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String[] textFilterGroup = stringArray[n6];
                                filterApplies = true;
                                String[] stringArray2 = textFilterGroup;
                                int n7 = textFilterGroup.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    String filter = stringArray2[n8];
                                    if (!actionString.contains(filter)) {
                                        filterApplies = false;
                                        break;
                                    }
                                    ++n8;
                                }
                                if (filterApplies) break;
                                ++n6;
                            }
                            if (!filterApplies) break block11;
                        }
                        displayableActionList.add(action);
                    }
                    ++n4;
                }
                displayableActionsWrapper[0] = displayableActionList.toArray(new GameEvents.Action[displayableActionList.size()]);
                ReplayAnalyzer.this.actionsList.setListData(displayableActionsWrapper[0]);
                if (useListedActionsAsInputCheckBox.isSelected()) {
                    chartCanvasHolder[0].repaint();
                }
            }
        };
        Box topBox = Box.createVerticalBox();
        Box generalChartOptionsBox = Box.createHorizontalBox();
        generalChartOptionsBox.add(new JPanel(new BorderLayout()));
        generalChartOptionsBox.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.chartType")));
        final JComboBox chartTypeComboBox = GuiUtils.createComboBox((Object[])ChartType.values(), "module.repAnalyzer.charts.chartType");
        chartTypeComboBox.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.chartTypeToolTip"));
        chartTypeComboBox.addActionListener(chartCanvasRepaintListener);
        generalChartOptionsBox.add(chartTypeComboBox);
        generalChartOptionsBox.add(Box.createHorizontalStrut(5));
        final JCheckBox allPlayersOnOneChartCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.allPlayersOn1Chart", "module.repAnalyzer.charts.allPlayersOn1Chart");
        allPlayersOnOneChartCheckBox.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.allPlayersOn1ChartToolTip"));
        allPlayersOnOneChartCheckBox.addActionListener(chartCanvasRepaintListener);
        generalChartOptionsBox.add(allPlayersOnOneChartCheckBox);
        generalChartOptionsBox.add(Box.createHorizontalStrut(8));
        final JCheckBox usePlayersColorsCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.usePlayersColors", "module.repAnalyzer.charts.usePlayersColors");
        usePlayersColorsCheckBox.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.usePlayersColorsToolTip"));
        usePlayersColorsCheckBox.addActionListener(chartCanvasRepaintListener);
        ActionListener actionsListRepainterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ReplayAnalyzer.this.actionsList.invalidate();
                ReplayAnalyzer.this.actionsList.getParent().repaint();
                if (useListedActionsAsInputCheckBox.isSelected()) {
                    chartCanvasHolder[0].repaint();
                }
            }
        };
        usePlayersColorsCheckBox.addActionListener(actionsListRepainterListener);
        generalChartOptionsBox.add(usePlayersColorsCheckBox);
        ActionListener allPlayersOnOneChartListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                usePlayersColorsCheckBox.setEnabled(!allPlayersOnOneChartCheckBox.isSelected());
            }
        };
        allPlayersOnOneChartCheckBox.addActionListener(allPlayersOnOneChartListener);
        allPlayersOnOneChartListener.actionPerformed(null);
        generalChartOptionsBox.add(Box.createHorizontalStrut(8));
        final JCheckBox displayInSecondsCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.displayInSeconds", "module.repAnalyzer.charts.displayInSeconds");
        displayInSecondsCheckBox.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.displayInSecondsToolTip"));
        ActionListener setDisplayInSecondsToGameEventsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.displayInSeconds = displayInSecondsCheckBox.isSelected();
            }
        };
        setDisplayInSecondsToGameEventsActionListener.actionPerformed(null);
        displayInSecondsCheckBox.addActionListener(setDisplayInSecondsToGameEventsActionListener);
        displayInSecondsCheckBox.addActionListener(actionsListRebuilderActionListener);
        displayInSecondsCheckBox.addActionListener(chartCanvasRepaintListener);
        generalChartOptionsBox.add(displayInSecondsCheckBox);
        generalChartOptionsBox.add(Box.createHorizontalStrut(9));
        final JLabel zoomLabel = new JLabel(Language.getText("module.repAnalyzer.tab.charts.zoom"));
        zoomLabel.setOpaque(true);
        generalChartOptionsBox.add(zoomLabel);
        final JComboBox zoomComboBox = GuiUtils.createComboBox(new Object[]{"x1", "x2", "x4", "x8", "x16", "x32"}, "module.repAnalyzer.charts.zoom");
        zoomComboBox.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.zoomToolTip"));
        generalChartOptionsBox.add(zoomComboBox);
        generalChartOptionsBox.add(new JPanel(new BorderLayout()));
        topBox.add(generalChartOptionsBox);
        final Box chartSpecificOptionsBox = Box.createHorizontalBox();
        topBox.add(chartSpecificOptionsBox);
        topBox.add(Box.createVerticalStrut(2));
        Box playersBox = Box.createHorizontalBox();
        playersBox.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.players")));
        playersBox.add(Box.createHorizontalStrut(5));
        int lastTeam = this.replay.details.players[playerCheckBoxToPlayerIndices[0]].team;
        int i = 0;
        while (i < this.replay.details.players.length) {
            JCheckBox playerCheckBox = playerCheckBoxes[i] = new JCheckBox(this.replay.details.players[playerCheckBoxToPlayerIndices[i]].name, this.replay.details.players[playerCheckBoxToPlayerIndices[i]].lastActionFrame > 0);
            playerCheckBox.addActionListener(actionsListRebuilderActionListener);
            playerCheckBox.addActionListener(chartCanvasRepaintListener);
            int team = this.replay.details.players[playerCheckBoxToPlayerIndices[i]].team;
            if (team != lastTeam) {
                playersBox.add(Box.createHorizontalStrut(7));
                playersBox.add(new JLabel("VS."));
                playersBox.add(Box.createHorizontalStrut(10));
                lastTeam = team;
            }
            playersBox.add(playerCheckBox);
            playersBox.add(Box.createHorizontalStrut(3));
            ++i;
        }
        topBox.add(playersBox);
        chartsPanel.add((Component)topBox, "North");
        final JSplitPane chartSplitPane = new JSplitPane(0, true);
        chartSplitPane.setDividerSize(6);
        final JComboBox apmGranularityComboBox = GuiUtils.createComboBox(new Integer[]{1, 2, 3, 4, 5, 10, 15, 20, 30, 50, 100}, "module.repAnalyzer.charts.apm.granularity");
        apmGranularityComboBox.addActionListener(chartCanvasRepaintListener);
        final JComboBox apmApproximationComboBox = GuiUtils.createComboBox((Object[])GraphApproximation.values(), "module.repAnalyzer.charts.apm.graphApproximation");
        apmApproximationComboBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showSelectHotkeysCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.hotkeys.showSelectHotkeys", "module.repAnalyzer.charts.hotkeys.showSelectHotkeys");
        showSelectHotkeysCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showBuildsCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showBuilds", "module.repAnalyzer.charts.buildsTech.showBuilds");
        showBuildsCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showTrainsCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showTrains", "module.repAnalyzer.charts.buildsTech.showTrains");
        showTrainsCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showWorkersCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showWorkers", "module.repAnalyzer.charts.buildsTech.showWorkers");
        ActionListener showWorkerEnablerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                showWorkersCheckBox.setEnabled(showTrainsCheckBox.isSelected());
            }
        };
        showWorkerEnablerActionListener.actionPerformed(null);
        showTrainsCheckBox.addActionListener(showWorkerEnablerActionListener);
        showWorkersCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showResearchesCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showResearches", "module.repAnalyzer.charts.buildsTech.showResearches");
        showResearchesCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showUpgradesCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showUpgrades", "module.repAnalyzer.charts.buildsTech.showUpgrades");
        showUpgradesCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox useIconsCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.useIcons", "module.repAnalyzer.charts.buildsTech.useIcons");
        useIconsCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showUnitsStatCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showUnits", "module.repAnalyzer.charts.buildsTechStat.showUnits");
        showUnitsStatCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showBuildingsStatCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showBuildings", "module.repAnalyzer.charts.buildsTechStat.showBuildings");
        showBuildingsStatCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showResearchesStatCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showResearches", "module.repAnalyzer.charts.buildsTechStat.showResearches");
        showResearchesStatCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showUpgradesStatCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showUpgrades", "module.repAnalyzer.charts.buildsTech.showUpgrades");
        showUpgradesStatCheckBox.addActionListener(chartCanvasRepaintListener);
        final JCheckBox showAbilityGroupsStatCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showAbilityGroups", "module.repAnalyzer.charts.buildsTechStat.showAbilityGroups");
        showAbilityGroupsStatCheckBox.addActionListener(chartCanvasRepaintListener);
        final JComboBox barSizeComboBox = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(IconHandler.Size.values(), EnumSet.of(IconHandler.Size.HIDDEN)), "module.repAnalyzer.charts.buildsTechStat.barSize");
        barSizeComboBox.addActionListener(chartCanvasRepaintListener);
        ActionListener chartTypeComboBoxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                chartSpecificOptionsBox.removeAll();
                switch ((ChartType)((Object)chartTypeComboBox.getSelectedItem())) {
                    case APM: {
                        chartSpecificOptionsBox.add(new JPanel(new BorderLayout()));
                        chartSpecificOptionsBox.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.apm.granularity")));
                        chartSpecificOptionsBox.add(apmGranularityComboBox);
                        chartSpecificOptionsBox.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.apm.pixels")));
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(6));
                        chartSpecificOptionsBox.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.graphApproximation")));
                        chartSpecificOptionsBox.add(apmApproximationComboBox);
                        chartSpecificOptionsBox.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case HOTKEYS: {
                        chartSpecificOptionsBox.add(showSelectHotkeysCheckBox);
                        break;
                    }
                    case BUILDS_TECH: {
                        chartSpecificOptionsBox.add(showBuildsCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(3));
                        chartSpecificOptionsBox.add(showTrainsCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(3));
                        chartSpecificOptionsBox.add(showWorkersCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(3));
                        chartSpecificOptionsBox.add(showResearchesCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(3));
                        chartSpecificOptionsBox.add(showUpgradesCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(3));
                        chartSpecificOptionsBox.add(useIconsCheckBox);
                        break;
                    }
                    case BUILDS_TECH_STAT: {
                        chartSpecificOptionsBox.add(new JPanel(new BorderLayout()));
                        chartSpecificOptionsBox.add(showUnitsStatCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(3));
                        chartSpecificOptionsBox.add(showBuildingsStatCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(3));
                        chartSpecificOptionsBox.add(showResearchesStatCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(3));
                        chartSpecificOptionsBox.add(showUpgradesStatCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(3));
                        chartSpecificOptionsBox.add(showAbilityGroupsStatCheckBox);
                        chartSpecificOptionsBox.add(Box.createHorizontalStrut(4));
                        chartSpecificOptionsBox.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.buildsTechStat.barSize")));
                        chartSpecificOptionsBox.add(barSizeComboBox);
                        chartSpecificOptionsBox.add(new JPanel(new BorderLayout()));
                    }
                }
                chartsPanel.validate();
            }
        };
        chartTypeComboBox.addActionListener(chartTypeComboBoxActionListener);
        chartTypeComboBoxActionListener.actionPerformed(null);
        final Integer[] markerXHolder = new Integer[1];
        final Integer[] markerFrameHolder = new Integer[1];
        final PaintChartParams[] chartParamsHolder = new PaintChartParams[1];
        final JScrollPane chartCanvasScrollPane = new JScrollPane(21, 31);
        final JComponent chartCanvas = chartCanvasHolder[0] = new JComponent(){

            @Override
            protected void paintComponent(Graphics graphics) {
                PaintChartParams params = chartParamsHolder[0] = new PaintChartParams();
                params.chartCanvas = chartCanvasHolder[0];
                params.markerFrame = markerFrameHolder[0];
                params.markerX = markerXHolder[0];
                params.visibleRectangle = this.getVisibleRect();
                params.g2 = (Graphics2D)graphics;
                params.replay = ReplayAnalyzer.this.replay;
                params.actions = useListedActionsAsInputCheckBox.isSelected() ? displayableActionsWrapper[0] : ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions;
                params.chartType = (ChartType)((Object)chartTypeComboBox.getSelectedItem());
                params.allPlayersOnOneChart = allPlayersOnOneChartCheckBox.isSelected();
                params.usePlayersInGameColors = usePlayersColorsCheckBox.isSelected();
                params.displayInSeconds = displayInSecondsCheckBox.isSelected();
                params.zoom = Integer.parseInt(((String)zoomComboBox.getSelectedItem()).substring(1));
                params.setVisiblePlayers(playerCheckBoxes, playerCheckBoxToPlayerIndices);
                params.width = this.getWidth();
                params.height = this.getHeight();
                switch (params.chartType) {
                    case APM: {
                        params.apmGranularity = (Integer)apmGranularityComboBox.getSelectedItem();
                        params.apmApproximation = (GraphApproximation)((Object)apmApproximationComboBox.getSelectedItem());
                        break;
                    }
                    case HOTKEYS: {
                        params.showSelectHotkeys = showSelectHotkeysCheckBox.isSelected();
                        break;
                    }
                    case BUILDS_TECH: {
                        params.showBuilds = showBuildsCheckBox.isSelected();
                        params.showTrains = showTrainsCheckBox.isSelected();
                        params.showWorkers = showWorkersCheckBox.isSelected();
                        params.showResearches = showResearchesCheckBox.isSelected();
                        params.showUpgrades = showUpgradesCheckBox.isSelected();
                        params.useIcons = useIconsCheckBox.isSelected();
                        break;
                    }
                    case BUILDS_TECH_STAT: {
                        params.showUnitsStat = showUnitsStatCheckBox.isSelected();
                        params.showBuildingsStat = showBuildingsStatCheckBox.isSelected();
                        params.showResearchesStat = showResearchesStatCheckBox.isSelected();
                        params.showUpgradesStat = showUpgradesStatCheckBox.isSelected();
                        params.showAbilityGroupsStat = showAbilityGroupsStatCheckBox.isSelected();
                        params.barSize = (IconHandler.Size)((Object)barSizeComboBox.getSelectedItem());
                    }
                }
                new ChartPainter(params).paintChart();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = chartCanvasScrollPane.getViewport().getExtentSize();
                d.width *= Integer.parseInt(((String)zoomComboBox.getSelectedItem()).substring(1));
                return d;
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                PaintChartParams params = chartParamsHolder[0];
                if (params == null) {
                    return null;
                }
                if (params.toolTipProvider == null) {
                    int frame = params.xToFrame(event.getX());
                    return frame < 0 ? null : Language.getText("module.repAnalyzer.tab.charts.chartTooltip.frameTime", frame, ReplayUtils.formatFrames(frame));
                }
                return params.toolTipProvider.getToolTip(event.getPoint());
            }
        };
        chartCanvas.setToolTipText("");
        GuiUtils.makeComponentDragScrollable(chartCanvas);
        final boolean[] disableSyncFromListToChartHolder = new boolean[1];
        chartCanvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.getButton() == 3) {
                    new ReplayOperationsPopupMenu(new File[]{ReplayAnalyzer.this.replayFile}, new ReplayOperationsPopupMenu.ReplayOpCallback(){

                        @Override
                        public void replayRenamed(File file, File newFile, int fileIndex) {
                            ReplayAnalyzer.this.replayFile = newFile;
                        }

                        @Override
                        public void replayMoved(File file, File targetFolder, int fileIndex) {
                            ReplayAnalyzer.this.replayFile = new File(targetFolder, file.getName());
                        }

                        @Override
                        public void replayDeleted(File file, int fileIndex) {
                        }

                        @Override
                        public void moveRenameDeleteEnded() {
                            ReplayAnalyzer.this.setTitle(GeneralUtils.getFileNameWithoutExt(ReplayAnalyzer.this.replayFile));
                            MainFrame.INSTANCE.refreshRepAnalNavigationNode();
                        }
                    }).show(event.getComponent(), event.getX(), event.getY());
                } else {
                    markerXHolder[0] = Math.max(25, event.getX());
                    markerFrameHolder[0] = null;
                    chartCanvas.repaint();
                    if (chartParamsHolder[0] != null && displayableActionsWrapper[0].length > 0) {
                        GameEvents.Action testAction = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.new GameEvents.Action();
                        testAction.frame = chartParamsHolder[0].xToFrame(markerXHolder[0]);
                        int position = Arrays.binarySearch(displayableActionsWrapper[0], testAction, ReplayUtils.ACTION_FRAME_COMPARATOR);
                        int index = position >= 0 ? position : (-position <= displayableActionsWrapper[0].length ? -position - 1 : -position - 2);
                        disableSyncFromListToChartHolder[0] = true;
                        ReplayAnalyzer.this.actionsList.setSelectedIndex(index);
                        ReplayAnalyzer.this.actionsList.ensureIndexIsVisible(index);
                        disableSyncFromListToChartHolder[0] = false;
                    }
                }
            }
        });
        chartCanvasScrollPane.setViewportView(chartCanvas);
        chartSplitPane.setTopComponent(chartCanvasScrollPane);
        ActionListener zoomComboBoxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int zoom = Integer.parseInt(((String)zoomComboBox.getSelectedItem()).substring(1));
                zoomLabel.setBackground(zoom == 1 ? null : Color.GREEN);
                chartCanvasScrollPane.setHorizontalScrollBarPolicy(zoom > 1 ? 32 : 31);
                chartCanvas.invalidate();
                chartCanvasScrollPane.validate();
            }
        };
        zoomComboBoxActionListener.actionPerformed(null);
        zoomComboBox.addActionListener(zoomComboBoxActionListener);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        Box hbox = Box.createHorizontalBox();
        hbox.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.displayActionTypes")));
        hbox.add(Box.createHorizontalStrut(5));
        ReplayConsts.ActionType[] actionTypeArray = ReplayConsts.ActionType.values();
        int n = actionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReplayConsts.ActionType actionType = actionTypeArray[n2];
            JCheckBox actionTypeCheckBox = new JCheckBox(actionType.toString(), actionType != ReplayConsts.ActionType.INACTION);
            actionTypeCheckBox.addActionListener(actionsListRebuilderActionListener);
            this.displayActionTypeCheckboxMap.put(actionType, actionTypeCheckBox);
            hbox.add(actionTypeCheckBox);
            hbox.add(Box.createHorizontalStrut(5));
            ++n2;
        }
        bottomPanel.add((Component)hbox, "North");
        this.actionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting() && ReplayAnalyzer.this.actionsList.getSelectedIndex() >= 0 && !disableSyncFromListToChartHolder[0]) {
                    markerXHolder[0] = null;
                    markerFrameHolder[0] = displayableActionsWrapper[0][((ReplayAnalyzer)ReplayAnalyzer.this).actionsList.getSelectedIndex()].frame;
                    int x = markerFrameHolder[0];
                    if (chartParamsHolder[0] != null) {
                        Rectangle visibleRectangle = chartParamsHolder[0].visibleRectangle;
                        if (x < visibleRectangle.x || x >= visibleRectangle.x + visibleRectangle.width) {
                            chartCanvas.scrollRectToVisible(new Rectangle(chartParamsHolder[0].frameToX(x) - (visibleRectangle.width >> 2), 0, visibleRectangle.width >> 1, 1));
                        }
                    }
                    chartCanvas.repaint();
                }
            }
        });
        this.actionsList.setFont(new Font("Monospaced", 0, 12));
        final JCheckBox invertListColorsCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.actions.invertColors", "module.repAnalyzer.charts.actions.invertColors");
        final JComboBox iconSizesComboBox = GuiUtils.createComboBox((Object[])IconHandler.Size.values(), "module.repAnalyzer.charts.actions.iconSize");
        this.actionsList.setCellRenderer(new ListCellRenderer(){
            private final JLabel label = new JLabel();
            {
                this.label.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                GameEvents.Action action = (GameEvents.Action)value;
                IconHandler.Size size = (IconHandler.Size)((Object)iconSizesComboBox.getSelectedItem());
                if (size == IconHandler.Size.HIDDEN) {
                    this.label.setIcon(null);
                } else if (action instanceof GameEvents.UseUnitAbilityAction) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.UseUnitAbilityAction)action).unitAbility.abilityGroup, size));
                } else if (action instanceof GameEvents.TrainAction) {
                    this.label.setIcon(Icons.getUnitIcon(((GameEvents.TrainAction)action).unit, size));
                } else if (action instanceof GameEvents.UseBuildingAbilityAction) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.UseBuildingAbilityAction)action).buildingAbility.abilityGroup, size));
                } else if (action instanceof GameEvents.BuildAction) {
                    this.label.setIcon(Icons.getBuildingIcon(((GameEvents.BuildAction)action).building, size));
                } else if (action instanceof GameEvents.UpgradeAction) {
                    this.label.setIcon(Icons.getUpgradeIcon(((GameEvents.UpgradeAction)action).upgrade, size));
                } else if (action instanceof GameEvents.ResearchAction) {
                    this.label.setIcon(Icons.getResearchIcon(((GameEvents.ResearchAction)action).research, size));
                } else if (action instanceof GameEvents.BaseUseAbilityAction && ((GameEvents.BaseUseAbilityAction)action).abilityGroup != null) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.BaseUseAbilityAction)action).abilityGroup, size));
                } else {
                    this.label.setIcon(IconHandler.NULL.get((Object)size));
                }
                this.label.setText(action.toString());
                if (isSelected ^ invertListColorsCheckBox.isSelected()) {
                    this.label.setBackground(usePlayersColorsCheckBox.isSelected() ? ((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players[action.player].getDarkerColor() : list.getSelectionBackground());
                    this.label.setForeground(usePlayersColorsCheckBox.isSelected() ? Color.WHITE : list.getSelectionForeground());
                } else {
                    this.label.setBackground(list.getBackground());
                    this.label.setForeground(usePlayersColorsCheckBox.isSelected() ? ((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players[action.player].getDarkerColor() : list.getForeground());
                }
                this.label.setEnabled(list.isEnabled());
                this.label.setFont(list.getFont());
                return this.label;
            }
        });
        bottomPanel.add((Component)new JScrollPane(this.actionsList), "Center");
        Box optionsWrapperBox = Box.createVerticalBox();
        JPanel actionsOpsPanel = new JPanel(new GridLayout(3, 2, 0, 0));
        actionsOpsPanel.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.jumpToFrame")));
        final JTextField jumpToFrameTextField = new JTextField(1);
        jumpToFrameTextField.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.jumpToFrameToolTip"));
        jumpToFrameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (displayableActionsWrapper[0].length > 0) {
                    try {
                        int toFrame = Integer.parseInt(jumpToFrameTextField.getText());
                        GameEvents.Action testAction = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.new GameEvents.Action();
                        testAction.frame = toFrame;
                        int position = Arrays.binarySearch(displayableActionsWrapper[0], testAction, ReplayUtils.ACTION_FRAME_COMPARATOR);
                        int index = position >= 0 ? position : (-position <= displayableActionsWrapper[0].length ? -position - 1 : -position - 2);
                        ReplayAnalyzer.this.actionsList.setSelectedIndex(index);
                        ReplayAnalyzer.this.actionsList.ensureIndexIsVisible(index);
                        chartCanvas.repaint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        actionsOpsPanel.add(jumpToFrameTextField);
        actionsOpsPanel.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.searchText")));
        final JTextField searchTextTextField = new JTextField(1);
        searchTextTextField.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.searchTextToolTip"));
        searchTextTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String searchText = searchTextTextField.getText().trim().toLowerCase();
                if (displayableActionsWrapper[0].length > 0 && searchText.length() > 0) {
                    int startIndex;
                    GameEvents.Action[] actionList = displayableActionsWrapper[0];
                    int i = startIndex = ReplayAnalyzer.this.actionsList.getSelectedIndex() < 0 ? actionList.length - 1 : ReplayAnalyzer.this.actionsList.getSelectedIndex();
                    do {
                        if (++i == actionList.length) {
                            i = 0;
                        }
                        if (!actionList[i].toString().toLowerCase().contains(searchText)) continue;
                        ReplayAnalyzer.this.actionsList.setSelectedIndex(i);
                        ReplayAnalyzer.this.actionsList.ensureIndexIsVisible(i);
                        chartCanvas.repaint();
                        break;
                    } while (i != startIndex);
                }
            }
        });
        actionsOpsPanel.add(searchTextTextField);
        final JLabel filterActionsLabel = new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterActions"));
        filterActionsLabel.setOpaque(true);
        actionsOpsPanel.add(filterActionsLabel);
        final JTextField filterActionsTextField = new JTextField(1);
        filterActionsTextField.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterActionsToolTip"));
        final ActionListener filterActionsTextFieldActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                textFilterGroupsHolder[0] = ReplayAnalyzer.createFilterGroups(filterActionsTextField.getText());
                if (textFilterGroupsHolder[0] == null) {
                    filterActionsLabel.setBackground(null);
                } else {
                    filterActionsLabel.setBackground(Color.GREEN);
                }
                actionsListRebuilderActionListener.actionPerformed(null);
            }
        };
        filterActionsTextField.addActionListener(filterActionsTextFieldActionListener);
        actionsOpsPanel.add(filterActionsTextField);
        optionsWrapperBox.add(actionsOpsPanel);
        actionsOpsPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        actionsOpsPanel.add(new JLabel());
        JButton clearFilterButton = new JButton();
        GuiUtils.updateButtonText(clearFilterButton, "module.repAnalyzer.tab.charts.actionOps.clearFilterButton", new Object[0]);
        clearFilterButton.putClientProperty("JComponent.sizeVariant", "small");
        clearFilterButton.updateUI();
        clearFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                filterActionsTextField.setText("");
                filterActionsTextFieldActionListener.actionPerformed(null);
            }
        });
        actionsOpsPanel.add(clearFilterButton);
        optionsWrapperBox.add(actionsOpsPanel);
        optionsWrapperBox.add(new JPanel(new BorderLayout()));
        optionsWrapperBox.setMinimumSize(new Dimension(10, 10));
        bottomPanel.add((Component)optionsWrapperBox, "East");
        Box listSettingsBox = Box.createHorizontalBox();
        invertListColorsCheckBox.addActionListener(actionsListRepainterListener);
        listSettingsBox.add(invertListColorsCheckBox);
        listSettingsBox.add(Box.createHorizontalStrut(12));
        listSettingsBox.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actions.iconSizes")));
        iconSizesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ReplayAnalyzer.this.actionsList.updateUI();
            }
        });
        listSettingsBox.add(iconSizesComboBox);
        listSettingsBox.add(Box.createHorizontalStrut(12));
        useListedActionsAsInputCheckBox.setOpaque(true);
        ActionListener useVisibleActionsAsInputBgColorHandlerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                useListedActionsAsInputCheckBox.setBackground(useListedActionsAsInputCheckBox.isSelected() ? Color.GREEN : null);
            }
        };
        useVisibleActionsAsInputBgColorHandlerActionListener.actionPerformed(null);
        useListedActionsAsInputCheckBox.addActionListener(useVisibleActionsAsInputBgColorHandlerActionListener);
        useListedActionsAsInputCheckBox.addActionListener(chartCanvasRepaintListener);
        listSettingsBox.add(useListedActionsAsInputCheckBox);
        listSettingsBox.add(new JPanel(new BorderLayout()));
        bottomPanel.add((Component)listSettingsBox, "South");
        chartSplitPane.setBottomComponent(bottomPanel);
        chartsPanel.add(chartSplitPane);
        chartSplitPane.setResizeWeight(0.7);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                chartSplitPane.setDividerLocation(0.7);
            }
        });
        actionsListRebuilderActionListener.actionPerformed(null);
        Object actionKey = new Object();
        ChartType[] chartTypeArray = ChartType.values();
        int n3 = chartTypeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            final ChartType chartType = chartTypeArray[n4];
            actionKey = new Object();
            chartsPanel.getInputMap(1).put(chartType.keyStroke, actionKey);
            chartsPanel.getActionMap().put(actionKey, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    chartTypeComboBox.setSelectedItem((Object)chartType);
                }
            });
            ++n4;
        }
        actionKey = new Object();
        chartsPanel.getInputMap(1).put(KeyStroke.getKeyStroke(73, 2), actionKey);
        chartsPanel.getActionMap().put(actionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (zoomComboBox.getSelectedIndex() < zoomComboBox.getItemCount() - 1) {
                    zoomComboBox.setSelectedIndex(zoomComboBox.getSelectedIndex() + 1);
                }
            }
        });
        actionKey = new Object();
        chartsPanel.getInputMap(1).put(KeyStroke.getKeyStroke(85, 2), actionKey);
        chartsPanel.getActionMap().put(actionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (zoomComboBox.getSelectedIndex() > 0) {
                    zoomComboBox.setSelectedIndex(zoomComboBox.getSelectedIndex() - 1);
                }
            }
        });
        actionKey = new Object();
        chartsPanel.getInputMap(1).put(KeyStroke.getKeyStroke(74, 2), actionKey);
        chartsPanel.getActionMap().put(actionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                jumpToFrameTextField.requestFocusInWindow();
            }
        });
        actionKey = new Object();
        chartsPanel.getInputMap(1).put(KeyStroke.getKeyStroke(83, 2), actionKey);
        chartsPanel.getActionMap().put(actionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                searchTextTextField.requestFocusInWindow();
            }
        });
        actionKey = new Object();
        chartsPanel.getInputMap(1).put(KeyStroke.getKeyStroke(70, 2), actionKey);
        chartsPanel.getActionMap().put(actionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                filterActionsTextField.requestFocusInWindow();
            }
        });
        return chartsPanel;
    }

    private static String[][] createFilterGroups(String filterText) {
        if ((filterText = filterText.trim()).length() == 0) {
            return null;
        }
        ArrayList filterGroupList = new ArrayList();
        StringTokenizer filterTokenizer = new StringTokenizer(filterText.toLowerCase());
        ArrayList<String> filterGroup = null;
        while (filterTokenizer.hasMoreTokens()) {
            String filterToken = filterTokenizer.nextToken();
            if (filterToken.equals("or")) {
                filterGroup = null;
                continue;
            }
            if (filterToken.equals("and")) continue;
            if (filterGroup == null) {
                filterGroup = new ArrayList<String>(2);
                filterGroupList.add(filterGroup);
            }
            filterGroup.add(filterToken);
        }
        String[][] filterGroups = new String[filterGroupList.size()][];
        int i = 0;
        while (i < filterGroups.length) {
            filterGroups[i] = ((List)filterGroupList.get(i)).toArray(new String[0]);
            ++i;
        }
        return filterGroups;
    }

    private JComponent createGameInfoTab() {
        JPanel gameInfoPanel = new JPanel(new BorderLayout());
        JTextArea gameInfoTextArea = new JTextArea();
        gameInfoTextArea.setEditable(false);
        gameInfoTextArea.setTabSize(4);
        GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.version", this.replay.version));
        GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gameLength", ReplayUtils.formatMs(this.replay.gameLength * 500)));
        GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gameSpeed", new Object[]{this.replay.initData.gameSpeed}));
        GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gameType", new Object[]{this.replay.initData.gameType}));
        if (this.replay.initData.format != null) {
            GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.format", new Object[]{this.replay.initData.format}));
        }
        if (this.replay.initData.gateway != null) {
            GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gateway", new Object[]{this.replay.initData.gateway}));
        }
        StringBuilder clientNamesBuilder = new StringBuilder();
        String[] stringArray = this.replay.initData.clientNames;
        int n = this.replay.initData.clientNames.length;
        int n2 = 0;
        while (n2 < n) {
            String clientName = stringArray[n2];
            if (clientName.length() > 0) {
                if (clientNamesBuilder.length() > 0) {
                    clientNamesBuilder.append(", ");
                }
                clientNamesBuilder.append(clientName);
            }
            ++n2;
        }
        GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.clients", clientNamesBuilder));
        GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapName", this.replay.details.mapName));
        if (this.replay.initData.mapFileName != null) {
            GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapFile", this.replay.initData.mapFileName));
        }
        if (this.replay.mapInfo != null) {
            GuiUtils.appendNewLine(gameInfoTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapSize", this.replay.mapInfo.getSizeString()));
        }
        gameInfoTextArea.append("\n");
        gameInfoTextArea.append(Language.getText("module.repAnalyzer.tab.gameInfo.players"));
        int[] teamOrderPlayerIndices = this.replay.details.getTeamOrderPlayerIndeces();
        int lastTeam = -1;
        int[] nArray = teamOrderPlayerIndices;
        int n3 = teamOrderPlayerIndices.length;
        int n4 = 0;
        while (n4 < n3) {
            int playerIndex = nArray[n4];
            Details.Player player = this.replay.details.players[playerIndex];
            if (player.team != lastTeam) {
                gameInfoTextArea.append("\n\t" + Language.getText("module.repAnalyzer.tab.gameInfo.team", player.team == Integer.MAX_VALUE ? Language.getText("general.unknown") : Integer.valueOf(player.team)));
                lastTeam = player.team;
            }
            gameInfoTextArea.append("\n\t\t");
            gameInfoTextArea.append(player.fullName);
            gameInfoTextArea.append(", ");
            gameInfoTextArea.append(player.raceString());
            if (player.type != null) {
                gameInfoTextArea.append(", ");
                gameInfoTextArea.append(player.type.toString());
            }
            gameInfoTextArea.append(", ");
            gameInfoTextArea.append(player.getColorName());
            ++n4;
        }
        gameInfoTextArea.append("\n");
        gameInfoPanel.add(new JScrollPane(gameInfoTextArea));
        return gameInfoPanel;
    }

    private JComponent createInGameChatTab() {
        final StyleContext STYLE_CONTEX = new StyleContext();
        Style defaultStyle = STYLE_CONTEX.addStyle("default", StyleContext.getDefaultStyleContext().getStyle("default"));
        int counter = 0;
        Details.Player[] playerArray = this.replay.details.players;
        int n = this.replay.details.players.length;
        int n2 = 0;
        while (n2 < n) {
            Details.Player player = playerArray[n2];
            Style style = STYLE_CONTEX.addStyle("p" + counter, defaultStyle);
            StyleConstants.setForeground(style, player.getDarkerColor());
            ++counter;
            ++n2;
        }
        JPanel chatPanel = new JPanel(new BorderLayout());
        Box optionsBox = Box.createHorizontalBox();
        final JTextPane chatTextPane = new JTextPane(){

            @Override
            public void paint(Graphics graphics) {
                Container comp = this;
                while (!(comp instanceof JViewport)) {
                    comp = comp.getParent();
                }
                Rectangle viewRect = ((JViewport)comp).getViewRect();
                graphics.setColor(new Color(240, 240, 240));
                graphics.fillRect(viewRect.x, viewRect.y, viewRect.width, viewRect.height);
                super.paint(graphics);
            }
        };
        chatTextPane.setOpaque(false);
        chatTextPane.setBackground(new Color(0, 0, 0, 0));
        final JCheckBox hideMessageTargetsCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.hideMessageTarget", "module.repAnalyzer.inGameChat.hideMessageTargets");
        final JCheckBox showBlinksCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.showBlinks", "module.repAnalyzer.inGameChat.showBlinks");
        final JCheckBox formatIntoParagraphsCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.formatIntoParagraphs", "module.repAnalyzer.inGameChat.formatIntoParagraphs");
        ActionListener chatActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean hideMessageTargets = hideMessageTargetsCheckBox.isSelected();
                boolean showBlinks = showBlinksCheckBox.isSelected();
                boolean emptyLinesForBreaks = formatIntoParagraphsCheckBox.isSelected();
                String allText = hideMessageTargets ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAll");
                String alliesText = hideMessageTargets ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAllies");
                chatTextPane.setText("");
                int ms = 0;
                int lastMs = 0;
                Document document = chatTextPane.getDocument();
                MessageEvents.Message[] messageArray = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.messageEvents.messages;
                int n = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.messageEvents.messages.length;
                int n2 = 0;
                while (n2 < n) {
                    MessageEvents.Message message = messageArray[n2];
                    lastMs = ms;
                    String outputMessage = null;
                    String playerName = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.initData.clientNames[message.client];
                    ms += message.time;
                    if (message instanceof MessageEvents.Text) {
                        MessageEvents.Text textMessage = (MessageEvents.Text)message;
                        outputMessage = hideMessageTargets ? Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageNoTarget", ReplayUtils.formatMs(ms), playerName, textMessage.text) : Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageFull", ReplayUtils.formatMs(ms), playerName, textMessage.opCode == 0 ? allText : alliesText, textMessage.text);
                    } else if (message instanceof MessageEvents.Blink && showBlinks) {
                        MessageEvents.Blink blinkMessage = (MessageEvents.Blink)message;
                        outputMessage = Language.getText("module.repAnalyzer.tab.inGameChat.blinkMessage", ReplayUtils.formatMs(ms), playerName, ReplayUtils.formatCoordinate(blinkMessage.x), ReplayUtils.formatCoordinate(blinkMessage.y));
                    }
                    if (outputMessage != null) {
                        try {
                            document.insertString(document.getLength(), emptyLinesForBreaks && ms - lastMs > 6000 && lastMs > 0 ? "\n" + outputMessage + "\n" : String.valueOf(outputMessage) + "\n", STYLE_CONTEX.getStyle("p" + message.client));
                        }
                        catch (BadLocationException be) {
                            be.printStackTrace();
                        }
                    }
                    ++n2;
                }
                chatTextPane.setCaretPosition(0);
            }
        };
        hideMessageTargetsCheckBox.addActionListener(chatActionListener);
        showBlinksCheckBox.addActionListener(chatActionListener);
        formatIntoParagraphsCheckBox.addActionListener(chatActionListener);
        chatActionListener.actionPerformed(null);
        optionsBox.add(hideMessageTargetsCheckBox);
        optionsBox.add(Box.createHorizontalStrut(10));
        optionsBox.add(showBlinksCheckBox);
        optionsBox.add(Box.createHorizontalStrut(10));
        optionsBox.add(formatIntoParagraphsCheckBox);
        chatPanel.add((Component)GuiUtils.wrapInPanel(optionsBox), "North");
        chatTextPane.setEditable(false);
        chatPanel.add((Component)new JScrollPane(chatTextPane), "Center");
        return chatPanel;
    }

    private JComponent createMapPreviewTab() {
        String mapFileName;
        File mapFile;
        final JPanel mapPreviewPanel = new JPanel(new BorderLayout());
        final JLabel mapPreviewLabel = new JLabel();
        Box northBox = Box.createVerticalBox();
        JLabel mapInfoLabel = new JLabel(Language.getText("module.repAnalyzer.tab.gameInfo.mapName", this.replay.mapInfo == null ? this.replay.details.mapName : String.valueOf(this.replay.details.mapName) + " (" + this.replay.mapInfo.getSizeString() + ")"), 0);
        GuiUtils.changeFontToBold(mapInfoLabel);
        northBox.add(GuiUtils.wrapInPanel(mapInfoLabel));
        if (this.replay.mapInfo == null && (mapFile = ReplayParser.getMapFile(this.replay)) != null && !mapFile.exists() && (mapFileName = mapFile.getName()).length() == 69) {
            final Box downloadBox = Box.createVerticalBox();
            final Box controlBox = Box.createHorizontalBox();
            final JLabel downloadInfoLabel = new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.mapFileNotExists"), 0);
            controlBox.add(downloadInfoLabel);
            controlBox.add(Box.createHorizontalStrut(5));
            final Box downloadSourceBox = Box.createHorizontalBox();
            final JComboBox downloadFromGatewayComboBox = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(ReplayConsts.Gateway.values(), EnumSet.of(ReplayConsts.Gateway.UNKNOWN)), "module.repAnalyzer.mapPreview.downloadFromGateway");
            final JButton downloadButton = new JButton(Icons.DRIVE_DOWNLOAD);
            GuiUtils.updateButtonText(downloadButton, "module.repAnalyzer.tab.mapPreview.downloadMapButton", new Object[0]);
            downloadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    downloadBox.remove(downloadSourceBox);
                    downloadButton.setEnabled(false);
                    downloadInfoLabel.setText(Language.getText("module.repAnalyzer.tab.mapPreview.downloadingMap"));
                    StringBuilder urlBuilder = new StringBuilder(((ReplayConsts.Gateway)((Object)downloadFromGatewayComboBox.getSelectedItem())).depotServerUrl);
                    int i = 0;
                    while (i < 6) {
                        urlBuilder.append(mapFileName.charAt(i)).append(mapFileName.charAt(i + 1)).append('/');
                        i += 2;
                    }
                    urlBuilder.append(mapFileName);
                    Downloader[] downloaderHolder = new Downloader[1];
                    Downloader downloader = downloaderHolder[0] = new Downloader(urlBuilder.toString(), mapFile, new Downloader.Callback(downloaderHolder){
                        private final InternalFrameListener downloadStopperListener;
                        {
                            this.downloadStopperListener = new InternalFrameAdapter(){

                                @Override
                                public void internalFrameClosing(InternalFrameEvent event) {
                                    downloaderArray[0].requestToCancel();
                                }
                            };
                            ReplayAnalyzer.this.addInternalFrameListener(this.downloadStopperListener);
                        }

                        @Override
                        public void downloadFinished(boolean success) {
                            ReplayAnalyzer.this.removeInternalFrameListener(this.downloadStopperListener);
                            if (!ReplayAnalyzer.this.isClosed()) {
                                downloadInfoLabel.setText(Language.getText(success ? "module.repAnalyzer.tab.mapPreview.mapDownloaded" : "module.repAnalyzer.tab.mapPreview.mapDownloadFailed"));
                                controlBox.remove(downloadButton);
                                JButton reopenButton = new JButton(Icons.ARROW_CIRCLE_DOUBLE);
                                GuiUtils.updateButtonText(reopenButton, "module.repAnalyzer.tab.mapPreview.reopenReplayButton", new Object[0]);
                                reopenButton.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent event) {
                                        try {
                                            ReplayAnalyzer.this.setClosed(true);
                                        }
                                        catch (PropertyVetoException propertyVetoException) {
                                            // empty catch block
                                        }
                                        MainFrame.INSTANCE.createNewInternalFrame(MainFrame.INSTANCE.newRepAnalNode, ReplayAnalyzer.this.replayFile);
                                    }
                                });
                                controlBox.add(reopenButton);
                                mapPreviewPanel.validate();
                            }
                        }
                    });
                    downloadBox.add(downloader.progressBar);
                    mapPreviewPanel.validate();
                    downloader.start();
                }
            });
            controlBox.add(downloadButton);
            downloadBox.add(controlBox);
            downloadSourceBox.add(new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.downloadFromGateway")));
            downloadSourceBox.add(downloadFromGatewayComboBox);
            downloadBox.add(downloadSourceBox);
            northBox.add(downloadBox);
        }
        Box optionsBox = Box.createHorizontalBox();
        optionsBox.add(new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.zoom")));
        final JSlider zoomSlider = new JSlider(0, 6, Settings.getInt("module.repAnalyzer.mapPreview.zoom"));
        zoomSlider.setPaintLabels(true);
        zoomSlider.setPaintTicks(true);
        zoomSlider.setSnapToTicks(true);
        zoomSlider.setMajorTickSpacing(1);
        zoomSlider.setLabelTable(LABEL_DICTIONARY);
        ChangeListener zoomChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (zoomSlider.getValueIsAdjusting()) {
                    return;
                }
                int zoom = zoomSlider.getValue();
                if (((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo == null) {
                    mapPreviewLabel.setText(Language.getText("module.repAnalyzer.tab.mapPreview.previewNotAvailable"));
                } else {
                    int width = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getIconWidth();
                    int height = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getIconHeight();
                    mapPreviewLabel.setIcon(new ImageIcon(((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getImage().getScaledInstance(zoom == 0 ? width / 2 : width * zoom, zoom == 0 ? height / 2 : height * zoom, 4)));
                }
                if (event != null) {
                    Settings.set("module.repAnalyzer.mapPreview.zoom", zoom);
                }
            }
        };
        zoomChangeListener.stateChanged(null);
        zoomSlider.addChangeListener(zoomChangeListener);
        optionsBox.add(zoomSlider);
        northBox.add(optionsBox);
        mapPreviewPanel.add((Component)GuiUtils.wrapInPanel(northBox), "North");
        mapPreviewLabel.setHorizontalAlignment(0);
        GuiUtils.makeComponentDragScrollable(mapPreviewLabel);
        mapPreviewPanel.add((Component)new JScrollPane(mapPreviewLabel), "Center");
        return mapPreviewPanel;
    }

    public static enum ChartType {
        APM("module.repAnalyzer.tab.charts.chartType.apm"),
        HOTKEYS("module.repAnalyzer.tab.charts.chartType.hotkeys"),
        BUILDS_TECH("module.repAnalyzer.tab.charts.chartType.buildsTech"),
        BUILDS_TECH_STAT("module.repAnalyzer.tab.charts.chartType.buildsTechStat");

        private final String stringValue;
        public final KeyStroke keyStroke;

        private ChartType(String textKey) {
            this.stringValue = Language.getText(textKey);
            this.keyStroke = KeyStroke.getKeyStroke(49 + this.ordinal(), 2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum GraphApproximation {
        LINEAR("module.repAnalyzer.tab.charts.graphApproximation.linear"),
        CUBIC("module.repAnalyzer.tab.charts.graphApproximation.cubic");

        private final String stringValue;

        private GraphApproximation(String textKey) {
            this.stringValue = Language.getText(textKey);
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

