/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.replay.model.GameEvents;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ReplayAnalyzer;
import hu.belicza.andras.sc2gears.util.Pair;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PaintChartParams {
    public static final int Y_AXIS_X = 25;
    public static final int CHART_TITLE_HEIGHT = 12;
    public static final int X_AXIS_LABELS_HEIGHT = 13;
    public int width;
    public int height;
    public JComponent chartCanvas;
    public Integer markerFrame;
    public Integer markerX;
    public Rectangle visibleRectangle;
    public Graphics2D g2;
    public Replay replay;
    public GameEvents.Action[] actions;
    public ReplayAnalyzer.ChartType chartType;
    public boolean allPlayersOnOneChart;
    public boolean usePlayersInGameColors;
    public boolean displayInSeconds;
    public int zoom;
    public int apmGranularity;
    public ReplayAnalyzer.GraphApproximation apmApproximation;
    public boolean showSelectHotkeys;
    public boolean showBuilds;
    public boolean showTrains;
    public boolean showWorkers;
    public boolean showResearches;
    public boolean showUpgrades;
    public boolean useIcons;
    public boolean showUnitsStat;
    public boolean showBuildingsStat;
    public boolean showResearchesStat;
    public boolean showUpgradesStat;
    public boolean showAbilityGroupsStat;
    public IconHandler.Size barSize;
    public int[] playerChartIndices;
    public int playersCount;
    public int[] chartPlayerIndices;
    public int chartsCount;
    public int chartX1;
    public int[] chartY1s;
    public int chartX2;
    public int[] chartY2s;
    public int chartDX;
    public int chartDY;
    public int chartWidth;
    public int chartHeight;
    public Color[] playerColors;
    public ToolTipProvider toolTipProvider;

    public void setVisiblePlayers(JCheckBox[] playerCheckBoxes, int[] playerIndices) {
        this.playerChartIndices = new int[playerCheckBoxes.length];
        int i = 0;
        while (i < playerCheckBoxes.length) {
            int n;
            int n2 = playerIndices[i];
            if (playerCheckBoxes[i].isSelected()) {
                int n3 = this.playersCount;
                n = n3;
                this.playersCount = n3 + 1;
            } else {
                n = -1;
            }
            this.playerChartIndices[n2] = n;
            ++i;
        }
        this.chartPlayerIndices = new int[this.playersCount];
        i = 0;
        while (i < this.playerChartIndices.length) {
            if (this.playerChartIndices[i] >= 0) {
                this.chartPlayerIndices[this.playerChartIndices[i]] = i;
            }
            ++i;
        }
    }

    public void calcualteDerivedData(Color defaultPlayerColor) {
        this.chartX1 = 25;
        this.chartX2 = this.width - 1;
        if (this.chartX2 < this.chartX1) {
            this.chartX2 = this.chartX1;
        }
        this.chartDX = this.chartX2 - this.chartX1;
        this.chartWidth = this.chartDX + 1;
        int n = this.chartsCount = this.allPlayersOnOneChart ? 1 : this.playersCount;
        if (this.playersCount > 0) {
            this.chartHeight = (this.height - this.chartsCount * 25) / this.chartsCount;
        }
        if (this.chartHeight < 0) {
            this.chartHeight = 0;
        }
        this.chartDY = this.chartHeight - 1;
        int chartHeightWithDecoration = 12 + this.chartHeight + 13;
        this.chartY1s = new int[this.playersCount];
        this.chartY2s = new int[this.playersCount];
        int i = this.playersCount - 1;
        while (i >= 0) {
            this.chartY1s[i] = (this.allPlayersOnOneChart ? 0 : i * chartHeightWithDecoration) + 12;
            this.chartY2s[i] = this.chartY1s[i] + this.chartHeight - 1;
            --i;
        }
        this.playerColors = new Color[this.playerChartIndices.length];
        i = 0;
        while (i < this.playerColors.length) {
            this.playerColors[i] = this.playerChartIndices[i] < 0 ? null : (this.allPlayersOnOneChart || this.usePlayersInGameColors ? this.replay.details.players[i].getColor() : defaultPlayerColor);
            ++i;
        }
    }

    public int xToFrame(int x) {
        return (int)((long)this.replay.frames * (long)(x - 25 + 1) / (long)this.chartDX);
    }

    public int frameToX(int frame) {
        return 25 + (int)((long)frame * (long)this.chartDX / (long)this.replay.frames);
    }

    public static class ToolTipProvider {
        private final List<Pair<Rectangle, String>> toolTipList;

        public ToolTipProvider(List<Pair<Rectangle, String>> toolTipList) {
            this.toolTipList = toolTipList;
        }

        public String getToolTip(Point point) {
            int i = this.toolTipList.size() - 1;
            while (i >= 0) {
                if (((Rectangle)this.toolTipList.get((int)i).value1).contains(point)) {
                    return (String)this.toolTipList.get((int)i).value2;
                }
                --i;
            }
            return null;
        }
    }
}

