/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.ReplayParser;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ReplayOperationsPopupMenu
extends JPopupMenu
implements ActionListener {
    public final JMenuItem openInAnalyzerMenuItem = new JMenuItem(Language.getText("replayops.openInAnalyzer"), Icons.CHART);
    public final JMenuItem watchReplayMenuItem = new JMenuItem(Language.getText("replayops.watchReplay"), Icons.WATCH_REPLAY);
    public final JMenuItem copyReplaysMenuItem = new JMenuItem(Language.getText("replayops.copyReplays"), Icons.DOCUMENT_COPY);
    public final JMenuItem moveReplaysMenuItem = new JMenuItem(Language.getText("replayops.moveReplays"), Icons.DOCUMENT_EXPORT);
    public final JMenuItem packReplaysMenuItem = new JMenuItem(Language.getText("replayops.packReplays"), Icons.DOCUMENT_ZIPPER);
    public final JMenuItem renameReplaysMenuItem = new JMenuItem(Language.getText("replayops.renameReplays"), Icons.DOCUMENT_RENAME);
    public final JMenuItem deleteReplaysMenuItem = new JMenuItem(Language.getText("replayops.deleteReplays"), Icons.CROSS);
    public final JMenuItem openReplaysFolderMenuItem = new JMenuItem(Language.getText("replayops.openReplaysFolder"), Icons.FOLDER_OPEN);
    private final File[] files;
    private final ReplayOpCallback replayOpCallback;

    public ReplayOperationsPopupMenu(File[] files, ReplayOpCallback replayOpCallback) {
        this.files = files;
        this.replayOpCallback = replayOpCallback;
        this.openInAnalyzerMenuItem.addActionListener(this);
        this.add(this.openInAnalyzerMenuItem);
        this.watchReplayMenuItem.addActionListener(this);
        this.add(this.watchReplayMenuItem);
        this.addSeparator();
        this.copyReplaysMenuItem.addActionListener(this);
        this.add(this.copyReplaysMenuItem);
        this.moveReplaysMenuItem.addActionListener(this);
        this.add(this.moveReplaysMenuItem);
        this.packReplaysMenuItem.addActionListener(this);
        this.add(this.packReplaysMenuItem);
        this.renameReplaysMenuItem.addActionListener(this);
        this.add(this.renameReplaysMenuItem);
        this.deleteReplaysMenuItem.addActionListener(this);
        this.add(this.deleteReplaysMenuItem);
        this.addSeparator();
        this.openReplaysFolderMenuItem.setEnabled(Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN));
        this.openReplaysFolderMenuItem.addActionListener(this);
        this.add(this.openReplaysFolderMenuItem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        block68: {
            if (event.getSource() == this.openInAnalyzerMenuItem) {
                MainFrame.INSTANCE.createNewInternalFrame(MainFrame.INSTANCE.newRepAnalNode, this.files[0]);
                return;
            }
            if (event.getSource() == this.watchReplayMenuItem) {
                try {
                    Runtime.getRuntime().exec(new String[]{new File(Settings.getString("settings.folders.sc2Installation"), GeneralUtils.isOsMac() ? "StarCraft II.app" : "StarCraft II.exe").getAbsolutePath(), this.files[0].getAbsolutePath()});
                    return;
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
                return;
            }
            if (event.getSource() != this.copyReplaysMenuItem && event.getSource() != this.moveReplaysMenuItem && event.getSource() != this.deleteReplaysMenuItem) break block68;
            boolean copy = event.getSource() == this.copyReplaysMenuItem;
            boolean move = event.getSource() == this.moveReplaysMenuItem;
            boolean delete = event.getSource() == this.deleteReplaysMenuItem;
            boolean copyOrMove = copy || move;
            boolean moveOrDelete = move || delete;
            File targetFolder = null;
            if (copyOrMove) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(1);
                fileChooser.setDialogTitle(Language.getText(copy ? "replayops.selectCopyTargetFolder" : "replayops.selectMoveTargetFolder"));
                fileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (fileChooser.showOpenDialog(MainFrame.INSTANCE) != 0) return;
                targetFolder = fileChooser.getSelectedFile();
            } else if (GuiUtils.showConfirmDialog(Language.getText("replayops.deleteConfirmation", this.files.length), true) != 0) {
                return;
            }
            byte[] buffer = new byte[16384];
            int copiedCounter = 0;
            int deletedCounter = 0;
            int i = 0;
            while (i < this.files.length) {
                block70: {
                    File file;
                    block69: {
                        file = this.files[i];
                        if (!copyOrMove) break block69;
                        if (!GeneralUtils.copyFile(file, targetFolder, buffer, null)) break block70;
                        ++copiedCounter;
                    }
                    if (moveOrDelete) {
                        if (file.delete()) {
                            if (!move && this.replayOpCallback != null) {
                                this.replayOpCallback.replayDeleted(file, i);
                            }
                            ++deletedCounter;
                        }
                        if (move && this.replayOpCallback != null) {
                            this.replayOpCallback.replayMoved(file, targetFolder, i);
                        }
                    }
                }
                ++i;
            }
            if (this.replayOpCallback != null) {
                this.replayOpCallback.moveRenameDeleteEnded();
            }
            ArrayList<String> messageList = new ArrayList<String>(3);
            if (copy) {
                messageList.add(Language.getText("replayops.successfullyCopied", copiedCounter));
                if (copiedCounter < this.files.length) {
                    messageList.add(Language.getText("replayops.failedToCopy", this.files.length - copiedCounter));
                }
            } else if (move) {
                messageList.add(Language.getText("replayops.successfullyMoved", deletedCounter));
                if (deletedCounter < copiedCounter) {
                    messageList.add(Language.getText("replayops.successfullyCopied", copiedCounter - deletedCounter));
                    messageList.add(Language.getText("replayops.failedToDelete", copiedCounter - deletedCounter));
                }
                if (copiedCounter < this.files.length) {
                    messageList.add(Language.getText("replayops.failedToCopy", this.files.length - copiedCounter));
                }
            } else if (delete) {
                messageList.add(Language.getText("replayops.successfullyDeleted", deletedCounter));
                if (deletedCounter < this.files.length) {
                    messageList.add(Language.getText("replayops.failedToDelete", this.files.length - deletedCounter));
                }
            }
            if (copyOrMove && copiedCounter != this.files.length) {
                GuiUtils.showErrorDialog(messageList.toArray());
                return;
            } else {
                GuiUtils.showInfoDialog(messageList.toArray());
            }
            return;
        }
        if (event.getSource() == this.packReplaysMenuItem) {
            int addedCounter;
            block67: {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogTitle(Language.getText("replayops.selectFileToPackTo"));
                fileChooser.setFileFilter(GuiUtils.ZIP_FILE_FILTER);
                fileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                final JCheckBox includePathInZipCheckBox = new JCheckBox(Language.getText("replayops.includePathInZip"), Settings.getBoolean("module.repSearch.results.includePathInZip"));
                includePathInZipCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        if (event != null) {
                            Settings.set("module.repSearch.results.includePathInZip", includePathInZipCheckBox.isSelected());
                        }
                    }
                });
                fileChooser.setAccessory(includePathInZipCheckBox);
                if (fileChooser.showSaveDialog(MainFrame.INSTANCE) != 0) return;
                File zipFile = fileChooser.getSelectedFile();
                if (!GuiUtils.ZIP_FILE_FILTER.accept(zipFile)) {
                    zipFile = new File(String.valueOf(zipFile.getAbsolutePath()) + ".zip");
                }
                addedCounter = 0;
                ZipOutputStream output = null;
                try {
                    try {
                        output = new ZipOutputStream(new FileOutputStream(zipFile));
                        boolean includePath = includePathInZipCheckBox.isSelected();
                        byte[] buffer = new byte[16384];
                        File[] fileArray = this.files;
                        int messageList = this.files.length;
                        int deletedCounter = 0;
                        while (deletedCounter < messageList) {
                            block65: {
                                File file = fileArray[deletedCounter];
                                output.putNextEntry(new ZipEntry(includePath ? file.getAbsolutePath() : file.getName()));
                                FileInputStream input = null;
                                try {
                                    try {
                                        int readBytes;
                                        input = new FileInputStream(file);
                                        while ((readBytes = input.read(buffer)) > 0) {
                                            output.write(buffer, 0, readBytes);
                                        }
                                        input.close();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        if (input != null) {
                                            try {
                                                input.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        break block65;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (input == null) throw throwable;
                                    try {
                                        input.close();
                                        throw throwable;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                            output.closeEntry();
                            ++addedCounter;
                            ++deletedCounter;
                        }
                        output.flush();
                        output.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block67;
                    }
                }
                catch (Throwable throwable) {
                    if (output == null) throw throwable;
                    try {
                        output.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (addedCounter == this.files.length) {
                GuiUtils.showInfoDialog(Language.getText("replayops.successfullyPacked", addedCounter));
                return;
            } else {
                GuiUtils.showErrorDialog(new Object[]{Language.getText("replayops.successfullyPacked", addedCounter), Language.getText("replayops.failedToPack", this.files.length - addedCounter)});
            }
            return;
        }
        if (event.getSource() == this.renameReplaysMenuItem) {
            final JDialog renameDialog = new JDialog((Frame)MainFrame.INSTANCE, Language.getText("replayops.renameDialog.title"));
            renameDialog.setDefaultCloseOperation(2);
            JPanel northPanel = new JPanel(new BorderLayout());
            Box box = Box.createVerticalBox();
            int i = 1;
            while (i <= 4) {
                if (i == 2 || i == 4) {
                    box.add(Box.createVerticalStrut(10));
                }
                box.add(new JLabel(Language.getText("replayops.renameDialog.description" + i)));
                ++i;
            }
            box.add(new JLabel("          /n    " + Language.getText("replayops.renameDialog.symbol.name")));
            box.add(new JLabel("          /e    " + Language.getText("replayops.renameDialog.symbol.extension")));
            box.add(new JLabel("          /d    " + Language.getText("replayops.renameDialog.symbol.date")));
            box.add(new JLabel("          /D    " + Language.getText("replayops.renameDialog.symbol.dateTime")));
            box.add(new JLabel("          /c    " + Language.getText("replayops.renameDialog.symbol.counter")));
            box.add(new JLabel("          /m   " + Language.getText("replayops.renameDialog.symbol.mapName")));
            box.add(new JLabel("          /px  " + Language.getText("replayops.renameDialog.symbol.playerName")));
            box.add(new JLabel("          /q   " + Language.getText("replayops.renameDialog.symbol.allPlayerNames")));
            box.add(new JLabel("          /rx   " + Language.getText("replayops.renameDialog.symbol.playerRaceFirstLetter")));
            box.add(new JLabel("          /Rx  " + Language.getText("replayops.renameDialog.symbol.playerRace")));
            box.add(new JLabel("          /Px  " + Language.getText("replayops.renameDialog.symbol.fullPlayerName")));
            box.add(new JLabel("          /Q   " + Language.getText("replayops.renameDialog.symbol.allFullPlayerNames")));
            box.add(new JLabel("          /f    " + Language.getText("replayops.renameDialog.symbol.format")));
            box.add(new JLabel("          /T   " + Language.getText("replayops.renameDialog.symbol.raceMatchup")));
            final JTextField templateTextField = new JTextField(Settings.getString("module.repSearch.results.renameTemplate"));
            box.add(templateTextField);
            northPanel.add((Component)box, "Center");
            JPanel buttonsPanel = new JPanel();
            final JButton previewButton = new JButton();
            GuiUtils.updateButtonText(previewButton, "replayops.renameDialog.previewButton", new Object[0]);
            buttonsPanel.add(previewButton);
            JButton renameButton = new JButton();
            GuiUtils.updateButtonText(renameButton, "replayops.renameDialog.renameButton", new Object[0]);
            buttonsPanel.add(renameButton);
            JButton cancelButton = new JButton();
            GuiUtils.updateButtonText(cancelButton, "button.cancel", new Object[0]);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    renameDialog.dispose();
                }
            });
            buttonsPanel.add(cancelButton);
            northPanel.add((Component)buttonsPanel, "South");
            renameDialog.getContentPane().add((Component)northPanel, "North");
            final JTextArea previewTextArea = new JTextArea();
            previewTextArea.setEditable(false);
            renameDialog.getContentPane().add((Component)new JScrollPane(previewTextArea), "Center");
            ActionListener renameActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean preview;
                    boolean bl = preview = event.getSource() == previewButton;
                    if (preview) {
                        previewTextArea.setText("");
                    }
                    int counter = 1;
                    int errorCounter = 0;
                    char[] templateCharArray = templateTextField.getText().toCharArray();
                    int fileIndex = 0;
                    while (fileIndex < ReplayOperationsPopupMenu.this.files.length) {
                        try {
                            File file = ReplayOperationsPopupMenu.this.files[fileIndex];
                            StringBuilder nameBuilder = new StringBuilder();
                            Replay replay = null;
                            int i = 0;
                            while (i < templateCharArray.length) {
                                block42: {
                                    block41: {
                                        if (templateCharArray[i] != '/') break block41;
                                        char symbol = templateCharArray[++i];
                                        switch (symbol) {
                                            case 'n': {
                                                nameBuilder.append(GeneralUtils.getFileNameWithoutExt(file));
                                                break block42;
                                            }
                                            case 'e': {
                                                nameBuilder.append("SC2Replay");
                                                break block42;
                                            }
                                            case 'd': {
                                                nameBuilder.append(Language.formatDate(new Date(file.lastModified())).replace('/', '-').replace('\\', '-').replace(':', '-'));
                                                break block42;
                                            }
                                            case 'D': {
                                                nameBuilder.append(Language.formatDateTime(new Date(file.lastModified())).replace('/', '-').replace('\\', '-').replace(':', '-'));
                                                break block42;
                                            }
                                            case 'c': {
                                                nameBuilder.append(Integer.toString(counter++));
                                                break block42;
                                            }
                                            case 'P': 
                                            case 'Q': 
                                            case 'R': 
                                            case 'T': 
                                            case 'f': 
                                            case 'm': 
                                            case 'p': 
                                            case 'q': 
                                            case 'r': {
                                                if (replay == null) {
                                                    replay = ReplayParser.parseReplay(file.getAbsolutePath(), ReplayParser.GENERAL_INFO_CONTENT);
                                                }
                                                if (replay == null) {
                                                    System.out.println("Could not parse replay!");
                                                    ++errorCounter;
                                                } else {
                                                    block9 : switch (symbol) {
                                                        case 'm': {
                                                            nameBuilder.append(replay.details.mapName);
                                                            break;
                                                        }
                                                        case 'q': {
                                                            nameBuilder.append(replay.details.getPlayerNames());
                                                            break;
                                                        }
                                                        case 'Q': {
                                                            nameBuilder.append(replay.details.getPlayerFullNames());
                                                            break;
                                                        }
                                                        case 'f': {
                                                            nameBuilder.append((Object)replay.initData.format);
                                                            break;
                                                        }
                                                        case 'T': {
                                                            nameBuilder.append(replay.details.getRaceMatchup());
                                                            break;
                                                        }
                                                        case 'P': 
                                                        case 'R': 
                                                        case 'p': 
                                                        case 'r': {
                                                            int index = templateCharArray[++i] - 49;
                                                            if (index < 0 || index > replay.details.players.length) {
                                                                System.out.println("Invalid player index!");
                                                                ++errorCounter;
                                                                break;
                                                            }
                                                            switch (symbol) {
                                                                case 'p': {
                                                                    nameBuilder.append(replay.details.players[index].name);
                                                                    break block9;
                                                                }
                                                                case 'R': {
                                                                    nameBuilder.append((Object)replay.details.players[index].race);
                                                                    break block9;
                                                                }
                                                                case 'r': {
                                                                    nameBuilder.append(replay.details.players[index].raceString().charAt(0));
                                                                    break block9;
                                                                }
                                                                case 'P': {
                                                                    nameBuilder.append(replay.details.players[index].fullName);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                break block42;
                                            }
                                            default: {
                                                System.out.println("Invalid symbol!");
                                                GuiUtils.showErrorDialog(Language.getText("replayops.renameDialog.invalidTemplate"));
                                                return;
                                            }
                                        }
                                    }
                                    nameBuilder.append(templateCharArray[i]);
                                }
                                ++i;
                            }
                            if (preview) {
                                previewTextArea.append(String.valueOf(nameBuilder.toString()) + "\n");
                                templateTextField.requestFocusInWindow();
                            } else {
                                File destinationFile = new File(file.getParent(), nameBuilder.toString());
                                if (file.renameTo(destinationFile)) {
                                    if (ReplayOperationsPopupMenu.this.replayOpCallback != null) {
                                        ReplayOperationsPopupMenu.this.replayOpCallback.replayRenamed(file, destinationFile, fileIndex);
                                    }
                                } else {
                                    System.out.println("Failed to rename replay file!");
                                    ++errorCounter;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            GuiUtils.showErrorDialog(Language.getText("replayops.renameDialog.invalidTemplate"));
                            return;
                        }
                        ++fileIndex;
                    }
                    if (preview) {
                        previewTextArea.setCaretPosition(0);
                    } else {
                        if (ReplayOperationsPopupMenu.this.replayOpCallback != null) {
                            ReplayOperationsPopupMenu.this.replayOpCallback.moveRenameDeleteEnded();
                        }
                        Settings.set("module.repSearch.results.renameTemplate", templateTextField.getText());
                        if (errorCounter == 0) {
                            GuiUtils.showInfoDialog(Language.getText("replayops.renameDialog.successfullyRenamed", ReplayOperationsPopupMenu.this.files.length));
                        } else {
                            GuiUtils.showErrorDialog(new Object[]{Language.getText("replayops.renameDialog.successfullyRenamed", ReplayOperationsPopupMenu.this.files.length - errorCounter), Language.getText("replayops.renameDialog.failedToRename", errorCounter)});
                        }
                        renameDialog.dispose();
                    }
                }
            };
            previewButton.addActionListener(renameActionListener);
            renameButton.addActionListener(renameActionListener);
            previewButton.doClick();
            renameDialog.setSize(750, 600);
            GuiUtils.centerWindowToWindow(renameDialog, MainFrame.INSTANCE);
            renameDialog.setVisible(true);
            return;
        }
        if (event.getSource() != this.openReplaysFolderMenuItem) return;
        try {
            Desktop.getDesktop().open(this.files[0].getParentFile());
            return;
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public static interface ReplayOpCallback {
        public void replayMoved(File var1, File var2, int var3);

        public void replayDeleted(File var1, int var2);

        public void replayRenamed(File var1, File var2, int var3);

        public void moveRenameDeleteEnded();
    }
}

