/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.replay;

import java.nio.ByteBuffer;

public class BitBufferView {
    private static final int[] LOW_BIT_MASKS;
    private final ByteBuffer wrapper;
    private int cache;
    public final byte initialBits;
    private final int lowBitMask;
    private final int highBitMask;
    private final int byteBoundary;
    private final int byteBoundarySupplement;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        LOW_BIT_MASKS = nArray;
    }

    public BitBufferView(ByteBuffer wrapper, int byteBoundary) {
        this.wrapper = wrapper;
        this.byteBoundary = byteBoundary;
        this.byteBoundarySupplement = 8 - byteBoundary;
        this.lowBitMask = LOW_BIT_MASKS[byteBoundary];
        this.highBitMask = 255 - this.lowBitMask;
        this.cache = wrapper.get() & 0xFF;
        this.initialBits = (byte)((this.cache & this.lowBitMask) << this.byteBoundarySupplement);
    }

    public int get() {
        int retVal = this.cache & this.highBitMask;
        this.cache = this.wrapper.get() & 0xFF;
        return retVal | this.cache & this.lowBitMask;
    }

    public short get2Bytes() {
        int retVal = (this.cache & this.highBitMask) << this.byteBoundarySupplement | this.wrapper.get() & 0xFF;
        this.cache = this.wrapper.get() & 0xFF;
        return (short)(retVal << this.byteBoundary | this.cache & this.lowBitMask);
    }

    public int getInt() {
        int retVal = (this.cache & this.highBitMask) << this.byteBoundarySupplement | this.wrapper.get() & 0xFF;
        retVal = retVal << 8 | this.wrapper.get() & 0xFF;
        retVal = retVal << 8 | this.wrapper.get() & 0xFF;
        this.cache = this.wrapper.get() & 0xFF;
        return Integer.reverseBytes(retVal << this.byteBoundary | this.cache & this.lowBitMask);
    }

    public int getRemainder() {
        return this.cache & this.highBitMask;
    }
}

