/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.replay.ReplayUtils;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalSearchField;
import java.io.File;

public class VersionSearchField
extends IntervalSearchField {
    public VersionSearchField() {
        super("module.repSearch.tab.filters.name.version");
    }

    @Override
    public boolean customValidateMin() {
        String minText = this.minTextField.getText();
        if (minText.length() == 0) {
            return true;
        }
        int[] min = ReplayUtils.parseVersion(minText);
        return min != null;
    }

    @Override
    public boolean customValidateMax() {
        String maxText = this.maxTextField.getText();
        if (maxText.length() == 0) {
            return true;
        }
        int[] max = ReplayUtils.parseVersion(maxText);
        return max != null;
    }

    @Override
    public ReplayFilter getFilter() {
        return this.minTextField.getText().length() == 0 && this.maxTextField.getText().length() == 0 ? null : new IntervalReplayFilter(this){
            private final int[] minVersion;
            private final int[] maxVersion;
            {
                this.minVersion = ReplayUtils.parseVersion(this.minText);
                this.maxVersion = ReplayUtils.parseVersion(this.maxText);
            }

            @Override
            public boolean accept(File file, Replay replay) {
                if (this.minText.length() > 0 && ReplayUtils.compareVersions(replay.buildNumbers, this.minVersion) < 0) {
                    return false;
                }
                return this.maxText.length() <= 0 || ReplayUtils.compareVersions(replay.buildNumbers, this.maxVersion) <= 0;
            }
        };
    }
}

