/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.replay.model.Details;
import hu.belicza.andras.sc2gears.replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.TextReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.TextSearchField;
import java.io.File;
import java.util.ArrayList;

public class PlayerNameSearchField
extends TextSearchField {
    public PlayerNameSearchField() {
        super("module.repSearch.tab.filters.name.playerName");
        this.textField.setToolTipText(Language.getText("module.repSearch.tab.filters.name.playerNameToolTip"));
    }

    @Override
    public boolean customValidate() {
        return this.textField.getText().length() == 0 || PlayerNameSearchField.parseNames(this.textField.getText()) != null;
    }

    @Override
    public ReplayFilter getFilter() {
        return this.textField.getText().length() == 0 ? null : new TextReplayFilter(this){
            private final String[] names;
            {
                this.names = PlayerNameSearchField.parseNames(this.text);
            }

            @Override
            public boolean accept(File file, Replay replay) {
                if (this.names.length == 1) {
                    Details.Player[] playerArray = replay.details.players;
                    int n = replay.details.players.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Details.Player player = playerArray[n2];
                        String playerName = player.fullName.toLowerCase();
                        if (this.exactMatch ? playerName.equals(this.text) : playerName.contains(this.text)) {
                            return true;
                        }
                        ++n2;
                    }
                } else {
                    ArrayList<String> nameList = new ArrayList<String>(this.names.length);
                    Object[] objectArray = this.names;
                    int n = this.names.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String name = objectArray[n3];
                        nameList.add(name);
                        ++n3;
                    }
                    objectArray = replay.details.players;
                    n = replay.details.players.length;
                    n3 = 0;
                    while (n3 < n) {
                        Object player = objectArray[n3];
                        String playerName = ((Details.Player)player).fullName.toLowerCase();
                        int i = nameList.size() - 1;
                        while (i >= 0) {
                            if (this.exactMatch ? playerName.equals(nameList.get(i)) : playerName.contains((CharSequence)nameList.get(i))) {
                                nameList.remove(i);
                                break;
                            }
                            --i;
                        }
                        ++n3;
                    }
                    return nameList.isEmpty();
                }
                return false;
            }
        };
    }

    private static String[] parseNames(String text) {
        String[] names = text.split(",");
        if (names.length == 0) {
            return null;
        }
        int i = 0;
        while (i < names.length) {
            names[i] = names[i].trim();
            if (names[i].length() == 0) {
                return null;
            }
            ++i;
        }
        return names;
    }
}

