/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;

public class SearchFieldGroup {
    public final Container parentToNotify;
    private final Class<? extends SearchField> searchFieldType;
    public final Box uiComponent = Box.createHorizontalBox();
    public final Box searchFieldsBox = Box.createVerticalBox();
    public final List<SearchField> searchFieldList = new ArrayList<SearchField>();

    public SearchFieldGroup(Container parentToNotify, Class<? extends SearchField> searchFieldType) {
        this.parentToNotify = parentToNotify;
        this.searchFieldType = searchFieldType;
        this.uiComponent.setBorder(BorderFactory.createRaisedBevelBorder());
        this.uiComponent.add(this.searchFieldsBox);
        JLabel addNewLabel = new JLabel(Icons.PLUS);
        addNewLabel.setCursor(Cursor.getPredefinedCursor(12));
        addNewLabel.setToolTipText(Language.getText("module.repSearch.tab.filters.addNewFieldToolTip"));
        addNewLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                SearchFieldGroup.this.addNewSearchField();
            }
        });
        this.uiComponent.add(addNewLabel);
        this.addNewSearchField();
    }

    private void addNewSearchField() {
        try {
            final Box searchFieldBox = Box.createHorizontalBox();
            final SearchField newSearchField = this.searchFieldType.newInstance();
            if (!this.searchFieldList.isEmpty()) {
                newSearchField.displayLabel.setPreferredSize(new Dimension(this.searchFieldList.get((int)0).displayLabel.getPreferredSize().width, newSearchField.displayLabel.getPreferredSize().height));
            }
            this.searchFieldList.add(newSearchField);
            searchFieldBox.add(newSearchField.uiComponent);
            searchFieldBox.add(Box.createHorizontalStrut(6));
            JLabel removeLabel = new JLabel(Icons.MINUS);
            removeLabel.setCursor(Cursor.getPredefinedCursor(12));
            removeLabel.setToolTipText(Language.getText("module.repSearch.tab.filters.removeFieldToolTip"));
            removeLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (SearchFieldGroup.this.searchFieldsBox.getComponentCount() > 1) {
                        SearchFieldGroup.this.searchFieldList.remove(newSearchField);
                        SearchFieldGroup.this.searchFieldsBox.remove(searchFieldBox);
                        SearchFieldGroup.this.updateRemoveLabels();
                        SearchFieldGroup.this.parentToNotify.validate();
                    }
                }
            });
            searchFieldBox.add(removeLabel);
            this.searchFieldsBox.add(searchFieldBox);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateRemoveLabels();
        this.parentToNotify.validate();
    }

    private void updateRemoveLabels() {
        boolean enabled = this.searchFieldsBox.getComponentCount() != 1;
        int i = this.searchFieldsBox.getComponentCount() - 1;
        while (i >= 0) {
            Box searchFieldBox = (Box)this.searchFieldsBox.getComponent(i);
            searchFieldBox.getComponent(searchFieldBox.getComponentCount() - 1).setEnabled(enabled);
            --i;
        }
    }

    public boolean validateAll() {
        boolean validAll = true;
        for (SearchField searchField : this.searchFieldList) {
            validAll &= searchField.validate();
        }
        return validAll;
    }

    public ReplayFilter[] getReplayFilters() {
        ArrayList<ReplayFilter> replayFilterList = new ArrayList<ReplayFilter>(this.searchFieldList.size());
        for (SearchField searchField : this.searchFieldList) {
            ReplayFilter replayFilter = searchField.getFilter();
            if (replayFilter == null) continue;
            replayFilterList.add(replayFilter);
        }
        return replayFilterList.isEmpty() ? null : replayFilterList.toArray(new ReplayFilter[replayFilterList.size()]);
    }
}

